/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class ActionFilePrint
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JProjectView projectView;

    public ActionFilePrint() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.print") + "...");
        String string = Common.I18N_ACTIONS.getString("file.print.tooltip");
        string = SystemUtilities.isOSMac() ? string + " (Cmmd-P)" : string + " (Ctrl-P)";
        this.putValue("ShortDescription", string);
        this.putValue("MnemonicKey", new Integer(80));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Print16.gif")));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PrintManager.setStartInterval(this.projectView.getProject().getStartDate());
        PrintManager.setEndInterval(this.projectView.getProject().getEndDate());
        JApplication jApplication = Common.getApplication();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable((Pageable)((Object)this.projectView));
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Common.logException("Error:", printerException);
                JOptionPane.showMessageDialog(jApplication, Common.I18N_MESSAGES.getString("print.failedToPrint.message") + " (" + printerException.getLocalizedMessage() + ")", Common.I18N_MESSAGES.getString("print.failedToPrint.title"), 0);
            }
        }
    }

    public void projectViewChanged(JProjectView jProjectView) {
        this.projectView = jProjectView;
        JApplication jApplication = Common.getApplication();
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        this.setEnabled(jProjectView instanceof Pageable && companyDocumentManager.getSelectedDocument() != null);
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            ActionFilePrint.this.setEnabled(ActionFilePrint.this.projectView instanceof Pageable && documentManagerEvent.getNewDocument() != null);
        }
    }
}

