/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.JApplication;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class ActionFileExport
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionFileExport() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.dataExport") + "...");
        String string = Common.I18N_ACTIONS.getString("file.dataExport.tooltip");
        string = SystemUtilities.isOSMac() ? string + " (Cmmd-E)" : string + " (Ctrl-E)";
        this.putValue("ShortDescription", string);
        this.putValue("MnemonicKey", new Integer(69));
        if (SystemUtilities.isOSMac()) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 256));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 128));
        }
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Export16.gif")));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JApplication jApplication = Common.getApplication();
            CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
            companyDocumentManager.getSelectedDocument().export();
        }
        catch (DocumentException documentException) {
            Common.logException("Error:", documentException);
            JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToExport"), 0);
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            ActionFileExport.this.setEnabled(documentManagerEvent.getNewDocument() != null);
        }
    }
}

