/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.shareit;

import com.sbs.jpm.Common;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class P300161123 {
    private static final int OUR_PRODUCT_ID = 300161123;
    public static final int ERC_SUCCESS = 0;
    public static final int ERC_SUCCESS_BIN = 1;
    public static final int ERC_ERROR = 10;
    public static final int ERC_MEMORY = 11;
    public static final int ERC_FILE_IO = 12;
    public static final int ERC_BAD_ARGS = 13;
    public static final int ERC_BAD_INPUT = 14;
    public static final int ERC_EXPIRED = 15;
    public static final int ERC_INTERNAL = 16;
    public static int ExitCode = 16;
    private static final String expectedEncoding = "UTF8";
    public static String fileEncoding = "ISO-8859-1";
    public static int PURCHASE_ID;
    public static int PRODUCT_ID;
    public static int LANGUAGE_ID;
    public static String REG_NAME;
    public static String EMAIL;
    public static String KeyMIMEType;
    public static String KeyDisplayFileName;
    public static byte[] KeyData;

    private static byte[] addParity(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < 56; ++i) {
            boolean bl;
            boolean bl2 = bl = (byArray[6 - i / 8] & 1 << i % 8) > 0;
            if (bl) {
                int n3 = 7 - n / 8;
                byArray2[n3] = (byte)(byArray2[n3] | 1 << n % 8 & 0xFF);
                ++n2;
            }
            if ((i + 1) % 7 == 0) {
                if (n2 % 2 == 0) {
                    int n4 = 7 - n / 8;
                    byArray2[n4] = (byte)(byArray2[n4] | 1);
                }
                ++n;
                n2 = 0;
            }
            ++n;
        }
        return byArray2;
    }

    private static SecretKey generateKey() {
        try {
            byte[] byArray = "StandBySoft".getBytes("UTF-8");
            SecretKeySpec secretKeySpec = new SecretKeySpec(P300161123.addParity(byArray), "DES");
            return secretKeySpec;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static void GenerateKey() throws Exception {
        SecretKey secretKey = P300161123.generateKey();
        byte by = P300161123.getVersion();
        byte[] byArray = P300161123.getCode();
        byte[] byArray2 = REG_NAME.getBytes("UTF-8");
        byte[] byArray3 = new byte[2 + byArray.length + byArray2.length];
        byArray3[0] = by;
        byArray3[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, 2, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 2 + byArray.length, byArray2.length);
        KeyData = P300161123.encodeKey(byArray3, secretKey);
        KeyMIMEType = "application/octet-stream";
    }

    private static byte[] encodeKey(byte[] byArray, SecretKey secretKey) throws Exception {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("DES");
            cipher.init(1, secretKey);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new Exception(noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Exception(invalidKeyException.getMessage());
        }
        try {
            byte[] byArray2 = cipher.doFinal(byArray);
            return byArray2;
        }
        catch (BadPaddingException badPaddingException) {
            throw new Exception(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new Exception(illegalBlockSizeException.getMessage());
        }
    }

    private static void ParseInputLine(String string) {
        int n = string.indexOf(61);
        if (n == 0) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string2.indexOf("ENCODING") >= 0) {
            fileEncoding = string3;
        } else if (string2.compareTo("REG_NAME") == 0) {
            REG_NAME = string3;
        } else if (string2.compareTo("EMAIL") == 0) {
            EMAIL = string3;
        } else if (string2.compareTo("PRODUCT_ID") == 0) {
            PRODUCT_ID = Integer.valueOf(string3);
        } else if (string2.compareTo("PURCHASE_ID") == 0) {
            PURCHASE_ID = Integer.valueOf(string3);
        } else if (string2.compareTo("LANGUAGE_ID") == 0) {
            LANGUAGE_ID = Integer.valueOf(string3);
        }
    }

    private static void ReadInput(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), expectedEncoding));
        while ((string2 = bufferedReader.readLine()) != null) {
            P300161123.ParseInputLine(string2);
        }
        bufferedReader.close();
        if (!fileEncoding.equals(expectedEncoding)) {
            ExitCode = 14;
            throw new Exception("bad input encoding, expected UTF8 but found: " + fileEncoding);
        }
        if (REG_NAME.length() < 8) {
            ExitCode = 14;
            throw new Exception("REG_NAME must have at least 8 characters UTF8 but found: " + fileEncoding);
        }
    }

    private static void WriteText(String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), fileEncoding));
        bufferedWriter.write(string2);
        bufferedWriter.flush();
    }

    private static void WriteBinary(String string, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
    }

    public static int KeyMain(String[] stringArray) {
        try {
            try {
                if (stringArray.length == 3) {
                    P300161123.ReadInput(stringArray[0]);
                    P300161123.GenerateKey();
                    P300161123.WriteText(stringArray[1], KeyMIMEType + ":" + stringArray[2]);
                    P300161123.WriteBinary(stringArray[2], KeyData);
                    ExitCode = 1;
                } else {
                    System.out.println("Usage: <input><output1><output2>");
                    ExitCode = 13;
                }
            }
            catch (IOException iOException) {
                ExitCode = 12;
                Common.logException("Error opening file:", iOException);
                throw iOException;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            try {
                P300161123.WriteText(stringArray[1], "Error #" + ExitCode + ": " + exception.getMessage());
            }
            catch (IOException iOException) {
                System.err.println("could not write error file: " + iOException.getMessage());
            }
        }
        return ExitCode;
    }

    public static final void main(String[] stringArray) {
        System.out.println("JAVA Example Key Generator");
        int n = P300161123.KeyMain(stringArray);
        switch (n) {
            case 0: {
                System.out.println("ERC_SUCCESS");
                break;
            }
            case 1: {
                System.out.println("ERC_SUCCESS_BIN");
                break;
            }
            case 10: {
                System.out.println("ERC_ERROR");
                break;
            }
            case 11: {
                System.out.println("ERC_MEMORY");
                break;
            }
            case 12: {
                System.out.println("ERC_FILE_IO");
                break;
            }
            case 13: {
                System.out.println("ERC_BAD_ARGS");
                break;
            }
            case 14: {
                System.out.println("ERC_BAD_INPUT");
                break;
            }
            case 15: {
                System.out.println("ERC_EXPIRED");
                break;
            }
            case 16: {
                System.out.println("ERC_INTERNAL");
            }
        }
        System.exit(n);
    }

    private static final byte[] getCode() {
        try {
            return "StandBySoft".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static final byte getVersion() {
        return 3;
    }
}

