/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.document;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.common.IDsGenerator.DefaultIDGenerator;
import com.sbs.jpm.common.IDsGenerator.IDGenerator;
import com.sbs.jpm.common.JpmServer;
import com.sbs.jpm.common.User;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.SessionManager;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.core.io.FileType;
import com.sbs.jpm.core.io.ProjectIOManager;
import com.sbs.jpm.core.remoteClient.ClientIdGenerator;
import com.sbs.jpm.core.remoteClient.RemoteClientFactory;
import com.sbs.jpm.document.AbstractDocument;
import com.sbs.jpm.document.Answer;
import com.sbs.jpm.document.CustomTypeFile;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.document.event.DocumentManagerListener;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.JLockingDialog;
import com.sbs.util.CustomNameFile;
import com.sbs.util.LockException;
import com.sbs.util.LockedFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.JXLoginPanel;
import org.jdesktop.swingx.auth.LoginService;

public abstract class AbstractDocumentManager
implements DocumentManager {
    private Document selectedDocument;
    private List documents = new Vector();
    private EventListenerList listeners = new EventListenerList();

    protected abstract Document createDefaultDocument();

    protected abstract Document create(File var1, FileType var2) throws Exception;

    public void create() throws DocumentException {
        Object object;
        Document document = this.getSelectedDocument();
        if (document != null) {
            if (!document.isLocked() && !document.isNewlyCreated() && document.isChanged() && ((object = this.shouldSaveDocument(Common.I18N_MESSAGES.getString("document.saveQuestion.onNew"))).equals(Answer.YES) ? !document.save() : object.equals(Answer.CANCEL))) {
                return;
            }
            this.forcedClose(document);
        }
        if ((object = this.createDefaultDocument()) != null) {
            this.open((Document)object);
            Company company = ((CompanyDocument)object).getData();
            ClientIdGenerator clientIdGenerator = new ClientIdGenerator();
            clientIdGenerator.setCompany(company);
            company.setIdGenerator(clientIdGenerator);
        }
    }

    private void open(Document document) {
        if (document != null) {
            this.documents.add(document);
            DocumentManagerEvent documentManagerEvent = new DocumentManagerEvent(this, this.selectedDocument, document);
            this.fireDocumentOpened(documentManagerEvent);
            this.setSelectedDocument(document);
        }
    }

    protected abstract CustomTypeFile getSelectedFile();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void open(Document document, CustomTypeFile customTypeFile) throws DocumentException {
        Company company;
        Document document2;
        LockedFile lockedFile;
        block27: {
            if (document != null) {
                this.forcedClose(document);
            }
            lockedFile = null;
            if (customTypeFile.getFileType().equals(FileType.PROPRIETARY)) {
                Object object;
                try {
                    lockedFile = LockedFile.createOpenedLockedFile(customTypeFile.getFile());
                }
                catch (LockException lockException) {
                    Common.logException("Error:", lockException);
                    JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("document.fileInUseOnSave.message"), Common.I18N_MESSAGES.getString("document.fileInUse.title"), 0);
                    object = customTypeFile.getFile().getAbsolutePath();
                    object = ((String)object).substring(0, ((String)object).length() - 4) + ".backup" + ((String)object).substring(((String)object).length() - 4);
                    try {
                        document2 = this.create(new CustomNameFile((String)object), FileType.PROPRIETARY);
                    }
                    catch (Exception exception) {
                        Common.logException("Error opening document:", exception);
                        throw new DocumentException(exception.getLocalizedMessage());
                    }
                    document2.setLocked(true);
                    break block27;
                }
                catch (IOException iOException) {
                    Common.logException("Error:", iOException);
                    if (Boolean.parseBoolean(Configuration.getInstance().getValue(ConfigurationSetting.NETWORK_LOCKING).toString())) {
                        object = new JLockingDialog((Frame)Common.getApplication(), iOException.getLocalizedMessage());
                        ((Dialog)object).setVisible(true);
                    }
                    try {
                        document2 = this.create(customTypeFile.getFile(), FileType.PROPRIETARY);
                        object = ((CompanyDocument)document2).getData();
                        if (((Company)object).getMultiProject() != 1) {
                            // empty if block
                        }
                    }
                    catch (Exception exception) {
                        Common.logException("Error opening file:", exception);
                        throw new DocumentException(exception.getLocalizedMessage());
                    }
                    try {
                        customTypeFile.backup();
                    }
                    catch (IOException iOException2) {
                        Common.logException("Error copying file:", iOException2);
                        iOException2.printStackTrace();
                    }
                    break block27;
                }
                try {
                    document2 = this.create(lockedFile, FileType.PROPRIETARY);
                    company = ((CompanyDocument)document2).getData();
                    if (company.getMultiProject() != 1) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                    Common.logException("Error while opening Single into Multi", exception);
                    exception.printStackTrace();
                    throw new DocumentException(exception.getLocalizedMessage());
                }
                try {
                    lockedFile.backup();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Common.logException("Error:", iOException);
                }
            } else {
                try {
                    document2 = this.create(customTypeFile.getFile(), customTypeFile.getFileType());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Common.logException("Error creating file:", exception);
                    throw new DocumentException(exception.getLocalizedMessage());
                }
            }
        }
        if (!customTypeFile.getFileType().equals(FileType.PROPRIETARY)) {
            try {
                this.open(document2);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Common.logException("Error opening file:", exception);
                throw new DocumentException(exception.getLocalizedMessage());
            }
        }
        company = ((CompanyDocument)document2).getData();
        if (company.getMultiProject() != 2) {
            if (company.getMultiProject() != 1) return;
            this.open(document2);
            return;
        }
        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("document.singleCannotOpenMulti"), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
        try {
            lockedFile.unlock();
            return;
        }
        catch (IOException iOException) {
            Common.logException("Error:", iOException);
            iOException.printStackTrace();
            return;
        }
    }

    public void open() throws DocumentException {
        Object object;
        Document document = this.getSelectedDocument();
        if (document != null && !document.isLocked() && !document.isNewlyCreated() && document.isChanged() && ((object = this.shouldSaveDocument(Common.I18N_MESSAGES.getString("document.saveQuestion.onOpen"))).equals(Answer.YES) ? !document.save() : object.equals(Answer.CANCEL))) {
            return;
        }
        object = this.getSelectedFile();
        if (object != null) {
            this.open(document, (CustomTypeFile)object);
        }
    }

    public void open(File file) throws DocumentException {
        Object object;
        Document document = this.getSelectedDocument();
        if (document != null && !document.isLocked() && !document.isNewlyCreated() && document.isChanged() && ((object = this.shouldSaveDocument(Common.I18N_MESSAGES.getString("document.saveQuestion.onOpen"))).equals(Answer.YES) ? !document.save() : object.equals(Answer.CANCEL))) {
            return;
        }
        object = new CustomTypeFile(file);
        if (((CustomTypeFile)object).getFileType() != null) {
            this.open(document, (CustomTypeFile)object);
        }
    }

    protected abstract CustomTypeFile getImportedFile();

    public void importDocument() throws DocumentException {
        Object object;
        Document document = this.getSelectedDocument();
        if (document != null && !document.isLocked() && !document.isNewlyCreated() && document.isChanged() && ((object = this.shouldSaveDocument(Common.I18N_MESSAGES.getString("document.saveQuestion.onImport"))).equals(Answer.YES) ? !document.save() : object.equals(Answer.CANCEL))) {
            return;
        }
        object = this.getImportedFile();
        if (object != null) {
            if (document != null) {
                this.forcedClose(document);
            }
            try {
                Document document2 = this.create(((CustomTypeFile)object).getFile(), ((CustomTypeFile)object).getFileType());
                this.open(document2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Common.logException("Error importing file:", exception);
                throw new DocumentException(exception.getLocalizedMessage());
            }
        }
    }

    protected abstract Answer shouldSaveDocument(String var1);

    public boolean close(Document document) throws DocumentException {
        if (document != null) {
            Answer answer;
            if (!document.isLocked() && !document.isNewlyCreated() && document.isChanged() && ((answer = this.shouldSaveDocument(Common.I18N_MESSAGES.getString("document.saveQuestion.onClose"))).equals(Answer.YES) ? !document.save() : answer.equals(Answer.CANCEL))) {
                return false;
            }
            this.forcedClose(document);
        }
        return true;
    }

    private void forcedClose(Document document) throws DocumentException {
        if (document != null) {
            Serializable serializable;
            FieldManager.getInstance().resetCustomNames();
            try {
                if (document.getFile() != null && document.getFile() instanceof LockedFile) {
                    serializable = (LockedFile)document.getFile();
                    serializable.unlock();
                }
            }
            catch (IOException iOException) {
                Common.logException("Error:", iOException);
            }
            this.documents.remove(document);
            if (this.documents.isEmpty()) {
                this.setSelectedDocument(null);
            } else {
                this.setSelectedDocument((Document)this.documents.get(this.documents.size() - 1));
            }
            serializable = new DocumentManagerEvent(this, this.selectedDocument, document);
            this.fireDocumentClosed((DocumentManagerEvent)serializable);
        }
        UIManager.getInstance().storeUISettings();
    }

    public boolean closeAll() throws DocumentException {
        int n = this.documents.size();
        for (int i = 0; i < n; ++i) {
            if (this.close(this.getSelectedDocument())) continue;
            return false;
        }
        return true;
    }

    public List getDocuments() {
        return this.documents;
    }

    public Document getSelectedDocument() {
        return this.selectedDocument;
    }

    public void setSelectedDocument(Document document) {
        DocumentManagerEvent documentManagerEvent = new DocumentManagerEvent(this, this.selectedDocument, document);
        this.selectedDocument = document;
        this.fireDocumentSelectionChanged(documentManagerEvent);
    }

    public void openServer() throws DocumentException {
        Object object;
        Document document = this.getSelectedDocument();
        if (document != null && !document.isLocked() && !document.isNewlyCreated() && document.isChanged() && ((object = this.shouldSaveDocument(Common.I18N_MESSAGES.getString("document.saveQuestion.onOpen"))).equals(Answer.YES) ? !document.save() : object.equals(Answer.CANCEL))) {
            return;
        }
        try {
            object = (RemoteClientFactory)Class.forName("com.sbs.jpm.remoteClient.spring.http.SpringHttpRemoteServer").newInstance();
        }
        catch (Throwable throwable) {
            Common.logException("Error:", throwable);
            JOptionPane.showMessageDialog(Common.getApplication(), throwable.toString(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
            return;
        }
        final JpmServer jpmServer = object.createJmpServer();
        final JXLoginPanel jXLoginPanel = new JXLoginPanel();
        LoginService loginService = new LoginService(){

            public boolean authenticate(String string, char[] cArray, String string2) throws Exception {
                User user = null;
                try {
                    user = jpmServer.authenticate(string, new String(cArray));
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{Configuration.getInstance().getValue(ConfigurationSetting.SERVER_URL)};
                    jXLoginPanel.setErrorMessage(MessageFormat.format(Common.I18N_MESSAGES.getString("server.failedToConnect.message"), objectArray));
                }
                if (user != null) {
                    if (user.isView()) {
                        SessionManager.getInstance().setUsername(string);
                        SessionManager.getInstance().setPassword(new String(cArray));
                        return true;
                    }
                    return false;
                }
                return false;
            }
        };
        jXLoginPanel.setLoginService(loginService);
        JXLoginPanel.Status status = JXLoginPanel.showLoginDialog((Component)Common.getApplication(), (JXLoginPanel)jXLoginPanel);
        if (status == JXLoginPanel.Status.SUCCEEDED) {
            Object object2;
            if (document != null) {
                this.forcedClose(document);
            }
            long l = System.currentTimeMillis();
            Company company = null;
            try {
                System.out.println("jpmServer.getCompany() ... " + System.currentTimeMillis());
                byte[] byArray = jpmServer.getCompanyData();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                object2 = ProjectIOManager.getProjectIOManager().getProjectIO(FileType.PROPRIETARY);
                company = object2.load(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                Common.logException("Error:", throwable);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("company retrived in  ... " + (l2 - l));
            object2 = new ClientIdGenerator();
            ((DefaultIDGenerator)object2).setCompany(company);
            company.setIdGenerator((IDGenerator)object2);
            CompanyDocument companyDocument = new CompanyDocument(company);
            if (companyDocument != null) {
                companyDocument.setServer(true);
                ((AbstractDocument)companyDocument).setProprietary(true);
                DocumentManagerEvent documentManagerEvent = new DocumentManagerEvent(this, this.selectedDocument, companyDocument);
                this.fireDocumentOpenedOnServer(documentManagerEvent);
                this.setSelectedDocument(companyDocument);
            }
        }
    }

    public boolean closeServer(Document document) throws DocumentException {
        if (document != null) {
            Object object;
            if (!document.isLocked() && !document.isNewlyCreated() && document.isChanged() && ((object = this.shouldSaveDocument(Common.I18N_MESSAGES.getString("document.saveQuestion.onClose"))).equals(Answer.YES) ? !document.save() : object.equals(Answer.CANCEL))) {
                return false;
            }
            FieldManager.getInstance().resetCustomNames();
            if (this.documents.isEmpty()) {
                this.setSelectedDocument(null);
            } else {
                this.setSelectedDocument((Document)this.documents.get(this.documents.size() - 1));
            }
            object = new DocumentManagerEvent(this, this.selectedDocument, document);
            this.fireDocumentClosedOnServer((DocumentManagerEvent)object);
            UIManager.getInstance().storeUISettings();
        }
        return true;
    }

    protected void fireDocumentOpened(DocumentManagerEvent documentManagerEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentManagerListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentManagerListener)eventListenerArray[i]).documentOpened(documentManagerEvent);
        }
    }

    protected void fireDocumentOpenedOnServer(DocumentManagerEvent documentManagerEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentManagerListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentManagerListener)eventListenerArray[i]).serverOpened(documentManagerEvent);
        }
    }

    protected void fireDocumentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentManagerListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentManagerListener)eventListenerArray[i]).documentSelectionChanged(documentManagerEvent);
        }
    }

    protected void fireDocumentClosed(DocumentManagerEvent documentManagerEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentManagerListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentManagerListener)eventListenerArray[i]).documentClosed(documentManagerEvent);
        }
    }

    protected void fireDocumentClosedOnServer(DocumentManagerEvent documentManagerEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentManagerListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentManagerListener)eventListenerArray[i]).serverClosed(documentManagerEvent);
        }
    }

    protected void fireDocumentCreated(DocumentManagerEvent documentManagerEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(DocumentManagerListener.class);
        int n = this.listeners.getListenerCount();
        for (int i = 0; i < n; ++i) {
            ((DocumentManagerListener)eventListenerArray[i]).documentCreated(documentManagerEvent);
        }
    }

    public void addDocumentManagerListener(DocumentManagerListener documentManagerListener) {
        this.listeners.add(DocumentManagerListener.class, documentManagerListener);
    }

    public void removeDocumentManagerListener(DocumentManagerListener documentManagerListener) {
        this.listeners.remove(DocumentManagerListener.class, documentManagerListener);
    }
}

