/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.ClientCollection;
import com.sbs.jpm.dB.xml.AdditionalFieldLoader;
import com.sbs.jpm.dB.xml.BaselineLoader;
import com.sbs.jpm.dB.xml.ConstraintLoader;
import com.sbs.jpm.dB.xml.DurationUnitLoader;
import com.sbs.jpm.dB.xml.LinkLoader;
import com.sbs.jpm.dB.xml.RiskLoader;
import com.sbs.jpm.ui.PrivacyManager;
import com.sbs.xml.XmlUtil;
import java.awt.Color;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskLoader {
    private static final String PLANNING = "Planning";
    private static final String IN_PROGRESS = "In progress";
    private static final String ON_HOLD = "On hold";
    private static final String CLOSED = "Closed";
    private static final String TASK_LIST = "task-list";
    public static final String TASK = "task";
    private static final String TASK_EMPTY = "empty-task";
    private static final String TASK_SPLIT = "split-task";
    private static final String TASK_CONFLICT = "conflict-task";
    private static final String TASK_NAME = "task-name";
    private static final String TASK_DURATION_UNIT = "task-unit";
    private static final String TASK_WORK_UNIT = "task-work-unit";
    private static final String TASK_CURRENCY_UNIT = "task-currency-unit";
    private static final String TASK_FIXED_COST = "task-fixed-cost";
    private static final String TASK_ACCRUAL = "task-accrual";
    private static final String PROJECT_STATUS = "task-status";
    private static final String TASK_ID = "task-id";
    private static final String TASK_UNIQUE_ID = "task-unique-id";
    private static final String TASK_CALENDAR_ID = "task-calendar-id";
    private static final String TASK_CLIENT_ID = "task-client-id";
    private static final String TASK_NOTES = "task-notes";
    private static final String TASK_LOOK = "task-look";
    private static final String TASK_BAR_COLOR = "task-bar-color";
    private static final String TASK_FORCED_WORKING = "task-forced-working";
    private static final String TASK_DURATION = "task-duration";
    private static final String TASK_WORK_DURATION = "task-work-duration";
    private static final String TASK_PERCENT_COMPLETE = "task-percent-complete";
    private static final String TASK_WORK_PERCENT_COMPLETE = "task-work-percent-complete";
    private static final String TASK_CONSTRAINT = "task-constraint";
    private static final String TASK_START_DATE = "task-start-date";
    private static final String TASK_END_DATE = "task-end-date";
    private static final String TASK_COMPLETION_DATE = "task-completion-date";
    private static final String TASK_DEADLINE = "task-deadline";
    private static final String TASK_EFFORT_DRIVEN = "task-effort-driven";
    private static final String TASK_FIXED_UNITS = "task-fixed-units";
    private static final String PROJECT = "project";
    private static final String PROJECT_CODE = "project-code";
    private static final String PROJECT_MANAGER = "project-manager";
    private static final String PROJECT_DESCRIPTION = "project-description";
    private static final String PROJECT_ASSUMPTIONS = "project-assumptions";
    private static final String PROJECT_CONSTRAINTS = "project-constraints";
    private static final String PROJECT_CRITICAL_SLACK_LIMIT = "project-critical-slack-limit";
    private static final String EXPANDED_GANTT = "expanded-gantt";
    private static final DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss");

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    private static List loadTaskList(Task task, Company company, Node node, CalendarCollection calendarCollection, ClientCollection clientCollection) throws RuntimeException {
        if (node.getNodeType() != 1 || node.getNodeName().compareTo(TASK_LIST) != 0) {
            throw new RuntimeException("Invalid node: not 'task-list'");
        }
        LinkedList<Task> linkedList = new LinkedList<Task>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(TASK) != 0 && node2.getNodeName().compareTo(TASK_EMPTY) != 0) continue;
            linkedList.add(TaskLoader.loadTask(task, company, node2, calendarCollection, clientCollection));
        }
        return linkedList;
    }

    public static Task loadTask(Task task, Company company, Node node, CalendarCollection calendarCollection, ClientCollection clientCollection) {
        Node node2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Node node3;
        Node node4;
        Object object6;
        Node node5;
        Node node6;
        Iterator iterator;
        Object object7;
        Node node7;
        Object object8;
        Node node8;
        Object object9;
        Object object10;
        Node node9;
        Node node10;
        Object object11;
        Node node11;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        List list = new LinkedList();
        List list2 = new LinkedList();
        long l = 0L;
        boolean bl = false;
        Task task2 = new Task(Long.MIN_VALUE);
        task2.setParent(task);
        if (node.getNodeName().compareTo(TASK) == 0) {
            task2.setEmpty(false);
            task2.setCompany(company);
        } else {
            task2.setEmpty(true);
        }
        Node node12 = TaskLoader.getChildNode(node, PROJECT);
        if (node12 != null) {
            bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node12));
            task2.setProject(bl);
            if (bl) {
                Iterator iterator2;
                node11 = TaskLoader.getChildNode(node, TASK_CONSTRAINT);
                if (node11 != null) {
                    task2.setProjectStartDate(ConstraintLoader.loadConstraint(node11).getDate());
                }
                if ((object11 = TaskLoader.getChildNode(node, PROJECT_CODE)) != null && (string = XmlUtil.getTextFromNode((Node)object11)) != null) {
                    task2.setCode(string);
                }
                if ((node10 = TaskLoader.getChildNode(node, PROJECT_MANAGER)) != null && (string2 = XmlUtil.getTextFromNode(node10)) != null) {
                    task2.setManager(string2);
                }
                if ((node9 = TaskLoader.getChildNode(node, TASK_CLIENT_ID)) != null) {
                    object10 = XmlUtil.getTextFromNode(node9);
                    long l2 = Long.parseLong((String)object10);
                    task2.setClient(clientCollection.getClientForId(l2));
                }
                if ((object10 = TaskLoader.getChildNode(node, PROJECT_CRITICAL_SLACK_LIMIT)) != null) {
                    l = Long.parseLong(XmlUtil.getTextFromNode((Node)object10));
                    task2.setCriticalSlackLimit(l);
                }
                if ((object9 = TaskLoader.getChildNode(node, "units-duration")) != null) {
                    DurationUnitLoader.loadDurationUnits((Node)object9, task2.getDurationManager());
                }
                if ((node8 = TaskLoader.getChildNode(node, PROJECT_DESCRIPTION)) != null && (string3 = XmlUtil.getTextFromNode(node8)) != null) {
                    task2.setDescription(string3);
                }
                if ((object8 = TaskLoader.getChildNode(node, PROJECT_ASSUMPTIONS)) != null && (string4 = XmlUtil.getTextFromNode((Node)object8)) != null) {
                    task2.setAssumptions(string4);
                }
                if ((node7 = TaskLoader.getChildNode(node, PROJECT_CONSTRAINTS)) != null && (string5 = XmlUtil.getTextFromNode(node7)) != null) {
                    task2.setConstraints(string5);
                }
                if ((object7 = TaskLoader.getChildNode(node, "link-list")) != null) {
                    list = LinkLoader.loadLinkList(task2, (Node)object7);
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        iterator2 = (Link)iterator.next();
                        task2.addLink((Link)((Object)iterator2));
                    }
                }
                if ((iterator = TaskLoader.getChildNode(node, "risk-list")) != null) {
                    list2 = RiskLoader.loadRiskList(company, task2, iterator);
                    iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        Risk risk = (Risk)iterator2.next();
                        task2.addRisk(risk);
                    }
                }
                if ((iterator2 = TaskLoader.getChildNode(node, "project-baseline-list")) != null) {
                    BaselineLoader.loadProjectBaselineList(task2, iterator2);
                }
            }
        }
        if ((node11 = TaskLoader.getChildNode(node, TASK_NAME)) != null) {
            object11 = XmlUtil.getTextFromNode(node11);
            if (object11 != null) {
                task2.setName((String)object11);
            } else {
                task2.setName("");
            }
        }
        if ((object11 = TaskLoader.getChildNode(node, TASK_CONFLICT)) != null) {
            task2.setConflict(Boolean.parseBoolean(XmlUtil.getTextFromNode((Node)object11)));
        }
        if ((node10 = TaskLoader.getChildNode(node, EXPANDED_GANTT)) != null) {
            task2.setExpanded(Boolean.parseBoolean(XmlUtil.getTextFromNode(node10)));
        }
        if ((node9 = TaskLoader.getChildNode(node, TASK_DURATION_UNIT)) != null) {
            object10 = XmlUtil.getTextFromNode(node9);
            if (((String)object10).equals("m")) {
                task2.setDurationUnit(DurationManager.MINUTE);
            } else if (((String)object10).equals("h")) {
                task2.setDurationUnit(DurationManager.HOUR);
            } else if (((String)object10).equals("d")) {
                task2.setDurationUnit(DurationManager.DAY);
            } else if (((String)object10).equals("w")) {
                task2.setDurationUnit(DurationManager.WEEK);
            }
        }
        if ((object10 = TaskLoader.getChildNode(node, TASK_WORK_UNIT)) != null) {
            object9 = XmlUtil.getTextFromNode(node9);
            if (((String)object9).equals("m")) {
                task2.setWorkUnit(DurationManager.MINUTE);
            } else if (((String)object9).equals("h")) {
                task2.setWorkUnit(DurationManager.HOUR);
            } else if (((String)object9).equals("d")) {
                task2.setWorkUnit(DurationManager.DAY);
            } else if (((String)object9).equals("w")) {
                task2.setWorkUnit(DurationManager.WEEK);
            }
        }
        if ((object9 = TaskLoader.getChildNode(node, TASK_CURRENCY_UNIT)) != null) {
            task2.setCurrencyUnit(XmlUtil.getTextFromNode((Node)object9));
        }
        if ((node8 = TaskLoader.getChildNode(node, TASK_FIXED_COST)) != null) {
            object8 = XmlUtil.getTextFromNode(node8);
            double d = Double.parseDouble((String)object8);
            task2.setFixedCost(d);
        }
        if ((object8 = TaskLoader.getChildNode(node, TASK_ACCRUAL)) != null) {
            task2.setAccrual(XmlUtil.getTextFromNode((Node)object8));
        }
        if ((node7 = TaskLoader.getChildNode(node, PROJECT_STATUS)) != null) {
            object7 = XmlUtil.getTextFromNode(node7);
            if (((String)object7).equals(PLANNING)) {
                task2.setStatus(Task.PLANNING);
            } else if (((String)object7).equals(IN_PROGRESS)) {
                task2.setStatus(Task.IN_PROGRESS);
            } else if (((String)object7).equals(ON_HOLD)) {
                task2.setStatus(Task.ON_HOLD);
            } else {
                task2.setStatus(Task.CLOSED);
            }
        }
        if ((object7 = TaskLoader.getChildNode(node, TASK_ID)) != null) {
            iterator = XmlUtil.getTextFromNode((Node)object7);
            long l3 = Long.parseLong((String)((Object)iterator));
            task2.setId(l3);
        }
        if ((iterator = TaskLoader.getChildNode(node, TASK_UNIQUE_ID)) != null) {
            String string6 = XmlUtil.getTextFromNode((Node)((Object)iterator));
            long l4 = Long.parseLong(string6);
            task2.setUniqueId(l4);
        } else {
            task2.setUniqueId(Long.MIN_VALUE);
        }
        Node node13 = TaskLoader.getChildNode(node, TASK_CALENDAR_ID);
        if (node13 != null) {
            String string7 = XmlUtil.getTextFromNode(node13);
            long l5 = Long.parseLong(string7);
            task2.setCalendar(calendarCollection.getCalendarForId(l5));
        }
        if ((node6 = TaskLoader.getChildNode(node, TASK_FORCED_WORKING)) != null) {
            task2.setForcedWorking(Boolean.parseBoolean(XmlUtil.getTextFromNode(node6)));
        }
        if ((node5 = TaskLoader.getChildNode(node, TASK_NOTES)) != null && (object6 = XmlUtil.getTextFromNode(node5)) != null) {
            task2.setNotes((String)object6);
        }
        if ((object6 = TaskLoader.getChildNode(node, TASK_CONSTRAINT)) != null) {
            task2.setConstraint(ConstraintLoader.loadConstraint((Node)object6));
        }
        if ((node4 = TaskLoader.getChildNode(node, TASK_LOOK)) != null && (node3 = TaskLoader.getChildNode(node4, TASK_BAR_COLOR)) != null) {
            try {
                object5 = XmlUtil.getTextFromNode(node3);
                task2.setBarColor(new Color(Integer.parseInt((String)object5)));
            }
            catch (RuntimeException runtimeException) {
                Common.logException("Error:", runtimeException);
            }
        }
        if ((node3 = TaskLoader.getChildNode(node, TASK_DEADLINE)) != null) {
            object5 = XmlUtil.getTextFromNode(node3);
            object4 = null;
            try {
                object4 = dateFormat.parse((String)object5);
            }
            catch (ParseException parseException) {
                Common.logException("Error:", parseException);
            }
            task2.setDeadlineDate((Date)object4);
        }
        if ((object5 = TaskLoader.getChildNode(node, TASK_START_DATE)) != null) {
            object4 = XmlUtil.getTextFromNode((Node)object5);
            object3 = null;
            try {
                object3 = dateFormat.parse((String)object4);
            }
            catch (ParseException parseException) {
                Common.logException("Error:", parseException);
            }
            task2.setStartDate((Date)object3);
        }
        if ((object4 = TaskLoader.getChildNode(node, TASK_END_DATE)) != null) {
            object3 = XmlUtil.getTextFromNode((Node)object4);
            object2 = null;
            try {
                object2 = dateFormat.parse((String)object3);
            }
            catch (ParseException parseException) {
                Common.logException("Error:", parseException);
            }
            task2.setEndDate((Date)object2);
        }
        if ((object3 = TaskLoader.getChildNode(node, TASK_COMPLETION_DATE)) != null) {
            object2 = XmlUtil.getTextFromNode((Node)object3);
            object = null;
            try {
                object = dateFormat.parse((String)object2);
            }
            catch (ParseException parseException) {
                Common.logException("Error:", parseException);
            }
            task2.setCompletionDate((Date)object);
        }
        if ((object2 = TaskLoader.getChildNode(node, "baseline-list")) != null) {
            BaselineLoader.loadBaselineList(task2, (Node)object2);
        }
        if ((object = TaskLoader.getChildNode(node, "field-list")) != null) {
            AdditionalFieldLoader.loadTaskFieldList(task2, (Node)object);
        }
        if ((node2 = TaskLoader.getChildNode(node, TASK_LIST)) != null) {
            task2.setChildList(TaskLoader.loadTaskList(task2, company, node2, calendarCollection, clientCollection));
        }
        return task2;
    }

    private static void loadTaskListCompletion(Task task, Node node) throws RuntimeException {
        if (node.getNodeType() != 1 || node.getNodeName().compareTo(TASK_LIST) != 0) {
            throw new RuntimeException("Invalid node: not 'task-list'");
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(TASK) != 0 && node2.getNodeName().compareTo(TASK_EMPTY) != 0) continue;
            TaskLoader.loadTaskCompletion(task.getChildAt(n), node2);
            ++n;
        }
    }

    private static void loadTaskListWorkDuration(Task task, Node node) throws RuntimeException {
        if (node.getNodeType() != 1 || node.getNodeName().compareTo(TASK_LIST) != 0) {
            throw new RuntimeException("Invalid node: not 'task-list'");
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(TASK) != 0 && node2.getNodeName().compareTo(TASK_EMPTY) != 0) continue;
            TaskLoader.loadTaskWorkDuration(task.getChildAt(n), node2);
            ++n;
        }
    }

    public static void loadTaskCompletion(Task task, Node node) {
        Node node2;
        if (!task.isEmpty()) {
            Node node3;
            node2 = TaskLoader.getChildNode(node, TASK_PERCENT_COMPLETE);
            if (node2 != null) {
                task.setCompletion(Double.parseDouble(XmlUtil.getTextFromNode(node2)));
            }
            if ((node3 = TaskLoader.getChildNode(node, TASK_WORK_PERCENT_COMPLETE)) != null) {
                task.setWorkCompletion(Double.parseDouble(XmlUtil.getTextFromNode(node3)), false);
            }
        }
        if ((node2 = TaskLoader.getChildNode(node, TASK_LIST)) != null) {
            TaskLoader.loadTaskListCompletion(task, node2);
        }
    }

    public static void loadTaskWorkDuration(Task task, Node node) {
        Node node2;
        if (!task.isEmpty()) {
            Node node3;
            Node node4;
            Node node5;
            node2 = TaskLoader.getChildNode(node, TASK_EFFORT_DRIVEN);
            boolean bl = false;
            if (node2 != null) {
                bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node2));
                task.setWorkDriven(bl);
            }
            Node node6 = TaskLoader.getChildNode(node, TASK_FIXED_UNITS);
            boolean bl2 = true;
            if (node6 != null) {
                bl2 = Boolean.parseBoolean(XmlUtil.getTextFromNode(node6));
                task.setFixedUnits(bl2);
            }
            if ((node5 = TaskLoader.getChildNode(node, TASK_DURATION)) != null) {
                task.setDuration(Long.parseLong(XmlUtil.getTextFromNode(node5)));
            }
            if ((node4 = TaskLoader.getChildNode(node, TASK_WORK_DURATION)) != null) {
                task.setWork(Long.parseLong(XmlUtil.getTextFromNode(node4)));
            }
            if ((node3 = TaskLoader.getChildNode(node, TASK_SPLIT)) != null) {
                task.setSplitted(Boolean.parseBoolean(XmlUtil.getTextFromNode(node3)));
            }
        }
        if ((node2 = TaskLoader.getChildNode(node, TASK_LIST)) != null) {
            TaskLoader.loadTaskListWorkDuration(task, node2);
        }
    }

    public static Element storeTask(Document document, Task task, boolean bl) {
        Element element;
        if (task.isEmpty()) {
            element = document.createElement(TASK_EMPTY);
            if (Common.SAVE_IDs) {
                Element element2 = XmlUtil.createTextElement(document, TASK_UNIQUE_ID, "" + task.getUniqueId());
                element.appendChild(element2);
            }
        } else {
            Element element3;
            Element element4;
            Element element5;
            Element element6;
            Element element7;
            Element element8;
            Element element9;
            Element element10;
            Element element11;
            Object object;
            Element element12;
            Element element13;
            Object object2;
            Element element14;
            Object object3;
            element = document.createElement(TASK);
            if (task.isProject()) {
                object3 = XmlUtil.createTextElement(document, PROJECT, task.isProject() + "");
                element14 = XmlUtil.createTextElement(document, PROJECT_CODE, task.getCode());
                object2 = PLANNING;
                if (task.getStatus().equals(Task.PLANNING)) {
                    object2 = PLANNING;
                } else if (task.getStatus().equals(Task.IN_PROGRESS)) {
                    object2 = IN_PROGRESS;
                } else if (task.getStatus().equals(Task.ON_HOLD)) {
                    object2 = ON_HOLD;
                } else if (task.getStatus().equals(Task.CLOSED)) {
                    object2 = CLOSED;
                }
                element13 = XmlUtil.createTextElement(document, PROJECT_STATUS, (String)object2);
                element12 = XmlUtil.createTextElement(document, PROJECT_MANAGER, task.getManager());
                object = XmlUtil.createTextElement(document, PROJECT_DESCRIPTION, task.getDescription());
                element11 = XmlUtil.createTextElement(document, PROJECT_ASSUMPTIONS, task.getAssumptions());
                element10 = XmlUtil.createTextElement(document, PROJECT_CONSTRAINTS, task.getConstraints());
                element9 = XmlUtil.createTextElement(document, PROJECT_CRITICAL_SLACK_LIMIT, "" + task.getCriticalSlackLimit());
                element8 = LinkLoader.storeLinkList(document, task.getLinks());
                element7 = RiskLoader.storeRiskList(document, task.getRisks());
                element6 = BaselineLoader.storeProjectBaselineList(document, task);
                element5 = DurationUnitLoader.storeDurationUnits(document, task.getDurationManager());
                element.appendChild((Node)object3);
                element.appendChild(element14);
                element.appendChild(element13);
                element.appendChild(element12);
                if (task.getClient() != null) {
                    element4 = XmlUtil.createTextElement(document, TASK_CLIENT_ID, "" + task.getClient().getId());
                    element.appendChild(element4);
                }
                element.appendChild((Node)object);
                element.appendChild(element11);
                element.appendChild(element10);
                element.appendChild(element9);
                element.appendChild(element8);
                element.appendChild(element7);
                element.appendChild(element6);
                element.appendChild(element5);
            }
            object3 = PrivacyManager.getInstance();
            element14 = XmlUtil.createTextElement(document, TASK_NAME, task.getName());
            object2 = XmlUtil.createTextElement(document, TASK_CONFLICT, task.isConflict() + "");
            element13 = XmlUtil.createTextElement(document, EXPANDED_GANTT, task.isExpanded() + "");
            element12 = XmlUtil.createTextElement(document, TASK_SPLIT, task.isSplitted() + "");
            object = "d";
            if (task.getDurationUnit().equals(DurationManager.MINUTE)) {
                object = "m";
            } else if (task.getDurationUnit().equals(DurationManager.HOUR)) {
                object = "h";
            } else if (task.getDurationUnit().equals(DurationManager.DAY)) {
                object = "d";
            } else if (task.getDurationUnit().equals(DurationManager.WEEK)) {
                object = "w";
            }
            element11 = XmlUtil.createTextElement(document, TASK_DURATION_UNIT, (String)object);
            object = "d";
            if (task.getWorkUnit().equals(DurationManager.MINUTE)) {
                object = "m";
            } else if (task.getWorkUnit().equals(DurationManager.HOUR)) {
                object = "h";
            } else if (task.getWorkUnit().equals(DurationManager.DAY)) {
                object = "d";
            } else if (task.getWorkUnit().equals(DurationManager.WEEK)) {
                object = "w";
            }
            element10 = XmlUtil.createTextElement(document, TASK_WORK_UNIT, (String)object);
            element9 = XmlUtil.createTextElement(document, TASK_CURRENCY_UNIT, task.getCurrencyUnit());
            element8 = XmlUtil.createTextElement(document, TASK_FIXED_COST, bl && ((PrivacyManager)object3).isHideTaskCosts() ? "0" : "" + task.getFixedCost());
            element7 = XmlUtil.createTextElement(document, TASK_ACCRUAL, task.getAccrual());
            element6 = XmlUtil.createTextElement(document, TASK_ID, "" + task.getId());
            element5 = XmlUtil.createTextElement(document, TASK_UNIQUE_ID, "" + task.getUniqueId());
            element4 = XmlUtil.createTextElement(document, TASK_FORCED_WORKING, "" + task.isForcedWorking());
            Element element15 = XmlUtil.createTextElement(document, TASK_EFFORT_DRIVEN, PrivacyManager.getInstance().isHideResources() ? "false" : "" + task.isWorkDriven());
            Element element16 = XmlUtil.createTextElement(document, TASK_FIXED_UNITS, task.isFixedUnits() + "");
            Element element17 = XmlUtil.createTextElement(document, TASK_WORK_DURATION, PrivacyManager.getInstance().isHideResources() ? "0" : "" + task.getWorkExceptChildren());
            Element element18 = XmlUtil.createTextElement(document, TASK_PERCENT_COMPLETE, "" + task.getCompletion());
            Element element19 = XmlUtil.createTextElement(document, TASK_WORK_PERCENT_COMPLETE, PrivacyManager.getInstance().isHideResources() ? "0.0" : "" + task.getWorkCompletion());
            Element element20 = XmlUtil.createTextElement(document, TASK_NOTES, bl && ((PrivacyManager)object3).isHideTaskNotes() ? "" : task.getNotes());
            Element element21 = XmlUtil.createTextElement(document, TASK_DURATION, String.valueOf(task.getDuration()));
            Element element22 = document.createElement(TASK_CONSTRAINT);
            element22.appendChild(ConstraintLoader.storeConstraint(document, task.getConstraint()));
            Element element23 = XmlUtil.createTextElement(document, TASK_START_DATE, dateFormat.format(task.getStartDate()));
            element.appendChild(element23);
            Element element24 = XmlUtil.createTextElement(document, TASK_END_DATE, dateFormat.format(task.getEndDate()));
            element.appendChild(element24);
            Element element25 = XmlUtil.createTextElement(document, TASK_COMPLETION_DATE, dateFormat.format(task.getCompletionDate()));
            element.appendChild(element25);
            if (task.getDeadlineDate() != null) {
                element3 = XmlUtil.createTextElement(document, TASK_DEADLINE, dateFormat.format(task.getDeadlineDate()));
                element.appendChild(element3);
            }
            element3 = BaselineLoader.storeBaselineList(document, task);
            Element element26 = document.createElement(TASK_LOOK);
            if (task.getBarColor() != null) {
                element26.appendChild(XmlUtil.createTextElement(document, TASK_BAR_COLOR, "" + task.getBarColor().getRGB()));
            }
            Element element27 = AdditionalFieldLoader.storeFieldList(document, task);
            element.appendChild(element14);
            element.appendChild(element6);
            if (Common.SAVE_IDs) {
                element.appendChild(element5);
            }
            element.appendChild((Node)object2);
            element.appendChild(element13);
            element.appendChild(element12);
            element.appendChild(element11);
            element.appendChild(element10);
            element.appendChild(element9);
            element.appendChild(element8);
            element.appendChild(element7);
            if (task.getCalendar() != null) {
                Element element28 = XmlUtil.createTextElement(document, TASK_CALENDAR_ID, "" + task.getCalendar().getId());
                element.appendChild(element28);
            }
            element.appendChild(element4);
            element.appendChild(element22);
            element.appendChild(element23);
            element.appendChild(element24);
            element.appendChild(element25);
            element.appendChild(element21);
            element.appendChild(element18);
            element.appendChild(element19);
            element.appendChild(element15);
            element.appendChild(element16);
            element.appendChild(element17);
            element.appendChild(element20);
            element.appendChild(element26);
            element.appendChild(element3);
            element.appendChild(element27);
            if (task.getChildNumber() != 0) {
                element.appendChild(TaskLoader.storeTaskList(document, task.getChildList(), bl));
            }
        }
        return element;
    }

    private static Element storeTaskList(Document document, List list, boolean bl) {
        Element element = document.createElement(TASK_LIST);
        for (Task task : list) {
            Element element2 = TaskLoader.storeTask(document, task, bl);
            element.appendChild(element2);
        }
        return element;
    }
}

