/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.core.DurationManager;
import com.sbs.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DurationUnitLoader {
    private static final String DEFAULT_UNIT = "default-unit";
    public static final String WEEK = "w";
    public static final String DAY = "d";
    public static final String HOUR = "h";
    public static final String MINUTE = "m";
    public static final String UNITS_DURATION = "units-duration";

    public static void loadDurationUnits(Node node, DurationManager durationManager) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(DEFAULT_UNIT) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                if (string.equals(MINUTE)) {
                    durationManager.setDefaultUnit(DurationManager.MINUTE);
                    continue;
                }
                if (string.equals(HOUR)) {
                    durationManager.setDefaultUnit(DurationManager.HOUR);
                    continue;
                }
                if (string.equals(DAY)) {
                    durationManager.setDefaultUnit(DurationManager.DAY);
                    continue;
                }
                if (!string.equals(WEEK)) continue;
                durationManager.setDefaultUnit(DurationManager.WEEK);
                continue;
            }
            if (node2.getNodeName().compareTo(WEEK) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                durationManager.setDuration(DurationManager.WEEK, Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(DAY) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                durationManager.setDuration(DurationManager.DAY, Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(HOUR) == 0) {
                string = XmlUtil.getTextFromNode(node2);
                durationManager.setDuration(DurationManager.HOUR, Long.parseLong(string));
                continue;
            }
            if (node2.getNodeName().compareTo(MINUTE) != 0) continue;
            string = XmlUtil.getTextFromNode(node2);
            durationManager.setDuration(DurationManager.MINUTE, Long.parseLong(string));
        }
    }

    public static Element storeDurationUnits(Document document, DurationManager durationManager) {
        Element element = document.createElement(UNITS_DURATION);
        String string = DAY;
        if (durationManager.getDefaultUnit().equals(DurationManager.MINUTE)) {
            string = MINUTE;
        } else if (durationManager.getDefaultUnit().equals(DurationManager.HOUR)) {
            string = HOUR;
        } else if (durationManager.getDefaultUnit().equals(DurationManager.DAY)) {
            string = DAY;
        } else if (durationManager.getDefaultUnit().equals(DurationManager.WEEK)) {
            string = WEEK;
        }
        element.appendChild(XmlUtil.createTextElement(document, DEFAULT_UNIT, string));
        element.appendChild(XmlUtil.createTextElement(document, WEEK, "" + durationManager.getDuration(DurationManager.WEEK)));
        element.appendChild(XmlUtil.createTextElement(document, DAY, "" + durationManager.getDuration(DurationManager.DAY)));
        element.appendChild(XmlUtil.createTextElement(document, HOUR, "" + durationManager.getDuration(DurationManager.HOUR)));
        element.appendChild(XmlUtil.createTextElement(document, MINUTE, "" + durationManager.getDuration(DurationManager.MINUTE)));
        return element;
    }
}

