/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.xml.XmlUtil;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DependencyLoader {
    private static final String TASK_PREDECESSOR_ID = "task-predecessor-id";
    private static final String TASK_SUCCESSOR_ID = "task-successor-id";
    public static final String TASK_DEPENDENCY_LIST = "task-dependency-list";
    private static final String TASK_DEPENDENCY = "task-dependency";
    private static final String TASK_DEPENDENCY_TYPE = "dependency-type";
    private static final String TASK_DEPENDENCY_START_TO_START = "start-to-start";
    private static final String TASK_DEPENDENCY_START_TO_FINISH = "start-to-finish";
    private static final String TASK_DEPENDENCY_FINISH_TO_START = "finish-to-start";
    private static final String TASK_DEPENDENCY_FINISH_TO_FINISH = "finish-to-finish";
    private static final String TASK_DEPENDENCY_LAG = "lag";
    private static final String DEPENDENCY_UNIQUE_ID = "dependency-unique-id";
    private static final String TASK_DEPENDENCY_UNIT = "task-dependency-unit";
    private TaskCollection taskCollection;

    public DependencyLoader(TaskCollection taskCollection) {
        this.taskCollection = taskCollection;
    }

    public List loadTaskDependencyList(Node node) {
        LinkedList<Dependency> linkedList = new LinkedList<Dependency>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(TASK_DEPENDENCY) != 0) continue;
            linkedList.add(this.loadTaskDependency(node2));
        }
        return linkedList;
    }

    private Dependency loadTaskDependency(Node node) {
        Dependency dependency = new Dependency(Long.MIN_VALUE);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(TASK_DEPENDENCY_TYPE) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                if (TASK_DEPENDENCY_START_TO_START.compareTo((String)object) == 0) {
                    dependency.setType(1);
                    continue;
                }
                if (TASK_DEPENDENCY_START_TO_FINISH.compareTo((String)object) == 0) {
                    dependency.setType(2);
                    continue;
                }
                if (TASK_DEPENDENCY_FINISH_TO_START.compareTo((String)object) == 0) {
                    dependency.setType(0);
                    continue;
                }
                if (TASK_DEPENDENCY_FINISH_TO_FINISH.compareTo((String)object) == 0) {
                    dependency.setType(3);
                    continue;
                }
                throw new RuntimeException("Invalid dependency type: " + (String)object);
            }
            if (node2.getNodeName().compareTo(TASK_PREDECESSOR_ID) == 0) {
                object = this.taskCollection.getTaskForId((long)Long.valueOf(XmlUtil.getTextFromNode(node2)));
                dependency.setPredecessor((Task)object);
                continue;
            }
            if (node2.getNodeName().compareTo(TASK_SUCCESSOR_ID) == 0) {
                object = this.taskCollection.getTaskForId((long)Long.valueOf(XmlUtil.getTextFromNode(node2)));
                dependency.setSuccessor((Task)object);
                continue;
            }
            if (node2.getNodeName().compareTo(DEPENDENCY_UNIQUE_ID) == 0) {
                object = (long)Long.valueOf(XmlUtil.getTextFromNode(node2));
                dependency.setUniqueId((Long)object);
                continue;
            }
            if (node2.getNodeName().compareTo(TASK_DEPENDENCY_LAG) == 0) {
                object = XmlUtil.getTextFromNode(node2);
                long l = Long.parseLong((String)object);
                dependency.setTaskDelay(l);
                continue;
            }
            if (node2.getNodeName().compareTo(TASK_DEPENDENCY_UNIT) != 0) continue;
            object = XmlUtil.getTextFromNode(node2);
            if (((String)object).equals("m")) {
                dependency.setUnit(DurationManager.MINUTE);
                continue;
            }
            if (((String)object).equals("h")) {
                dependency.setUnit(DurationManager.HOUR);
                continue;
            }
            if (((String)object).equals("d")) {
                dependency.setUnit(DurationManager.DAY);
                continue;
            }
            if (!((String)object).equals("w")) continue;
            dependency.setUnit(DurationManager.WEEK);
        }
        return dependency;
    }

    public Element storeTaskDependencyList(Document document, Task task) {
        Element element = document.createElement(TASK_DEPENDENCY_LIST);
        this.storeTaskDependencyList(document, element, task, task);
        return element;
    }

    private void storeTaskDependencyList(Document document, Element element, Task task, Task task2) {
        for (Dependency mouseHoover : task.getPredecessorDependencies()) {
            Object[] objectArray;
            if (mouseHoover.getPredecessor().isDescendent(task2)) {
                objectArray = this.storeTaskDependency(document, mouseHoover);
                element.appendChild((Node)objectArray);
                continue;
            }
            objectArray = new Object[]{task.getName(), mouseHoover.getPredecessor().getName()};
            JOptionPane.showMessageDialog(null, MessageFormat.format(Common.I18N_MESSAGES.getString("dependency.externalDependency.message"), objectArray), Common.I18N_MESSAGES.getString("dependency.externalDependency.title"), 2);
        }
        for (Task task3 : task.getChildList()) {
            this.storeTaskDependencyList(document, element, task3, task2);
        }
    }

    private Element storeTaskDependency(Document document, Dependency dependency) {
        Element element = document.createElement(TASK_DEPENDENCY);
        Element element2 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_FINISH_TO_START);
        if (dependency.getType() == 1) {
            element2 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_START_TO_START);
        } else if (dependency.getType() == 2) {
            element2 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_START_TO_FINISH);
        } else if (dependency.getType() == 0) {
            element2 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_FINISH_TO_START);
        } else if (dependency.getType() == 3) {
            element2 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_TYPE, TASK_DEPENDENCY_FINISH_TO_FINISH);
        }
        Element element3 = XmlUtil.createTextElement(document, TASK_PREDECESSOR_ID, "" + dependency.getPredecessor().getId());
        Element element4 = XmlUtil.createTextElement(document, TASK_SUCCESSOR_ID, "" + dependency.getSuccessor().getId());
        Element element5 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_LAG, String.valueOf(dependency.getTaskDelay()));
        Element element6 = XmlUtil.createTextElement(document, DEPENDENCY_UNIQUE_ID, String.valueOf(dependency.getUniqueId()));
        String string = "d";
        if (dependency.getUnit().equals(DurationManager.MINUTE)) {
            string = "m";
        } else if (dependency.getUnit().equals(DurationManager.HOUR)) {
            string = "h";
        } else if (dependency.getUnit().equals(DurationManager.DAY)) {
            string = "d";
        } else if (dependency.getUnit().equals(DurationManager.WEEK)) {
            string = "w";
        }
        Element element7 = XmlUtil.createTextElement(document, TASK_DEPENDENCY_UNIT, string);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element2);
        if (Common.SAVE_IDs) {
            element.appendChild(element6);
        }
        element.appendChild(element5);
        element.appendChild(element7);
        return element;
    }
}

