/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.conflict.Conflict;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.xml.XmlUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictLoader {
    private static final String CONFLICT_TASK_ID = "conflict-task-id";
    private static final String CONFLICT_MESSAGE = "conflict-message";
    public static final String CONFLICT_LIST = "conflict-list";
    private static final String CONFLICT = "conflict";
    private TaskCollection taskCollection;

    public ConflictLoader(TaskCollection taskCollection) {
        this.taskCollection = taskCollection;
    }

    public List<Conflict> loadConflictList(Node node) {
        LinkedList<Conflict> linkedList = new LinkedList<Conflict>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(CONFLICT) != 0) continue;
            linkedList.add(this.loadConflict(node2));
        }
        return linkedList;
    }

    private Conflict loadConflict(Node node) {
        Conflict conflict = new Conflict();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(CONFLICT_TASK_ID) == 0) {
                Task task = this.taskCollection.getTaskForId((long)Long.valueOf(XmlUtil.getTextFromNode(node2)));
                conflict.setTask(task);
                continue;
            }
            if (node2.getNodeName().compareTo(CONFLICT_MESSAGE) != 0) continue;
            conflict.setMessage(XmlUtil.getTextFromNode(node2));
        }
        return conflict;
    }

    public Element storeConflictList(Document document, Company company) {
        Element element = document.createElement(CONFLICT_LIST);
        this.storeConflictList(document, element, company);
        return element;
    }

    private void storeConflictList(Document document, Element element, Company company) {
        for (Conflict conflict : company.getConflictManager().getConflicts()) {
            if (!conflict.getTask().isDescendent(company.getRootTask())) continue;
            Element element2 = this.storeConflict(document, conflict);
            element.appendChild(element2);
        }
    }

    private Element storeConflict(Document document, Conflict conflict) {
        Element element = document.createElement(CONFLICT);
        Element element2 = XmlUtil.createTextElement(document, CONFLICT_TASK_ID, "" + conflict.getTask().getId());
        Element element3 = XmlUtil.createTextElement(document, CONFLICT_MESSAGE, conflict.getMessage());
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }
}

