/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.StandardCalendarManager;
import com.sbs.jpm.core.InvalidOperationException;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CalendarLoader {
    private static final String CALENDAR = "calendar";
    private static final String CALENDAR_NAME = "calendar-name";
    private static final String CALENDAR_ID = "calendar-id";
    private static final String CALENDAR_UNIQUE_ID = "calendar-unique-id";
    public static final String CALENDAR_LIST = "calendar-list";
    private static final String WEEK_PATTERN_LIST = "week-pattern-list";
    private static final String SPECIAL_PATTERN_LIST = "special-pattern-list";
    private static final String PATTERN = "pattern";
    private static final String PATTERN_POSITION = "day-in-week";
    private static final String PATTERN_DATE = "date";
    private static final String PERIOD_IN_DAY = "period-in-day";
    private static final String PERIOD_TYPE = "period-type";
    private static final String PERIOD_START = "period-start-date";
    private static final String PERIOD_END = "period-end-date";
    private static final DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss");

    public static List loadCalendarList(Node node) {
        LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(CALENDAR) != 0) continue;
            CalendarManager calendarManager = CalendarLoader.loadCalendar(node2);
            linkedList.add(calendarManager);
        }
        return linkedList;
    }

    private static CalendarManager loadCalendar(Node node) {
        StandardCalendarManager standardCalendarManager = new StandardCalendarManager(Long.MIN_VALUE);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(CALENDAR_NAME) == 0) {
                standardCalendarManager.setName(XmlUtil.getTextFromNode(node2));
            }
            if (node2.getNodeName().compareTo(CALENDAR_ID) == 0) {
                standardCalendarManager.setId(Long.parseLong(XmlUtil.getTextFromNode(node2)));
            }
            if (node2.getNodeName().compareTo(CALENDAR_UNIQUE_ID) == 0) {
                standardCalendarManager.setUniqueId(Long.parseLong(XmlUtil.getTextFromNode(node2)));
            }
            if (node2.getNodeName().compareTo(WEEK_PATTERN_LIST) == 0) {
                CalendarLoader.loadWeekPatternList(standardCalendarManager, node2);
                continue;
            }
            if (node2.getNodeName().compareTo(SPECIAL_PATTERN_LIST) != 0) continue;
            CalendarLoader.loadSpecialPatternList(standardCalendarManager, node2);
        }
        return standardCalendarManager;
    }

    private static void loadWeekPatternList(CalendarManager calendarManager, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PATTERN) != 0) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem(PATTERN_POSITION);
            calendarManager.setDayPattern(Integer.valueOf(node3.getNodeValue()), CalendarLoader.loadDayPattern(calendarManager, node2));
        }
    }

    private static void loadSpecialPatternList(CalendarManager calendarManager, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PATTERN) != 0) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem(PATTERN_DATE);
            String string = node3.getNodeValue();
            Date date = null;
            try {
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                Common.logException("Error:", parseException);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendarManager.setDayPattern(calendar, CalendarLoader.loadDayPattern(calendarManager, node2));
        }
    }

    private static DayWorkingPattern loadDayPattern(CalendarManager calendarManager, Node node) {
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        dayWorkingPattern.setOwner(calendarManager);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(PERIOD_IN_DAY) != 0) continue;
            dayWorkingPattern.addAlternance(CalendarLoader.loadPeriodInDay(node2));
        }
        dayWorkingPattern.fillWithNonWorking();
        return dayWorkingPattern;
    }

    private static PeriodInDay loadPeriodInDay(Node node) {
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(PERIOD_TYPE) == 0) {
                bl = Boolean.parseBoolean(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(PERIOD_START) == 0) {
                l = Long.parseLong(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(PERIOD_END) != 0) continue;
            l2 = Long.parseLong(XmlUtil.getTextFromNode(node2));
        }
        PeriodInDay periodInDay = null;
        try {
            periodInDay = new PeriodInDay(bl, l, l2);
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
            JOptionPane.showMessageDialog(Common.getApplication(), invalidOperationException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
        }
        return periodInDay;
    }

    public static Element storeCalendarList(Document document, List list) {
        Element element = document.createElement(CALENDAR_LIST);
        for (CalendarManager calendarManager : list) {
            Element element2 = CalendarLoader.storeCalendar(document, calendarManager);
            element.appendChild(element2);
        }
        return element;
    }

    private static Element storeCalendar(Document document, CalendarManager calendarManager) {
        Element element = document.createElement(CALENDAR);
        Element element2 = XmlUtil.createTextElement(document, CALENDAR_NAME, calendarManager.getName());
        Element element3 = XmlUtil.createTextElement(document, CALENDAR_ID, "" + calendarManager.getId());
        Element element4 = XmlUtil.createTextElement(document, CALENDAR_UNIQUE_ID, "" + calendarManager.getUniqueId());
        Element element5 = CalendarLoader.storeWeekPatternList(document, calendarManager.getWeekPatternList());
        Element element6 = CalendarLoader.storeSpecialPatternList(document, calendarManager.getSpecialPatternList());
        element.appendChild(element2);
        if (Common.SAVE_IDs) {
            element.appendChild(element4);
        }
        element.appendChild(element3);
        element.appendChild(element5);
        element.appendChild(element6);
        return element;
    }

    private static Element storeWeekPatternList(Document document, DayWorkingPattern[] dayWorkingPatternArray) {
        Element element = document.createElement(WEEK_PATTERN_LIST);
        for (int i = 0; i < dayWorkingPatternArray.length; ++i) {
            DayWorkingPattern dayWorkingPattern = dayWorkingPatternArray[i];
            Element element2 = CalendarLoader.storeDayPattern(document, i + 1, dayWorkingPattern);
            element.appendChild(element2);
        }
        return element;
    }

    private static Element storeSpecialPatternList(Document document, List list) {
        Element element = document.createElement(SPECIAL_PATTERN_LIST);
        for (CalendarManager.SpecialDay specialDay : list) {
            Element element2 = CalendarLoader.storeDayPattern(document, specialDay.getDate(), specialDay.getDayPattern());
            element.appendChild(element2);
        }
        return element;
    }

    private static Element storeDayPattern(Document document, int n, DayWorkingPattern dayWorkingPattern) {
        Element element = document.createElement(PATTERN);
        element.setAttribute(PATTERN_POSITION, String.valueOf(n));
        PeriodInDay[] periodInDayArray = dayWorkingPattern.getPeriodsInDay();
        for (int i = 0; i < periodInDayArray.length; ++i) {
            PeriodInDay periodInDay = periodInDayArray[i];
            element.appendChild(CalendarLoader.storePeriodInDay(document, periodInDay));
        }
        return element;
    }

    private static Element storeDayPattern(Document document, Calendar calendar, DayWorkingPattern dayWorkingPattern) {
        Element element = document.createElement(PATTERN);
        element.setAttribute(PATTERN_DATE, dateFormat.format(calendar.getTime()));
        PeriodInDay[] periodInDayArray = dayWorkingPattern.getPeriodsInDay();
        for (int i = 0; i < periodInDayArray.length; ++i) {
            PeriodInDay periodInDay = periodInDayArray[i];
            element.appendChild(CalendarLoader.storePeriodInDay(document, periodInDay));
        }
        return element;
    }

    private static Element storePeriodInDay(Document document, PeriodInDay periodInDay) {
        Element element = document.createElement(PERIOD_IN_DAY);
        Element element2 = XmlUtil.createTextElement(document, PERIOD_TYPE, String.valueOf(periodInDay.isWorking()));
        Element element3 = XmlUtil.createTextElement(document, PERIOD_START, String.valueOf(periodInDay.getStartPeriod()));
        Element element4 = XmlUtil.createTextElement(document, PERIOD_END, String.valueOf(periodInDay.getEndPeriod()));
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        return element;
    }
}

