/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.dB.ResourceCollection;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.jpm.ui.PrivacyManager;
import com.sbs.xml.XmlUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssignmentLoader {
    private static final String ASSIGNMENT_UNIQUE_ID = "assignment-unique-id";
    private static final String ASSIGNMENT_TASK_ID = "assignment-task-id";
    private static final String ASSIGNMENT_RESOURCE_ID = "assignment-resource-id";
    private static final String ASSIGNMENT_UNITS = "assignment-units";
    public static final String ASSIGNMENT_LIST = "assignment-list";
    private static final String ASSIGNMENT = "assignment";
    private TaskCollection taskCollection;
    private ResourceCollection resourceCollection;

    public AssignmentLoader(TaskCollection taskCollection, ResourceCollection resourceCollection) {
        this.taskCollection = taskCollection;
        this.resourceCollection = resourceCollection;
    }

    public List loadAssignmentList(Node node) {
        LinkedList<Assignment> linkedList = new LinkedList<Assignment>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(ASSIGNMENT) != 0) continue;
            linkedList.add(this.loadAssignment(node2));
        }
        return linkedList;
    }

    private Assignment loadAssignment(Node node) {
        Assignment assignment = new Assignment(Long.MIN_VALUE);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(ASSIGNMENT_UNIQUE_ID) == 0) {
                long l = Long.valueOf(XmlUtil.getTextFromNode(node2));
                assignment.setUniqueId(l);
                continue;
            }
            if (node2.getNodeName().compareTo(ASSIGNMENT_TASK_ID) == 0) {
                Task task = this.taskCollection.getTaskForId((long)Long.valueOf(XmlUtil.getTextFromNode(node2)));
                assignment.setTask(task);
                continue;
            }
            if (node2.getNodeName().compareTo(ASSIGNMENT_RESOURCE_ID) == 0) {
                Resource resource = this.resourceCollection.getResourceForId((long)Long.valueOf(XmlUtil.getTextFromNode(node2)));
                assignment.setResource(resource);
                continue;
            }
            if (node2.getNodeName().compareTo(ASSIGNMENT_UNITS) != 0) continue;
            double d = Double.valueOf(XmlUtil.getTextFromNode(node2));
            assignment.setUnits(d);
        }
        return assignment;
    }

    public Element storeAssignmentList(Document document, Task task) {
        Element element = document.createElement(ASSIGNMENT_LIST);
        if (!PrivacyManager.getInstance().isHideResources()) {
            this.storeAssignmentList(document, element, task);
        }
        return element;
    }

    private void storeAssignmentList(Document document, Element element, Task task) {
        for (Assignment uniqueId : task.getAssignments()) {
            Element element2 = this.storeAssignment(document, uniqueId);
            element.appendChild(element2);
        }
        for (Task task2 : task.getChildList()) {
            this.storeAssignmentList(document, element, task2);
        }
    }

    private Element storeAssignment(Document document, Assignment assignment) {
        Element element = document.createElement(ASSIGNMENT);
        Element element2 = XmlUtil.createTextElement(document, ASSIGNMENT_UNIQUE_ID, "" + assignment.getUniqueId());
        Element element3 = XmlUtil.createTextElement(document, ASSIGNMENT_TASK_ID, "" + assignment.getTask().getId());
        Element element4 = XmlUtil.createTextElement(document, ASSIGNMENT_RESOURCE_ID, "" + assignment.getResource().getId());
        Element element5 = XmlUtil.createTextElement(document, ASSIGNMENT_UNITS, "" + assignment.getUnits());
        if (Common.SAVE_IDs) {
            element.appendChild(element2);
        }
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        return element;
    }
}

