/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.xml;

import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdditionalFieldLoader {
    public static final String TASK_FIELD_LIST = "task-field-list";
    public static final String RESOURCE_FIELD_LIST = "resource-field-list";
    public static final String CLIENT_FIELD_LIST = "client-field-list";
    private static final String NO = "no";
    private static final String NAME = "name";
    public static final String FIELD_LIST = "field-list";
    private static final String FIELD = "field";
    private static final String FIELD_NO = "field-no";
    private static final String FIELD_VALUE = "field-value";

    public static void loadCompanyTaskFieldList(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(FIELD) != 0) continue;
            AdditionalFieldLoader.loadCompanyTaskField(node2);
        }
    }

    public static void loadCompanyClientFieldList(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(FIELD) != 0) continue;
            AdditionalFieldLoader.loadCompanyClientField(node2);
        }
    }

    public static void loadCompanyResourceFieldList(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(FIELD) != 0) continue;
            AdditionalFieldLoader.loadCompanyResourceField(node2);
        }
    }

    public static void loadTaskFieldList(Task task, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(FIELD) != 0) continue;
            AdditionalFieldLoader.loadField(node2, task);
        }
    }

    public static void loadClientFieldList(Client client, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(FIELD) != 0) continue;
            AdditionalFieldLoader.loadField(node2, client);
        }
    }

    public static void loadResourceFieldList(Resource resource, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(FIELD) != 0) continue;
            AdditionalFieldLoader.loadField(node2, resource);
        }
    }

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    private static void loadField(Node node, Task task) {
        Node node2 = AdditionalFieldLoader.getChildNode(node, FIELD_NO);
        if (node2 != null) {
            String string;
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            Node node3 = AdditionalFieldLoader.getChildNode(node, FIELD_VALUE);
            if (node3 != null && (string = XmlUtil.getTextFromNode(node3)) != null) {
                task.setFieldAt(n, string);
            }
        }
    }

    private static void loadField(Node node, Client client) {
        Node node2 = AdditionalFieldLoader.getChildNode(node, FIELD_NO);
        if (node2 != null) {
            String string;
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            Node node3 = AdditionalFieldLoader.getChildNode(node, FIELD_VALUE);
            if (node3 != null && (string = XmlUtil.getTextFromNode(node3)) != null) {
                client.setFieldAt(n, string);
            }
        }
    }

    private static void loadField(Node node, Resource resource) {
        Node node2 = AdditionalFieldLoader.getChildNode(node, FIELD_NO);
        if (node2 != null) {
            String string;
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            Node node3 = AdditionalFieldLoader.getChildNode(node, FIELD_VALUE);
            if (node3 != null && (string = XmlUtil.getTextFromNode(node3)) != null) {
                resource.setFieldAt(n, string);
            }
        }
    }

    private static void loadCompanyTaskField(Node node) {
        Node node2 = AdditionalFieldLoader.getChildNode(node, NO);
        if (node2 != null) {
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1 || node3.getNodeName().compareTo(NAME) != 0) continue;
                String string = XmlUtil.getTextFromNode(node3);
                FieldManager.getInstance().setTaskFieldNameAt(n, string);
            }
        }
    }

    private static void loadCompanyResourceField(Node node) {
        Node node2 = AdditionalFieldLoader.getChildNode(node, NO);
        if (node2 != null) {
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1 || node3.getNodeName().compareTo(NAME) != 0) continue;
                String string = XmlUtil.getTextFromNode(node3);
                FieldManager.getInstance().setResourceFieldNameAt(n, string);
            }
        }
    }

    private static void loadCompanyClientField(Node node) {
        Node node2 = AdditionalFieldLoader.getChildNode(node, NO);
        if (node2 != null) {
            int n = Integer.parseInt(XmlUtil.getTextFromNode(node2));
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1 || node3.getNodeName().compareTo(NAME) != 0) continue;
                String string = XmlUtil.getTextFromNode(node3);
                FieldManager.getInstance().setClientFieldNameAt(n, string);
            }
        }
    }

    public static Element storeTaskFieldList(Document document) {
        Element element = document.createElement(TASK_FIELD_LIST);
        FieldManager fieldManager = FieldManager.getInstance();
        for (int i = 0; i < 10; ++i) {
            element.appendChild(AdditionalFieldLoader.storeCompanyField(document, fieldManager.getTaskFieldNameAt(i), i));
        }
        return element;
    }

    public static Element storeResourceFieldList(Document document) {
        Element element = document.createElement(RESOURCE_FIELD_LIST);
        FieldManager fieldManager = FieldManager.getInstance();
        for (int i = 0; i < 10; ++i) {
            element.appendChild(AdditionalFieldLoader.storeCompanyField(document, fieldManager.getResourceFieldNameAt(i), i));
        }
        return element;
    }

    public static Element storeClientFieldList(Document document) {
        Element element = document.createElement(CLIENT_FIELD_LIST);
        FieldManager fieldManager = FieldManager.getInstance();
        for (int i = 0; i < 10; ++i) {
            element.appendChild(AdditionalFieldLoader.storeCompanyField(document, fieldManager.getClientFieldNameAt(i), i));
        }
        return element;
    }

    public static Element storeFieldList(Document document, Task task) {
        Element element = document.createElement(FIELD_LIST);
        for (int i = 0; i < 10; ++i) {
            String string = task.getFieldAt(i);
            if (string == null) continue;
            element.appendChild(AdditionalFieldLoader.storeField(document, string, i));
        }
        return element;
    }

    public static Element storeFieldList(Document document, Client client) {
        Element element = document.createElement(FIELD_LIST);
        for (int i = 0; i < 10; ++i) {
            String string = client.getFieldAt(i);
            if (string == null) continue;
            element.appendChild(AdditionalFieldLoader.storeField(document, string, i));
        }
        return element;
    }

    public static Element storeFieldList(Document document, Resource resource) {
        Element element = document.createElement(FIELD_LIST);
        for (int i = 0; i < 10; ++i) {
            String string = resource.getFieldAt(i);
            if (string == null) continue;
            element.appendChild(AdditionalFieldLoader.storeField(document, string, i));
        }
        return element;
    }

    private static Element storeCompanyField(Document document, String string, int n) {
        Element element = document.createElement(FIELD);
        element.appendChild(XmlUtil.createTextElement(document, NO, "" + n));
        if (string != null) {
            element.appendChild(XmlUtil.createTextElement(document, NAME, string));
        }
        return element;
    }

    private static Element storeField(Document document, String string, int n) {
        Element element = document.createElement(FIELD);
        element.appendChild(XmlUtil.createTextElement(document, FIELD_NO, "" + n));
        if (string != null) {
            element.appendChild(XmlUtil.createTextElement(document, FIELD_VALUE, string));
        }
        return element;
    }
}

