/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.msproject.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.constraint.ALAP;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.jpm.dB.msproject.xml.BaselineLoader;
import com.sbs.jpm.dB.msproject.xml.DependencyLoader;
import com.sbs.xml.XmlUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskLoader {
    private static Hashtable wbsToTaskMap = new Hashtable();
    public static final String TASK_LIST = "Tasks";
    private static final String TASK = "Task";
    private static final String TASK_ID = "ID";
    public static final String TASK_UID = "UID";
    private static final String TASK_NAME = "Name";
    public static final String TASK_EMPTY = "IsNull";
    private static final String TASK_TYPE = "Type";
    private static final String TASK_EFFORT_DRIVEN = "EffortDriven";
    private static final String TASK_START = "Start";
    private static final String TASK_FINISH = "Finish";
    private static final String TASK_STOP = "Stop";
    private static final String TASK_UNIT = "DurationFormat";
    private static final String TASK_FIXED_COST = "FixedCost";
    private static final String TASK_ACCRUAL = "FixedCostAccrual";
    private static final String TASK_PERCENT_COMPLETE = "PercentComplete";
    private static final String TASK_PERCENT_WORK_COMPLETE = "PercentWorkComplete";
    private static final String TASK_CALENDAR_ID = "CalendarUID";
    private static final String TASK_NOTES = "Notes";
    private static final String TASK_FORCED_WORKING = "IgnoreResourceCalendar";
    private static final String TASK_DURATION = "Duration";
    private static final String TASK_WORK = "Work";
    private static final String TASK_REMAINING_DURATION = "RemainingDuration";
    private static final String TASK_CONSTRAINT = "ConstraintType";
    private static final String TASK_CONSTRAINT_DATE = "ConstraintDate";
    private static final String TASK_DEADLINE = "Deadline";
    private static final String TASK_SUMMARY = "Summary";
    private static final String TASK_WBS = "WBS";
    private static final String TASK_OUTLINE_LEVEL = "OutlineLevel";
    private static final String TASK_OUTLINE_NUMBER = "OutlineNumber";
    private static final String TASK_MILESTONE = "Milestone";
    private static final String TASK_CRITICAL = "Critical";
    private static final String TASK_SPLIT = "TimephasedData";
    private static final String TASK_SPLIT_START = "Start";
    private static final String TASK_SPLIT_FINISH = "Finish";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    private static Task getTaskForWBS(String string) {
        return (Task)wbsToTaskMap.get(string);
    }

    private static void putTaskForWBS(String string, Task task) {
        wbsToTaskMap.put(string, task);
    }

    public static void loadTaskCompletion(Task task, Node node) {
        if (!task.isEmpty() && !task.isProject() && task.isLeaf() || task.isSplitted()) {
            Node node2;
            Node node3 = TaskLoader.getChildNode(node, TASK_PERCENT_COMPLETE);
            if (node3 != null) {
                task.setCompletion(Double.parseDouble(XmlUtil.getTextFromNode(node3)));
            }
            if ((node2 = TaskLoader.getChildNode(node, TASK_PERCENT_WORK_COMPLETE)) != null) {
                task.setWorkCompletion(Double.parseDouble(XmlUtil.getTextFromNode(node2)), false);
            }
        }
    }

    public static void loadTaskTypeDriven(Task task, Node node) {
        Node node2;
        if (!task.isEmpty() && task.isLeaf() && (node2 = TaskLoader.getChildNode(node, TASK_EFFORT_DRIVEN)) != null) {
            task.setWorkDriven(XmlUtil.getTextFromNode(node2).equals("1"));
        }
    }

    public static Task loadTask(Company company, Task task, Node node, CalendarCollection calendarCollection) throws Exception {
        Object object;
        Object object2;
        Node node2;
        Task task2 = new Task(company.getIdGenerator().getNewId());
        Node node3 = TaskLoader.getChildNode(node, TASK_EMPTY);
        if (node3 != null) {
            if (XmlUtil.getTextFromNode(node3).equals("0")) {
                task2.setEmpty(false);
                task2.setCompany(company);
            } else {
                task2.setEmpty(true);
            }
        }
        if ((node2 = TaskLoader.getChildNode(node, TASK_OUTLINE_LEVEL)) != null) {
            object2 = XmlUtil.getTextFromNode(node2);
            Task task3 = null;
            Node node4 = TaskLoader.getChildNode(node, TASK_OUTLINE_NUMBER);
            if (node4 != null) {
                object = XmlUtil.getTextFromNode(node4);
                if (!((String)object).equals("0")) {
                    TaskLoader.putTaskForWBS((String)object, task2);
                    if (((String)object).lastIndexOf(".") == -1) {
                        task3 = task;
                        task3.addChild(task2, false);
                    } else {
                        task3 = TaskLoader.getTaskForWBS(((String)object).substring(0, ((String)object).lastIndexOf(".")));
                        task3.addChild(Integer.parseInt(((String)object).substring(((String)object).lastIndexOf(".") + 1)) - 1, task2);
                    }
                }
            } else {
                task3 = task;
                task3.addChild(task2, false);
            }
        } else {
            task.addChild(task2, false);
        }
        object2 = null;
        boolean bl = true;
        boolean bl2 = false;
        if (!task2.isEmpty()) {
            object = node.getChildNodes();
            block23: for (int i = 0; i < object.getLength(); ++i) {
                long l;
                Node node5 = object.item(i);
                if (node5.getNodeType() != 1) continue;
                if (node5.getNodeName().compareTo(TASK_NAME) == 0) {
                    String string = XmlUtil.getTextFromNode(node5);
                    if (string == null) continue;
                    task2.setName(string);
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_UID) == 0) {
                    String string = XmlUtil.getTextFromNode(node5);
                    l = Long.parseLong(string);
                    task2.setId(l);
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_UNIT) == 0) {
                    int n = Integer.parseInt(XmlUtil.getTextFromNode(node5));
                    switch (n) {
                        case 3: 
                        case 4: 
                        case 35: 
                        case 36: {
                            task2.setDurationUnit(DurationManager.MINUTE);
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 37: 
                        case 38: {
                            task2.setDurationUnit(DurationManager.HOUR);
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 39: 
                        case 40: {
                            task2.setDurationUnit(DurationManager.DAY);
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 41: 
                        case 42: {
                            task2.setDurationUnit(DurationManager.WEEK);
                            break;
                        }
                        default: {
                            task2.setDurationUnit(DurationManager.DAY);
                            break;
                        }
                    }
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_FIXED_COST) == 0) {
                    String string = XmlUtil.getTextFromNode(node5);
                    double d = Double.parseDouble(string);
                    task2.setFixedCost(d);
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_ACCRUAL) == 0) {
                    int n = Integer.parseInt(XmlUtil.getTextFromNode(node5));
                    switch (n) {
                        case 1: {
                            task2.setAccrual(Task.START);
                            break;
                        }
                        case 2: {
                            task2.setAccrual(Task.PRORATED);
                            break;
                        }
                        case 3: {
                            task2.setAccrual(Task.END);
                            break;
                        }
                        default: {
                            task2.setAccrual(Task.PRORATED);
                            break;
                        }
                    }
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_CALENDAR_ID) == 0) {
                    long l2 = Long.parseLong(XmlUtil.getTextFromNode(node5));
                    task2.setCalendar(calendarCollection.getCalendarForId(l2));
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_FORCED_WORKING) == 0) {
                    task2.setForcedWorking(XmlUtil.getTextFromNode(node5).equals("1"));
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_NOTES) == 0) {
                    String string = XmlUtil.getTextFromNode(node5);
                    if (string == null) continue;
                    task2.setNotes(string);
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_MILESTONE) == 0) {
                    if (!XmlUtil.getTextFromNode(node5).equals("1")) continue;
                    task2.setDuration(0L);
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_DURATION) == 0) {
                    String string = XmlUtil.getTextFromNode(node5);
                    l = 0L;
                    l += (long)Integer.parseInt(string.substring(2, string.indexOf("H"))) * 3600000L;
                    l += (long)Integer.parseInt(string.substring(string.indexOf("H") + 1, string.indexOf("M"))) * 60000L;
                    task2.setDuration(l += (long)Integer.parseInt(string.substring(string.indexOf("M") + 1, string.indexOf("S"))) * 1000L);
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_WORK) == 0) {
                    String string = XmlUtil.getTextFromNode(node5);
                    l = 0L;
                    l += (long)Integer.parseInt(string.substring(2, string.indexOf("H"))) * 3600000L;
                    l += (long)Integer.parseInt(string.substring(string.indexOf("H") + 1, string.indexOf("M"))) * 60000L;
                    task2.setWork(l += (long)Integer.parseInt(string.substring(string.indexOf("M") + 1, string.indexOf("S"))) * 1000L);
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_CONSTRAINT) == 0) {
                    String string;
                    Node node6 = TaskLoader.getChildNode(node, TASK_OUTLINE_NUMBER);
                    if (node6 != null && (string = XmlUtil.getTextFromNode(node6)).equals("0")) {
                        return task2;
                    }
                    int n = Integer.parseInt(XmlUtil.getTextFromNode(node5));
                    try {
                        switch (n) {
                            case 0: {
                                task2.setConstraint(new ASAP());
                                break;
                            }
                            case 1: {
                                task2.setConstraint(new ALAP());
                                break;
                            }
                            case 2: {
                                Node node7 = TaskLoader.getChildNode(node, TASK_CONSTRAINT_DATE);
                                if (node7 == null) continue block23;
                                task2.setConstraint(new MSO(dateFormat.parse(XmlUtil.getTextFromNode(node7))));
                                break;
                            }
                            case 3: {
                                Node node7 = TaskLoader.getChildNode(node, TASK_CONSTRAINT_DATE);
                                if (node7 == null) continue block23;
                                task2.setConstraint(new MFO(dateFormat.parse(XmlUtil.getTextFromNode(node7))));
                                break;
                            }
                            case 4: {
                                Node node7 = TaskLoader.getChildNode(node, TASK_CONSTRAINT_DATE);
                                if (node7 == null) continue block23;
                                task2.setConstraint(new SNET(dateFormat.parse(XmlUtil.getTextFromNode(node7))));
                                break;
                            }
                            case 5: {
                                Node node7 = TaskLoader.getChildNode(node, TASK_CONSTRAINT_DATE);
                                if (node7 == null) continue block23;
                                task2.setConstraint(new SNLT(dateFormat.parse(XmlUtil.getTextFromNode(node7))));
                                break;
                            }
                            case 6: {
                                Node node7 = TaskLoader.getChildNode(node, TASK_CONSTRAINT_DATE);
                                if (node7 == null) continue block23;
                                task2.setConstraint(new FNET(dateFormat.parse(XmlUtil.getTextFromNode(node7))));
                                break;
                            }
                            case 7: {
                                Node node7 = TaskLoader.getChildNode(node, TASK_CONSTRAINT_DATE);
                                if (node7 == null) continue block23;
                                task2.setConstraint(new FNLT(dateFormat.parse(XmlUtil.getTextFromNode(node7))));
                                break;
                            }
                            default: {
                                task2.setConstraint(new ASAP());
                                break;
                            }
                        }
                    }
                    catch (ParseException parseException) {
                        Common.logException("Error:", parseException);
                    }
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_DEADLINE) == 0) {
                    task2.setDeadlineDate(dateFormat.parse(XmlUtil.getTextFromNode(node5)));
                    continue;
                }
                if (node5.getNodeName().compareTo("Start") == 0) {
                    task2.setStartDate(dateFormat.parse(XmlUtil.getTextFromNode(node5)));
                    continue;
                }
                if (node5.getNodeName().compareTo("Finish") == 0) {
                    task2.setEndDate(dateFormat.parse(XmlUtil.getTextFromNode(node5)));
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_STOP) == 0) {
                    task2.setCompletionDate(dateFormat.parse(XmlUtil.getTextFromNode(node5)));
                    continue;
                }
                if (node5.getNodeName().compareTo(TASK_SPLIT) == 0) {
                    bl2 = true;
                    if (bl) {
                        object2 = TaskLoader.loadSplit(company, task2, (Task)object2, node5);
                    }
                    bl = !bl;
                    continue;
                }
                if (node5.getNodeName().compareTo("Baseline") != 0) continue;
                BaselineLoader.loadBaseline(task2, node5);
            }
            if (bl2) {
                task2.setSplitted(true);
                task2.setExpanded(false);
            }
        }
        return task2;
    }

    public static Task loadSplit(Company company, Task task, Task task2, Node node) throws Exception {
        Node node2;
        Date date = new Date();
        Date date2 = new Date();
        Node node3 = TaskLoader.getChildNode(node, "Start");
        if (node3 != null) {
            date = dateFormat.parse(XmlUtil.getTextFromNode(node3));
        }
        if ((node2 = TaskLoader.getChildNode(node, "Finish")) != null) {
            date2 = dateFormat.parse(XmlUtil.getTextFromNode(node2));
        }
        Task task3 = new Task(company.getIdGenerator().getNewId());
        task.addChild(task3, false);
        task3.setName(task.getName());
        task3.setStartDate(date);
        task3.setEndDate(date2);
        if (task2 != null) {
            task3.setConstraint(new SNET(date));
            Dependency dependency = new Dependency(company.getIdGenerator().getNewId());
            dependency.setPredecessor(task2);
            dependency.setSuccessor(task3);
            Task.addDependency(dependency, false);
        }
        return task3;
    }

    public static void loadTaskDependency(Company company, Node node, TaskCollection taskCollection) throws Exception {
        Task task = null;
        Node node2 = TaskLoader.getChildNode(node, TASK_UID);
        if (node2 != null) {
            task = taskCollection.getTaskForId(Long.parseLong(XmlUtil.getTextFromNode(node2)));
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node node3 = node.getChildNodes().item(i);
            if (!node3.getNodeName().equals("PredecessorLink")) continue;
            DependencyLoader dependencyLoader = new DependencyLoader(taskCollection);
            Dependency dependency = new Dependency(company.getIdGenerator().getNewId());
            dependency.setSuccessor(task);
            dependencyLoader.loadTaskDependency(node3, dependency);
            dependency.getPredecessor();
            Task.addDependency(dependency, false);
        }
    }

    public static void storeTask(Document document, Element element, Task task, String string, int n, Task task2) {
        Element element2 = document.createElement(TASK);
        element.appendChild(element2);
        Element element3 = XmlUtil.createTextElement(document, TASK_WBS, string);
        Element element4 = XmlUtil.createTextElement(document, TASK_OUTLINE_NUMBER, string);
        Element element5 = XmlUtil.createTextElement(document, TASK_OUTLINE_LEVEL, "" + n);
        if (task.isEmpty()) {
            Element element6 = XmlUtil.createTextElement(document, TASK_EMPTY, "1");
            element2.appendChild(element6);
            element2.appendChild(element3);
            element2.appendChild(element4);
            element2.appendChild(element5);
        } else {
            Object object;
            Element element7;
            Element element8 = XmlUtil.createTextElement(document, TASK_UID, task == task2 ? "0" : "" + task.getId());
            Element element9 = XmlUtil.createTextElement(document, TASK_NAME, task.getName());
            Element element10 = XmlUtil.createTextElement(document, TASK_EMPTY, "0");
            Element element11 = task.isLeaf() ? XmlUtil.createTextElement(document, TASK_SUMMARY, "0") : XmlUtil.createTextElement(document, TASK_SUMMARY, "1");
            Element element12 = XmlUtil.createTextElement(document, TASK_TYPE, "0");
            Element element13 = task.isWorkDriven() ? XmlUtil.createTextElement(document, TASK_EFFORT_DRIVEN, "1") : XmlUtil.createTextElement(document, TASK_EFFORT_DRIVEN, "0");
            Element element14 = task.getDurationUnit().equals(DurationManager.MINUTE) ? XmlUtil.createTextElement(document, TASK_UNIT, "3") : (task.getDurationUnit().equals(DurationManager.HOUR) ? XmlUtil.createTextElement(document, TASK_UNIT, "5") : (task.getDurationUnit().equals(DurationManager.WEEK) ? XmlUtil.createTextElement(document, TASK_UNIT, "9") : XmlUtil.createTextElement(document, TASK_UNIT, "7")));
            Element element15 = XmlUtil.createTextElement(document, TASK_FIXED_COST, "" + task.getFixedCost());
            Element element16 = task.getAccrual().equals(Task.START) ? XmlUtil.createTextElement(document, TASK_ACCRUAL, "1") : (task.getAccrual().equals(Task.PRORATED) ? XmlUtil.createTextElement(document, TASK_ACCRUAL, "2") : XmlUtil.createTextElement(document, TASK_ACCRUAL, "3"));
            Element element17 = XmlUtil.createTextElement(document, "Start", dateFormat.format(task.getStartDate()));
            Element element18 = XmlUtil.createTextElement(document, "Finish", dateFormat.format(task.getEndDate()));
            Element element19 = XmlUtil.createTextElement(document, TASK_STOP, dateFormat.format(task.getCompletionDate()));
            Element element20 = XmlUtil.createTextElement(document, TASK_MILESTONE, task.isMilestone() ? "1" : "0");
            Element element21 = XmlUtil.createTextElement(document, TASK_CRITICAL, task.isCritical() ? "1" : "0");
            long l = task.getDuration() / 3600000L;
            long l2 = task.getDuration() % 3600000L / 60000L;
            long l3 = task.getDuration() % 3600000L % 60000L / 1000L;
            Element element22 = XmlUtil.createTextElement(document, TASK_NOTES, task.getNotes());
            Element element23 = XmlUtil.createTextElement(document, TASK_PERCENT_COMPLETE, "" + task.getCompletion());
            Element element24 = XmlUtil.createTextElement(document, TASK_PERCENT_WORK_COMPLETE, "" + task.getWorkCompletion());
            Element element25 = XmlUtil.createTextElement(document, TASK_DURATION, "PT" + l + "H" + l2 + "M" + l3 + "S");
            Element element26 = XmlUtil.createTextElement(document, TASK_REMAINING_DURATION, "PT" + l + "H" + l2 + "M" + l3 + "S");
            Element element27 = null;
            if (task.getConstraint() instanceof ASAP) {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "0");
            } else if (task.getConstraint() instanceof ALAP) {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "1");
            } else if (task.getConstraint() instanceof MSO) {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "2");
                element27 = XmlUtil.createTextElement(document, TASK_CONSTRAINT_DATE, dateFormat.format(task.getConstraint().getDate()));
            } else if (task.getConstraint() instanceof MFO) {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "3");
                element27 = XmlUtil.createTextElement(document, TASK_CONSTRAINT_DATE, dateFormat.format(task.getConstraint().getDate()));
            } else if (task.getConstraint() instanceof SNET) {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "4");
                element27 = XmlUtil.createTextElement(document, TASK_CONSTRAINT_DATE, dateFormat.format(task.getConstraint().getDate()));
            } else if (task.getConstraint() instanceof SNLT) {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "5");
                element27 = XmlUtil.createTextElement(document, TASK_CONSTRAINT_DATE, dateFormat.format(task.getConstraint().getDate()));
            } else if (task.getConstraint() instanceof FNET) {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "6");
                element27 = XmlUtil.createTextElement(document, TASK_CONSTRAINT_DATE, dateFormat.format(task.getConstraint().getDate()));
            } else {
                element7 = XmlUtil.createTextElement(document, TASK_CONSTRAINT, "7");
                element27 = XmlUtil.createTextElement(document, TASK_CONSTRAINT_DATE, dateFormat.format(task.getConstraint().getDate()));
            }
            Element element28 = task.isForcedWorking() ? XmlUtil.createTextElement(document, TASK_FORCED_WORKING, "1") : XmlUtil.createTextElement(document, TASK_FORCED_WORKING, "0");
            element2.appendChild(element8);
            element2.appendChild(element10);
            element2.appendChild(element9);
            element2.appendChild(element12);
            element2.appendChild(element3);
            element2.appendChild(element4);
            element2.appendChild(element5);
            element2.appendChild(element17);
            element2.appendChild(element18);
            element2.appendChild(element19);
            element2.appendChild(element25);
            element2.appendChild(element26);
            element2.appendChild(element14);
            element2.appendChild(element13);
            element2.appendChild(element20);
            element2.appendChild(element11);
            element2.appendChild(element21);
            element2.appendChild(element15);
            element2.appendChild(element16);
            element2.appendChild(element23);
            element2.appendChild(element24);
            element2.appendChild(element22);
            element2.appendChild(element7);
            if (element27 != null) {
                element2.appendChild(element27);
            }
            if (task.getDeadlineDate() != null) {
                object = XmlUtil.createTextElement(document, TASK_DEADLINE, dateFormat.format(task.getDeadlineDate()));
                element2.appendChild((Node)object);
            }
            object = task.getCalendar() != null ? Long.valueOf(task.getCalendar().getId() + 1L) : (task.isProject() ? Long.valueOf(task.getCompany().getCalendarManager().getId() + 1L) : Long.valueOf(-1L));
            Element element29 = XmlUtil.createTextElement(document, TASK_CALENDAR_ID, "" + object);
            element2.appendChild(element29);
            element2.appendChild(element28);
            BaselineLoader.storeBaselineList(document, element2, task);
            if (task.getChildNumber() != 0) {
                TaskLoader.storeTaskList(document, element, task.getChildList(), string, n + 1, task2);
            }
            DependencyLoader.storeTaskDependencyList(document, element2, task, task2);
        }
    }

    private static void storeTaskList(Document document, Element element, List list, String string, int n, Task task) {
        for (int i = 0; i < list.size(); ++i) {
            Task task2 = (Task)list.get(i);
            if (string.equals("0")) {
                TaskLoader.storeTask(document, element, task2, "" + (i + 1), n, task);
                continue;
            }
            TaskLoader.storeTask(document, element, task2, string + "." + (i + 1), n, task);
        }
    }
}

