/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.dB.msproject.xml;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.baseline.ProjectBaseline;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.ResourceCollection;
import com.sbs.jpm.dB.TaskCollection;
import com.sbs.jpm.dB.msproject.xml.AssignmentLoader;
import com.sbs.jpm.dB.msproject.xml.CalendarLoader;
import com.sbs.jpm.dB.msproject.xml.ResourceLoader;
import com.sbs.jpm.dB.msproject.xml.TaskLoader;
import com.sbs.xml.XmlUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectLoader {
    public static final String PROJECT = "Project";
    private static final String PROJECT_TITLE = "Title";
    private static final String PROJECT_START_DATE = "StartDate";
    private static final String PROJECT_FINISH_DATE = "FinishDate";
    private static final String PROJECT_MANAGER = "Manager";
    private static final String PROJECT_CRITICAL_SLACK_LIMIT = "CriticalSlackLimit";
    private static final String PROJECT_CALENDAR_ID = "CalendarUID";
    private static final String PROJECT_MINUTES_PER_DAY = "MinutesPerDay";
    private static final String PROJECT_MINUTES_PER_WEEK = "MinutesPerWeek";
    private static final String PROJECT_CURRENCY_UNIT = "CurrencySymbol";
    private static final String PROJECT_CURRENCY_DIGITS = "CurrencyDigits";
    private static final String PROJECT_CURRENCY_SYMBOL_POSITION = "CurrencySymbolPosition";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return null;
    }

    public static Task loadProject(Node node, Company company) throws Exception {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Node node2;
        Node node3;
        Object object4;
        Object object5;
        Node node4;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Node node5;
        Task task = new Task(company.getIdGenerator().getNewId(), Common.I18N_RP.getString("allProjects"));
        Task task2 = new Task(company.getIdGenerator().getNewId(), Common.I18N_RP.getString("project"));
        task2.setCompany(company);
        task2.setId(0L);
        company.setRootTask(task2);
        Date date = new Date();
        long l = 0L;
        CalendarManager calendarManager = CalendarManager.createStandardCalendarInstance();
        LinkedList linkedList = new LinkedList();
        LinkedList<HumanResource> linkedList2 = new LinkedList();
        LinkedList<MaterialResource> linkedList3 = new LinkedList();
        LinkedList<CalendarManager> linkedList4 = new LinkedList();
        TaskCollection taskCollection = null;
        ResourceCollection resourceCollection = null;
        CalendarCollection calendarCollection = null;
        Node node6 = ProjectLoader.getChildNode(node, PROJECT_TITLE);
        if (node6 != null) {
            task2.setName(XmlUtil.getTextFromNode(node6));
        }
        if ((node5 = ProjectLoader.getChildNode(node, PROJECT_MANAGER)) != null && (object9 = XmlUtil.getTextFromNode(node5)) != null) {
            task2.setManager((String)object9);
        }
        if ((object9 = ProjectLoader.getChildNode(node, PROJECT_START_DATE)) != null) {
            object8 = XmlUtil.getTextFromNode((Node)object9);
            date = dateFormat.parse((String)object8);
            task2.setConstraint(new SNET(date));
            task2.setStartDate(date);
        }
        if ((object8 = ProjectLoader.getChildNode(node, PROJECT_FINISH_DATE)) != null) {
            object7 = XmlUtil.getTextFromNode((Node)object8);
            object6 = dateFormat.parse((String)object7);
            task2.setEndDate((Date)object6);
        }
        if ((object7 = ProjectLoader.getChildNode(node, PROJECT_CRITICAL_SLACK_LIMIT)) != null) {
            l = Long.parseLong(XmlUtil.getTextFromNode((Node)object7));
            task2.setCriticalSlackLimit(l * 86400000L);
        }
        if ((object6 = ProjectLoader.getChildNode(node, PROJECT_CURRENCY_UNIT)) != null) {
            task2.setCurrencyUnit(XmlUtil.getTextFromNode((Node)object6));
        }
        if ((node4 = ProjectLoader.getChildNode(node, PROJECT_MINUTES_PER_DAY)) != null) {
            object5 = XmlUtil.getTextFromNode(node4);
            task2.getDurationManager().setDuration(DurationManager.DAY, (long)Integer.valueOf((String)object5).intValue() * 60000L);
        }
        if ((object5 = ProjectLoader.getChildNode(node, PROJECT_MINUTES_PER_WEEK)) != null) {
            object4 = XmlUtil.getTextFromNode((Node)object5);
            task2.getDurationManager().setDuration(DurationManager.WEEK, (long)Integer.valueOf((String)object4).intValue() * 60000L);
        }
        if ((object4 = ProjectLoader.getChildNode(node, "Calendars")) != null) {
            linkedList4 = CalendarLoader.loadCalendarList((Node)object4);
            calendarCollection = new CalendarCollection(linkedList4);
            company.setCalendarList(linkedList4);
        }
        if ((node3 = ProjectLoader.getChildNode(node, PROJECT_CALENDAR_ID)) != null) {
            calendarManager = calendarCollection.getCalendarForId(Long.parseLong(XmlUtil.getTextFromNode(node3)));
            if (calendarManager == null) {
                throw new Exception(Common.I18N_MESSAGES.getString("project.calendarIDNotFound"));
            }
            company.setCalendarManager(calendarManager);
        }
        if ((node2 = ProjectLoader.getChildNode(node, "Resources")) != null) {
            linkedList2 = ResourceLoader.loadHumanResourceList(company, node2, calendarCollection);
            linkedList3 = ResourceLoader.loadMaterialResourceList(company, node2);
            object3 = new LinkedList(linkedList2);
            object3.addAll(linkedList3);
            resourceCollection = new ResourceCollection((List)object3);
            company.setHumanResources(linkedList2);
            company.setMaterialResources(linkedList3);
        }
        if ((object3 = ProjectLoader.getChildNode(node, "Tasks")) != null) {
            Node node7;
            int n;
            taskCollection = new TaskCollection();
            taskCollection.putTaskForId(task2.getId(), task2);
            object2 = object3.getChildNodes();
            for (n = 1; n < object2.getLength(); ++n) {
                node7 = object2.item(n);
                object = TaskLoader.loadTask(company, task2, node7, calendarCollection);
                if (((Task)object).isEmpty()) continue;
                if (((Task)object).getEndDate() == null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(((Task)object).getStartDate());
                    serializable = ((Task)object).getCalendar() != null ? ((Task)object).getCalendar() : CalendarManager.createStandardCalendarInstance();
                    RemainingDuration remainingDuration = new RemainingDuration(((Task)object).getDuration());
                    ((CalendarManager)serializable).convertToWorkingTime(calendar, remainingDuration, !((Task)object).isMilestone());
                    ((Task)object).setEndDate(new Date(remainingDuration.getEndMilis()));
                }
                taskCollection.putTaskForId(((Task)object).getId(), (Task)object);
                for (int i = 0; i < ((Task)object).getBaselines().length; ++i) {
                    serializable = ((Task)object).getBaselineAt(i);
                    if (serializable == null) continue;
                    task2.setProjectBaselineAt(i, new ProjectBaseline(null, null));
                }
            }
            for (n = 1; n < object2.getLength(); ++n) {
                node7 = object2.item(n);
                TaskLoader.loadTaskDependency(company, node7, taskCollection);
            }
        }
        if ((object2 = ProjectLoader.getChildNode(node, "Assignments")) != null) {
            AssignmentLoader assignmentLoader = new AssignmentLoader(taskCollection, resourceCollection);
            assignmentLoader.loadAssignmentList(company, (Node)object2);
        }
        if (object3 != null) {
            NodeList nodeList = object3.getChildNodes();
            for (int i = 1; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                Node node8 = ProjectLoader.getChildNode((Node)object, "IsNull");
                if (node8 == null || !XmlUtil.getTextFromNode(node8).equals("0") || (serializable = taskCollection.getTaskForId(Long.parseLong(XmlUtil.getTextFromNode(ProjectLoader.getChildNode((Node)object, "UID"))))) == null || ((Task)serializable).getAssignmentNumber() <= 0) continue;
                TaskLoader.loadTaskTypeDriven((Task)serializable, (Node)object);
            }
        }
        if (object3 != null) {
            NodeList nodeList = object3.getChildNodes();
            for (int i = 1; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                Node node9 = ProjectLoader.getChildNode((Node)object, "IsNull");
                if (node9 == null || !XmlUtil.getTextFromNode(node9).equals("0") || (serializable = taskCollection.getTaskForId(Long.parseLong(XmlUtil.getTextFromNode(ProjectLoader.getChildNode((Node)object, "UID"))))) == null) continue;
                TaskLoader.loadTaskCompletion((Task)serializable, (Node)object);
            }
        }
        TaskPlanner.forceTree(company.getRootTask(), false);
        company.setMultiProject(1);
        return task2;
    }

    public static void storeProject(Document document, Task task) {
        Element element = XmlUtil.createTextElement(document, PROJECT_TITLE, task.getName());
        Element element2 = XmlUtil.createTextElement(document, PROJECT_MANAGER, task.getManager());
        Element element3 = XmlUtil.createTextElement(document, PROJECT_START_DATE, dateFormat.format(task.getStartDate()));
        Element element4 = XmlUtil.createTextElement(document, PROJECT_FINISH_DATE, dateFormat.format(task.getEndDate()));
        Element element5 = XmlUtil.createTextElement(document, PROJECT_CRITICAL_SLACK_LIMIT, "" + task.getCriticalSlackLimit() / 86400000L);
        Element element6 = XmlUtil.createTextElement(document, PROJECT_CURRENCY_UNIT, task.getCurrencyUnit());
        Element element7 = XmlUtil.createTextElement(document, PROJECT_CURRENCY_DIGITS, "1");
        Element element8 = XmlUtil.createTextElement(document, PROJECT_CURRENCY_SYMBOL_POSITION, "1");
        Long l = task.getCalendar() != null ? Long.valueOf(task.getCalendar().getId() + 1L) : Long.valueOf(task.getCompany().getCalendarManager().getId() + 1L);
        Element element9 = XmlUtil.createTextElement(document, PROJECT_CALENDAR_ID, l.toString());
        Element element10 = XmlUtil.createTextElement(document, PROJECT_MINUTES_PER_DAY, "" + task.getDurationManager().getDuration(DurationManager.DAY) / 60000L);
        Element element11 = XmlUtil.createTextElement(document, PROJECT_MINUTES_PER_WEEK, "" + task.getDurationManager().getDuration(DurationManager.WEEK) / 60000L);
        Element element12 = CalendarLoader.storeCalendarList(document, task.getCompany());
        Element element13 = document.createElement("Tasks");
        TaskLoader.storeTask(document, element13, task, "0", 0, task);
        TaskCollection taskCollection = new TaskCollection(task);
        Element element14 = document.createElement("Resources");
        ResourceLoader.storeHumanResourceList(document, element14, task.getCompany().getHumanResources());
        ResourceLoader.storeMaterialResourceList(document, element14, task.getCompany().getMaterialResources());
        ResourceCollection resourceCollection = new ResourceCollection(task.getCompany().getResources());
        AssignmentLoader assignmentLoader = new AssignmentLoader(taskCollection, resourceCollection);
        Element element15 = assignmentLoader.storeAssignmentList(document, task);
        document.getDocumentElement().appendChild(element);
        document.getDocumentElement().appendChild(element2);
        document.getDocumentElement().appendChild(element3);
        document.getDocumentElement().appendChild(element4);
        document.getDocumentElement().appendChild(element5);
        document.getDocumentElement().appendChild(element10);
        document.getDocumentElement().appendChild(element11);
        document.getDocumentElement().appendChild(element7);
        document.getDocumentElement().appendChild(element6);
        document.getDocumentElement().appendChild(element8);
        document.getDocumentElement().appendChild(element9);
        document.getDocumentElement().appendChild(element12);
        document.getDocumentElement().appendChild(element13);
        document.getDocumentElement().appendChild(element14);
        document.getDocumentElement().appendChild(element15);
    }
}

