/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.io;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.io.ProjectIO;
import com.sbs.jpm.core.io.ProjectIOException;
import com.sbs.jpm.dB.xml.CompanyLoader;
import com.sbs.util.Version;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProjectIOXML
implements ProjectIO {
    private Company loadProject(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo("company") != 0) continue;
            Company company = CompanyLoader.loadCompany(node2);
            company.setLoaded(true);
            Version version = new Version(CompanyLoader.getVersion(node2));
            Version version2 = new Version("3.5.0");
            if (version.compareTo(version2) < 0) {
                ProjectIOXML.updateCompletions(company.getRootTask());
                TaskPlanner.forceTree(company.getRootTask().getCompany().getRootTask(), true);
                TaskPlanner.rescheduleTree(company.getRootTask().getCompany().getRootTask());
                TaskPlanner.forceTree(company.getRootTask().getCompany().getRootTask(), false);
            }
            TaskPlanner.forceTree(company.getRootTask(), false);
            for (HumanResource humanResource : company.getHumanResources()) {
                if (humanResource.isEmpty()) continue;
                for (Assignment assignment : humanResource.getAssignments()) {
                    Task task = assignment.getTask();
                    assignment.start(task.getStartDate(), task.getEndDate(), task.getCompletionDate());
                }
                humanResource.computeWorkIntervals();
            }
            if (version.compareTo(version2) < 0) {
                ProjectIOXML.updateWork(company.getRootTask());
            }
            company.computeCriticalPath();
            return company;
        }
        return new Company();
    }

    private static void updateCompletions(Task task) {
        if (!task.isEmpty() && task.isLeaf()) {
            task.setCompletion(task.getCompletion());
        } else {
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task2 = task.getChildAt(i);
                ProjectIOXML.updateCompletions(task2);
            }
        }
    }

    private static void updateWork(Task task) {
        if (!task.isEmpty() && task.isLeaf()) {
            task.setWork(task.getWork());
        } else {
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task2 = task.getChildAt(i);
                ProjectIOXML.updateWork(task2);
            }
        }
    }

    public Company load(InputStream inputStream) throws ProjectIOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Company company = this.loadProject(document);
            return company;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error loading input stream:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    public void save(Company company, OutputStream outputStream, boolean bl) throws ProjectIOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, "company", null);
            Common.LOGGER.info("Storing document... ");
            CompanyLoader.storeCompany(document, company, bl);
            Common.LOGGER.info("document stored.");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            Common.LOGGER.info("transforming document... ");
            transformer.transform(dOMSource, streamResult);
            Common.LOGGER.info("transformed. ");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.LOGGER.severe("Unable to Save(File, FileType): " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            JOptionPane.showMessageDialog(null, throwable.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToSave"), 0);
        }
    }

    public void save(Task task, OutputStream outputStream, boolean bl) throws ProjectIOException {
        this.save(task.getCompany(), outputStream, bl);
    }
}

