/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.io;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.io.ProjectIO;
import com.sbs.jpm.core.io.ProjectIOException;
import com.sbs.jpm.ui.UIManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ProjectIOXLS
implements ProjectIO {
    private Company loadProject(Node node) throws Exception {
        return new Company();
    }

    public Company load(InputStream inputStream) throws ProjectIOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Company company = this.loadProject(document);
            return company;
        }
        catch (Throwable throwable) {
            Common.logException("Error loading input stream:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    private void createTaskLines(WritableSheet writableSheet, Task task) throws WriteException, RowsExceededException {
        UniqueId uniqueId;
        int n;
        WritableCellFormat writableCellFormat = new WritableCellFormat(NumberFormats.FLOAT);
        int n2 = task.getId().intValue() + 1;
        Label label = new Label(0, n2, task.getOutlineNumber());
        writableSheet.addCell((WritableCell)label);
        label = new Label(1, n2, task.getName());
        writableSheet.addCell((WritableCell)label);
        label = new Label(2, n2, task.getProjectTask().getCode());
        writableSheet.addCell((WritableCell)label);
        double d = (double)task.getDuration() / (double)task.getDurationManager().getDuration(DurationManager.HOUR);
        Number number = new Number(3, n2, d, (CellFormat)writableCellFormat);
        writableSheet.addCell((WritableCell)number);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
        label = new Label(4, n2, simpleDateFormat.format(task.getStartDate()));
        writableSheet.addCell((WritableCell)label);
        label = new Label(5, n2, simpleDateFormat.format(task.getEndDate()));
        writableSheet.addCell((WritableCell)label);
        label = new Label(6, n2, task.getCompletion() + "%");
        writableSheet.addCell((WritableCell)label);
        label = new Label(7, n2, task.getWorkCompletion() + "%");
        writableSheet.addCell((WritableCell)label);
        label = new Label(8, n2, task.getDeadlineDate() != null ? simpleDateFormat.format(task.getDeadlineDate()) : "");
        writableSheet.addCell((WritableCell)label);
        double d2 = (double)task.getWork() / (double)task.getDurationManager().getDuration(DurationManager.HOUR);
        number = new Number(9, n2, d2, (CellFormat)writableCellFormat);
        writableSheet.addCell((WritableCell)number);
        double d3 = task.getCost();
        number = new Number(10, n2, d3, (CellFormat)writableCellFormat);
        writableSheet.addCell((WritableCell)number);
        double d4 = task.getFixedCost();
        number = new Number(11, n2, d4, (CellFormat)writableCellFormat);
        writableSheet.addCell((WritableCell)number);
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < task.getAssignmentNumber() - 1; ++n) {
            uniqueId = task.getAssignmentAt(n);
            stringBuffer.append(((Assignment)uniqueId).getResource().getName());
            stringBuffer.append(",");
        }
        if (task.getAssignmentNumber() != 0) {
            stringBuffer.append(task.getAssignmentAt(task.getAssignmentNumber() - 1).getResource().getName());
        }
        label = new Label(12, n2, stringBuffer.toString());
        writableSheet.addCell((WritableCell)label);
        label = new Label(13, n2, task.getNotes());
        writableSheet.addCell((WritableCell)label);
        for (n = 0; n < task.getChildNumber(); ++n) {
            uniqueId = task.getChildAt(n);
            if (((Task)uniqueId).isEmpty()) continue;
            this.createTaskLines(writableSheet, (Task)uniqueId);
        }
    }

    private void createTaskTable(WritableWorkbook writableWorkbook, Task task) throws WriteException {
        WritableSheet writableSheet = writableWorkbook.createSheet(Common.I18N_RP.getString("excel.task.table"), 0);
        Label label = new Label(0, 0, Common.I18N_RP.getString("excel.task.wbs"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(1, 0, Common.I18N_RP.getString("excel.task.name"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(2, 0, Common.I18N_RP.getString("excel.task.code"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(3, 0, Common.I18N_RP.getString("excel.task.duration"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(4, 0, Common.I18N_RP.getString("excel.task.start"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(5, 0, Common.I18N_RP.getString("excel.task.end"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(6, 0, Common.I18N_RP.getString("excel.task.percentComplete"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(7, 0, Common.I18N_RP.getString("excel.task.percentWorkComplete"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(8, 0, Common.I18N_RP.getString("excel.task.deadline"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(9, 0, Common.I18N_RP.getString("excel.task.totalWork"));
        writableSheet.addCell((WritableCell)label);
        Object[] objectArray = new Object[]{task.getCompany().getRootTask().getCurrencyUnit()};
        label = new Label(10, 0, MessageFormat.format(Common.I18N_RP.getString("excel.task.totalCost"), objectArray));
        writableSheet.addCell((WritableCell)label);
        label = new Label(11, 0, MessageFormat.format(Common.I18N_RP.getString("excel.task.fixedCost"), objectArray));
        writableSheet.addCell((WritableCell)label);
        label = new Label(12, 0, Common.I18N_RP.getString("excel.task.resource.name"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(13, 0, Common.I18N_RP.getString("excel.task.notes"));
        writableSheet.addCell((WritableCell)label);
        this.createTaskLines(writableSheet, task);
    }

    private void createHumanResourceLines(WritableSheet writableSheet, Company company) throws WriteException, RowsExceededException {
        WritableCellFormat writableCellFormat = new WritableCellFormat(NumberFormats.FLOAT);
        for (int i = 0; i < company.getHumanResourcesNumber(); ++i) {
            HumanResource humanResource = company.getHumanResourceAt(i);
            int n = i + 1;
            if (humanResource.isEmpty()) continue;
            Label label = new Label(0, n, humanResource.getName());
            writableSheet.addCell((WritableCell)label);
            Number number = new Number(1, n, humanResource.getStandardRate(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            number = new Number(2, n, humanResource.getOvertimeRate(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            number = new Number(3, n, humanResource.getMaxUnits(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            double d = (double)humanResource.getWork() / (double)company.getRootTask().getDurationManager().getDuration(DurationManager.HOUR);
            number = new Number(4, n, d, (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            number = new Number(5, n, humanResource.getCost(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            label = new Label(6, n, humanResource.getPhoneNo());
            writableSheet.addCell((WritableCell)label);
            label = new Label(7, n, humanResource.getEmail());
            writableSheet.addCell((WritableCell)label);
        }
    }

    private void createHumanResourceTable(WritableWorkbook writableWorkbook, Company company) throws WriteException {
        WritableSheet writableSheet = writableWorkbook.createSheet(Common.I18N_RP.getString("excel.resource.humanTable"), 1);
        Label label = new Label(0, 0, Common.I18N_RP.getString("excel.resource.name"));
        writableSheet.addCell((WritableCell)label);
        Object[] objectArray = new Object[]{company.getRootTask().getCurrencyUnit()};
        label = new Label(1, 0, MessageFormat.format(Common.I18N_RP.getString("excel.resource.standardRate"), objectArray));
        writableSheet.addCell((WritableCell)label);
        label = new Label(2, 0, MessageFormat.format(Common.I18N_RP.getString("excel.resource.overtimeRate"), objectArray));
        writableSheet.addCell((WritableCell)label);
        label = new Label(3, 0, Common.I18N_RP.getString("excel.resource.maxUnits"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(4, 0, Common.I18N_RP.getString("excel.resource.totalWork"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(5, 0, MessageFormat.format(Common.I18N_RP.getString("excel.resource.totalCost"), objectArray));
        writableSheet.addCell((WritableCell)label);
        label = new Label(6, 0, Common.I18N_RP.getString("excel.resource.phoneNumber"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(7, 0, Common.I18N_RP.getString("excel.resource.email"));
        writableSheet.addCell((WritableCell)label);
        this.createHumanResourceLines(writableSheet, company);
    }

    private void createMaterialResourceLines(WritableSheet writableSheet, Company company) throws WriteException, RowsExceededException {
        WritableCellFormat writableCellFormat = new WritableCellFormat(NumberFormats.FLOAT);
        for (int i = 0; i < company.getMaterialResourcesNumber(); ++i) {
            MaterialResource materialResource = company.getMaterialResourceAt(i);
            int n = i + 1;
            if (materialResource.isEmpty()) continue;
            Label label = new Label(0, n, materialResource.getName());
            writableSheet.addCell((WritableCell)label);
            Number number = new Number(1, n, materialResource.getTotalUnits(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            label = new Label(2, n, materialResource.getMeasurementUnit());
            writableSheet.addCell((WritableCell)label);
            number = new Number(3, n, materialResource.getStandardRate(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            number = new Number(4, n, materialResource.getCost(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
        }
    }

    private void createMaterialResourceTable(WritableWorkbook writableWorkbook, Company company) throws WriteException {
        WritableSheet writableSheet = writableWorkbook.createSheet(Common.I18N_RP.getString("excel.resource.materialTable"), 2);
        Label label = new Label(0, 0, Common.I18N_RP.getString("excel.resource.name"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(1, 0, Common.I18N_RP.getString("excel.resource.quantity"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(2, 0, Common.I18N_RP.getString("excel.resource.measurementUnit"));
        writableSheet.addCell((WritableCell)label);
        Object[] objectArray = new Object[]{company.getRootTask().getCurrencyUnit()};
        label = new Label(3, 0, MessageFormat.format(Common.I18N_RP.getString("excel.resource.pricePerUnit"), objectArray));
        writableSheet.addCell((WritableCell)label);
        label = new Label(4, 0, MessageFormat.format(Common.I18N_RP.getString("excel.resource.totalCost"), objectArray));
        writableSheet.addCell((WritableCell)label);
        this.createMaterialResourceLines(writableSheet, company);
    }

    private int createAssignmentLines(WritableSheet writableSheet, Task task, int n) throws WriteException, RowsExceededException {
        UniqueId uniqueId;
        int n2;
        WritableCellFormat writableCellFormat = new WritableCellFormat(NumberFormats.FLOAT);
        for (n2 = 0; n2 < task.getAssignmentNumber(); ++n2) {
            double d;
            uniqueId = task.getAssignmentAt(n2);
            Resource resource = ((Assignment)uniqueId).getResource();
            if (resource.isEmpty()) continue;
            Label label = new Label(0, n, task.getOutlineNumber());
            writableSheet.addCell((WritableCell)label);
            label = new Label(1, n, task.getName());
            writableSheet.addCell((WritableCell)label);
            label = new Label(2, n, resource.getName());
            writableSheet.addCell((WritableCell)label);
            Number number = new Number(3, n, ((Assignment)uniqueId).getUnits(), (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            if (resource instanceof HumanResource) {
                d = (double)((HumanResource)resource).getWork((Assignment)uniqueId) / (double)task.getDurationManager().getDuration(DurationManager.HOUR);
                number = new Number(4, n, d, (CellFormat)writableCellFormat);
                writableSheet.addCell((WritableCell)number);
            }
            d = resource.getCost((Assignment)uniqueId);
            number = new Number(5, n, d, (CellFormat)writableCellFormat);
            writableSheet.addCell((WritableCell)number);
            ++n;
        }
        for (n2 = 0; n2 < task.getChildNumber(); ++n2) {
            uniqueId = task.getChildAt(n2);
            if (((Task)uniqueId).isEmpty()) continue;
            n = this.createAssignmentLines(writableSheet, (Task)uniqueId, n);
        }
        return n;
    }

    private void createAssignmentTable(WritableWorkbook writableWorkbook, Company company) throws WriteException {
        WritableSheet writableSheet = writableWorkbook.createSheet(Common.I18N_RP.getString("excel.assignment.assignmentTable"), 3);
        Label label = new Label(0, 0, Common.I18N_RP.getString("excel.task.wbs"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(1, 0, Common.I18N_RP.getString("excel.assignment.taskName"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(2, 0, Common.I18N_RP.getString("excel.assignment.resourceName"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(3, 0, Common.I18N_RP.getString("excel.assignment.units"));
        writableSheet.addCell((WritableCell)label);
        label = new Label(4, 0, Common.I18N_RP.getString("excel.assignment.work"));
        writableSheet.addCell((WritableCell)label);
        Object[] objectArray = new Object[]{company.getRootTask().getCurrencyUnit()};
        label = new Label(5, 0, MessageFormat.format(Common.I18N_RP.getString("excel.assignment.cost"), objectArray));
        writableSheet.addCell((WritableCell)label);
        this.createAssignmentLines(writableSheet, company.getRootTask(), 1);
    }

    public void save(Company company, OutputStream outputStream, boolean bl) throws ProjectIOException {
        try {
            WritableWorkbook writableWorkbook = Workbook.createWorkbook((OutputStream)outputStream);
            this.createTaskTable(writableWorkbook, company.getRootTask());
            this.createHumanResourceTable(writableWorkbook, company);
            this.createMaterialResourceTable(writableWorkbook, company);
            this.createAssignmentTable(writableWorkbook, company);
            writableWorkbook.write();
            writableWorkbook.close();
        }
        catch (IOException iOException) {
            Common.logException("Error:", iOException);
        }
        catch (WriteException writeException) {
            Common.logException("Error:", writeException);
        }
    }

    public void save(Task task, OutputStream outputStream, boolean bl) throws ProjectIOException {
    }
}

