/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.io;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.io.ProjectIO;
import com.sbs.jpm.core.io.ProjectIOException;
import com.sbs.jpm.dB.xml.ApplicationLoader;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectIOSettings
implements ProjectIO {
    private Company loadSettings(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNodeName().compareTo("settings") != 0) continue;
            ApplicationLoader.loadSettings(node2);
        }
        return null;
    }

    public Company loadColumnsSettings(InputStream inputStream) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || node.getNodeName().compareTo("settings") != 0) continue;
                ApplicationLoader.loadColumnsSettings(node);
            }
            return null;
        }
        catch (Throwable throwable) {
            Common.logException("Error loading loadColumnsSettings:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    public Company load(InputStream inputStream) throws ProjectIOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            this.loadSettings(document);
            return null;
        }
        catch (Throwable throwable) {
            Common.LOGGER.warning("Error loading settings (9/10/2009 1:14:05): " + throwable.getLocalizedMessage());
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    public void save(Company company, OutputStream outputStream, boolean bl) throws ProjectIOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, null, null);
            Element element = ApplicationLoader.storeSettings(document);
            document.appendChild(element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Common.logException("Error:", parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Common.logException("Error:", transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            Common.logException("Error:", transformerException);
        }
    }

    public void save(Task task, OutputStream outputStream, boolean bl) throws ProjectIOException {
    }
}

