/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.io;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.io.FileType;
import com.sbs.jpm.core.io.ProjectIO;
import com.sbs.jpm.core.io.ProjectIOMSMPP;
import com.sbs.jpm.core.io.ProjectIOMSMPX;
import com.sbs.jpm.core.io.ProjectIOMSXML;
import com.sbs.jpm.core.io.ProjectIOSettings;
import com.sbs.jpm.core.io.ProjectIOXLS;
import com.sbs.jpm.core.io.ProjectIOXML;
import java.util.Hashtable;
import java.util.Map;

public class ProjectIOManager {
    private static ProjectIOManager ioManager;
    private Map typeToProjectIO = new Hashtable();

    private ProjectIOManager() {
        this.typeToProjectIO.put(FileType.SETTINGS, new ProjectIOSettings());
        this.typeToProjectIO.put(FileType.PROPRIETARY, new ProjectIOXML());
        if (!Common.isServerBuild()) {
            this.typeToProjectIO.put(FileType.MSPROJECT_XML, new ProjectIOMSXML());
            this.typeToProjectIO.put(FileType.MSPROJECT_MPP, new ProjectIOMSMPP());
            this.typeToProjectIO.put(FileType.MSPROJECT_MPT, new ProjectIOMSMPP());
            this.typeToProjectIO.put(FileType.MSPROJECT_MPX, new ProjectIOMSMPX());
            this.typeToProjectIO.put(FileType.XLS, new ProjectIOXLS());
        }
    }

    public static ProjectIOManager getProjectIOManager() {
        if (ioManager == null) {
            ioManager = new ProjectIOManager();
        }
        return ioManager;
    }

    public ProjectIO getProjectIO(FileType fileType) {
        ProjectIO projectIO = (ProjectIO)this.typeToProjectIO.get(fileType);
        return projectIO;
    }
}

