/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core.io;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.calendar.ResourceCalendarManager;
import com.sbs.jpm.calendar.StandardCalendarManager;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.InvalidOperationException;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.baseline.Baseline;
import com.sbs.jpm.core.baseline.ProjectBaseline;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import com.sbs.jpm.core.io.ProjectIO;
import com.sbs.jpm.core.io.ProjectIOException;
import com.sbs.jpm.dB.CalendarCollection;
import com.sbs.jpm.dB.ResourceCollection;
import com.sbs.jpm.dB.TaskCollection;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.MPPReader;

class ProjectIOMSP
implements ProjectIO {
    protected static Calendar c = Calendar.getInstance();
    protected CalendarCollection calendarCollection;
    protected TaskCollection taskCollection;
    protected Map<net.sf.mpxj.Task, Task> msTaskToTaskMap = new HashMap<net.sf.mpxj.Task, Task>();

    ProjectIOMSP() {
    }

    protected Task loadProject(ProjectFile projectFile, Company company) throws Exception {
        Object object;
        UniqueId uniqueId;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Object object422;
        Object object5;
        Cloneable cloneable2;
        Object object622;
        Date date;
        Date date2;
        String string;
        Task task = new Task(company.getIdGenerator().getNewId(), Common.I18N_RP.getString("allProjects"));
        Task task2 = new Task(company.getIdGenerator().getNewId(), Common.I18N_RP.getString("project"));
        task2.setCompany(company);
        task2.setId(0L);
        company.setRootTask(task2);
        ProjectHeader projectHeader = projectFile.getProjectHeader();
        String string2 = projectHeader.getProjectTitle();
        if (string2 != null && !string2.equals("")) {
            task2.setName(projectHeader.getProjectTitle());
        }
        if ((string = projectHeader.getManager()) != null) {
            task2.setManager(projectHeader.getManager());
        }
        if ((date2 = projectHeader.getStartDate()) != null) {
            task2.setConstraint(new SNET(date2));
            task2.setStartDate(date2);
        }
        if ((date = projectHeader.getFinishDate()) != null) {
            task2.setEndDate(date);
        }
        task2.setCriticalSlackLimit((long)projectHeader.getCriticalSlackLimit().intValue() * 86400000L);
        task2.setCurrencyUnit(projectHeader.getCurrencySymbol());
        task2.getDurationManager().setDuration(DurationManager.DAY, (long)projectHeader.getMinutesPerDay().intValue() * 60000L);
        task2.getDurationManager().setDuration(DurationManager.WEEK, (long)projectHeader.getMinutesPerWeek().intValue() * 60000L);
        LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>();
        for (Object object622 : projectFile.getBaseCalendars()) {
            cloneable2 = new StandardCalendarManager(Long.MIN_VALUE);
            if (object622.getName().equals("Used for Microsoft Project 98 Baseline Calendar")) continue;
            ((CalendarManager)cloneable2).setName(object622.getName());
            ((CalendarManager)cloneable2).setId(object622.getUniqueID().intValue());
            object5 = new DayWorkingPattern();
            ((DayWorkingPattern)object5).setOwner((CalendarManager)cloneable2);
            boolean bl = object622.isWorkingDay(Day.MONDAY);
            if (bl) {
                this.loadDayPattern(object622.getCalendarHours(Day.MONDAY), (DayWorkingPattern)object5);
            } else {
                ((DayWorkingPattern)object5).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(2, (DayWorkingPattern)object5);
            object5 = new DayWorkingPattern();
            ((DayWorkingPattern)object5).setOwner((CalendarManager)cloneable2);
            bl = object622.isWorkingDay(Day.TUESDAY);
            if (bl) {
                this.loadDayPattern(object622.getCalendarHours(Day.TUESDAY), (DayWorkingPattern)object5);
            } else {
                ((DayWorkingPattern)object5).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(3, (DayWorkingPattern)object5);
            object5 = new DayWorkingPattern();
            ((DayWorkingPattern)object5).setOwner((CalendarManager)cloneable2);
            bl = object622.isWorkingDay(Day.WEDNESDAY);
            if (bl) {
                this.loadDayPattern(object622.getCalendarHours(Day.WEDNESDAY), (DayWorkingPattern)object5);
            } else {
                ((DayWorkingPattern)object5).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(4, (DayWorkingPattern)object5);
            object5 = new DayWorkingPattern();
            ((DayWorkingPattern)object5).setOwner((CalendarManager)cloneable2);
            bl = object622.isWorkingDay(Day.THURSDAY);
            if (bl) {
                this.loadDayPattern(object622.getCalendarHours(Day.THURSDAY), (DayWorkingPattern)object5);
            } else {
                ((DayWorkingPattern)object5).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(5, (DayWorkingPattern)object5);
            object5 = new DayWorkingPattern();
            ((DayWorkingPattern)object5).setOwner((CalendarManager)cloneable2);
            bl = object622.isWorkingDay(Day.FRIDAY);
            if (bl) {
                this.loadDayPattern(object622.getCalendarHours(Day.FRIDAY), (DayWorkingPattern)object5);
            } else {
                ((DayWorkingPattern)object5).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(6, (DayWorkingPattern)object5);
            object5 = new DayWorkingPattern();
            ((DayWorkingPattern)object5).setOwner((CalendarManager)cloneable2);
            bl = object622.isWorkingDay(Day.SATURDAY);
            if (bl) {
                this.loadDayPattern(object622.getCalendarHours(Day.SATURDAY), (DayWorkingPattern)object5);
            } else {
                ((DayWorkingPattern)object5).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(7, (DayWorkingPattern)object5);
            object5 = new DayWorkingPattern();
            ((DayWorkingPattern)object5).setOwner((CalendarManager)cloneable2);
            bl = object622.isWorkingDay(Day.SUNDAY);
            if (bl) {
                this.loadDayPattern(object622.getCalendarHours(Day.SUNDAY), (DayWorkingPattern)object5);
            } else {
                ((DayWorkingPattern)object5).setWorking(bl);
            }
            ((CalendarManager)cloneable2).setDayPattern(1, (DayWorkingPattern)object5);
            for (ProjectCalendarException projectCalendarException : object622.getCalendarExceptions()) {
                Object object7;
                int n;
                object422 = new DayWorkingPattern();
                ((DayWorkingPattern)object422).setOwner((CalendarManager)cloneable2);
                for (n = 0; n < projectCalendarException.getRangeCount(); n += 1) {
                    object7 = projectCalendarException.getRange(n);
                    if (object7.getStart() == null) continue;
                    c.setTime(object7.getStart());
                    long l = CalendarManager.getDayStartTime(c);
                    ((DayWorkingPattern)object422).addAlternance(new PeriodInDay(true, object7.getStart().getTime() - l, object7.getEnd().getTime() - l));
                }
                n = projectCalendarException.getWorking() ? 1 : 0;
                if (!n) {
                    ((DayWorkingPattern)object422).setWorking(n != 0);
                }
                object7 = projectCalendarException.getFromDate();
                cloneable = projectCalendarException.getToDate();
                c.setTime((Date)object7);
                while (c.getTime().before((Date)cloneable)) {
                    ((CalendarManager)cloneable2).setDayPattern(c, (DayWorkingPattern)object422);
                    c.add(6, 1);
                }
            }
            linkedList.add((CalendarManager)cloneable2);
        }
        this.calendarCollection = new CalendarCollection(linkedList);
        company.setCalendarList(linkedList);
        for (Object object622 : projectFile.getResourceCalendars()) {
        }
        Object object8 = null;
        object622 = projectHeader.getCalendarName();
        company.setCalendarManager(this.calendarCollection.getCalendarForId(projectFile.getBaseCalendar((String)object622).getUniqueID().longValue()));
        cloneable2 = new LinkedList();
        object5 = new LinkedList();
        for (Object object422 : projectFile.getAllResources()) {
            double d;
            Resource resource;
            if (object422.getType() == null) {
                object422.setType(ResourceType.WORK);
            }
            if (object422.getType().equals((Object)ResourceType.WORK)) {
                if (object422.getUniqueID().equals(0)) continue;
                resource = new HumanResource(Long.MIN_VALUE);
                resource.setOwner(company);
                resource.setId(object422.getUniqueID().intValue());
                if (object422.getName() != null) {
                    resource.setName(object422.getName());
                }
                if (object422.getCode() != null) {
                    resource.setCode(object422.getCode());
                }
                if (object422.getEmailAddress() != null) {
                    ((HumanResource)resource).setEmail(object422.getEmailAddress());
                }
                ((HumanResource)resource).setMaxUnits(object422.getMaxUnits().doubleValue() / 100.0);
                d = object422.getStandardRate().getAmount();
                object3 = object422.getStandardRate().getUnits();
                if (object3.equals((Object)TimeUnit.MINUTES)) {
                    ((HumanResource)resource).setStandardRate(d * 60.0);
                } else if (object3.equals((Object)TimeUnit.HOURS)) {
                    ((HumanResource)resource).setStandardRate(d);
                } else if (object3.equals((Object)TimeUnit.DAYS)) {
                    ((HumanResource)resource).setStandardRate(d / 24.0);
                } else if (object3.equals((Object)TimeUnit.WEEKS)) {
                    ((HumanResource)resource).setStandardRate(d / 168.0);
                } else if (object3.equals((Object)TimeUnit.MONTHS)) {
                    ((HumanResource)resource).setStandardRate(d / 720.0);
                } else if (object3.equals((Object)TimeUnit.YEARS)) {
                    ((HumanResource)resource).setStandardRate(d / 8760.0);
                } else {
                    ((HumanResource)resource).setStandardRate(d);
                }
                double d2 = object422.getOvertimeRate().getAmount();
                object3 = object422.getOvertimeRate().getUnits();
                if (object3.equals((Object)TimeUnit.MINUTES)) {
                    ((HumanResource)resource).setOvertimeRate(d2 * 60.0);
                } else if (object3.equals((Object)TimeUnit.HOURS)) {
                    ((HumanResource)resource).setOvertimeRate(d2);
                } else if (object3.equals((Object)TimeUnit.DAYS)) {
                    ((HumanResource)resource).setOvertimeRate(d2 / 24.0);
                } else if (object3.equals((Object)TimeUnit.WEEKS)) {
                    ((HumanResource)resource).setOvertimeRate(d2 / 168.0);
                } else if (object3.equals((Object)TimeUnit.MONTHS)) {
                    ((HumanResource)resource).setOvertimeRate(d2 / 720.0);
                } else if (object3.equals((Object)TimeUnit.YEARS)) {
                    ((HumanResource)resource).setOvertimeRate(d2 / 8760.0);
                } else {
                    ((HumanResource)resource).setOvertimeRate(d2);
                }
                object2 = resource.getNotes();
                if (object2 != null && ((String)object2).length() != 0) {
                    resource.setNotes(object422.getNotes());
                }
                uniqueId = new ResourceCalendarManager((HumanResource)resource);
                if (object422.getResourceCalendar() != null && object422.getResourceCalendar().getBaseCalendar() != null) {
                    object8 = this.calendarCollection.getCalendarForId(object422.getResourceCalendar().getBaseCalendar().getUniqueID().longValue());
                    LinkedList<CalendarManager.SpecialDay> linkedList2 = new LinkedList<CalendarManager.SpecialDay>();
                    for (Assignment assignment : object422.getResourceCalendar().getCalendarExceptions()) {
                        Object object4;
                        int n;
                        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
                        dayWorkingPattern.setOwner((CalendarManager)object8);
                        for (n = 0; n < assignment.getRangeCount(); n += 1) {
                            object4 = assignment.getRange(n);
                            if (object4.getStart() == null) continue;
                            c.setTime(object4.getStart());
                            long l = CalendarManager.getDayStartTime(c);
                            dayWorkingPattern.addAlternance(new PeriodInDay(true, object4.getStart().getTime() - l, object4.getEnd().getTime() - l));
                        }
                        n = assignment.getWorking() ? 1 : 0;
                        if (!n) {
                            dayWorkingPattern.setWorking(n != 0);
                        }
                        object4 = assignment.getFromDate();
                        Date date3 = assignment.getToDate();
                        c.setTime((Date)object4);
                        while (c.getTime().before(date3)) {
                            CalendarManager.SpecialDay specialDay = new CalendarManager.SpecialDay();
                            specialDay.setDate((Calendar)c.clone());
                            specialDay.setDayPattern(dayWorkingPattern);
                            linkedList2.add(specialDay);
                            c.add(6, 1);
                        }
                    }
                    ((ResourceCalendarManager)uniqueId).setResourcePatternList(linkedList2);
                    ((HumanResource)resource).setCalendar((CalendarManager)object8);
                    ((HumanResource)resource).setResourceCalendar((ResourceCalendarManager)uniqueId);
                }
                cloneable2.add(resource);
                continue;
            }
            resource = new MaterialResource(Long.MIN_VALUE);
            resource.setOwner(company);
            resource.setId(object422.getUniqueID().intValue());
            if (object422.getName() != null) {
                resource.setName(object422.getName());
            }
            if (object422.getCode() != null) {
                resource.setCode(object422.getCode());
            }
            resource.setStandardRate(object422.getStandardRate().getAmount());
            d = object422.getStandardRate().getAmount();
            object3 = object422.getStandardRate().getUnits();
            if (object3.equals((Object)TimeUnit.MINUTES)) {
                resource.setStandardRate(d * 60.0);
            } else if (object3.equals((Object)TimeUnit.HOURS)) {
                resource.setStandardRate(d);
            } else if (object3.equals((Object)TimeUnit.DAYS)) {
                resource.setStandardRate(d / 24.0);
            } else if (object3.equals((Object)TimeUnit.WEEKS)) {
                resource.setStandardRate(d / 168.0);
            } else if (object3.equals((Object)TimeUnit.MONTHS)) {
                resource.setStandardRate(d / 720.0);
            } else if (object3.equals((Object)TimeUnit.YEARS)) {
                resource.setStandardRate(d / 8760.0);
            } else {
                resource.setStandardRate(d);
            }
            String string3 = resource.getNotes();
            if (string3 != null && string3.length() != 0) {
                resource.setNotes(object422.getNotes());
            }
            object5.add(resource);
        }
        LinkedList linkedList3 = new LinkedList(cloneable2);
        linkedList3.addAll(object5);
        object422 = new ResourceCollection(linkedList3);
        company.setHumanResources((List<HumanResource>)((Object)cloneable2));
        company.setMaterialResources((List<MaterialResource>)object5);
        this.taskCollection = new TaskCollection();
        this.taskCollection.putTaskForId(task2.getId(), task2);
        for (net.sf.mpxj.Task task3 : projectFile.getAllTasks()) {
            if (task3.getExternalTask() || this.msTaskToTaskMap.containsKey(task3)) continue;
            this.loadTask(task3, task2, company);
        }
        for (net.sf.mpxj.Task task4 : projectFile.getAllTasks()) {
            cloneable = this.taskCollection.getTaskForId(new Long(task4.getUniqueID().longValue()));
            if (task4.getExternalTask() || (object3 = task4.getPredecessors()) == null || object3.isEmpty()) continue;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (Relation)iterator.next();
                if (object.getTask().getExternalTask()) continue;
                object2 = new Dependency(company.getIdGenerator().getNewId());
                uniqueId = this.taskCollection.getTaskForId(new Long(object.getTaskUniqueID().longValue()));
                ((Dependency)object2).setSuccessor((Task)cloneable);
                if (object.getType().equals((Object)RelationType.START_START)) {
                    ((Dependency)object2).setType(1);
                } else if (object.getType().equals((Object)RelationType.START_FINISH)) {
                    ((Dependency)object2).setType(2);
                } else if (object.getType().equals((Object)RelationType.FINISH_START)) {
                    ((Dependency)object2).setType(0);
                } else if (object.getType().equals((Object)RelationType.FINISH_FINISH)) {
                    ((Dependency)object2).setType(3);
                } else {
                    throw new RuntimeException("Invalid dependency type");
                }
                ((Dependency)object2).setPredecessor((Task)uniqueId);
                double d = object.getDuration().getDuration();
                d = object.getDuration().getUnits().equals((Object)TimeUnit.HOURS) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.HOUR)) : (object.getDuration().getUnits().equals((Object)TimeUnit.MINUTES) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.MINUTE)) : (object.getDuration().getUnits().equals((Object)TimeUnit.DAYS) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.DAY)) : (object.getDuration().getUnits().equals((Object)TimeUnit.WEEKS) ? (d *= (double)task2.getDurationManager().getDuration(DurationManager.WEEK)) : (object.getDuration().getUnits().equals((Object)TimeUnit.PERCENT) ? d / 100.0 * (double)((Task)uniqueId).getDuration() : (d *= (double)task2.getDurationManager().getDuration(DurationManager.DAY))))));
                ((Dependency)object2).setTaskDelay((long)d);
                ((Dependency)object2).getPredecessor();
                Task.addDependency((Dependency)object2, true);
            }
        }
        for (ResourceAssignment resourceAssignment : projectFile.getAllResourceAssignments()) {
            cloneable = resourceAssignment.getTask();
            object3 = resourceAssignment.getResource();
            Task task5 = this.taskCollection.getTaskForId(new Long(cloneable.getUniqueID().longValue()));
            if (task5.isSplitted()) {
                object = ((ResourceCollection)object422).getResourceForId(new Long(object3.getUniqueID().longValue()));
                double d = resourceAssignment.getUnits().doubleValue() / 100.0;
                for (Task task3 : task5.getChildList()) {
                    Assignment assignment;
                    assignment = new Assignment(company.getIdGenerator().getNewId());
                    assignment.setTask(task3);
                    assignment.setResource((Resource)object);
                    assignment.setUnits(d);
                    assignment.getTask().addAssignment(assignment);
                    assignment.getResource().addAssignment(assignment);
                }
                continue;
            }
            object = new Assignment(company.getIdGenerator().getNewId());
            ((Assignment)object).setTask(task5);
            Resource resource = ((ResourceCollection)object422).getResourceForId(new Long(object3.getUniqueID().longValue()));
            ((Assignment)object).setResource(resource);
            ((Assignment)object).setUnits(resourceAssignment.getUnits().doubleValue() / 100.0);
            ((Assignment)object).getTask().addAssignment((Assignment)object);
            ((Assignment)object).getResource().addAssignment((Assignment)object);
        }
        for (net.sf.mpxj.Task task6 : projectFile.getAllTasks()) {
            cloneable = this.taskCollection.getTaskForId(new Long(task6.getUniqueID().longValue()));
            if (cloneable == null) continue;
            if (task6.getType().compareTo((Enum)TaskType.FIXED_UNITS) == 0) {
                cloneable.setWorkDriven(task6.getEffortDriven());
                cloneable.setFixedUnits(true);
            } else if (task6.getType().compareTo((Enum)TaskType.FIXED_DURATION) == 0) {
                cloneable.setWorkDriven(task6.getEffortDriven());
                cloneable.setFixedUnits(false);
            } else if (task6.getType().compareTo((Enum)TaskType.FIXED_WORK) == 0) {
                cloneable.setWorkDriven(true);
                cloneable.setFixedUnits(false);
            }
            if (!cloneable.isSplitted()) continue;
            this.setWork((Task)cloneable, cloneable.getWork());
        }
        for (net.sf.mpxj.Task task7 : projectFile.getAllTasks()) {
            cloneable = this.taskCollection.getTaskForId(new Long(task7.getUniqueID().longValue()));
            if (cloneable == null) continue;
            if (task7.getPercentageComplete() != null) {
                cloneable.setCompletion(task7.getPercentageComplete().intValue());
                continue;
            }
            cloneable.setCompletion(0.0);
        }
        company.setMultiProject(1);
        return task2;
    }

    protected boolean isEmpty(net.sf.mpxj.Task task) {
        boolean bl = task.getNull();
        return bl;
    }

    protected void loadTask(net.sf.mpxj.Task task, Task task2, Company company) throws Exception {
        Object object;
        Object object2;
        Object object3;
        boolean bl = this.isEmpty(task);
        Task task3 = task.getParentTask() == null ? (bl ? new Task(company.getIdGenerator().getNewId()) : (task.getOutlineLevel() == 0 ? task2 : new Task(company.getIdGenerator().getNewId()))) : new Task(company.getIdGenerator().getNewId());
        this.msTaskToTaskMap.put(task, task3);
        task3.setEmpty(bl);
        if (!bl) {
            task3.setCompany(company);
        }
        if (task.getParentTask() != null) {
            object3 = this.msTaskToTaskMap.get(task.getParentTask());
            if (this.isEmpty(task.getParentTask())) {
                object3 = task2;
            }
            ((Task)object3).addChild(task3, false);
        } else if (task3.isEmpty()) {
            task2.addChild(task3, false);
        } else if (task.getOutlineLevel() == null) {
            task2.addChild(task3, false);
        } else if (task.getOutlineLevel() != 0) {
            task2.addChild(task3, false);
        }
        if (!bl) {
            int n;
            if (task.getParentTask() != null) {
                task3.setName(task.getName());
            } else if (task.getOutlineLevel() != 0) {
                task3.setName(task.getName());
            }
            task3.setId(task.getUniqueID().intValue());
            task3.setExpanded(task.getExpanded());
            if (task.getDuration() != null) {
                object3 = task.getDuration().getUnits();
                if (object3 != null) {
                    if (object3.equals((Object)TimeUnit.MINUTES)) {
                        task3.setDurationUnit(DurationManager.MINUTE);
                    } else if (object3.equals((Object)TimeUnit.HOURS)) {
                        task3.setDurationUnit(DurationManager.HOUR);
                    } else if (object3.equals((Object)TimeUnit.DAYS)) {
                        task3.setDurationUnit(DurationManager.DAY);
                    } else if (object3.equals((Object)TimeUnit.WEEKS)) {
                        task3.setDurationUnit(DurationManager.WEEK);
                    } else {
                        task3.setDurationUnit(DurationManager.DAY);
                    }
                }
            } else {
                task3.setDurationUnit(DurationManager.DAY);
            }
            task3.setFixedCost(task.getFixedCost().doubleValue());
            if (task.getFixedCostAccrual() != null) {
                if (task.getFixedCostAccrual().equals((Object)AccrueType.START)) {
                    task3.setAccrual(Task.START);
                } else if (task.getFixedCostAccrual().equals((Object)AccrueType.END)) {
                    task3.setAccrual(Task.END);
                } else if (task.getFixedCostAccrual().equals((Object)AccrueType.PRORATED)) {
                    task3.setAccrual(Task.PRORATED);
                } else {
                    task3.setAccrual(Task.PRORATED);
                }
            } else {
                task3.setAccrual(Task.PRORATED);
            }
            if (task.getCalendar() != null) {
                task3.setCalendar(this.calendarCollection.getCalendarForId(task.getCalendar().getUniqueID().longValue()));
            }
            if ((object3 = task.getNotes()) != null) {
                task3.setNotes((String)object3);
            }
            if (task.getMilestone()) {
                task3.setDuration(0L);
            }
            if (task.getSplits() != null) {
                Task task4 = null;
                boolean bl2 = true;
                for (Object object4 : task.getSplits()) {
                    if (bl2) {
                        Task task5 = new Task(company.getIdGenerator().getNewId());
                        task3.addChild(task5, false);
                        task5.setName(task3.getName());
                        task5.setStartDate(object4.getStart());
                        task5.setEndDate(object4.getEnd());
                        if (task4 != null) {
                            task5.setConstraint(new SNET(object4.getStart()));
                            Dependency dependency = new Dependency(company.getIdGenerator().getNewId());
                            dependency.setPredecessor(task4);
                            dependency.setSuccessor(task5);
                            Task.addDependency(dependency, false);
                        }
                        task4 = task5;
                    }
                    bl2 = !bl2;
                }
                task3.setSplitted(true);
                task3.setExpanded(false);
            }
            if (task.getDuration() != null) {
                double d = task.getDuration().getDuration();
                if (task.getDuration().getUnits().equals((Object)TimeUnit.HOURS)) {
                    this.setDuration(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.HOUR)));
                } else if (task.getDuration().getUnits().equals((Object)TimeUnit.MINUTES)) {
                    this.setDuration(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.MINUTE)));
                } else if (task.getDuration().getUnits().equals((Object)TimeUnit.DAYS)) {
                    this.setDuration(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                } else if (task.getDuration().getUnits().equals((Object)TimeUnit.WEEKS)) {
                    this.setDuration(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.WEEK)));
                } else {
                    this.setDuration(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                }
            } else {
                this.setDuration(task3, task2.getDurationManager().getDuration(DurationManager.DAY));
            }
            if (task.getWork() != null) {
                double d = 0.0;
                if (!task.getSummary()) {
                    d = task.getWork().getDuration();
                } else {
                    for (Object object4 : task.getResourceAssignments()) {
                        d += object4.getWork().getDuration();
                    }
                }
                if (task.getWork().getUnits().equals((Object)TimeUnit.HOURS)) {
                    this.setWork(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.HOUR)));
                } else if (task.getWork().getUnits().equals((Object)TimeUnit.MINUTES)) {
                    this.setWork(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.MINUTE)));
                } else if (task.getWork().getUnits().equals((Object)TimeUnit.DAYS)) {
                    this.setWork(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                } else if (task.getWork().getUnits().equals((Object)TimeUnit.WEEKS)) {
                    this.setWork(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.WEEK)));
                } else {
                    this.setWork(task3, (long)(d * (double)task2.getDurationManager().getDuration(DurationManager.DAY)));
                }
            } else {
                this.setWork(task3, task2.getDurationManager().getDuration(DurationManager.DAY));
            }
            if (task.getOutlineNumber() != null && !task.getOutlineNumber().equals("0")) {
                if (task.getConstraintType().equals((Object)ConstraintType.AS_SOON_AS_POSSIBLE)) {
                    task3.setConstraint(new ASAP());
                } else if (task.getConstraintType().equals((Object)ConstraintType.START_NO_EARLIER_THAN)) {
                    task3.setConstraint(new SNET(task.getConstraintDate()));
                } else if (task.getConstraintType().equals((Object)ConstraintType.MUST_START_ON)) {
                    task3.setConstraint(new MSO(task.getConstraintDate()));
                } else if (task.getConstraintType().equals((Object)ConstraintType.MUST_FINISH_ON)) {
                    task3.setConstraint(new MFO(task.getConstraintDate()));
                } else if (task.getConstraintType().equals((Object)ConstraintType.START_NO_LATER_THAN)) {
                    task3.setConstraint(new SNLT(task.getConstraintDate()));
                } else if (task.getConstraintType().equals((Object)ConstraintType.FINISH_NO_EARLIER_THAN)) {
                    task3.setConstraint(new FNET(task.getConstraintDate()));
                } else if (task.getConstraintType().equals((Object)ConstraintType.FINISH_NO_LATER_THAN)) {
                    task3.setConstraint(new FNLT(task.getConstraintDate()));
                }
            }
            task3.setDeadlineDate(task.getDeadline());
            if (task.getStart() != null) {
                task3.setStartDate(task.getStart());
            } else {
                task3.setStartDate(task2.getStartDate());
            }
            if (task.getFinish() != null) {
                task3.setEndDate(task.getFinish());
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(task3.getStartDate());
                CalendarManager calendarManager = task3.getCalendar() != null ? task3.getCalendar() : CalendarManager.createStandardCalendarInstance();
                RemainingDuration remainingDuration = new RemainingDuration(task3.getDuration());
                calendarManager.convertToWorkingTime(calendar, remainingDuration, !task3.isMilestone());
                task3.setEndDate(new Date(remainingDuration.getEndMilis()));
            }
            task3.setForcedWorking(task.getIgnoreResourceCalendar());
            if (task.getPercentageComplete() != null) {
                task3.setCompletion(task.getPercentageComplete().doubleValue());
            } else {
                task3.setCompletion(0.0);
            }
            if (task.getPercentageWorkComplete() != null) {
                task3.setWorkCompletion(task.getPercentageWorkComplete().doubleValue(), false);
            } else {
                task3.setWorkCompletion(0.0, false);
            }
            object2 = task.getStop();
            if (object2 == null) {
                object2 = task.getStart();
            }
            task3.setCompletionDate((Date)object2);
            object = new Baseline();
            if (task.getBaselineStart() != null && task.getBaselineFinish() != null) {
                ((Baseline)object).setStartDate(task.getBaselineStart());
                ((Baseline)object).setEndDate(task.getBaselineFinish());
                task3.setBaselineAt(0, (Baseline)object);
            }
            for (n = 1; n < 10; ++n) {
                if (task.getBaselineStart(n) == null || task.getBaselineFinish(n) == null) continue;
                object = new Baseline();
                ((Baseline)object).setStartDate(task.getBaselineStart(n));
                ((Baseline)object).setEndDate(task.getBaselineFinish(n));
                task3.setBaselineAt(n, (Baseline)object);
            }
            this.taskCollection.putTaskForId(task3.getId(), task3);
            for (n = 0; n < task3.getBaselines().length; ++n) {
                Object object4;
                object4 = task3.getBaselineAt(n);
                if (object4 == null) continue;
                task2.setProjectBaselineAt(n, new ProjectBaseline(null, null));
            }
        }
        object3 = task.getChildTasks();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (net.sf.mpxj.Task)object2.next();
            if (this.msTaskToTaskMap.containsKey(object)) continue;
            this.loadTask((net.sf.mpxj.Task)object, task2, company);
        }
    }

    protected void loadDayPattern(ProjectCalendarHours projectCalendarHours, DayWorkingPattern dayWorkingPattern) throws InvalidOperationException {
        for (DateRange dateRange : projectCalendarHours) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateRange.getStart());
            calendar.clear(14);
            long l = CalendarManager.getDayStartTime(calendar);
            calendar.setTime(dateRange.getStart());
            calendar.clear(14);
            long l2 = calendar.getTimeInMillis();
            calendar.setTime(dateRange.getEnd());
            calendar.clear(14);
            long l3 = calendar.getTimeInMillis();
            dayWorkingPattern.addAlternance(new PeriodInDay(true, l2 - l, l3 - l));
        }
    }

    protected Company loadProject(ProjectFile projectFile) throws Exception {
        Company company = new Company();
        Task task = this.loadProject(projectFile, company);
        company.setRootTask(task);
        company.setLoaded(true);
        for (HumanResource humanResource : company.getHumanResources()) {
            if (humanResource.isEmpty()) continue;
            for (Assignment assignment : humanResource.getAssignments()) {
                Task task2 = assignment.getTask();
                assignment.start(task2.getStartDate(), task2.getEndDate(), task2.getCompletionDate());
            }
            humanResource.computeWorkIntervals();
        }
        this.updateCompletions(company.getRootTask());
        company.computeTasksId();
        company.computeResourceId();
        TaskPlanner.forceTree(company.getRootTask(), false);
        company.computeCriticalPath();
        return company;
    }

    public Company load(InputStream inputStream) throws ProjectIOException {
        ProjectFile projectFile = null;
        try {
            projectFile = new MPPReader().read(inputStream);
            Company company = this.loadProject(projectFile);
            return company;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error loading input stream:", throwable);
            throw new ProjectIOException(throwable.getLocalizedMessage());
        }
    }

    private void setDuration(Task task, long l) {
        task.setDuration(l);
        if (task.isSplitted()) {
            long l2 = l;
            Task task2 = task.getChildAt(task.getChildNumber() - 1);
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task3 = task.getChildAt(i);
                if (l2 > task3.getDuration()) {
                    if (i < task.getChildNumber() - 1) {
                        l2 -= task3.getDuration();
                        continue;
                    }
                    task2 = task3;
                    continue;
                }
                task2 = task3;
                break;
            }
            if (task.getChildNumber() == 0) {
                task.setDuration(l2);
            } else {
                task2.setDuration(l2);
            }
        }
    }

    private void setWork(Task task, long l) {
        task.setWork(l);
        if (task.isSplitted()) {
            long l2 = l;
            int n = 0;
            Task task2 = task.getChildAt(0);
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task3 = task.getChildAt(i);
                if (task3.hasHumanResources()) {
                    task2 = task3;
                    n = i;
                }
                if (l2 <= task3.getWorkExceptChildren()) break;
                if (i >= task.getChildNumber() - 1) continue;
                l2 -= task3.getWorkExceptChildren();
            }
            if (n == 0 && !task2.hasHumanResources()) {
                task2.setWork(l);
                return;
            }
            if (task.getChildNumber() == 0) {
                task.setWork(l2);
            } else {
                task2.setWork(l2);
            }
        }
    }

    protected void updateCompletions(Task task) {
        if (!task.isEmpty()) {
            if (task.isLeaf() || task.isSplitted()) {
                if (task.isSplitted()) {
                    for (Task task2 : task.getChildList()) {
                        task2.computeCompletionDate();
                    }
                }
                task.setCompletion(task.getCompletion());
            } else {
                for (int i = 0; i < task.getChildNumber(); ++i) {
                    Task task3 = task.getChildAt(i);
                    this.updateCompletions(task3);
                }
            }
        }
    }

    public void save(Company company, OutputStream outputStream, boolean bl) throws ProjectIOException {
    }

    public void save(Task task, OutputStream outputStream, boolean bl) throws ProjectIOException {
    }
}

