/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.core.ActualWorkingData;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MouseHoover;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.conflict.Conflict;
import com.sbs.jpm.core.conflict.ConflictManager;
import com.sbs.jpm.core.constraint.ALAP;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.core.constraint.FNET;
import com.sbs.jpm.core.constraint.FNLT;
import com.sbs.jpm.core.constraint.MFO;
import com.sbs.jpm.core.constraint.MSO;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.constraint.SNLT;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPlanner {
    private static final Calendar c = Calendar.getInstance();
    private static final long roundUnit = 1000L;
    static int rescheduleCnt = 0;
    static int rescheduleMisscalls = 0;
    static boolean rescheduleProcess = false;
    static long debugCnt = 0L;
    static int dirtyLeafs = 0;
    static int calculatedLeafs = 0;
    static int dirtyPhases = 0;
    static int calculatedPhases = 0;
    static final boolean debugCycles = false;
    static boolean debugReschedule = false;
    static int cnt = 0;

    public static void forceTree(Task task, boolean bl) {
        if (!task.isEmpty()) {
            task.setForce(bl);
            task.setDirty(bl, false);
            if (!task.isLeaf()) {
                for (Task task2 : task.getChildList().toArray(new Task[0])) {
                    TaskPlanner.forceTree(task2, bl);
                }
            }
        }
    }

    private static void dependencyTypeChanged(Dependency dependency, int n) {
        dependency.type = n;
        dependency.getSuccessor().setDirty(true, true);
        dependency.getSuccessor().fireDataChanged();
    }

    private static void dependencyTaskDelayChanged(Dependency dependency, long l) {
        dependency.taskDelay = l;
        dependency.getSuccessor().setDirty(true, true);
        dependency.getSuccessor().fireDataChanged();
    }

    static void taskConstraintChanged(Task task, Constraint constraint) {
        task.constraint = constraint;
    }

    private static void taskChildAdded(Task task, Task task2) {
        TaskPlanner.taskChildAdded(task, task.getChildNumber(), task2);
    }

    static void taskChildAdded(Task task, int n, Task task2) {
        task2.parent = task;
        if (task.getCompany() != null) {
            task2.setCompany(task.getCompany());
            if (task.isLeaf()) {
                task.getCompany().getConflictManager().removeConflict(task);
            }
        }
        if (task.isLeaf()) {
            task.saveLeafDuration = task.duration;
            task.saveLeafWork = task.workOnTask;
            task.saveLeafCompletion = task.completion;
        }
        task.childList.add(n, task2);
        task.fireChildAdded(task2);
    }

    static void taskChildDeleted(Task task, Task task2) {
        task.fireChildWillRemove(task2);
        task.childList.remove(task2);
        task.fireChildRemoved(task2);
    }

    static void taskIndentOutdentCutted(Task task, Task task2) {
        task.fireChildWillRemove(task2);
        task.childList.remove(task2);
        task.fireChildRemoved(task2);
        task2.parent = null;
        task2.company = null;
    }

    static void taskDependencyAdded(Task task, Dependency dependency) {
        task.fireSuccesorAdded(dependency);
        dependency.getSuccessor().firePredecessorAdded(dependency);
    }

    static void taskDependencyRemoved(Task task, Dependency dependency) {
        task.successorDependencies.remove(dependency);
        dependency.getSuccessor().predecessorDependencies.remove(dependency);
        task.fireSuccesorRemoved(dependency);
        dependency.getSuccessor().firePredecessorRemoved(dependency);
    }

    static void setDuration(Task task, long l) {
        task.duration = l;
        task.setDirty(true, false);
    }

    static void setDependencyType(Dependency dependency, int n) {
        TaskPlanner.dependencyTypeChanged(dependency, n);
    }

    static void setDependencyTaskDelay(Dependency dependency, long l) {
        TaskPlanner.dependencyTaskDelayChanged(dependency, l);
    }

    static void setConstraint(Task task, Constraint constraint) {
        TaskPlanner.taskConstraintChanged(task, constraint);
        task.setDirty(true, true);
    }

    static void setCompletion(Task task, double d) {
        task.completion = d < 0.0 ? 0.0 : (d > 100.0 ? 100.0 : d);
        if (task.hasHumanResources()) {
            long l = task.getWork(task.getStartDate(), task.getEndDate());
            if (l != 0L) {
                long l2 = task.getWork(task.getStartDate(), task.getCompletionDate());
                task.workCompletion = (double)l2 * 100.0 / (double)l;
            } else {
                task.workCompletion = 0.0;
            }
        }
        task.setDirty(true, false);
    }

    static void setWorkCompletion(Task task, double d, boolean bl) {
        task.workCompletion = d < 0.0 ? 0.0 : (d > 100.0 ? 100.0 : d);
        if (bl && task.hasHumanResources()) {
            long l = (long)((double)task.workOnTask * task.workCompletion / 100.0);
            ActualWorkingData actualWorkingData = TaskPlanner.estimateWorkingDurationForWork(task, task.getStartDate(), l, true);
            double d2 = task.getCompletionForCompletionDate(actualWorkingData.endDate);
            task.setCompletion(d2);
        }
    }

    static void addTask(Task task, int n, Task task2) {
        TaskPlanner.taskChildAdded(task, n, task2);
        if (task.company != null) {
            task2.setDirty(true, true);
            task.setDirty(true, false);
        }
    }

    static void deleteTask(Task task, Task task2) {
        for (Task task3 : task2.getChildList().toArray(new Task[0])) {
            TaskPlanner.deleteTask(task2, task3);
        }
        TaskPlanner.removeRelations(task2);
        TaskPlanner.removeAssignments(task2);
        TaskPlanner.taskChildDeleted(task, task2);
        task2.getCompany().getConflictManager().removeConflict(task2);
        task.setDirty(true, false);
    }

    static void removeRelations(Task task) {
        for (Dependency dependency : task.successorDependencies.toArray(new Dependency[0])) {
            TaskPlanner.removeDependency(dependency);
        }
        for (Dependency dependency : task.predecessorDependencies.toArray(new Dependency[0])) {
            Task.removeDependency(dependency);
        }
    }

    static void removeAssignments(Task task) {
        for (Assignment assignment : task.assignments.toArray(new Assignment[0])) {
            assignment.getResource().removeAssignment(assignment);
            assignment.getTask().removeAssignment(assignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indent(Task task, Task task2) throws CircularRelationshipException {
        Task task3 = task.getParent();
        int n = task3.getChildIndex(task);
        task3.childList.remove(task);
        task2.childList.add(task2.getChildNumber(), task);
        task.parent = task2;
        try {
            List<Task> list = TaskPlanner.circularCheckRoot(task);
            if (list != null) {
                throw new CircularRelationshipException(list);
            }
        }
        finally {
            task2.childList.remove(task);
            task3.childList.add(n, task);
            task.parent = task3;
        }
        TaskPlanner.taskIndentOutdentCutted(task3, task);
        TaskPlanner.taskChildAdded(task2, task);
        task.setDirty(true, true);
        task2.setDirty(true, false);
        task3.setDirty(true, false);
    }

    static void outdent(Task task) {
        Task task2 = task.getParent();
        Task task3 = task2.getParent();
        if (task3 != null) {
            int n = task3.getChildIndex(task2);
            TaskPlanner.taskIndentOutdentCutted(task2, task);
            task3.addChild(n + 1, task);
        }
        task.setDirty(true, true);
        task2.setDirty(true, false);
        task3.setDirty(true, false);
    }

    public static Dependency areLinked(Task task, Task task2) {
        if (!task.equals(task2)) {
            Task task3;
            for (Dependency dependency : task.getSuccessorDependencies()) {
                task3 = dependency.getSuccessor();
                if (!task2.equals(task3)) continue;
                return dependency;
            }
            for (Dependency dependency : task2.getSuccessorDependencies()) {
                task3 = dependency.getSuccessor();
                if (!task.equals(task3)) continue;
                return dependency;
            }
        }
        return null;
    }

    public static void printTree(Task task, int n) {
        MouseHoover mouseHoover;
        int n2;
        System.out.println();
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("\t");
        }
        System.out.print(task.name + ": calculated=" + task.calculated + "; dirty=" + task.isDirty());
        System.out.print("; start=" + task.getStartDate() + "; end= " + task.getEndDate() + "; ");
        if (task.getChildNumber() > 0) {
            System.out.print("; children=(");
            for (n2 = 0; n2 < task.getChildNumber(); ++n2) {
                Task task2 = task.getChildAt(n2);
                if (task2.isEmpty()) continue;
                System.out.print(task2.name + " ");
            }
            System.out.print("); ");
        } else {
            System.out.print("; children=(); ");
        }
        List<Dependency> list = task.getSuccessorDependencies();
        if (list.size() > 0) {
            System.out.print("dep list=( ");
            for (int i = 0; i < list.size(); ++i) {
                mouseHoover = list.get(i);
                Task task3 = ((Dependency)mouseHoover).getSuccessor();
                if (task3.isEmpty()) continue;
                System.out.print(task3.name + " ");
            }
            System.out.print("); ");
        } else {
            System.out.print("dep list=(); ");
        }
        if (task.parent != null) {
            System.out.print("parent: " + task.parent.name);
        } else {
            System.out.print("parent: NULL ");
        }
        for (int i = 0; i < task.getChildNumber(); ++i) {
            mouseHoover = task.getChildAt(i);
            if (((Task)mouseHoover).isEmpty()) continue;
            TaskPlanner.printTree((Task)mouseHoover, n + 1);
        }
    }

    static boolean addDependency(Dependency dependency, boolean bl) throws CircularRelationshipException {
        List<Task> list;
        Task task = dependency.getSuccessor();
        Task task2 = dependency.getPredecessor();
        Dependency dependency2 = TaskPlanner.areLinked(task2, task);
        if (dependency2 != null && task2.equals(dependency2.getPredecessor())) {
            return false;
        }
        task2.successorDependencies.add(dependency);
        task.predecessorDependencies.add(dependency);
        if (bl && (list = TaskPlanner.circularCheckLink(task2, task)) != null) {
            task2.successorDependencies.remove(dependency);
            task.predecessorDependencies.remove(dependency);
            throw new CircularRelationshipException(list);
        }
        task.setDirty(true, true);
        TaskPlanner.taskDependencyAdded(task2, dependency);
        return true;
    }

    static void removeDependency(Dependency dependency) {
        TaskPlanner.taskDependencyRemoved(dependency.getPredecessor(), dependency);
        Task task = dependency.getSuccessor();
        task.setDirty(true, true);
    }

    private static void computeCompletionDate(ActualWorkingData actualWorkingData, Task task) {
        CalendarManager calendarManager = task.getUsedCalendar();
        double d = (double)actualWorkingData.duration * task.getCompletion() / 100.0;
        RemainingDuration remainingDuration = new RemainingDuration((long)d);
        c.setTime(actualWorkingData.startDate);
        calendarManager.convertToWorkingTime(c, remainingDuration, 1000L, !task.isMilestone());
        actualWorkingData.completionDate = new Date(remainingDuration.getEndMilis());
    }

    private static ActualWorkingData computeActualData(Task task) {
        boolean bl;
        ConflictManager conflictManager;
        Serializable serializable;
        Object object;
        block109: {
            boolean bl2;
            Object object2;
            block108: {
                boolean bl3;
                Object object3;
                Object object4;
                Serializable serializable2;
                object = null;
                LinkedList<Dependency> linkedList = new LinkedList<Dependency>();
                linkedList.addAll(task.getPredecessorDependencies());
                Task task2 = task;
                while (task2.getParent() != null) {
                    task2 = task2.getParent();
                    linkedList.addAll(task2.getPredecessorDependencies());
                }
                for (Dependency dependency : linkedList) {
                    Task task3 = dependency.getPredecessor();
                    serializable2 = null;
                    object2 = task.getUsedCalendar();
                    if (dependency.getType() == 0) {
                        serializable2 = task3.getEndDate();
                    } else if (dependency.getType() == 1) {
                        serializable2 = task3.getStartDate();
                    } else if (dependency.getType() == 3) {
                        c.setTime(task3.getEndDate());
                        object4 = new RemainingDuration(-task.getDuration());
                        ((CalendarManager)object2).convertToWorkingTime(c, (RemainingDuration)object4, !task.isMilestone());
                        serializable2 = new Date(((RemainingDuration)object4).getEndMilis());
                    } else if (dependency.getType() == 2) {
                        c.setTime(task3.getStartDate());
                        object4 = new RemainingDuration(-task.getDuration());
                        ((CalendarManager)object2).convertToWorkingTime(c, (RemainingDuration)object4, !task.isMilestone());
                        serializable2 = new Date(((RemainingDuration)object4).getEndMilis());
                    }
                    c.setTime((Date)serializable2);
                    object4 = new RemainingDuration(dependency.getTaskDelay());
                    ((CalendarManager)object2).convertToWorkingTime(c, (RemainingDuration)object4, !task.isMilestone());
                    serializable2 = new Date(((RemainingDuration)object4).getEndMilis());
                    if ((dependency.getType() == 3 || dependency.getType() == 2) && ((Date)serializable2).before((Date)(serializable = task.getProjectTask().getConstraint().getDate()))) {
                        serializable2 = serializable;
                    }
                    if (object == null) {
                        object = new Date(((Date)serializable2).getTime());
                    }
                    if (!((Date)serializable2).after((Date)object)) continue;
                    object = serializable2;
                }
                conflictManager = task.getCompany().getConflictManager();
                bl = false;
                bl2 = true;
                serializable2 = task.getProjectTask().getConstraint().getDate();
                object2 = object;
                object4 = object;
                if (!task.force && task.getCompletion() != 0.0) {
                    serializable = task.getStartDate();
                    object4 = serializable;
                    object2 = serializable;
                } else {
                    String string;
                    Serializable serializable3;
                    Object object5;
                    Object object6;
                    serializable = task.getConstraint();
                    if (serializable instanceof SNET) {
                        object6 = ((Constraint)serializable).getDate();
                        if (object == null || object != null && !((Date)object).after((Date)object6)) {
                            object2 = object6;
                            object4 = object6;
                            if (((Date)object6).before((Date)serializable2)) {
                                bl = true;
                                object5 = Common.I18N_MESSAGES.getString("task.beforeEstimatedProjectStart");
                                if (!task.isConflict()) {
                                    conflictManager.addConflict(new Conflict(task, (String)object5));
                                } else {
                                    serializable3 = conflictManager.getConflict(task);
                                    ((Conflict)serializable3).setMessage((String)object5);
                                }
                            }
                        } else if (((Date)object6).after((Date)object)) {
                            object2 = object6;
                            object4 = object6;
                        } else {
                            object2 = object;
                            object4 = object;
                        }
                    } else if (serializable instanceof SNLT) {
                        object6 = ((Constraint)serializable).getDate();
                        if (object == null || object != null && !((Date)object).after((Date)object6)) {
                            if (((Date)serializable2).after((Date)object6)) {
                                object2 = object6;
                                object4 = object6;
                                bl = true;
                                object5 = Common.I18N_MESSAGES.getString("task.beforeEstimatedProjectStart");
                                if (!task.isConflict()) {
                                    conflictManager.addConflict(new Conflict(task, (String)object5));
                                } else {
                                    serializable3 = conflictManager.getConflict(task);
                                    ((Conflict)serializable3).setMessage((String)object5);
                                }
                            } else {
                                object2 = serializable2;
                                object4 = serializable2;
                            }
                        } else {
                            object2 = object6;
                            object4 = object6;
                            bl = true;
                            object5 = Common.I18N_MESSAGES.getString("task.SNLTDateBeforeEndDateOfPredecessors");
                            if (!task.isConflict()) {
                                conflictManager.addConflict(new Conflict(task, (String)object5));
                            } else {
                                serializable3 = conflictManager.getConflict(task);
                                ((Conflict)serializable3).setMessage((String)object5);
                            }
                        }
                    } else if (serializable instanceof FNLT) {
                        c.setTime(((Constraint)serializable).getDate());
                        object6 = new RemainingDuration(-task.getDuration());
                        object5 = task.getUsedCalendar();
                        ((CalendarManager)object5).convertToWorkingTime(c, (RemainingDuration)object6, !task.isMilestone());
                        c.setTimeInMillis(((RemainingDuration)object6).getEndMilis());
                        serializable3 = c.getTime();
                        if (object == null || object != null && !((Date)object).after((Date)serializable3)) {
                            if (((Date)serializable2).after((Date)serializable3)) {
                                object2 = ((Constraint)serializable).getDate();
                                object4 = serializable3;
                                bl = true;
                                string = Common.I18N_MESSAGES.getString("task.beforeEstimatedProjectStart");
                                if (!task.isConflict()) {
                                    conflictManager.addConflict(new Conflict(task, string));
                                } else {
                                    object3 = conflictManager.getConflict(task);
                                    ((Conflict)object3).setMessage(string);
                                }
                            } else {
                                object2 = serializable2;
                                object4 = serializable2;
                            }
                        } else {
                            object2 = ((Constraint)serializable).getDate();
                            object4 = serializable3;
                            bl = true;
                            string = Common.I18N_MESSAGES.getString("task.FNLTDateBeforeEndDateOfPredecessors");
                            if (!task.isConflict()) {
                                conflictManager.addConflict(new Conflict(task, string));
                            } else {
                                object3 = conflictManager.getConflict(task);
                                ((Conflict)object3).setMessage(string);
                            }
                        }
                    } else if (serializable instanceof FNET) {
                        c.setTime(((Constraint)serializable).getDate());
                        object6 = new RemainingDuration(-task.getDuration());
                        object5 = task.getUsedCalendar();
                        ((CalendarManager)object5).convertToWorkingTime(c, (RemainingDuration)object6, !task.isMilestone());
                        c.setTimeInMillis(((RemainingDuration)object6).getEndMilis());
                        serializable3 = c.getTime();
                        if (object == null || object != null && !((Date)object).after((Date)serializable3)) {
                            object2 = serializable3;
                            object4 = serializable3;
                            if (((Date)serializable3).before((Date)serializable2)) {
                                bl = true;
                                string = Common.I18N_MESSAGES.getString("task.beforeEstimatedProjectStart");
                                if (!task.isConflict()) {
                                    conflictManager.addConflict(new Conflict(task, string));
                                } else {
                                    object3 = conflictManager.getConflict(task);
                                    ((Conflict)object3).setMessage(string);
                                }
                            }
                        } else if (((Date)serializable3).after((Date)object)) {
                            object2 = serializable3;
                            object4 = serializable3;
                        } else {
                            object2 = object;
                            object4 = object;
                        }
                    } else if (serializable instanceof ASAP) {
                        object6 = object;
                        if (object6 == null) {
                            object6 = serializable2;
                        } else if (((Date)serializable2).after((Date)object6)) {
                            bl = true;
                            object5 = Common.I18N_MESSAGES.getString("task.beforeEstimatedProjectStart");
                            if (!task.isConflict()) {
                                conflictManager.addConflict(new Conflict(task, (String)object5));
                            } else {
                                serializable3 = conflictManager.getConflict(task);
                                ((Conflict)serializable3).setMessage((String)object5);
                            }
                        }
                        object4 = object6;
                        object2 = object6;
                    } else if (!(serializable instanceof ALAP)) {
                        if (serializable instanceof MSO) {
                            object2 = object6 = ((Constraint)serializable).getDate();
                            object4 = object6;
                            if (object == null || object != null && !((Date)object).after((Date)object6)) {
                                if (((Date)serializable2).after((Date)object6)) {
                                    bl = true;
                                    object5 = Common.I18N_MESSAGES.getString("task.beforeEstimatedProjectStart");
                                    if (!task.isConflict()) {
                                        conflictManager.addConflict(new Conflict(task, (String)object5));
                                    } else {
                                        serializable3 = conflictManager.getConflict(task);
                                        ((Conflict)serializable3).setMessage((String)object5);
                                    }
                                }
                            } else {
                                bl = true;
                                object5 = Common.I18N_MESSAGES.getString("task.MSODateBeforeEndDateOfPredecessors");
                                if (!task.isConflict()) {
                                    conflictManager.addConflict(new Conflict(task, (String)object5));
                                } else {
                                    serializable3 = conflictManager.getConflict(task);
                                    ((Conflict)serializable3).setMessage((String)object5);
                                }
                            }
                        } else if (serializable instanceof MFO) {
                            bl2 = false;
                            c.setTime(((Constraint)serializable).getDate());
                            object6 = new RemainingDuration(-task.getDuration());
                            object5 = task.getUsedCalendar();
                            ((CalendarManager)object5).convertToWorkingTime(c, (RemainingDuration)object6, !task.isMilestone());
                            c.setTimeInMillis(((RemainingDuration)object6).getEndMilis());
                            serializable3 = c.getTime();
                            object2 = ((Constraint)serializable).getDate();
                            object4 = serializable3;
                            if (object == null || object != null && !((Date)object).after((Date)serializable3)) {
                                if (((Date)serializable2).after((Date)serializable3)) {
                                    bl = true;
                                    string = Common.I18N_MESSAGES.getString("task.beforeEstimatedProjectStart");
                                    if (!task.isConflict()) {
                                        conflictManager.addConflict(new Conflict(task, string));
                                    } else {
                                        object3 = conflictManager.getConflict(task);
                                        ((Conflict)object3).setMessage(string);
                                    }
                                }
                            } else {
                                bl = true;
                                string = Common.I18N_MESSAGES.getString("task.MFODateBeforeEndDateOfPredecessors");
                                if (!task.isConflict()) {
                                    conflictManager.addConflict(new Conflict(task, string));
                                } else {
                                    object3 = conflictManager.getConflict(task);
                                    ((Conflict)object3).setMessage(string);
                                }
                            }
                        }
                    }
                }
                boolean bl4 = task.isDurationDriven();
                boolean bl5 = !task.hasHumanResources();
                boolean bl6 = task.isWorkDriven() && task.hasHumanResources() && task.workOnTask == Long.MAX_VALUE;
                boolean bl7 = bl3 = task.isDurationDriven() && task.hasHumanResources() && task.duration == Long.MIN_VALUE;
                if (!bl4 && !bl5 && !bl6 || bl3) break block108;
                c.setTime((Date)object4);
                if (task.getFirstNonEmptyChild() == null && task.getCompletion() == 0.0 && !task.isMilestone()) {
                    object3 = task.getUsedCalendar();
                    ((CalendarManager)object3).getFirstTime(c, true, Long.MAX_VALUE);
                }
                object3 = c.getTime();
                serializable = task.getData();
                ((ActualWorkingData)serializable).setStartDate((Date)object3);
                ((ActualWorkingData)serializable).setEndDate(TaskPlanner.computeEndDateDurationDriven(task, (Date)object3));
                TaskPlanner.computeCompletionDate((ActualWorkingData)serializable, task);
                if (!task.hasHumanResources()) break block109;
                long l = 0L;
                for (Assignment assignment : task.getAssignments()) {
                    if (!(assignment.getResource() instanceof HumanResource)) continue;
                    assignment.start(((ActualWorkingData)serializable).getStartDate(), ((ActualWorkingData)serializable).getEndDate(), ((ActualWorkingData)serializable).getCompletionDate());
                    l += assignment.getWork();
                }
                ((ActualWorkingData)serializable).work = l;
                if (!task.isWorkDriven() || task.isFixedUnits() || l == 0L) break block109;
                ((ActualWorkingData)serializable).work = task.workOnTask = task.saveWorkOnTask;
                double d = (double)task.saveWorkOnTask / (double)l;
                for (Assignment assignment : task.getAssignments()) {
                    if (!(assignment.getResource() instanceof HumanResource)) continue;
                    assignment.units = assignment.getUnits() * d;
                    assignment.start(((ActualWorkingData)serializable).getStartDate(), ((ActualWorkingData)serializable).getEndDate(), ((ActualWorkingData)serializable).getCompletionDate());
                    l += assignment.getWork();
                }
                task.setDirty(true);
                break block109;
            }
            if (task.duration == Long.MIN_VALUE && !task.isFixedUnits() && task.hasHumanResources() && task.workOnTask != 0L) {
                serializable = task.getData();
                double d = (double)task.saveWorkOnTask / (double)task.workOnTask;
                ((ActualWorkingData)serializable).duration = task.saveDuration;
                for (Assignment assignment : task.getAssignments()) {
                    if (!(assignment.getResource() instanceof HumanResource)) continue;
                    assignment.units = assignment.getUnits() / d;
                }
                for (Assignment assignment : task.getAssignments()) {
                    if (!(assignment.getResource() instanceof HumanResource)) continue;
                    assignment.start(((ActualWorkingData)serializable).getStartDate(), ((ActualWorkingData)serializable).getEndDate(), ((ActualWorkingData)serializable).getCompletionDate());
                }
                task.setDirty(true);
            } else {
                serializable = TaskPlanner.estimateWorkingDurationForWork(task, (Date)object2, task.workOnTask, bl2);
                TaskPlanner.computeCompletionDate((ActualWorkingData)serializable, task);
                for (Assignment assignment : task.getAssignments()) {
                    if (!(assignment.getResource() instanceof HumanResource)) continue;
                    assignment.start(((ActualWorkingData)serializable).getStartDate(), ((ActualWorkingData)serializable).getEndDate(), ((ActualWorkingData)serializable).getCompletionDate());
                }
            }
        }
        if (!task.force && task.getCompletion() != 0.0) {
            Constraint constraint = task.getConstraint();
            if (constraint instanceof SNLT) {
                Date date = constraint.getDate();
                if (((ActualWorkingData)serializable).getStartDate().after(date)) {
                    bl = true;
                    if (!task.isConflict()) {
                        conflictManager.addConflict(new Conflict(task, Common.I18N_MESSAGES.getString("task.alreadyStarted.SNLT")));
                    }
                }
            } else if (constraint instanceof FNLT) {
                Date date = constraint.getDate();
                if (((ActualWorkingData)serializable).getEndDate().after(date)) {
                    bl = true;
                    if (!task.isConflict()) {
                        conflictManager.addConflict(new Conflict(task, Common.I18N_MESSAGES.getString("task.alreadyStarted.FNLT")));
                    }
                }
            } else if (!(constraint instanceof MSO) && constraint instanceof MFO) {
                Date date = constraint.getDate();
                if (((ActualWorkingData)serializable).getEndDate().after(date)) {
                    bl = true;
                    if (!task.isConflict()) {
                        conflictManager.addConflict(new Conflict(task, Common.I18N_MESSAGES.getString("task.alreadyStarted.MFO")));
                    }
                }
            }
        } else {
            Constraint constraint = task.getConstraint();
            if (constraint instanceof SNLT) {
                Date date = constraint.getDate();
                if (((ActualWorkingData)serializable).getStartDate().after(date)) {
                    bl = true;
                    if (!task.isConflict()) {
                        conflictManager.addConflict(new Conflict(task, Common.I18N_MESSAGES.getString("task.startsLaterThanSNLT")));
                    }
                }
            } else if (constraint instanceof FNLT) {
                Date date = constraint.getDate();
                if (((ActualWorkingData)serializable).getEndDate().after(date)) {
                    bl = true;
                    if (!task.isConflict()) {
                        conflictManager.addConflict(new Conflict(task, Common.I18N_MESSAGES.getString("task.finishesLaterThanFNLT")));
                    }
                }
            } else if (constraint instanceof MFO && object != null && ((ActualWorkingData)serializable).getStartDate().before((Date)object)) {
                bl = true;
                if (!task.isConflict()) {
                    conflictManager.addConflict(new Conflict(task, Common.I18N_MESSAGES.getString("task.startsBeforeEndDateOfPredecessors")));
                }
            }
        }
        if (!bl) {
            conflictManager.removeConflict(task);
        }
        return serializable;
    }

    private static final long round(double d) {
        return Math.round(d / 1000.0) * 1000L;
    }

    public static ActualWorkingData estimateWorkingDurationForWork(Task task, Date date, long l, boolean bl) {
        ActualWorkingData actualWorkingData = new ActualWorkingData();
        actualWorkingData.setWorkDriven(task.isWorkDriven());
        if (bl) {
            if (!task.hasHumanResources()) {
                actualWorkingData.duration = task.duration;
                actualWorkingData.work = task.workOnTask;
                if (actualWorkingData.startDate == null) {
                    actualWorkingData.startDate = date;
                }
                actualWorkingData.endDate = TaskPlanner.computeEndDateDurationDriven(task, date);
                return actualWorkingData;
            }
            actualWorkingData.duration = 0L;
            actualWorkingData.work = 0L;
            double d = 0.0;
            boolean bl2 = false;
            CalendarManager calendarManager = task.getUsedCalendar();
            c.setTime(date);
            Date serializable = null;
            block0: while (!bl2) {
                long l2 = c.getTimeInMillis() + l;
                calendarManager.getFirstTime(c, true, bl, Long.MAX_VALUE);
                Date serializable2 = c.getTime();
                calendarManager.getFirstTime(c, false, bl, l2);
                Date date2 = c.getTime();
                Vector<Alternance> vector = new Vector<Alternance>();
                for (Assignment serializable5 : task.getAssignments()) {
                    HumanResource humanResource;
                    Resource resource = serializable5.getResource();
                    if (!(resource instanceof HumanResource)) continue;
                    if (task.isForcedWorking()) {
                        humanResource = (HumanResource)resource;
                        vector.add(new Alternance(serializable2, date2, humanResource, serializable5.getUnits()));
                        continue;
                    }
                    c.setTime(serializable2);
                    humanResource = (HumanResource)resource;
                    calendarManager = humanResource.getResourceCalendar();
                    calendarManager.getFirstTime(c, true, bl, date2.getTime());
                    Date date3 = c.getTime();
                    calendarManager.getFirstTime(c, false, bl, date2.getTime());
                    Date date4 = c.getTime();
                    vector.add(new Alternance(date3, date4, humanResource, serializable5.getUnits()));
                }
                if (vector.size() <= 0) continue;
                while (!bl2) {
                    Object object = serializable2;
                    Date date5 = TaskPlanner.nextCut((Date)object, vector, date2, true);
                    long l3 = date5.getTime() - ((Date)object).getTime();
                    double d2 = 0.0;
                    for (int i = 0; i < vector.size(); ++i) {
                        Alternance alternance = vector.elementAt(i);
                        if (alternance.isIntersectingPeriod(((Date)object).getTime(), date5.getTime())) {
                            d2 += alternance.resourceUnits;
                        }
                        if (alternance.endAlternance.getTime() > date5.getTime()) continue;
                        HumanResource humanResource = alternance.resource;
                        calendarManager = humanResource.getResourceCalendar();
                        c.setTime(alternance.endAlternance);
                        calendarManager.getFirstTime(c, true, bl, date2.getTime());
                        Date date6 = c.getTime();
                        calendarManager.getFirstTime(c, false, bl, date2.getTime());
                        Date date7 = c.getTime();
                        vector.removeElementAt(i);
                        vector.add(i, new Alternance(date6, date7, humanResource, alternance.resourceUnits));
                    }
                    double d3 = d2 * (double)l3;
                    if (actualWorkingData.startDate == null && d3 != 0.0) {
                        actualWorkingData.startDate = object;
                    }
                    if (d + d3 + 1000.0 < (double)l) {
                        if ((d += d3) > 0.0) {
                            actualWorkingData.duration += l3;
                        }
                        serializable = date5;
                        object = date5;
                        serializable2 = object;
                        Date date8 = TaskPlanner.nextCut((Date)object, vector, date2, true);
                        if (((Date)object).getTime() < date2.getTime()) continue;
                        calendarManager = task.getUsedCalendar();
                        c.setTime(date2);
                        continue block0;
                    }
                    double d4 = d2 == 0.0 ? 0.0 : ((double)l - d) / d2;
                    d += d4 * d2;
                    actualWorkingData.work = l;
                    long l4 = TaskPlanner.round(d4);
                    actualWorkingData.duration += l4;
                    if (l4 == 0L) {
                        if (serializable == null) {
                            serializable = date;
                        }
                        actualWorkingData.endDate = serializable;
                    } else {
                        actualWorkingData.endDate = new Date(((Date)object).getTime() + l4);
                    }
                    if (actualWorkingData.startDate == null) {
                        actualWorkingData.startDate = date;
                    }
                    bl2 = true;
                    return actualWorkingData;
                }
            }
        } else {
            if (!task.hasHumanResources()) {
                actualWorkingData.duration = task.duration;
                actualWorkingData.work = task.workOnTask;
                if (actualWorkingData.endDate == null) {
                    actualWorkingData.endDate = date;
                }
                actualWorkingData.startDate = TaskPlanner.computeEndDateDurationDriven(task, date);
                return actualWorkingData;
            }
            actualWorkingData.duration = 0L;
            actualWorkingData.work = task.workOnTask;
            double d = 0.0;
            boolean bl3 = false;
            CalendarManager calendarManager = task.getUsedCalendar();
            c.setTime(date);
            Date serializable = null;
            block4: while (!bl3) {
                long l5 = c.getTimeInMillis() - l;
                calendarManager.getFirstTime(c, true, bl, Long.MAX_VALUE);
                Date serializable4 = c.getTime();
                calendarManager.getFirstTime(c, false, bl, l5);
                Date date7 = c.getTime();
                Vector<Alternance> vector = new Vector<Alternance>();
                for (Assignment assignment : task.getAssignments()) {
                    HumanResource humanResource;
                    Resource resource = assignment.getResource();
                    if (!(resource instanceof HumanResource)) continue;
                    if (task.isForcedWorking()) {
                        humanResource = (HumanResource)resource;
                        vector.add(new Alternance(date7, serializable4, humanResource, assignment.getUnits()));
                        continue;
                    }
                    c.setTime(serializable4);
                    humanResource = (HumanResource)resource;
                    calendarManager = humanResource.getResourceCalendar();
                    calendarManager.getFirstTime(c, true, bl, date7.getTime());
                    Date date9 = c.getTime();
                    calendarManager.getFirstTime(c, false, bl, date7.getTime());
                    Date date10 = c.getTime();
                    vector.add(new Alternance(date10, date9, humanResource, assignment.getUnits()));
                }
                if (vector.size() <= 0) continue;
                while (!bl3) {
                    Object object = serializable4;
                    Date date11 = TaskPlanner.nextCut((Date)object, vector, date7, false);
                    long l6 = ((Date)object).getTime() - date11.getTime();
                    double d5 = 0.0;
                    for (int i = 0; i < vector.size(); ++i) {
                        Alternance alternance = vector.elementAt(i);
                        if (alternance.isIntersectingPeriod(date11.getTime(), ((Date)object).getTime())) {
                            d5 += alternance.resourceUnits;
                        }
                        if (alternance.startAlternance.getTime() < date11.getTime()) continue;
                        HumanResource humanResource = alternance.resource;
                        calendarManager = humanResource.getResourceCalendar();
                        c.setTime(alternance.startAlternance);
                        calendarManager.getFirstTime(c, true, bl, date7.getTime());
                        Date date12 = c.getTime();
                        calendarManager.getFirstTime(c, false, bl, date7.getTime());
                        Date date13 = c.getTime();
                        vector.removeElementAt(i);
                        vector.add(i, new Alternance(date13, date12, humanResource, alternance.resourceUnits));
                    }
                    double d6 = d5 * (double)l6;
                    if (actualWorkingData.endDate == null && d6 != 0.0) {
                        actualWorkingData.endDate = object;
                    }
                    if (d + d6 + 1000.0 < (double)l) {
                        if ((d += d6) > 0.0) {
                            actualWorkingData.duration += l6;
                        }
                        object = date11;
                        serializable4 = object;
                        serializable = object;
                        Date date14 = TaskPlanner.nextCut((Date)object, vector, date7, false);
                        if (((Date)object).getTime() > date7.getTime()) continue;
                        calendarManager = task.getUsedCalendar();
                        c.setTime(date7);
                        continue block4;
                    }
                    double d7 = d5 == 0.0 ? 0.0 : ((double)l - d) / d5;
                    d += d7 * d5;
                    actualWorkingData.work = l;
                    long l7 = TaskPlanner.round(d7);
                    actualWorkingData.duration += l7;
                    if (l7 == 0L) {
                        if (serializable == null) {
                            serializable = date;
                        }
                        actualWorkingData.startDate = serializable;
                    } else {
                        actualWorkingData.startDate = new Date(((Date)object).getTime() - l7);
                    }
                    if (actualWorkingData.endDate == null) {
                        actualWorkingData.endDate = date;
                    }
                    bl3 = true;
                    return actualWorkingData;
                }
            }
        }
        return null;
    }

    static void computeEndDate(Task task) {
        if (!task.isEmpty()) {
            if (task.getFirstNonEmptyChild() == null) {
                if (!task.workDriven || !task.hasHumanResources()) {
                    task.endDate = TaskPlanner.computeEndDateDurationDriven(task, task.startDate);
                }
            } else {
                task.endDate = new Date(task.startDate.getTime() + task.duration);
            }
        }
    }

    static Date computeEndDateDurationDriven(Task task, Date date) {
        if (!task.isMilestone()) {
            CalendarManager calendarManager = task.getUsedCalendar();
            c.setTime(date);
            RemainingDuration remainingDuration = new RemainingDuration(task.duration);
            calendarManager.convertToWorkingTime(c, remainingDuration, !task.isMilestone());
            return new Date(remainingDuration.getEndMilis());
        }
        return date;
    }

    private static final Date nextCut(Date date, Vector<Alternance> vector, Date date2, boolean bl) {
        if (bl) {
            Date date3 = date2;
            for (int i = 0; i < vector.size(); ++i) {
                Alternance alternance = vector.elementAt(i);
                if (alternance.startAlternance.after(date)) {
                    if (!alternance.startAlternance.before(date3)) continue;
                    date3 = alternance.startAlternance;
                    continue;
                }
                if (!alternance.endAlternance.after(date) || !alternance.endAlternance.before(date3)) continue;
                date3 = alternance.endAlternance;
            }
            return date3;
        }
        Date date4 = date2;
        for (int i = 0; i < vector.size(); ++i) {
            Alternance alternance = vector.elementAt(i);
            if (alternance.endAlternance.before(date)) {
                if (!alternance.endAlternance.after(date4)) continue;
                date4 = alternance.endAlternance;
                continue;
            }
            if (!alternance.startAlternance.before(date) || !alternance.startAlternance.after(date4)) continue;
            date4 = alternance.startAlternance;
        }
        return date4;
    }

    private static void recalculateCompletion(Task task, Completion completion) {
        for (Task task2 : task.getChildList().toArray(new Task[0])) {
            if (task2.isEmpty()) continue;
            if (task2.isLeaf()) {
                if (task2.getDuration() == 0L) {
                    ++completion.workingDuration;
                    completion.completion = (long)((double)completion.completion + task2.getCompletion());
                    continue;
                }
                completion.workingDuration += task2.getDuration();
                completion.completion = (long)((double)completion.completion + task2.getCompletion() * (double)task2.getDuration());
                long l = task2.getWork();
                completion.work += l;
                completion.workCompletion = (long)((double)completion.workCompletion + task2.getWorkCompletion() * (double)l);
                continue;
            }
            TaskPlanner.recalculateCompletion(task2, completion);
        }
    }

    private static void clearTree(Task task) {
        if (!task.isEmpty()) {
            task.calculated = false;
            task.setDirty(false, false);
            if (!task.isLeaf()) {
                for (Task task2 : task.getChildList()) {
                    TaskPlanner.clearTree(task2);
                }
            }
        }
    }

    private static void announceTreeChanged(Task task) {
        if (!task.isEmpty()) {
            if (task.isDirty()) {
                task.fireDataChanged();
            }
            if (!task.isLeaf()) {
                for (Task task2 : task.getChildList()) {
                    TaskPlanner.announceTreeChanged(task2);
                }
            }
        }
    }

    private static boolean computeTree(Task task) {
        if (!task.isEmpty()) {
            if (!task.calculated) {
                if (task.isLeaf()) {
                    TaskPlanner.computeLeaf(task);
                } else {
                    TaskPlanner.computePhase(task);
                }
            }
            task.calculated = true;
        }
        return task.isDirty();
    }

    private static boolean computeLeaf(Task task) {
        boolean bl = TaskPlanner.computeAllPredecessors(task);
        if (bl || task.isDirty()) {
            ++calculatedLeafs;
            if (debugReschedule) {
                // empty if block
            }
            ActualWorkingData actualWorkingData = TaskPlanner.computeActualData(task);
            if (task.getStartDate() != null && !task.getStartDate().equals(actualWorkingData.getStartDate()) || task.getEndDate() != null && !task.getEndDate().equals(actualWorkingData.getEndDate())) {
                task.setDirty(true, false);
            }
            task.setData(actualWorkingData);
            if (task.isDirty()) {
                ++dirtyLeafs;
                if (debugReschedule) {
                    // empty if block
                }
                if (task.hasHumanResources()) {
                    long l = task.workOnTask;
                    if (l != 0L) {
                        long l2 = task.getWork(task.getStartDate(), task.getCompletionDate());
                        task.workCompletion = (double)l2 * 100.0 / (double)l;
                    } else {
                        task.workCompletion = 0.0;
                    }
                }
            }
        }
        task.force = false;
        return task.isDirty();
    }

    private static boolean computePhase(Task task) {
        boolean bl = TaskPlanner.computeKids(task);
        if (bl || task.isDirty()) {
            TaskPlanner.computePhaseFromKids(task);
        }
        return task.isDirty();
    }

    private static boolean computeKids(Task task) {
        Task[] taskArray = task.getChildList().toArray(new Task[0]);
        int n = taskArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Task task2 = taskArray[i];
            if (!TaskPlanner.computeTree(task2)) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean computeAllPredecessors(Task task) {
        boolean bl = false;
        if (TaskPlanner.computeDirectPredecessors(task)) {
            bl = true;
        }
        if (TaskPlanner.computeParentPredecessors(task)) {
            bl = true;
        }
        return bl;
    }

    private static boolean computeDirectPredecessors(Task task) {
        Dependency[] dependencyArray = task.predecessorDependencies.toArray(new Dependency[0]);
        int n = dependencyArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Dependency dependency = dependencyArray[i];
            if (!TaskPlanner.computeTree(dependency.getPredecessor())) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean computeParentPredecessors(Task task) {
        Task task2 = task.parent;
        boolean bl = false;
        while (task2 != null) {
            if (TaskPlanner.computeDirectPredecessors(task2)) {
                bl = true;
            }
            task2 = task2.parent;
        }
        return bl;
    }

    private static boolean computePhaseFromKids(Task task) {
        Task task2;
        Task[] taskArray = task.getChildList().toArray(new Task[0]);
        int n = taskArray.length;
        ++calculatedPhases;
        if (debugReschedule) {
            // empty if block
        }
        if ((task2 = task.getFirstNonEmptyChild()) == null) {
            task.startDate = new Date();
            task.duration = 0L;
            TaskPlanner.computeEndDate(task);
        } else {
            Date date = task2.getStartDate();
            Date date2 = task2.getEndDate();
            for (int i = 0; i < n; ++i) {
                Task task3 = taskArray[i];
                if (task3.isEmpty()) continue;
                if (task3.getStartDate().before(date)) {
                    date = task3.getStartDate();
                }
                if (!task3.getEndDate().after(date2)) continue;
                date2 = task3.getEndDate();
            }
            if (task.getStartDate() == null || task.getEndDate() == null) {
                task.setDirty(true, false);
            } else if (!task.getStartDate().equals(date) || !task.getEndDate().equals(date2)) {
                task.setDirty(true, false);
            }
            long l = date2.getTime() - date.getTime();
            if (l != task.getDuration()) {
                task.setDirty(true, false);
            }
            if (task.isDirty()) {
                ++dirtyPhases;
                task.startDate = date;
                task.endDate = date2;
                task.duration = l;
                task.phaseWorkingDuration = task.getUsedCalendar().getDuration(date, date2, true);
                TaskPlanner.computeEndDate(task);
                if (!task.isSplitted()) {
                    long l2;
                    long l3 = date2.getTime() - date.getTime();
                    if (l3 >= (l2 = 86400000L)) {
                        task.setDurationUnit(DurationManager.DAY);
                    } else {
                        long l4 = 3600000L;
                        if (l3 >= l4) {
                            task.setDurationUnit(DurationManager.HOUR);
                        } else {
                            task.setDurationUnit(DurationManager.MINUTE);
                        }
                    }
                }
            }
            Completion completion = new Completion();
            TaskPlanner.recalculateCompletion(task, completion);
            task.completion = Math.round((double)completion.completion / (double)completion.workingDuration);
            task.computeCompletionDate();
            task.workCompletion = Math.round((double)completion.workCompletion / (double)completion.work);
            task.computeWorkCompletionDate();
            long l5 = 0L;
            for (Assignment assignment : task.getAssignments()) {
                if (!(assignment.getResource() instanceof HumanResource)) continue;
                assignment.start(date, date2, task.getCompletionDate());
                l5 += assignment.getWork();
            }
            task.workOnTask = l5;
            task.setDirty(true, false);
        }
        return task.isDirty();
    }

    private static void printDebugInfo(String string, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rescheduleTree(Task task) {
        if (rescheduleProcess) {
            ++rescheduleMisscalls;
            return;
        }
        dirtyLeafs = 0;
        calculatedLeafs = 0;
        dirtyPhases = 0;
        calculatedPhases = 0;
        rescheduleProcess = true;
        rescheduleMisscalls = 0;
        TaskPlanner.printDebugInfo("\nstart reschedule: " + rescheduleCnt++, 0);
        long l = 0L;
        long l2 = 0L;
        try {
            if (task.getCompany() != null) {
                task = task.getCompany().getRootTask();
            }
            if (debugReschedule) {
                TaskPlanner.printDebugInfo("\nstart reschedule: " + rescheduleCnt, 0);
                l = System.currentTimeMillis();
            }
            TaskPlanner.computeTree(task);
            if (debugReschedule) {
                l2 = System.currentTimeMillis();
                TaskPlanner.printDebugInfo("\nreschedule duration:" + (l2 - l), 0);
                l = System.currentTimeMillis();
            }
            block3: for (HumanResource humanResource : task.getCompany().getHumanResources()) {
                for (Assignment assignment : humanResource.getAssignments()) {
                    if (!assignment.getTask().isDirty() || !assignment.getTask().company.isLoaded()) continue;
                    humanResource.dirty = true;
                    continue block3;
                }
            }
            for (HumanResource humanResource : task.getCompany().getHumanResources()) {
                if (!humanResource.dirty || humanResource.getAssignmentNumber() <= 0 || !humanResource.getAssignmentAt((int)0).getTask().company.isLoaded()) continue;
                humanResource.computeWorkIntervals();
            }
            if (debugReschedule) {
                l2 = System.currentTimeMillis();
                TaskPlanner.printDebugInfo("\nrecalculate work intervals for all affected resources duration:" + (l2 - l), 0);
                l = System.currentTimeMillis();
            }
            if (debugReschedule) {
                l2 = System.currentTimeMillis();
                TaskPlanner.printDebugInfo("\nrecalculate completion/workCompletion duration:" + (l2 - l), 0);
                l = System.currentTimeMillis();
            }
            if (task.getCompany().isShowCriticalPath()) {
                task.getCompany().computeCriticalPath();
                if (debugReschedule) {
                    l2 = System.currentTimeMillis();
                    TaskPlanner.printDebugInfo("\ncomputeCriticalPath duration:" + (l2 - l), 0);
                    l = System.currentTimeMillis();
                }
            }
            TaskPlanner.announceTreeChanged(task);
            if (debugReschedule) {
                l2 = System.currentTimeMillis();
                TaskPlanner.printDebugInfo("announce duration:" + (l2 - l), 0);
                TaskPlanner.printDebugInfo("calculatedLeafs: " + calculatedLeafs + "; (dirty:" + dirtyLeafs + ")", 1);
                TaskPlanner.printDebugInfo("calculatedPhases: " + calculatedPhases + "; (dirty:" + dirtyPhases + ")", 1);
            }
        }
        finally {
            if (debugReschedule) {
                TaskPlanner.printDebugInfo("\nrescheduleMisscalls: " + rescheduleMisscalls, 0);
            }
            rescheduleProcess = false;
            rescheduleMisscalls = 0;
            TaskPlanner.clearTree(task);
        }
    }

    public static List<Task> circularCheckLink(Task task, Task task2) {
        TaskPlanner.circularReset(task.getCompany().getRootTask());
        List<Task> list = TaskPlanner.circularCheckTree(task, new Vector<Task>(), false);
        return list;
    }

    public static List<Task> circularCheckRoot(Task task) {
        if (task == null) {
            return null;
        }
        TaskPlanner.circularReset(task.getCompany().getRootTask());
        List<Task> list = TaskPlanner.circularCheckTree(task.getCompany().getRootTask(), new Vector<Task>(), false);
        if (list != null) {
            Task task2 = list.get(list.size() - 1);
            while (list.get(0) != task2) {
                list.remove(0);
            }
        }
        return list;
    }

    public static void circularReset(Task task) {
        if (task == null) {
            return;
        }
        if (task.isEmpty()) {
            return;
        }
        task.cycleVisited = false;
        task.cycleCurrentPath = false;
        for (int i = 0; i < task.getChildNumber(); ++i) {
            TaskPlanner.circularReset(task.getChildAt(i));
        }
    }

    public static List<Task> circularCheckTree(Task task, List<Task> list, boolean bl) {
        if (task == null) {
            return null;
        }
        if (task.isEmpty()) {
            return null;
        }
        if (task.cycleCurrentPath) {
            list.add(task);
            return list;
        }
        if (task.cycleVisited) {
            return null;
        }
        if (bl) {
            list.add(task);
        }
        List<Task> list2 = null;
        list2 = TaskPlanner.circularCheckDependencies(task, list);
        if (list2 != null) {
            return list2;
        }
        int n = task.getChildNumber();
        for (int i = 0; i < n; ++i) {
            Task task2 = task.getChildAt(i);
            list2 = TaskPlanner.circularCheckTree(task2, list, bl);
            if (list2 == null) continue;
            return list2;
        }
        if (bl) {
            list.remove(list.size() - 1);
        }
        task.cycleVisited = true;
        return null;
    }

    public static List<Task> circularCheckDependencies(Task task, List<Task> list) {
        List<Dependency> list2 = task.getSuccessorDependencies();
        if (list2.size() > 0) {
            boolean bl;
            task.cycleCurrentPath = true;
            boolean bl2 = bl = list.size() == 0;
            if (bl) {
                list.add(task);
            }
            for (int i = 0; i < list2.size(); ++i) {
                Dependency dependency = list2.get(i);
                Task task2 = dependency.getSuccessor();
                if (task2.isAncestor(task)) {
                    return TaskPlanner.getDescendentRelashionshipPath(task2, task);
                }
                List<Task> list3 = TaskPlanner.circularCheckTree(task2, list, true);
                if (list3 != null) {
                    return list3;
                }
                list.add(task2);
                int n = 1;
                for (Task task3 = task2.getParent(); task3 != null; task3 = task3.getParent()) {
                    if (task3.cycleCurrentPath) {
                        list.add(task3);
                        return list;
                    }
                    if (task3.cycleVisited) break;
                    list.add(task3);
                    ++n;
                    list3 = TaskPlanner.circularCheckDependencies(task3, list);
                    if (list3 == null) continue;
                    return list3;
                }
                while (n > 0) {
                    list.remove(list.size() - 1);
                    --n;
                }
            }
            task.cycleCurrentPath = false;
            if (bl) {
                list.remove(list.size() - 1);
            }
        }
        return null;
    }

    public static List<Task> getDescendentRelashionshipPath(Task task, Task task2) {
        Vector<Task> vector = new Vector<Task>();
        Task task3 = task2;
        do {
            vector.add(0, task3);
        } while ((task3 = task3.getParent()) != task);
        vector.add(0, task);
        vector.add(0, task2);
        return vector;
    }

    static class Completion {
        long completion;
        long workingDuration;
        long workCompletion;
        long work;

        Completion() {
        }
    }

    static class Alternance {
        Date startAlternance;
        Date endAlternance;
        long startAlternanceLong;
        long endAlternanceLong;
        HumanResource resource;
        double resourceUnits;

        Alternance(Date date, Date date2, HumanResource humanResource, double d) {
            this.startAlternance = date;
            this.endAlternance = date2;
            this.startAlternanceLong = date.getTime();
            this.endAlternanceLong = date2.getTime();
            this.resource = humanResource;
            this.resourceUnits = d;
        }

        private boolean isIntersectingPeriod(long l, long l2) {
            return l < this.endAlternanceLong && l2 > this.startAlternanceLong;
        }
    }
}

