/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.event.RiskEvent;
import com.sbs.jpm.core.event.RiskListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class Risk
implements Serializable,
UniqueId {
    public static final Level LOW = new Level(Common.I18N_RP.getString("risk.priority.low"));
    public static final Level MEDIUM = new Level(Common.I18N_RP.getString("risk.priority.medium"));
    public static final Level HIGH = new Level(Common.I18N_RP.getString("risk.priority.high"));
    public static final Status OPENED = new Status(Common.I18N_RP.getString("risk.status.opened"));
    public static final Status CLOSED = new Status(Common.I18N_RP.getString("risk.status.closed"));
    private Status status;
    private Level impact;
    private Level probability;
    private String description;
    private String responsePlan;
    private Company owner;
    private EventListenerList listeners;
    private long uniqueId;

    public Company getOwner() {
        return this.owner;
    }

    public Risk(long l) {
        this(l, "");
    }

    public Risk(long l, String string) {
        this.description = string;
        this.setUniqueId(l);
        this.status = OPENED;
        this.impact = MEDIUM;
        this.probability = MEDIUM;
        this.responsePlan = "";
        this.listeners = new EventListenerList();
    }

    public void setOwner(Company company) {
        this.owner = company;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fireDataChanged();
    }

    public String getResponsePlan() {
        return this.responsePlan;
    }

    public void setResponsePlan(String string) {
        this.responsePlan = string;
        this.fireResponsePlanChanged();
    }

    private void fireRiskChanged() {
        if (this.owner != null) {
            this.owner.setChanged(true);
        }
    }

    public String toString() {
        return this.description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.fireDataChanged();
    }

    public Level getImpact() {
        return this.impact;
    }

    public void setImpact(Level level) {
        this.impact = level;
        this.fireDataChanged();
    }

    public Level getProbability() {
        return this.probability;
    }

    public void setProbability(Level level) {
        this.probability = level;
        this.fireDataChanged();
    }

    public void fireResponsePlanChanged() {
        RiskEvent riskEvent = new RiskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(RiskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((RiskListener)eventListenerArray[i]).responsePlanChanged(riskEvent);
        }
        this.fireRiskChanged();
    }

    public void fireDataChanged() {
        RiskEvent riskEvent = new RiskEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(RiskListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((RiskListener)eventListenerArray[i]).dataChanged(riskEvent);
        }
        this.fireRiskChanged();
    }

    public void addRiskListener(RiskListener riskListener) {
        this.listeners.add(RiskListener.class, riskListener);
    }

    public void removeRiskListener(RiskListener riskListener) {
        this.listeners.remove(RiskListener.class, riskListener);
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    public static class Status
    implements Serializable {
        private String name;

        public Status(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Level
    implements Serializable {
        private String name;

        public Level(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

