/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.event.LinkEvent;
import com.sbs.jpm.core.event.LinkListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class Link
implements Serializable,
UniqueId {
    private String name;
    private String description;
    private Company owner;
    private long uniqueId;
    private EventListenerList listeners;

    public Link(long l) {
        this(l, "");
    }

    public Link(long l, String string) {
        this.name = string;
        this.uniqueId = l;
        this.description = "";
        this.listeners = new EventListenerList();
    }

    public void setOwner(Company company) {
        this.owner = company;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.fireDataChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fireDataChanged();
    }

    private void fireLinkChanged() {
        if (this.owner != null) {
            this.owner.setChanged(true);
        }
    }

    public void fireDataChanged() {
        LinkEvent linkEvent = new LinkEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(LinkListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((LinkListener)eventListenerArray[i]).dataChanged(linkEvent);
        }
        this.fireLinkChanged();
    }

    public void addLinkListener(LinkListener linkListener) {
        this.listeners.add(LinkListener.class, linkListener);
    }

    public void removeLinkListener(LinkListener linkListener) {
        this.listeners.remove(LinkListener.class, linkListener);
    }

    public String toString() {
        return this.name;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(long l) {
        this.uniqueId = this.uniqueId;
    }
}

