/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.ResourceCalendarManager;
import com.sbs.jpm.calendar.event.CalendarManagerEvent;
import com.sbs.jpm.calendar.event.CalendarManagerListener;
import com.sbs.jpm.common.IDsGenerator.IDGenerator;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.AssignmentUnit;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.ResourceUnit;
import com.sbs.jpm.core.Task;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanResource
extends Resource {
    private static final long serialVersionUID = 1L;
    private String phoneNo;
    private String email;
    private double maxUnits;
    private double overtimeRate;
    private CalendarManager calendar;
    private ResourceCalendarManager resourceCalendar;
    private long actualStandardWork;
    private long remainingStandardWork;
    private long actualOvertimeWork;
    private long remainingOvertimeWork;
    private long overtimeWork;
    private long standardWork;
    private long overallocatedWork;
    private long intervalOvertimeWork;
    private long intervalStandardWork;
    private long intervalOverallocatedWork;
    private long intervalCapacityWork;
    private long intervalUsedWork;
    private long intervalAvailableWork;
    private long intervalActualWork;
    private long intervalActualStandardWork;
    private long intervalActualOvertimeWork;
    private long intervalRemainingWork;
    private long intervalRemainingStandardWork;
    private long intervalRemainingOvertimeWork;
    private List allocationUnits;
    private final CalendarHandler calendarHandler = new CalendarHandler();
    boolean dirty = false;

    public HumanResource(long l) {
        super.setUniqueId(l);
        this.maxUnits = 1.0;
        this.resourceCalendar = new ResourceCalendarManager(this);
        this.resourceCalendar.addCalendarManagerListener(this.calendarHandler);
        this.allocationUnits = new LinkedList();
    }

    @Override
    protected void initEmptyResource() {
        if (this.name == null) {
            this.name = "";
        }
        if (this.code == null) {
            this.code = "";
        }
        if (this.notes == null) {
            this.notes = "";
        }
        if (this.phoneNo == null) {
            this.phoneNo = "";
        }
        if (this.email == null) {
            this.email = "";
        }
        this.empty = false;
        this.getOwner().computeResourceId();
    }

    public double getMaxUnits() {
        return this.maxUnits;
    }

    public void setMaxUnits(double d) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.maxUnits = d;
        if (this.owner != null && this.owner.isLoaded()) {
            for (Assignment assignment : this.getAssignments()) {
                if (!(assignment.getResource() instanceof HumanResource)) continue;
                Task task = assignment.getTask();
                assignment.start(task.getStartDate(), task.getEndDate(), task.getCompletionDate());
            }
            this.computeWorkIntervals();
        }
        this.fireDataChanged();
    }

    public double getOvertimeRate() {
        return this.overtimeRate;
    }

    public void setOvertimeRate(double d) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.overtimeRate = d;
        if (this.owner != null && this.owner.isLoaded()) {
            this.computeWorkIntervals();
        }
        this.fireDataChanged();
    }

    @Override
    public void setStandardRate(double d) {
        super.setStandardRate(d);
        if (this.owner != null && this.owner.isLoaded()) {
            this.computeWorkIntervals();
        }
    }

    public ResourceCalendarManager getResourceCalendar() {
        return this.resourceCalendar;
    }

    public CalendarManager getCalendar() {
        return this.calendar;
    }

    public CalendarManager getUsedCalendar() {
        CalendarManager calendarManager = this.calendar;
        if (calendarManager == null) {
            calendarManager = this.getOwner().getCalendarManager();
        }
        return calendarManager;
    }

    public void setCalendar(CalendarManager calendarManager) {
        if (this.empty) {
            this.initEmptyResource();
        }
        CalendarManager calendarManager2 = this.calendar;
        this.calendar = calendarManager;
        if (this.owner != null && this.owner.isLoaded()) {
            this.computeWorkIntervals();
        }
        for (Assignment assignment : this.getAssignments()) {
            Task task = assignment.getTask();
            task.setCompletion(task.getCompletion());
        }
        if (calendarManager2 != null) {
            calendarManager2.removeCalendarManagerListener(this.calendarHandler);
        }
        if (calendarManager != null) {
            calendarManager.addCalendarManagerListener(this.calendarHandler);
        }
        this.fireDataChanged();
    }

    public long getWork() {
        return this.getStandardWork() + this.getOvertimeWork();
    }

    public long getActualWork() {
        long l = 0L;
        for (Assignment assignment : this.assignments) {
            l += assignment.getActualWork();
        }
        return l;
    }

    public long getRemainingWork() {
        long l = 0L;
        for (Assignment assignment : this.assignments) {
            l += assignment.getRemainingWork();
        }
        return l;
    }

    public long getActualWork(Assignment assignment) {
        return assignment.getActualWork();
    }

    public long getRemainingWork(Assignment assignment) {
        return assignment.getRemainingWork();
    }

    public long getStandardWork() {
        if (!this.isEmpty()) {
            return this.standardWork;
        }
        return 0L;
    }

    public long getOvertimeWork() {
        if (!this.isEmpty()) {
            return this.overtimeWork;
        }
        return 0L;
    }

    public long getStandardWork(Assignment assignment) {
        if (!this.isEmpty()) {
            return assignment.getStandardWork();
        }
        return 0L;
    }

    public long getOvertimeWork(Assignment assignment) {
        if (!this.isEmpty()) {
            return assignment.getOvertimeWork();
        }
        return 0L;
    }

    @Override
    public double getActualCost(Assignment assignment) {
        if (!this.isEmpty()) {
            return this.standardRate * (double)assignment.getActualStandardWork() / 3600000.0 + this.overtimeRate * (double)assignment.getActualOvertimeWork() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getRemainingCost(Assignment assignment) {
        if (!this.isEmpty()) {
            return this.standardRate * (double)assignment.getRemainingStandardWork() / 3600000.0 + this.overtimeRate * (double)assignment.getRemainingOvertimeWork() / 3600000.0;
        }
        return 0.0;
    }

    public long getStandardWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalStandardWork;
        }
        return 0L;
    }

    public long getOvertimeWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalOvertimeWork;
        }
        return 0L;
    }

    public long getActualWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalActualWork;
        }
        return 0L;
    }

    public long getRemainingWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalRemainingWork;
        }
        return 0L;
    }

    private long getWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalStandardWork + this.intervalOvertimeWork;
        }
        return 0L;
    }

    public long getUsedWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalUsedWork;
        }
        return 0L;
    }

    public long getAvailableWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalAvailableWork;
        }
        return 0L;
    }

    public long getCapacityWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalCapacityWork;
        }
        return 0L;
    }

    public long getStandardWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalStandardWork();
        }
        return 0L;
    }

    public long getOvertimeWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalOvertimeWork();
        }
        return 0L;
    }

    public long getActualWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalActualWork();
        }
        return 0L;
    }

    private long getActualStandardWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalActualStandardWork();
        }
        return 0L;
    }

    private long getActualOvertimeWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalActualOvertimeWork();
        }
        return 0L;
    }

    public long getRemainingWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalRemainingWork();
        }
        return 0L;
    }

    private long getRemainingStandardWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalRemainingStandardWork();
        }
        return 0L;
    }

    private long getRemainingOvertimeWork(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalRemainingOvertimeWork();
        }
        return 0L;
    }

    public long getWork(Assignment assignment) {
        return this.getStandardWork(assignment) + this.getOvertimeWork(assignment);
    }

    public long getWork(Assignment assignment, Date date, Date date2) {
        return this.getStandardWork(assignment, date, date2) + this.getOvertimeWork(assignment, date, date2);
    }

    public boolean isOverallocated() {
        if (!this.isEmpty()) {
            return this.getOverallocatedWork() != 0L;
        }
        return false;
    }

    public boolean isOverallocated(Assignment assignment) {
        if (!this.isEmpty()) {
            return assignment.getOverallocatedWork() != 0L;
        }
        return false;
    }

    public boolean isOverallocated(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return assignment.getIntervalOverallocatedWork() != 0L;
        }
        return false;
    }

    public boolean isOverallocated(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.getOverallocatedWork(date, date2) != 0L;
        }
        return false;
    }

    public double getOvertimeCost(Assignment assignment) {
        if (!this.isEmpty()) {
            return (double)assignment.getOvertimeWork() * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getStandardCost(Assignment assignment) {
        if (!this.isEmpty()) {
            return (double)assignment.getStandardWork() * this.getStandardRate() / 3600000.0;
        }
        return 0.0;
    }

    public double getOvertimeCost(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getOvertimeWork(assignment, date, date2) * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getStandardCost(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getStandardWork(assignment, date, date2) * this.getStandardRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getActualCost(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getActualStandardWork(assignment, date, date2) * this.getStandardRate() / 3600000.0 + (double)this.getActualOvertimeWork(assignment, date, date2) * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getRemainingCost(Assignment assignment, Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getActualStandardWork(assignment, date, date2) * this.getStandardRate() / 3600000.0 + (double)this.getActualOvertimeWork(assignment, date, date2) * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getRemainingCost(Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getIntervalRemainingStandardWork() * this.getStandardRate() / 3600000.0 + (double)this.getIntervalRemainingOvertimeWork() * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    public double getOvertimeCost(Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getOvertimeWork(date, date2) * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getActualCost(Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getIntervalActualStandardWork() * this.getStandardRate() / 3600000.0 + (double)this.getIntervalActualOvertimeWork() * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getStandardCost(Date date, Date date2) {
        if (!this.isEmpty()) {
            return (double)this.getStandardWork(date, date2) * this.getStandardRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getActualCost() {
        double d = 0.0;
        for (Assignment assignment : this.assignments) {
            d += this.getActualCost(assignment);
        }
        return d;
    }

    @Override
    public double getRemainingCost() {
        double d = 0.0;
        for (Assignment assignment : this.assignments) {
            d += this.getRemainingCost(assignment);
        }
        return d;
    }

    @Override
    public double getStandardCost() {
        if (!this.isEmpty()) {
            return (double)this.getStandardWork() * this.getStandardRate() / 3600000.0;
        }
        return 0.0;
    }

    public double getOvertimeCost() {
        if (!this.isEmpty()) {
            return (double)this.getOvertimeWork() * this.getOvertimeRate() / 3600000.0;
        }
        return 0.0;
    }

    @Override
    public double getCost() {
        return this.getStandardCost() + this.getOvertimeCost();
    }

    @Override
    public double getCost(Assignment assignment) {
        return this.getStandardCost(assignment) + this.getOvertimeCost(assignment);
    }

    @Override
    public double getCost(Date date, Date date2) {
        return this.getStandardCost(date, date2) + this.getOvertimeCost(date, date2);
    }

    @Override
    public double getCost(Assignment assignment, Date date, Date date2) {
        return this.getStandardCost(assignment, date, date2) + this.getOvertimeCost(assignment, date, date2);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.email = string;
        this.fireDataChanged();
    }

    public String getPhoneNo() {
        return this.phoneNo;
    }

    public void setPhoneNo(String string) {
        if (this.empty) {
            this.initEmptyResource();
        }
        this.phoneNo = string;
        this.fireDataChanged();
    }

    @Override
    public void addAssignment(Assignment assignment, int n) {
        super.addAssignment(assignment, n);
        if (this.owner != null && this.owner.isLoaded()) {
            assignment.getTask().setDirty(true, false);
        }
    }

    @Override
    public void removeAssignment(Assignment assignment) {
        Task task = assignment.getTask();
        super.removeAssignment(assignment);
        task.setCompletion(task.getCompletion());
        this.dirty = true;
        assignment.getTask().setDirty(true, false);
    }

    @Override
    public void fireDataChanged() {
        super.fireDataChanged();
        if (this.owner != null && this.owner.isLoaded()) {
            this.computeWorkIntervals();
        }
    }

    public void computeWorkIntervals() {
        long l = System.currentTimeMillis();
        this.allocationUnits.clear();
        if (this.getAssignmentNumber() > 0) {
            Object object;
            Object object2;
            AssignmentUnitsList[] assignmentUnitsListArray = new AssignmentUnitsList[this.getAssignmentNumber()];
            int n = 0;
            long l2 = Long.MAX_VALUE;
            int n2 = -1;
            TreeSet<AssignmentUnitDate> treeSet = new TreeSet<AssignmentUnitDate>(new AssignmentUnitDateComparator());
            long l3 = System.currentTimeMillis();
            int n3 = 0;
            for (Assignment serializable : this.getAssignments()) {
                serializable.assignmentUnitID = n3++;
                assignmentUnitsListArray[n] = new AssignmentUnitsList(serializable);
                object2 = assignmentUnitsListArray[n].aList.iterator();
                while (object2.hasNext()) {
                    object = (AssignmentUnit)object2.next();
                    treeSet.add(new AssignmentUnitDate((AssignmentUnit)object, true));
                    treeSet.add(new AssignmentUnitDate((AssignmentUnit)object, false));
                }
                if (assignmentUnitsListArray[n].crtTimePoint < l2) {
                    l2 = assignmentUnitsListArray[n].crtTimePoint;
                    n2 = n;
                }
                ++n;
            }
            Iterator<Object> iterator = treeSet.iterator();
            if (iterator.hasNext()) {
                Vector<AssignmentUnitDate> vector = new Vector<AssignmentUnitDate>();
                object = object2 = (AssignmentUnitDate)iterator.next();
                while (iterator.hasNext() && ((AssignmentUnitDate)object).getDate() == ((AssignmentUnitDate)object2).getDate()) {
                    vector.add((AssignmentUnitDate)object);
                    object = (AssignmentUnitDate)iterator.next();
                }
                HumanResource.removeEndAssignmentsUnitDate(vector, (AssignmentUnitDate)object2);
                do {
                    double d = 0.0;
                    for (int resourceUnit = 0; resourceUnit < vector.size(); ++resourceUnit) {
                        d += vector.elementAt((int)resourceUnit).assignmentUnit.assignment.getUnits();
                    }
                    if (d > this.getMaxUnits()) {
                        ResourceUnit resourceUnit = new ResourceUnit();
                        resourceUnit.startDate = ((AssignmentUnitDate)object2).getDate();
                        resourceUnit.endDate = ((AssignmentUnitDate)object).getDate();
                        resourceUnit.value = resourceUnit.endDate - resourceUnit.startDate;
                        resourceUnit.setUnits(d - this.getMaxUnits());
                        this.allocationUnits.add(resourceUnit);
                    }
                    object2 = object;
                    while (iterator.hasNext() && ((AssignmentUnitDate)object).getDate() == ((AssignmentUnitDate)object2).getDate()) {
                        if (((AssignmentUnitDate)object).dateType) {
                            vector.add((AssignmentUnitDate)object);
                        } else {
                            HumanResource.removeAssignmentUnitDatePeer(vector, (AssignmentUnitDate)object);
                        }
                        object = (AssignmentUnitDate)iterator.next();
                    }
                } while (iterator.hasNext());
            }
            this.computeWork();
        } else {
            this.overtimeWork = 0L;
            this.standardWork = 0L;
            this.overallocatedWork = 0L;
        }
        this.dirty = false;
        long l4 = System.currentTimeMillis();
    }

    public int getNextMin(long l, AssignmentUnitsList[] assignmentUnitsListArray) {
        long l2 = Long.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.getAssignmentNumber(); ++i) {
            AssignmentUnitsList assignmentUnitsList = assignmentUnitsListArray[i];
            if (assignmentUnitsList.crtTimePoint < l || assignmentUnitsList.crtTimePoint >= l2) continue;
            l2 = assignmentUnitsList.crtTimePoint;
            n = i;
        }
        return n;
    }

    private void computeWork() {
        this.overtimeWork = 0L;
        this.standardWork = 0L;
        this.overallocatedWork = 0L;
        this.actualStandardWork = 0L;
        this.actualOvertimeWork = 0L;
        this.remainingStandardWork = 0L;
        this.remainingOvertimeWork = 0L;
        for (Assignment serializable : this.getAssignments()) {
            this.overtimeWork += serializable.getOvertimeWork();
            this.standardWork += serializable.getStandardWork();
            this.actualStandardWork += serializable.getActualStandardWork();
            this.actualOvertimeWork += serializable.getActualOvertimeWork();
            this.remainingStandardWork += serializable.getRemainingStandardWork();
            this.remainingOvertimeWork += serializable.getRemainingOvertimeWork();
        }
        for (ResourceUnit resourceUnit : this.allocationUnits) {
            this.overallocatedWork = (long)((double)this.overallocatedWork + (double)resourceUnit.value * resourceUnit.getUnits());
        }
    }

    public long getOverallocatedWork() {
        return this.overallocatedWork;
    }

    public long getOverallocatedWork(Date date, Date date2) {
        if (!this.isEmpty()) {
            return this.intervalOverallocatedWork;
        }
        return 0L;
    }

    public void computeWork(Date date, Date date2) {
        this.intervalStandardWork = 0L;
        this.intervalOvertimeWork = 0L;
        this.intervalOverallocatedWork = 0L;
        this.intervalActualWork = 0L;
        this.intervalActualStandardWork = 0L;
        this.intervalActualOvertimeWork = 0L;
        this.intervalRemainingWork = 0L;
        this.intervalRemainingStandardWork = 0L;
        this.intervalRemainingOvertimeWork = 0L;
        for (Assignment serializable : this.getAssignments()) {
            serializable.computeWork(date, date2, serializable.getTask().getCompletionDate());
            this.intervalStandardWork += serializable.getIntervalStandardWork();
            this.intervalOvertimeWork += serializable.getIntervalOvertimeWork();
            this.intervalActualWork += serializable.getIntervalActualWork();
            this.intervalActualStandardWork += serializable.getIntervalActualStandardWork();
            this.intervalActualOvertimeWork += serializable.getIntervalActualOvertimeWork();
            this.intervalRemainingWork += serializable.getIntervalRemainingWork();
            this.intervalRemainingStandardWork += serializable.getIntervalRemainingStandardWork();
            this.intervalRemainingOvertimeWork += serializable.getIntervalRemainingOvertimeWork();
        }
        for (ResourceUnit resourceUnit : this.allocationUnits) {
            long l = resourceUnit.startDate;
            long l2 = resourceUnit.endDate;
            if (date.getTime() > resourceUnit.endDate || date2.getTime() < resourceUnit.startDate) continue;
            long l3 = date2.getTime() < l2 ? date2.getTime() : l2;
            long l4 = date.getTime() > l ? date.getTime() : l;
            this.intervalOverallocatedWork = (long)((double)this.intervalOverallocatedWork + (double)(l3 - l4) * resourceUnit.getUnits());
        }
        ResourceCalendarManager resourceCalendarManager = this.getResourceCalendar();
        this.intervalCapacityWork = (long)((double)resourceCalendarManager.getDuration(date, date2, true) * this.maxUnits);
        long l = this.getWork(date, date2);
        this.intervalUsedWork = l < this.intervalCapacityWork ? l : this.intervalCapacityWork;
        this.intervalAvailableWork = this.intervalCapacityWork - this.intervalUsedWork;
    }

    public String getProjects(Date date, Date date2) {
        LinkedList<Task> linkedList = new LinkedList<Task>();
        for (Assignment object : this.getAssignments()) {
            Task task;
            object.computeWork(date, date2, object.getTask().getCompletionDate());
            if (object.getIntervalStandardWork() + object.getIntervalOvertimeWork() == 0L || linkedList.contains(task = object.getTask().getProjectTask())) continue;
            linkedList.add(task);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Task task : linkedList) {
            stringBuffer.append(task.toString());
            stringBuffer.append(",");
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public void setResourceCalendar(ResourceCalendarManager resourceCalendarManager) {
        this.resourceCalendar = resourceCalendarManager;
    }

    public long getIntervalActualOvertimeWork() {
        if (!this.isEmpty()) {
            return this.intervalActualOvertimeWork;
        }
        return 0L;
    }

    public long getIntervalActualStandardWork() {
        if (!this.isEmpty()) {
            return this.intervalActualStandardWork;
        }
        return 0L;
    }

    public long getIntervalRemainingOvertimeWork() {
        if (!this.isEmpty()) {
            return this.intervalRemainingOvertimeWork;
        }
        return 0L;
    }

    public long getIntervalRemainingStandardWork() {
        if (!this.isEmpty()) {
            return this.intervalRemainingStandardWork;
        }
        return 0L;
    }

    public long getActualOvertimeWork() {
        return this.actualOvertimeWork;
    }

    public long getActualStandardWork() {
        return this.actualStandardWork;
    }

    public long getRemainingOvertimeWork() {
        return this.remainingOvertimeWork;
    }

    public long getRemainingStandardWork() {
        return this.remainingStandardWork;
    }

    public static void removeAssignmentUnitDatePeer(Vector<AssignmentUnitDate> vector, AssignmentUnitDate assignmentUnitDate) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt((int)i).assignmentUnit.assignment.assignmentUnitID != assignmentUnitDate.assignmentUnit.assignment.assignmentUnitID) continue;
            vector.removeElementAt(i);
            return;
        }
        assert (false);
    }

    public static void removeEndAssignmentsUnitDate(Vector<AssignmentUnitDate> vector, AssignmentUnitDate assignmentUnitDate) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt((int)i).dateType) continue;
            vector.removeElementAt(i);
            --i;
        }
    }

    @Override
    public Object clone(IDGenerator iDGenerator, boolean bl) {
        long l = bl ? iDGenerator.getNewId() : this.uniqueId;
        HumanResource humanResource = new HumanResource(l);
        humanResource.assignments = new LinkedList();
        humanResource.listeners = new EventListenerList();
        humanResource.owner = null;
        humanResource.code = this.code;
        humanResource.empty = this.empty;
        humanResource.name = this.name;
        humanResource.notes = this.notes;
        humanResource.resourceId = this.resourceId;
        humanResource.standardRate = this.standardRate;
        humanResource.actualOvertimeWork = this.actualOvertimeWork;
        humanResource.actualStandardWork = this.actualStandardWork;
        humanResource.email = this.email;
        humanResource.maxUnits = this.maxUnits;
        humanResource.overallocatedWork = this.overallocatedWork;
        humanResource.overtimeRate = this.overtimeRate;
        humanResource.overtimeWork = this.overtimeWork;
        humanResource.phoneNo = this.phoneNo;
        humanResource.remainingOvertimeWork = this.remainingOvertimeWork;
        humanResource.remainingStandardWork = this.remainingStandardWork;
        humanResource.standardRate = this.standardRate;
        humanResource.standardWork = this.standardWork;
        return humanResource;
    }

    class AssignmentUnitDate {
        static final boolean START = true;
        static final boolean END = false;
        AssignmentUnit assignmentUnit;
        boolean dateType;

        public AssignmentUnitDate(AssignmentUnit assignmentUnit, boolean bl) {
            this.assignmentUnit = assignmentUnit;
            this.dateType = bl;
        }

        public long getDate() {
            return this.dateType ? this.assignmentUnit.startDate : this.assignmentUnit.endDate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssignmentUnitDateComparator
    implements Comparator<AssignmentUnitDate> {
        AssignmentUnitDateComparator() {
        }

        @Override
        public int compare(AssignmentUnitDate assignmentUnitDate, AssignmentUnitDate assignmentUnitDate2) {
            long l;
            long l2 = assignmentUnitDate.dateType ? assignmentUnitDate.assignmentUnit.startDate : assignmentUnitDate.assignmentUnit.endDate;
            long l3 = l = assignmentUnitDate2.dateType ? assignmentUnitDate2.assignmentUnit.startDate : assignmentUnitDate2.assignmentUnit.endDate;
            if (l2 < l) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            if (assignmentUnitDate.assignmentUnit.assignment.assignmentUnitID < assignmentUnitDate2.assignmentUnit.assignment.assignmentUnitID) {
                return -1;
            }
            if (assignmentUnitDate.assignmentUnit.assignment.assignmentUnitID > assignmentUnitDate2.assignmentUnit.assignment.assignmentUnitID) {
                return 1;
            }
            if (assignmentUnitDate.dateType == assignmentUnitDate2.dateType) {
                throw new RuntimeException("Internal error: adding the same AssignmentUnit twice ");
            }
            if (assignmentUnitDate.dateType) {
                return 1;
            }
            return -1;
        }
    }

    private class CalendarHandler
    implements CalendarManagerListener,
    Serializable {
        private CalendarHandler() {
        }

        public void dayWorkingPatternChanged(CalendarManagerEvent calendarManagerEvent) {
        }

        public void calendarChanged(CalendarManagerEvent calendarManagerEvent) {
            for (Assignment assignment : HumanResource.this.getAssignments()) {
                Task task = assignment.getTask();
                task.setDirty(true, false);
                if (!task.isProject()) continue;
                task.setProjectDirty();
            }
        }

        public void nameChanged(CalendarManagerEvent calendarManagerEvent) {
        }
    }

    class AssignmentUnitsList {
        public List<AssignmentUnit> aList;
        int aListIndex = 0;
        long crtTimePoint;
        Assignment assignment;
        boolean working = false;

        public AssignmentUnitsList(Assignment assignment) {
            this.assignment = assignment;
            this.aList = assignment.getAllocationUnits();
            while (true) {
                if (this.aListIndex >= this.aList.size()) {
                    this.crtTimePoint = Long.MAX_VALUE;
                    return;
                }
                if (this.aList.get(this.aListIndex).getType() != 1 || assignment.getTask().isForcedWorking()) break;
                ++this.aListIndex;
            }
            this.crtTimePoint = this.aList.get((int)this.aListIndex).startDate;
        }

        public void moveToNextCrtPoint() {
            block5: {
                while (true) {
                    if (this.aListIndex >= this.aList.size()) {
                        this.crtTimePoint = Long.MAX_VALUE;
                        this.working = false;
                        break block5;
                    }
                    if (this.aList.get(this.aListIndex).getType() == 1 && !this.assignment.getTask().isForcedWorking()) {
                        ++this.aListIndex;
                        continue;
                    }
                    if (this.crtTimePoint == this.aList.get((int)this.aListIndex).startDate) {
                        this.crtTimePoint = this.aList.get((int)this.aListIndex).endDate;
                        this.working = true;
                        break block5;
                    }
                    if (this.crtTimePoint == this.aList.get((int)this.aListIndex).endDate) {
                        ++this.aListIndex;
                        this.crtTimePoint = 0L;
                        continue;
                    }
                    this.crtTimePoint = this.aList.get((int)this.aListIndex).startDate;
                    if (this.aList.get(this.aListIndex).getType() != 1 || this.assignment.getTask().isForcedWorking()) break;
                }
                this.working = false;
            }
        }

        public double getCrtUnits() {
            if (this.aListIndex >= this.aList.size() || !this.working) {
                return 0.0;
            }
            return this.assignment.getUnits();
        }
    }
}

