/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.core;

import com.sbs.jpm.Common;
import com.sbs.jpm.common.IDsGenerator.IDGenerator;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.MouseHoover;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.event.DependencyEvent;
import com.sbs.jpm.core.event.DependencyListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class Dependency
extends MouseHoover
implements Cloneable,
Serializable,
UniqueId {
    private long uniqueId;
    public static final int DEPENDENCY_FINISH_TO_START = 0;
    public static final int DEPENDENCY_START_TO_START = 1;
    public static final int DEPENDENCY_START_TO_FINISH = 2;
    public static final int DEPENDENCY_FINISH_TO_FINISH = 3;
    private Task successor;
    private Task predecessor;
    int type;
    long taskDelay;
    private EventListenerList listeners;
    private String unit;

    public Dependency(long l) {
        this(l, 0);
    }

    public Dependency(long l, Integer n) {
        this.setUniqueId(l);
        this.unit = DurationManager.DAY;
        this.type = n;
        this.listeners = new EventListenerList();
    }

    public int getType() {
        return this.type;
    }

    public void adjustDependencyForSplit() {
        if (this.getSuccessor().isParentSplitted()) {
            this.setSuccessor(this.getSuccessor().getParent());
        }
        if (this.getPredecessor().isParentSplitted()) {
            this.setPredecessor(this.getPredecessor().getParent());
        }
    }

    public void setType(int n) {
        if (n != 2 && n != 1 && n != 0 && n != 3) {
            throw new RuntimeException("Invalid dependency type: " + n);
        }
        if (this.successor != null) {
            TaskPlanner.setDependencyType(this, n);
        }
        this.fireTypeChanged();
    }

    public long getTaskDelay() {
        return this.taskDelay;
    }

    public void setTaskDelay(long l) {
        if (this.successor != null) {
            TaskPlanner.setDependencyTaskDelay(this, l);
            this.fireTaskDelayChanged();
        }
    }

    public Task getSuccessor() {
        return this.successor;
    }

    public void setSuccessor(Task task) {
        this.successor = task;
    }

    public Task getPredecessor() {
        return this.predecessor;
    }

    public void setPredecessor(Task task) {
        this.predecessor = task;
    }

    public void fireTypeChanged() {
        DependencyEvent dependencyEvent = new DependencyEvent((Object)this, this.type);
        EventListener[] eventListenerArray = this.listeners.getListeners(DependencyListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((DependencyListener)eventListenerArray[i]).typeChanged(dependencyEvent);
        }
    }

    public void fireTaskDelayChanged() {
        DependencyEvent dependencyEvent = new DependencyEvent((Object)this, this.taskDelay);
        EventListener[] eventListenerArray = this.listeners.getListeners(DependencyListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((DependencyListener)eventListenerArray[i]).taskDelayChanged(dependencyEvent);
        }
    }

    public void addDependencyListener(DependencyListener dependencyListener) {
        this.listeners.add(DependencyListener.class, dependencyListener);
    }

    public void removeDependencyListener(DependencyListener dependencyListener) {
        this.listeners.remove(DependencyListener.class, dependencyListener);
    }

    public Object clone(IDGenerator iDGenerator, boolean bl) {
        try {
            Dependency dependency = (Dependency)super.clone();
            dependency.listeners = new EventListenerList();
            long l = bl ? iDGenerator.getNewId() : this.uniqueId;
            dependency.setUniqueId(l);
            return dependency;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Common.logException("Error cloning dependency:", cloneNotSupportedException);
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }
}

