/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.configuration;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.ConfigurationIO;
import com.sbs.jpm.configuration.ConfigurationIOProperties;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.io.FileType;
import com.sbs.jpm.core.io.ProjectIOManager;
import com.sbs.jpm.core.io.ProjectIOSettings;
import com.sbs.jpm.ui.JApplication;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Configuration {
    private static final String SETTINGS_DIRECTORY = System.getProperty("user.home") + "/." + JApplication.getApplicationShortName() + "/";
    private static final String SETTINGS_FILE = "single.properties";
    private static final String UI_SETTINGS_FILE = "single.settings";
    private static final String EMAIL_SETTINGS_FILE = "email.properties";
    private static Configuration INSTANCE;
    private ConfigurationIO ioHandler = new ConfigurationIOProperties();
    private Map settings = new HashMap();

    private Configuration() {
        for (int i = ConfigurationSetting.SETTINGS.length - 1; i >= 0; --i) {
            ConfigurationSetting configurationSetting = ConfigurationSetting.SETTINGS[i];
            this.settings.put(configurationSetting.getName(), configurationSetting.getValue());
        }
    }

    public static Configuration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Configuration();
        }
        return INSTANCE;
    }

    public void setValue(ConfigurationSetting configurationSetting, Object object) {
        this.settings.put(configurationSetting.getName(), object);
    }

    public Object getValue(ConfigurationSetting configurationSetting) {
        return this.settings.get(configurationSetting.getName());
    }

    public static String getSettingsDirectory() {
        return SETTINGS_DIRECTORY;
    }

    public void store() {
        try {
            File file = new File(SETTINGS_DIRECTORY);
            if (!file.exists()) {
                file.mkdir();
            }
            File file2 = new File(file, SETTINGS_FILE);
            File file3 = new File(file, UI_SETTINGS_FILE);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            if (!file3.exists()) {
                file3.createNewFile();
            }
            this.ioHandler.store(this, new FileOutputStream(file2));
            ProjectIOManager.getProjectIOManager().getProjectIO(FileType.SETTINGS).save(new Company(), (OutputStream)new FileOutputStream(file3), false);
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
    }

    public void load() {
        try {
            File file;
            File file2 = new File(SETTINGS_DIRECTORY);
            if (!file2.exists()) {
                file2.mkdir();
            }
            if (!(file = new File(file2, SETTINGS_FILE)).exists()) {
                file.createNewFile();
            }
            this.ioHandler.load(this, new FileInputStream(file));
            File file3 = new File(file2, "RationalPlanServerConfig.xml");
            if (!file3.exists()) {
                this.createServerConfigurationFile();
            }
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createServerConfigurationFile() {
        try {
            File file = new File(SETTINGS_DIRECTORY);
            File file2 = new File(file, "RationalPlanServerConfig.xml");
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file2));
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                stringBuffer.append('\n');
                stringBuffer.append("<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\">");
                stringBuffer.append('\n');
                stringBuffer.append("<bean id=\"RationalPlanClient-MainBean\" class=\"org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean\">");
                stringBuffer.append('\n');
                stringBuffer.append("<property name=\"serviceUrl\">");
                stringBuffer.append('\n');
                stringBuffer.append("<value>" + this.getValue(ConfigurationSetting.SERVER_URL) + "</value>");
                stringBuffer.append('\n');
                stringBuffer.append("</property>");
                stringBuffer.append('\n');
                stringBuffer.append("<property name=\"serviceInterface\">");
                stringBuffer.append('\n');
                stringBuffer.append("<value>com.sbs.jpm.common.JpmServer</value>");
                stringBuffer.append('\n');
                stringBuffer.append("</property>");
                stringBuffer.append('\n');
                stringBuffer.append("</bean>");
                stringBuffer.append('\n');
                stringBuffer.append("</beans>");
                bufferedWriter.append(stringBuffer.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
    }

    public File getEmailPropertiesFile() {
        File file = new File(SETTINGS_DIRECTORY);
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file, EMAIL_SETTINGS_FILE);
        try {
            if (!file2.exists()) {
                file2.createNewFile();
            }
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
        return file2;
    }

    public void storeEmailProperties(Properties properties) {
        try {
            File file;
            File file2 = new File(SETTINGS_DIRECTORY);
            if (!file2.exists()) {
                file2.mkdir();
            }
            if (!(file = new File(file2, EMAIL_SETTINGS_FILE)).exists()) {
                file.createNewFile();
            }
            try {
                properties.store(new FileOutputStream(file), null);
            }
            catch (IOException iOException) {
                Common.logException("Error:", iOException);
            }
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
    }

    public void loadUISettings() {
        try {
            File file;
            File file2 = new File(SETTINGS_DIRECTORY);
            if (!file2.exists()) {
                file2.mkdir();
            }
            if (!(file = new File(file2, UI_SETTINGS_FILE)).exists()) {
                file.createNewFile();
            }
            ProjectIOManager.getProjectIOManager().getProjectIO(FileType.SETTINGS).load(new FileInputStream(file));
        }
        catch (Throwable throwable) {
            Common.LOGGER.warning("Error loading settings (9/10/2009 1:13:00): " + throwable.getLocalizedMessage());
        }
    }

    public void loadColumnsSettings() {
        try {
            File file;
            File file2 = new File(SETTINGS_DIRECTORY);
            if (!file2.exists()) {
                file2.mkdir();
            }
            if (!(file = new File(file2, UI_SETTINGS_FILE)).exists()) {
                file.createNewFile();
            }
            ((ProjectIOSettings)ProjectIOManager.getProjectIOManager().getProjectIO(FileType.SETTINGS)).loadColumnsSettings(new FileInputStream(file));
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
    }
}

