/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.common;

import com.sbs.jpm.Common;
import com.sbs.jpm.common.User;
import com.sbs.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager {
    private final Object userManagerlock = new Object();
    private static final String USERS = "users";
    private static final String USER = "user";
    private static final String UNIQUEID = "uniqueid";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String FIRST_NAME = "first-name";
    private static final String LAST_NAME = "last-name";
    private static final String EMAIL = "email";
    private static final String RIGHT_ADMIN = "right-admin";
    private static final String RIGHT_VIEW = "right-view";
    private static final String RIGHT_WRITE = "right-write";
    private static final User ADMIN = new User();
    private List<User> users;
    private String userFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers() {
        Object object = this.userManagerlock;
        synchronized (object) {
            return this.users;
        }
    }

    public UserManager(String string) {
        this.userFilePath = string;
        this.users = new LinkedList<User>();
        this.loadUsers();
        if (this.users.size() == 0) {
            this.users.add(ADMIN);
            this.saveUsers();
        }
    }

    public User getUser(long l) {
        for (User user : this.users) {
            if (user.getUniqueId() != l) continue;
            return user;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUser(User user) {
        Object object = this.userManagerlock;
        synchronized (object) {
            for (User user2 : this.users) {
                if (!user2.getUsername().equals(user.getUsername())) continue;
                return false;
            }
            long l = System.currentTimeMillis();
            boolean bl = true;
            block4: while (bl) {
                bl = false;
                for (User user3 : this.users) {
                    if (user3.getUniqueId() != user.getUniqueId()) continue;
                    bl = true;
                    ++l;
                    continue block4;
                }
            }
            user.setUniqueId(l);
            this.users.add(user);
            this.saveUsers();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUser(User user) {
        Object object = this.userManagerlock;
        synchronized (object) {
            for (User user2 : this.users) {
                if (user2.getUniqueId() != user.getUniqueId()) continue;
                user2.setPassword(user.getPassword());
                user2.setFirstName(user.getFirstName());
                user2.setLastName(user.getLastName());
                user2.setEmail(user.getEmail());
                this.saveUsers();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(long l) {
        Object object = this.userManagerlock;
        synchronized (object) {
            if (l == ADMIN.getUniqueId()) {
                return false;
            }
            User user = null;
            for (User user2 : this.users) {
                if (user2.getUniqueId() != l) continue;
                user = user2;
                break;
            }
            if (user != null) {
                this.users.remove(user);
                this.saveUsers();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User authenticateUser(String string, String string2) {
        Object object = this.userManagerlock;
        synchronized (object) {
            for (User user : this.users) {
                if (!user.getUsername().equals(string) || !user.getPassword().equals(string2)) continue;
                return user;
            }
        }
        return null;
    }

    public void loadUsers() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            File file = new File(this.userFilePath);
            if (!file.exists()) {
                file.createNewFile();
            } else {
                Document document = documentBuilder.parse(new FileInputStream(file));
                Node node = document.getChildNodes().item(0);
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeType() != 1 || node2.getNodeName().compareTo(USER) != 0) continue;
                    this.users.add(this.loadUser(node2));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.logException("Error loading users:", throwable);
        }
    }

    private User loadUser(Node node) {
        User user = new User();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().compareTo(UNIQUEID) == 0) {
                user.setUniqueId(Long.parseLong(XmlUtil.getTextFromNode(node2)));
                continue;
            }
            if (node2.getNodeName().compareTo(USERNAME) == 0) {
                user.setUsername(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(PASSWORD) == 0) {
                user.setPassword(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(FIRST_NAME) == 0) {
                user.setFirstName(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(LAST_NAME) == 0) {
                user.setLastName(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(EMAIL) == 0) {
                user.setEmail(XmlUtil.getTextFromNode(node2));
                continue;
            }
            if (node2.getNodeName().compareTo(RIGHT_ADMIN) == 0) {
                user.setAdmin(Boolean.parseBoolean(XmlUtil.getTextFromNode(node2)));
                continue;
            }
            if (node2.getNodeName().compareTo(RIGHT_VIEW) == 0) {
                user.setView(Boolean.parseBoolean(XmlUtil.getTextFromNode(node2)));
                continue;
            }
            if (node2.getNodeName().compareTo(RIGHT_WRITE) != 0) continue;
            user.setWrite(Boolean.parseBoolean(XmlUtil.getTextFromNode(node2)));
        }
        return user;
    }

    public void saveUsers() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.userFilePath));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, USERS, null);
            for (User object2 : this.users) {
                this.saveUser(document, object2);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.transform(dOMSource, streamResult);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Common.LOGGER.severe("Unable to save users: " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
        }
    }

    private void saveUser(Document document, User user) {
        Node node = document.getFirstChild();
        Element element = document.createElement(USER);
        node.appendChild(element);
        Element element2 = XmlUtil.createTextElement(document, UNIQUEID, user.getUniqueId() + "");
        Element element3 = XmlUtil.createTextElement(document, USERNAME, user.getUsername());
        Element element4 = XmlUtil.createTextElement(document, PASSWORD, user.getPassword());
        Element element5 = XmlUtil.createTextElement(document, FIRST_NAME, user.getFirstName());
        Element element6 = XmlUtil.createTextElement(document, LAST_NAME, user.getLastName());
        Element element7 = XmlUtil.createTextElement(document, EMAIL, user.getEmail());
        Element element8 = XmlUtil.createTextElement(document, RIGHT_ADMIN, user.isAdmin() + "");
        Element element9 = XmlUtil.createTextElement(document, RIGHT_VIEW, user.isView() + "");
        Element element10 = XmlUtil.createTextElement(document, RIGHT_WRITE, user.isWrite() + "");
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        element.appendChild(element6);
        element.appendChild(element7);
        element.appendChild(element8);
        element.appendChild(element9);
        element.appendChild(element10);
    }

    static {
        ADMIN.setUniqueId(0L);
        ADMIN.setUsername("admin");
        ADMIN.setPassword("admin");
        ADMIN.setAdmin(true);
        ADMIN.setView(true);
        ADMIN.setWrite(true);
    }
}

