/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.calendar;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.core.InvalidOperationException;

public class StandardCalendarManager
extends CalendarManager {
    private static final DayWorkingPattern workingPattern = StandardCalendarManager.createWorkingPattern();
    private static final DayWorkingPattern nonWorkingPattern = StandardCalendarManager.createNonWorkingPattern();

    public StandardCalendarManager(long l) {
        super(l);
    }

    private static final DayWorkingPattern createWorkingPattern() {
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        try {
            PeriodInDay periodInDay = new PeriodInDay(true, 28800000L, 43200000L);
            PeriodInDay periodInDay2 = new PeriodInDay(true, 46800000L, 61200000L);
            dayWorkingPattern.addAlternance(periodInDay);
            dayWorkingPattern.addAlternance(periodInDay2);
            dayWorkingPattern.fillWithNonWorking();
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
        }
        return dayWorkingPattern;
    }

    private static final DayWorkingPattern createNonWorkingPattern() {
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        try {
            PeriodInDay periodInDay = new PeriodInDay(false, 0L, 86400000L);
            dayWorkingPattern.addAlternance(periodInDay);
            dayWorkingPattern.fillWithNonWorking();
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
        }
        return dayWorkingPattern;
    }

    public PeriodInDay[] getWorkingPeriods() {
        return workingPattern.getPeriodsInDay();
    }

    public DayWorkingPattern getWorkingPattern() {
        return (DayWorkingPattern)workingPattern.clone();
    }

    public DayWorkingPattern getNonWorkingPattern() {
        return (DayWorkingPattern)nonWorkingPattern.clone();
    }
}

