/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.calendar;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.FullTimeCalendarManager;
import com.sbs.jpm.calendar.Period;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.RemainingDuration;
import com.sbs.jpm.calendar.StandardCalendarManager;
import com.sbs.jpm.calendar.event.CalendarManagerEvent;
import com.sbs.jpm.calendar.event.CalendarManagerListener;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.InvalidOperationException;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarManager
implements Cloneable,
Serializable,
UniqueId {
    private static final Calendar C = Calendar.getInstance();
    public static final CalendarManager STANDARD_CALENDAR = CalendarManager.createStandardCalendarInstance();
    public static final CalendarManager FULLTIME_CALENDAR = CalendarManager.createFullTimeCalendarInstance();
    public static final boolean WORKING_TIME = true;
    public static final boolean NON_WORKING_TIME = false;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    protected DayWorkingPattern[] weekPatternList;
    protected List<SpecialDay> specialPatternList;
    protected Long id;
    private long uniqueId;
    protected String name;
    protected Company owner;
    private boolean transaction;
    protected EventListenerList listeners;

    public Company getOwner() {
        return this.owner;
    }

    protected CalendarManager(long l) {
        this.setUniqueId(l);
        this.weekPatternList = new DayWorkingPattern[7];
        this.specialPatternList = new LinkedList<SpecialDay>();
        this.listeners = new EventListenerList();
    }

    public void beginTransaction() {
        this.transaction = true;
    }

    public void endTransaction() {
        this.transaction = false;
        if (this.owner != null) {
            this.owner.calendarChanged(this);
            this.owner.computeCriticalPath();
            this.owner.setChanged(true);
        }
        this.fireCalendarChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.fireNameChanged();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = new Long(l);
    }

    public List<SpecialDay> getSpecialPatternList() {
        return this.specialPatternList;
    }

    public DayWorkingPattern[] getWeekPatternList() {
        return this.weekPatternList;
    }

    public void setDayPattern(int n, DayWorkingPattern dayWorkingPattern) {
        this.weekPatternList[n - 1] = dayWorkingPattern;
        dayWorkingPattern.setOwner(this);
    }

    public void setDayPattern(Calendar calendar, DayWorkingPattern dayWorkingPattern) {
        for (int i = 0; i < this.specialPatternList.size(); ++i) {
            SpecialDay specialDay = this.specialPatternList.get(i);
            if (specialDay.date.get(1) != calendar.get(1) || specialDay.date.get(6) != calendar.get(6)) continue;
            specialDay.dayPattern = dayWorkingPattern;
            return;
        }
        SpecialDay specialDay = new SpecialDay();
        specialDay.date = (Calendar)calendar.clone();
        specialDay.dayPattern = dayWorkingPattern;
        this.specialPatternList.add(specialDay);
        dayWorkingPattern.setOwner(this);
    }

    public void removeDayPattern(Calendar calendar) {
        SpecialDay[] specialDayArray = this.specialPatternList.toArray(new SpecialDay[0]);
        for (int i = 0; i < specialDayArray.length; ++i) {
            SpecialDay specialDay = specialDayArray[i];
            if (specialDay.date.get(1) != calendar.get(1) || specialDay.date.get(6) != calendar.get(6)) continue;
            this.specialPatternList.remove(specialDay);
        }
    }

    protected DayWorkingPattern getDayPattern(Calendar calendar) {
        for (int i = 0; i < this.specialPatternList.size(); ++i) {
            SpecialDay specialDay = this.specialPatternList.get(i);
            if (specialDay.date.get(1) != calendar.get(1) || specialDay.date.get(6) != calendar.get(6)) continue;
            return specialDay.dayPattern;
        }
        return this.getDayPattern(calendar.get(7));
    }

    public DayWorkingPattern getSpecialDayPattern(Calendar calendar) {
        for (int i = 0; i < this.specialPatternList.size(); ++i) {
            SpecialDay specialDay = this.specialPatternList.get(i);
            if (specialDay.date.get(1) != calendar.get(1) || specialDay.date.get(6) != calendar.get(6)) continue;
            return specialDay.dayPattern;
        }
        return null;
    }

    public DayWorkingPattern getDayPattern(int n) {
        return this.weekPatternList[n - 1];
    }

    public abstract PeriodInDay[] getWorkingPeriods();

    public abstract DayWorkingPattern getWorkingPattern();

    public abstract DayWorkingPattern getNonWorkingPattern();

    public static CalendarManager createStandardCalendarInstance() {
        StandardCalendarManager standardCalendarManager = new StandardCalendarManager(Long.MIN_VALUE);
        standardCalendarManager.setName(Common.I18N_RP.getString("calendar.standard"));
        standardCalendarManager.setDayPattern(2, standardCalendarManager.getWorkingPattern());
        standardCalendarManager.setDayPattern(3, standardCalendarManager.getWorkingPattern());
        standardCalendarManager.setDayPattern(4, standardCalendarManager.getWorkingPattern());
        standardCalendarManager.setDayPattern(5, standardCalendarManager.getWorkingPattern());
        standardCalendarManager.setDayPattern(6, standardCalendarManager.getWorkingPattern());
        standardCalendarManager.setDayPattern(1, standardCalendarManager.getNonWorkingPattern());
        standardCalendarManager.setDayPattern(7, standardCalendarManager.getNonWorkingPattern());
        return standardCalendarManager;
    }

    public static CalendarManager createFullTimeCalendarInstance() {
        FullTimeCalendarManager fullTimeCalendarManager = new FullTimeCalendarManager(Long.MIN_VALUE);
        fullTimeCalendarManager.setName(Common.I18N_RP.getString("calendar.24hours"));
        fullTimeCalendarManager.setDayPattern(2, fullTimeCalendarManager.getWorkingPattern());
        fullTimeCalendarManager.setDayPattern(3, fullTimeCalendarManager.getWorkingPattern());
        fullTimeCalendarManager.setDayPattern(4, fullTimeCalendarManager.getWorkingPattern());
        fullTimeCalendarManager.setDayPattern(5, fullTimeCalendarManager.getWorkingPattern());
        fullTimeCalendarManager.setDayPattern(6, fullTimeCalendarManager.getWorkingPattern());
        fullTimeCalendarManager.setDayPattern(1, fullTimeCalendarManager.getWorkingPattern());
        fullTimeCalendarManager.setDayPattern(7, fullTimeCalendarManager.getWorkingPattern());
        return fullTimeCalendarManager;
    }

    public static DayWorkingPattern createCustomDayWorkingPattern() {
        DayWorkingPattern dayWorkingPattern = new DayWorkingPattern();
        try {
            dayWorkingPattern.addAlternance(new PeriodInDay(true, 28800000L, 43200000L));
            dayWorkingPattern.fillWithNonWorking();
        }
        catch (InvalidOperationException invalidOperationException) {
            Common.logException("Error:", invalidOperationException);
        }
        return dayWorkingPattern;
    }

    public static final long getDayStartTime(Calendar calendar) {
        C.setTimeInMillis(calendar.getTimeInMillis());
        C.set(11, 0);
        C.set(12, 0);
        C.set(13, 0);
        C.set(14, 0);
        return C.getTimeInMillis();
    }

    public static final long getDayEndTime(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, 1);
        long l = CalendarManager.getDayStartTime(calendar2);
        return l;
    }

    public void getFirstTime(Calendar calendar, boolean bl, long l) {
        this.getFirstTime(calendar, bl, true, l);
    }

    public void getFirstTime(Calendar calendar, boolean bl, boolean bl2, Long l) {
        DayWorkingPattern dayWorkingPattern = this.getDayPattern(calendar);
        long l2 = CalendarManager.getDayStartTime(calendar);
        long l3 = calendar.getTimeInMillis() - l2;
        long l4 = dayWorkingPattern.getFirstDayTime(l3, bl, bl2);
        if (l4 == -1L) {
            calendar.setTimeInMillis(l2);
            do {
                calendar.add(5, bl2 ? 1 : -1);
            } while ((l4 = (dayWorkingPattern = this.getDayPattern(calendar)).getFirstDayTime(bl2 ? 0L : 86400000L, bl, bl2)) == -1L && (!bl2 ? calendar.getTimeInMillis() > l : calendar.getTimeInMillis() < l));
            l2 = CalendarManager.getDayStartTime(calendar);
        }
        calendar.setTimeInMillis(l2 + (l4 == -1L ? 0L : l4));
    }

    private void advanceWorking(Calendar calendar, RemainingDuration remainingDuration, long l) {
        boolean bl = remainingDuration.getRemainingDuration() >= 0L;
        DayWorkingPattern dayWorkingPattern = this.getDayPattern(calendar);
        long l2 = CalendarManager.getDayStartTime(calendar);
        long l3 = calendar.getTimeInMillis() - l2;
        dayWorkingPattern.advanceWorking(l3, remainingDuration, l);
        if (remainingDuration.getRemainingDuration() == 0L) {
            remainingDuration.setEndMilis(remainingDuration.getEndMilis() + l2);
            return;
        }
        calendar.setTimeInMillis(l2);
        while (true) {
            calendar.add(5, bl ? 1 : -1);
            dayWorkingPattern = this.getDayPattern(calendar);
            if (l != 0L && bl && remainingDuration.getRemainingDuration() <= dayWorkingPattern.getTotalWorkingDuration() + l && remainingDuration.getRemainingDuration() > dayWorkingPattern.getTotalWorkingDuration()) {
                remainingDuration.setRemainingDuration(dayWorkingPattern.getTotalWorkingDuration());
            }
            if (Math.abs(remainingDuration.getRemainingDuration()) <= dayWorkingPattern.getTotalWorkingDuration()) {
                dayWorkingPattern.advanceWorking(bl ? 0L : 86400000L, remainingDuration, l);
                l2 = CalendarManager.getDayStartTime(calendar);
                remainingDuration.setEndMilis(remainingDuration.getEndMilis() + l2);
                return;
            }
            if (bl) {
                remainingDuration.setRemainingDuration(remainingDuration.getRemainingDuration() - dayWorkingPattern.getTotalWorkingDuration());
                continue;
            }
            remainingDuration.setRemainingDuration(remainingDuration.getRemainingDuration() + dayWorkingPattern.getTotalWorkingDuration());
        }
    }

    public void convertToWorkingTime(Calendar calendar, RemainingDuration remainingDuration, boolean bl) {
        this.convertToWorkingTime(calendar, remainingDuration, 0L, bl);
    }

    public void convertToWorkingTime(Calendar calendar, RemainingDuration remainingDuration, long l, boolean bl) {
        if (bl || remainingDuration.getRemainingDuration() != 0L) {
            this.getFirstTime(calendar, true, remainingDuration.getRemainingDuration() >= 0L, Long.MAX_VALUE);
            long l2 = calendar.getTimeInMillis();
            this.advanceWorking(calendar, remainingDuration, l);
            calendar.setTimeInMillis(l2);
        } else {
            remainingDuration.setEndMilis(calendar.getTimeInMillis());
        }
    }

    public List getPeriods(Date date, Date date2, long l, boolean bl) {
        Calendar calendar = (Calendar)C.clone();
        calendar.setTime(date);
        Calendar calendar2 = (Calendar)C.clone();
        calendar2.setTime(date);
        Calendar calendar3 = (Calendar)C.clone();
        calendar3.setTime(date2);
        boolean bl2 = !bl;
        LinkedList<Period> linkedList = new LinkedList<Period>();
        while (calendar2.compareTo(calendar3) < 0) {
            this.getFirstTime(calendar2, bl, date2.getTime());
            if (bl == bl2 && calendar2.getTimeInMillis() - calendar.getTimeInMillis() >= l) {
                linkedList.add(new Period(!bl, calendar.getTimeInMillis(), calendar2.getTimeInMillis()));
            }
            bl = !bl;
            calendar.setTime(calendar2.getTime());
        }
        return linkedList;
    }

    public List getPeriods(Date date, Date date2) {
        Calendar calendar = (Calendar)C.clone();
        calendar.setTime(date);
        Calendar calendar2 = (Calendar)C.clone();
        calendar2.setTime(date);
        Calendar calendar3 = (Calendar)C.clone();
        calendar3.setTime(date2);
        boolean bl = false;
        LinkedList<Period> linkedList = new LinkedList<Period>();
        while (calendar2.compareTo(calendar3) < 0) {
            Calendar calendar4;
            this.getFirstTime(calendar2, bl, date2.getTime());
            Calendar calendar5 = calendar4 = calendar2.before(calendar3) ? calendar2 : calendar3;
            if (!calendar.equals(calendar2)) {
                linkedList.add(new Period(!bl, calendar.getTimeInMillis(), calendar4.getTimeInMillis()));
            }
            bl = !bl;
            calendar.setTime(calendar2.getTime());
        }
        return linkedList;
    }

    public List getWorkingPeriods(Date date, Date date2) {
        Calendar calendar = (Calendar)C.clone();
        calendar.setTime(date);
        Calendar calendar2 = (Calendar)C.clone();
        calendar2.setTime(date);
        Calendar calendar3 = (Calendar)C.clone();
        calendar3.setTime(date2);
        boolean bl = false;
        LinkedList<Period> linkedList = new LinkedList<Period>();
        while (calendar2.compareTo(calendar3) < 0) {
            Calendar calendar4;
            this.getFirstTime(calendar2, bl, date2.getTime());
            Calendar calendar5 = calendar4 = calendar2.before(calendar3) ? calendar2 : calendar3;
            if (!calendar.equals(calendar2) && !bl) {
                linkedList.add(new Period(!bl, calendar.getTimeInMillis(), calendar4.getTimeInMillis()));
            }
            bl = !bl;
            calendar.setTime(calendar2.getTime());
        }
        return linkedList;
    }

    public long getDurationForShortPeriod(Date date, Date date2, boolean bl) {
        Calendar calendar = (Calendar)C.clone();
        calendar.setTime(date);
        Calendar calendar2 = (Calendar)C.clone();
        calendar2.setTime(date);
        Calendar calendar3 = (Calendar)C.clone();
        calendar3.setTime(date2);
        boolean bl2 = !bl;
        long l = 0L;
        this.getFirstTime(calendar2, bl, date2.getTime());
        while (calendar2.compareTo(calendar3) < 0) {
            if (bl == bl2) {
                l += calendar2.getTimeInMillis() - calendar.getTimeInMillis();
            }
            bl = !bl;
            calendar.setTime(calendar2.getTime());
            this.getFirstTime(calendar2, bl, date2.getTime());
        }
        if (bl == bl2) {
            l += calendar3.getTimeInMillis() - calendar.getTimeInMillis();
        }
        return l;
    }

    public long getDuration(Date date, Date date2, boolean bl) {
        Calendar calendar = (Calendar)C.clone();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        if (calendar.getTime().after(date2)) {
            return this.getDurationForShortPeriod(date, date2, bl);
        }
        long l = this.getDurationForShortPeriod(date, calendar.getTime(), bl);
        Calendar calendar2 = (Calendar)calendar.clone();
        Calendar calendar3 = (Calendar)calendar.clone();
        calendar3.add(5, 1);
        while (calendar3.getTime().before(date2)) {
            l += this.getDayDuration(calendar2, bl);
            calendar2.add(5, 1);
            calendar3.add(5, 1);
        }
        return l += this.getDurationForShortPeriod(calendar2.getTime(), date2, bl);
    }

    public long getDayDuration(Calendar calendar, boolean bl) {
        DayWorkingPattern dayWorkingPattern = this.getDayPattern(calendar);
        if (bl) {
            return dayWorkingPattern.getTotalWorkingDuration();
        }
        return dayWorkingPattern.getTotalNonWorkingDuration();
    }

    public void setOwner(Company company) {
        this.owner = company;
    }

    public boolean isUsed() {
        if (this.owner.getCalendarManager() == this) {
            return true;
        }
        if (this.isUsed(this.owner.getRootTask())) {
            return true;
        }
        for (HumanResource humanResource : this.owner.getHumanResources()) {
            if (humanResource.getCalendar() != this) continue;
            return true;
        }
        return false;
    }

    public void replace(CalendarManager calendarManager) {
        if (this.owner.getCalendarManager() == this) {
            this.owner.setCalendarManager(calendarManager);
        }
        this.replaceCalendar(this.owner.getRootTask(), calendarManager);
        for (HumanResource humanResource : this.owner.getHumanResources()) {
            if (humanResource.getCalendar() != this) continue;
            humanResource.setCalendar(calendarManager);
        }
    }

    private boolean isUsed(Task task) {
        if (task.getCalendar() == this) {
            return true;
        }
        for (Task task2 : task.getChildList()) {
            if (!this.isUsed(task2)) continue;
            return true;
        }
        return false;
    }

    private void replaceCalendar(Task task, CalendarManager calendarManager) {
        if (task.getCalendar() == this) {
            task.setCalendar(calendarManager);
        }
        for (Task task2 : task.getChildList()) {
            this.replaceCalendar(task2, calendarManager);
        }
    }

    public void fireNameChanged() {
        CalendarManagerEvent calendarManagerEvent = new CalendarManagerEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(CalendarManagerListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((CalendarManagerListener)eventListenerArray[i]).nameChanged(calendarManagerEvent);
        }
        if (!this.transaction && this.owner != null) {
            this.owner.setChanged(true);
        }
    }

    public void fireCalendarChanged() {
        CalendarManagerEvent calendarManagerEvent = new CalendarManagerEvent(this);
        EventListener[] eventListenerArray = this.listeners.getListeners(CalendarManagerListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((CalendarManagerListener)eventListenerArray[i]).calendarChanged(calendarManagerEvent);
        }
        if (!this.transaction && this.owner != null) {
            this.owner.setChanged(true);
        }
    }

    public void addCalendarManagerListener(CalendarManagerListener calendarManagerListener) {
        this.listeners.add(CalendarManagerListener.class, calendarManagerListener);
    }

    public void removeCalendarManagerListener(CalendarManagerListener calendarManagerListener) {
        this.listeners.remove(CalendarManagerListener.class, calendarManagerListener);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CalendarManager)) {
            return false;
        }
        CalendarManager calendarManager = (CalendarManager)object;
        if (!this.name.equals(calendarManager.getName())) {
            return false;
        }
        for (int i = 0; i < this.weekPatternList.length; ++i) {
            if (this.weekPatternList[i].equals(calendarManager.weekPatternList[i])) continue;
            return false;
        }
        return ((Object)this.specialPatternList).equals(calendarManager.specialPatternList);
    }

    public Object clone() {
        CalendarManager calendarManager = CalendarManager.createStandardCalendarInstance();
        calendarManager.listeners = new EventListenerList();
        calendarManager.name = this.name;
        calendarManager.owner = null;
        calendarManager.weekPatternList = new DayWorkingPattern[7];
        for (int i = 0; i < this.weekPatternList.length; ++i) {
            calendarManager.weekPatternList[i] = (DayWorkingPattern)this.weekPatternList[i].clone();
            calendarManager.weekPatternList[i].setOwner(calendarManager);
        }
        calendarManager.specialPatternList = new LinkedList<SpecialDay>();
        for (SpecialDay specialDay : this.specialPatternList) {
            SpecialDay specialDay2 = (SpecialDay)specialDay.clone();
            calendarManager.specialPatternList.add(specialDay2);
            specialDay2.getDayPattern().setOwner(calendarManager);
        }
        calendarManager.setUniqueId(this.owner.getIdGenerator().getNewId());
        return calendarManager;
    }

    @Override
    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    public static class SpecialDay
    implements Cloneable,
    Serializable {
        private Calendar date;
        private DayWorkingPattern dayPattern;

        public Calendar getDate() {
            return this.date;
        }

        public void setDate(Calendar calendar) {
            this.date = calendar;
        }

        public DayWorkingPattern getDayPattern() {
            return this.dayPattern;
        }

        public void setDayPattern(DayWorkingPattern dayWorkingPattern) {
            this.dayPattern = dayWorkingPattern;
        }

        public Object clone() {
            SpecialDay specialDay = new SpecialDay();
            specialDay.date = this.date;
            specialDay.dayPattern = (DayWorkingPattern)this.dayPattern.clone();
            return specialDay;
        }
    }
}

