/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm;

import com.sbs.jpm.Common;
import com.sbs.jpm.MSMPXFileFilter;
import com.sbs.jpm.MSXMLFileFilter;
import com.sbs.jpm.XLSFileFilter;
import com.sbs.jpm.XMLFileFilter;
import com.sbs.jpm.common.JpmServer;
import com.sbs.jpm.common.User;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.SessionManager;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.io.FileType;
import com.sbs.jpm.core.io.ProjectIO;
import com.sbs.jpm.core.io.ProjectIOManager;
import com.sbs.jpm.core.remoteClient.RemoteClientFactory;
import com.sbs.jpm.document.AbstractDocument;
import com.sbs.jpm.document.CustomTypeFile;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.component.JChangesDialog;
import com.sbs.jpm.undo.ExtendedUndoManager;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import com.sbs.util.LockedFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoableEdit;

public class CompanyDocument
extends AbstractDocument {
    public static final int EXPORT = 0;
    public static final int ARCHIVE = 1;
    public static final int PRIVACY = 2;
    private Company data;

    public CompanyDocument() {
        this(new Company());
        this.data.setLoaded(true);
        this.data.computeTasksId();
        this.changed = true;
        this.proprietary = true;
    }

    public CompanyDocument(Company company) {
        this.data = company;
        company.addCompanyListener(new CompanyAdapter(){

            public void companyChanged(CompanyEvent companyEvent) {
                CompanyDocument.this.setChanged(CompanyDocument.this.data.isChanged());
            }
        });
    }

    public CompanyDocument(File file, FileType fileType) throws Exception {
        ProjectIO projectIO = ProjectIOManager.getProjectIOManager().getProjectIO(fileType);
        Company company = file instanceof LockedFile ? projectIO.load(((LockedFile)file).getSeek0InputStream()) : projectIO.load(new FileInputStream(file));
        this.file = file;
        if (fileType == FileType.PROPRIETARY) {
            this.proprietary = true;
            this.changed = false;
        } else {
            this.changed = true;
        }
        this.data = company;
        this.data.addCompanyListener(new CompanyAdapter(){

            public void companyChanged(CompanyEvent companyEvent) {
                Company company = (Company)companyEvent.getSource();
                CompanyDocument.this.setChanged(company.isChanged());
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean save() throws DocumentException {
        try {
            if (!this.isServer()) return super.save();
            RemoteClientFactory remoteClientFactory = (RemoteClientFactory)Class.forName("com.sbs.jpm.remoteClient.spring.http.SpringHttpRemoteServer").newInstance();
            JpmServer jpmServer = remoteClientFactory.createJmpServer();
            SessionManager sessionManager = SessionManager.getInstance();
            try {
                User user = jpmServer.authenticate(sessionManager.getUsername(), new String(sessionManager.getPassword()));
                if (user == null) return true;
                if (user.isWrite()) {
                    LinkedList<UndoableEdit> linkedList = new LinkedList<UndoableEdit>();
                    ExtendedUndoManager extendedUndoManager = (ExtendedUndoManager)this.data.getUndoManager();
                    UndoableEdit undoableEdit = extendedUndoManager.getEditToBeUndone();
                    if (undoableEdit == null) return true;
                    Vector<UndoableEdit> vector = extendedUndoManager.getEdits();
                    for (UndoableEdit undoableEdit2 : vector) {
                        if (undoableEdit2 instanceof SerializableEdit) {
                            ((SerializableEdit)((Object)undoableEdit2)).serialize();
                            linkedList.add(undoableEdit2);
                        }
                        if (!undoableEdit2.equals(undoableEdit)) continue;
                        break;
                    }
                    JChangesDialog jChangesDialog = new JChangesDialog();
                    jChangesDialog.pack();
                    jChangesDialog.setLocationRelativeTo(Common.getApplication());
                    jChangesDialog.setVisible(true);
                    if (jChangesDialog.getStatus() != 0) return false;
                    Vector<FailedSerializableEdit> vector2 = jpmServer.setChanges(linkedList, jChangesDialog.getMessage(), sessionManager.getUsername(), sessionManager.getPassword());
                    this.setChanged(false);
                    return true;
                }
                JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("server.noWriteAccess"), Common.I18N_MESSAGES.getString("server.noWriteAccess"), 0);
                return false;
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
                Object[] objectArray = new Object[]{Configuration.getInstance().getValue(ConfigurationSetting.SERVER_URL)};
                JOptionPane.showMessageDialog(Common.getApplication(), MessageFormat.format(Common.I18N_MESSAGES.getString("server.failedToConnect.message"), objectArray), Common.I18N_MESSAGES.getString("server.failedToConnect"), 0);
                return false;
            }
        }
        catch (Throwable throwable) {
            Common.LOGGER.severe("Unable to Save: " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            if (!(throwable instanceof DocumentException)) return false;
            throw (DocumentException)throwable;
        }
    }

    public Company getData() {
        return this.data;
    }

    public void setChanged(boolean bl) {
        this.newlyCreated = false;
        if (this.changed != bl) {
            this.changed = bl;
            this.fireDocumentChanged();
            this.data.setChanged(bl);
        }
    }

    protected void save(File file, FileType fileType) throws DocumentException {
        OutputStream outputStream;
        try {
            ProjectIO projectIO = ProjectIOManager.getProjectIOManager().getProjectIO(fileType);
            outputStream = null;
            outputStream = file instanceof LockedFile ? ((LockedFile)file).getSeek0OutputStream() : new FileOutputStream(file);
            Common.LOGGER.info("projectIO.save ... ");
            projectIO.save(this.data, outputStream, false);
            Common.LOGGER.info("saved; closing ... ");
            ((FileOutputStream)outputStream).close();
            Common.LOGGER.info("closed.");
        }
        catch (Throwable throwable) {
            Common.LOGGER.severe("Unable to Save(File, FileType): " + throwable.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            Common.LOGGER.severe("Exception: " + byteArrayOutputStream.toString());
            throw new DocumentException(throwable.getLocalizedMessage());
        }
        if (fileType == FileType.PROPRIETARY && file instanceof LockedFile) {
            try {
                Common.getProjectDocumentManager().create(file, FileType.PROPRIETARY);
            }
            catch (Throwable throwable) {
                Common.LOGGER.severe("failed to load in Save(File, FileType): " + throwable.getMessage());
                outputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(outputStream);
                throwable.printStackTrace(printStream);
                printStream.flush();
                Common.LOGGER.severe("Exception: " + ((ByteArrayOutputStream)outputStream).toString());
                return;
            }
            try {
                ((LockedFile)file).backup();
            }
            catch (Throwable throwable) {
                Common.LOGGER.severe("Unable to backup: " + throwable.getMessage());
                outputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(outputStream);
                throwable.printStackTrace(printStream);
                printStream.flush();
                Common.LOGGER.severe("Exception: " + ((ByteArrayOutputStream)outputStream).toString());
                throwable.printStackTrace();
            }
        }
    }

    protected void saveProject(File file, FileType fileType, boolean bl) throws DocumentException {
        try {
            ProjectIO projectIO = ProjectIOManager.getProjectIOManager().getProjectIO(fileType);
            FileOutputStream fileOutputStream = null;
            fileOutputStream = file instanceof LockedFile ? ((LockedFile)file).getSeek0OutputStream() : new FileOutputStream(file);
            projectIO.save(this.data.getCurrentTask(), (OutputStream)fileOutputStream, bl);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Common.logException("Error saving file:", exception);
            throw new DocumentException(exception.getLocalizedMessage());
        }
        if (fileType == FileType.PROPRIETARY && file instanceof LockedFile) {
            try {
                Common.getProjectDocumentManager().create(file, FileType.PROPRIETARY);
            }
            catch (Exception exception) {
                Common.logException("Error saving file:", exception);
                return;
            }
            try {
                ((LockedFile)file).backup();
            }
            catch (IOException iOException) {
                Common.logException("Error saving file:", iOException);
                iOException.printStackTrace();
            }
        }
    }

    protected CustomTypeFile getSelectedFile() {
        Configuration configuration = Configuration.getInstance();
        String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(Common.I18N_RP.getString("saveAs"));
        MSXMLFileFilter mSXMLFileFilter = new MSXMLFileFilter();
        MSMPXFileFilter mSMPXFileFilter = new MSMPXFileFilter();
        XMLFileFilter xMLFileFilter = new XMLFileFilter();
        jFileChooser.addChoosableFileFilter(xMLFileFilter);
        jFileChooser.addChoosableFileFilter(mSXMLFileFilter);
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter(xMLFileFilter);
        JApplication jApplication = Common.getApplication();
        int n = jFileChooser.showSaveDialog(jApplication);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            FileType fileType = null;
            if (fileFilter instanceof XMLFileFilter) {
                fileType = FileType.PROPRIETARY;
                if (!file.getName().toLowerCase().endsWith(".xrp")) {
                    file = new File(file.getAbsolutePath() + ".xrp");
                }
            } else if (fileFilter instanceof MSXMLFileFilter) {
                fileType = FileType.MSPROJECT_XML;
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            } else if (fileFilter instanceof MSMPXFileFilter) {
                fileType = FileType.MSPROJECT_MPX;
                if (!file.getName().toLowerCase().endsWith(".mpx")) {
                    file = new File(file.getAbsolutePath() + ".mpx");
                }
            } else {
                int n2 = file.getName().lastIndexOf(".");
                if (n2 != -1) {
                    String string2 = file.getName().substring(n2).toLowerCase();
                    if (string2.equals(".xrp")) {
                        fileType = FileType.PROPRIETARY;
                    } else if (string2.equals(".xml")) {
                        fileType = FileType.MSPROJECT_XML;
                    }
                }
            }
            CustomTypeFile customTypeFile = new CustomTypeFile(file, fileType);
            configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            return customTypeFile;
        }
        return null;
    }

    public boolean exportProject(int n) throws DocumentException {
        CustomTypeFile customTypeFile = this.getExportedProjectFile(n);
        if (customTypeFile != null && customTypeFile.getFile() != null) {
            this.exportProject(customTypeFile.getFile(), customTypeFile.getFileType(), n == 2);
            return true;
        }
        return false;
    }

    protected void exportProject(File file, FileType fileType, boolean bl) throws DocumentException {
        block5: {
            try {
                if (file instanceof LockedFile) {
                    LockedFile lockedFile = null;
                    try {
                        lockedFile = LockedFile.createOpenedLockedFile(file);
                    }
                    catch (Exception exception) {
                        Common.logException("Error:", exception);
                        JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("document.fileInUseOnExport.message"), Common.I18N_MESSAGES.getString("document.fileInUse.title"), 0);
                        return;
                    }
                    this.saveProject(lockedFile, fileType, bl);
                    lockedFile.unlock();
                    break block5;
                }
                this.saveProject(file, fileType, bl);
            }
            catch (Exception exception) {
                Common.logException("Error exporting file:", exception);
                throw new DocumentException(exception.getLocalizedMessage());
            }
        }
    }

    protected CustomTypeFile getExportedFile() {
        Configuration configuration = Configuration.getInstance();
        String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(Common.I18N_RP.getString("exportAs"));
        MSXMLFileFilter mSXMLFileFilter = new MSXMLFileFilter();
        MSMPXFileFilter mSMPXFileFilter = new MSMPXFileFilter();
        XLSFileFilter xLSFileFilter = new XLSFileFilter();
        jFileChooser.addChoosableFileFilter(xLSFileFilter);
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter(xLSFileFilter);
        JApplication jApplication = Common.getApplication();
        int n = jFileChooser.showDialog(jApplication, Common.I18N_RP.getString("export"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            FileType fileType = null;
            if (fileFilter instanceof MSXMLFileFilter) {
                fileType = FileType.MSPROJECT_XML;
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            } else if (fileFilter instanceof MSMPXFileFilter) {
                fileType = FileType.MSPROJECT_MPX;
                if (!file.getName().toLowerCase().endsWith(".mpx")) {
                    file = new File(file.getAbsolutePath() + ".mpx");
                }
            } else if (fileFilter instanceof XLSFileFilter) {
                fileType = FileType.XLS;
                if (!file.getName().toLowerCase().endsWith(".xls")) {
                    file = new File(file.getAbsolutePath() + ".xls");
                }
            }
            CustomTypeFile customTypeFile = new CustomTypeFile(file, fileType);
            configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            return customTypeFile;
        }
        return null;
    }

    protected CustomTypeFile getExportedProjectFile(int n) {
        Configuration configuration = Configuration.getInstance();
        String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
        JFileChooser jFileChooser = new JFileChooser(string);
        switch (n) {
            case 0: {
                jFileChooser.setDialogTitle(Common.I18N_RP.getString("exportCurrentProject"));
                break;
            }
            case 1: {
                jFileChooser.setDialogTitle(Common.I18N_RP.getString("archiveCurrentProject"));
                break;
            }
            case 2: {
                jFileChooser.setDialogTitle(Common.I18N_RP.getString("privacyExport"));
                break;
            }
        }
        XMLFileFilter xMLFileFilter = new XMLFileFilter();
        MSXMLFileFilter mSXMLFileFilter = new MSXMLFileFilter();
        MSMPXFileFilter mSMPXFileFilter = new MSMPXFileFilter();
        jFileChooser.addChoosableFileFilter(xMLFileFilter);
        if (n == 0 || n == 2) {
            jFileChooser.addChoosableFileFilter(mSXMLFileFilter);
        }
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter(xMLFileFilter);
        JApplication jApplication = Common.getApplication();
        int n2 = 1;
        switch (n) {
            case 0: {
                n2 = jFileChooser.showDialog(jApplication, Common.I18N_RP.getString("exportProject"));
                break;
            }
            case 1: {
                n2 = jFileChooser.showDialog(jApplication, Common.I18N_RP.getString("archiveProject"));
                break;
            }
            case 2: {
                n2 = jFileChooser.showDialog(jApplication, Common.I18N_RP.getString("privacyExport"));
                break;
            }
        }
        if (n2 == 0) {
            File file = jFileChooser.getSelectedFile();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            FileType fileType = null;
            if (fileFilter instanceof XMLFileFilter) {
                fileType = FileType.PROPRIETARY;
                if (!file.getName().toLowerCase().endsWith(".xrp")) {
                    file = new File(file.getAbsolutePath() + ".xrp");
                }
            } else if (fileFilter instanceof MSXMLFileFilter) {
                fileType = FileType.MSPROJECT_XML;
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            } else if (fileFilter instanceof MSMPXFileFilter) {
                fileType = FileType.MSPROJECT_MPX;
                if (!file.getName().toLowerCase().endsWith(".mpx")) {
                    file = new File(file.getAbsolutePath() + ".mpx");
                }
            }
            CustomTypeFile customTypeFile = new CustomTypeFile(file, fileType);
            configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            return customTypeFile;
        }
        return null;
    }
}

