/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import net.sf.mpxj.Filter;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.ProjectReaderUtility;

public class MpxjFilter {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MpxFilter <input file name> <filter name>");
            } else {
                MpxjFilter.filter(args[0], args[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void filter(String filename, String filtername) throws Exception {
        ProjectReader reader = ProjectReaderUtility.getProjectReader(filename);
        ProjectFile project = reader.read(filename);
        Filter filter = project.getFilterByName(filtername);
        if (filter == null) {
            MpxjFilter.displayAvailableFilters(project);
        } else {
            System.out.println(filter);
            System.out.println();
            if (filter.isTaskFilter()) {
                MpxjFilter.processTaskFilter(project, filter);
            } else {
                MpxjFilter.processResourceFilter(project, filter);
            }
        }
    }

    private static void displayAvailableFilters(ProjectFile project) {
        System.out.println("Unknown filter name supplied.");
        System.out.println("Available task filters:");
        for (Filter filter : project.getAllTaskFilters()) {
            System.out.println("   " + filter.getName());
        }
        System.out.println("Available resource filters:");
        for (Filter filter : project.getAllResourceFilters()) {
            System.out.println("   " + filter.getName());
        }
    }

    private static void processTaskFilter(ProjectFile project, Filter filter) {
        for (Task task : project.getAllTasks()) {
            if (!filter.evaluate(task)) continue;
            System.out.println(task.getID() + "," + task.getUniqueID() + "," + task.getName());
        }
    }

    private static void processResourceFilter(ProjectFile project, Filter filter) {
        for (Resource resource : project.getAllResources()) {
            if (!filter.evaluate(resource)) continue;
            System.out.println(resource.getID() + "," + resource.getUniqueID() + "," + resource.getName());
        }
    }
}

