/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.reader.ProjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectReaderUtility {
    private static final Map<String, Class<? extends ProjectReader>> READER_MAP = new HashMap<String, Class<? extends ProjectReader>>();

    private ProjectReaderUtility() {
    }

    public static ProjectReader getProjectReader(String name) throws InstantiationException, IllegalAccessException {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Filename has no extension: " + name);
        }
        String extension = name.substring(index + 1).toUpperCase();
        Class<? extends ProjectReader> fileClass = READER_MAP.get(extension);
        if (fileClass == null) {
            throw new IllegalArgumentException("Cannot read files of type: " + name);
        }
        ProjectReader file = fileClass.newInstance();
        return file;
    }

    public static Set<String> getSupportedFileExtensions() {
        return READER_MAP.keySet();
    }

    static {
        READER_MAP.put("MPP", MPPReader.class);
        READER_MAP.put("MPT", MPPReader.class);
        READER_MAP.put("MPX", MPXReader.class);
        READER_MAP.put("XML", MSPDIReader.class);
        READER_MAP.put("MPD", MPDDatabaseReader.class);
        READER_MAP.put("PLANNER", PlannerReader.class);
    }
}

