/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ExtendedAttributeResourceFields;
import net.sf.mpxj.ExtendedAttributeTaskFields;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.schema.ObjectFactory;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.writer.AbstractProjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MSPDIWriter
extends AbstractProjectWriter {
    private ObjectFactory m_factory;
    private ProjectFile m_projectFile;
    private static final BigInteger BIGINTEGER_ZERO = BigInteger.valueOf(0L);
    private static final Integer NULL_RESOURCE_ID = -65535;

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            JAXBContext context = JAXBContext.newInstance((String)"net.sf.mpxj.mspdi.schema");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.m_factory = new ObjectFactory();
            Project project = this.m_factory.createProject();
            this.writeProjectHeader(project);
            this.writeProjectExtendedAttributes(project);
            this.writeCalendars(project);
            this.writeResources(project);
            this.writeTasks(project);
            this.writeAssignments(project);
            DatatypeConverter.setParentFile(this.m_projectFile);
            marshaller.marshal((Object)project, stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
        }
    }

    private void writeProjectHeader(Project project) {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        project.setActualsInSync(header.getActualsInSync());
        project.setAdminProject(header.getAdminProject());
        project.setAuthor(header.getAuthor());
        project.setAutoAddNewResourcesAndTasks(header.getAutoAddNewResourcesAndTasks());
        project.setAutolink(header.getAutolink());
        project.setBaselineForEarnedValue(NumberUtility.getBigInteger(header.getBaselineForEarnedValue()));
        project.setCalendarUID(BigInteger.ONE);
        project.setCategory(header.getCategory());
        project.setCompany(header.getCompany());
        project.setCreationDate(DatatypeConverter.printDate(header.getCreationDate()));
        project.setCriticalSlackLimit(NumberUtility.getBigInteger(header.getCriticalSlackLimit()));
        project.setCurrencyCode(header.getCurrencyCode());
        project.setCurrencyDigits(BigInteger.valueOf(header.getCurrencyDigits().intValue()));
        project.setCurrencySymbol(header.getCurrencySymbol());
        project.setCurrencySymbolPosition(header.getSymbolPosition());
        project.setCurrentDate(DatatypeConverter.printDate(header.getCurrentDate()));
        project.setDaysPerMonth(NumberUtility.getBigInteger(header.getDaysPerMonth()));
        project.setDefaultFinishTime(DatatypeConverter.printTime(header.getDefaultEndTime()));
        project.setDefaultFixedCostAccrual(header.getDefaultFixedCostAccrual());
        project.setDefaultOvertimeRate(DatatypeConverter.printRate(header.getDefaultOvertimeRate()));
        project.setDefaultStandardRate(DatatypeConverter.printRate(header.getDefaultStandardRate()));
        project.setDefaultStartTime(DatatypeConverter.printTime(header.getDefaultStartTime()));
        project.setDefaultTaskEVMethod(DatatypeConverter.printEarnedValueMethod(header.getDefaultTaskEarnedValueMethod()));
        project.setDefaultTaskType(header.getDefaultTaskType());
        project.setDurationFormat(DatatypeConverter.printDurationTimeUnits(header.getDefaultDurationUnits()));
        project.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(header.getEarnedValueMethod()));
        project.setEditableActualCosts(header.getEditableActualCosts());
        project.setExtendedCreationDate(DatatypeConverter.printDate(header.getExtendedCreationDate()));
        project.setFinishDate(DatatypeConverter.printDate(header.getFinishDate()));
        project.setFiscalYearStart(header.getFiscalYearStart());
        project.setFYStartDate(NumberUtility.getBigInteger(header.getFiscalYearStartMonth()));
        project.setHonorConstraints(header.getHonorConstraints());
        project.setInsertedProjectsLikeSummary(header.getInsertedProjectsLikeSummary());
        project.setLastSaved(DatatypeConverter.printDate(header.getLastSaved()));
        project.setManager(header.getManager());
        project.setMicrosoftProjectServerURL(header.getMicrosoftProjectServerURL());
        project.setMinutesPerDay(NumberUtility.getBigInteger(header.getMinutesPerDay()));
        project.setMinutesPerWeek(NumberUtility.getBigInteger(header.getMinutesPerWeek()));
        project.setMoveCompletedEndsBack(header.getMoveCompletedEndsBack());
        project.setMoveCompletedEndsForward(header.getMoveCompletedEndsForward());
        project.setMoveRemainingStartsBack(header.getMoveRemainingStartsBack());
        project.setMoveRemainingStartsForward(header.getMoveRemainingStartsForward());
        project.setMultipleCriticalPaths(header.getMultipleCriticalPaths());
        project.setName(header.getName());
        project.setNewTasksEffortDriven(header.getNewTasksEffortDriven());
        project.setNewTasksEstimated(header.getNewTasksEstimated());
        project.setNewTaskStartDate(header.getNewTaskStartIsProjectStart() ? BigInteger.ZERO : BigInteger.ONE);
        project.setProjectExternallyEdited(header.getProjectExternallyEdited());
        project.setRemoveFileProperties(header.getRemoveFileProperties());
        project.setRevision(NumberUtility.getBigInteger(header.getRevision()));
        project.setScheduleFromStart(header.getScheduleFrom() == ScheduleFrom.START);
        project.setSplitsInProgressTasks(header.getSplitInProgressTasks());
        project.setSpreadActualCost(header.getSpreadActualCost());
        project.setSpreadPercentComplete(header.getSpreadPercentComplete());
        project.setStartDate(DatatypeConverter.printDate(header.getStartDate()));
        project.setStatusDate(DatatypeConverter.printDate(header.getStatusDate()));
        project.setSubject(header.getSubject());
        project.setTaskUpdatesResource(header.getUpdatingTaskStatusUpdatesResourceStatus());
        project.setTitle(header.getProjectTitle());
        project.setUID(header.getUniqueID());
        project.setWeekStartDay(DatatypeConverter.printDay(header.getWeekStartDay()));
        project.setWorkFormat(DatatypeConverter.printWorkUnits(header.getDefaultWorkUnits()));
    }

    private void writeProjectExtendedAttributes(Project project) {
        Project.ExtendedAttributes attributes = this.m_factory.createProjectExtendedAttributes();
        project.setExtendedAttributes(attributes);
        List<Project.ExtendedAttributes.ExtendedAttribute> list = attributes.getExtendedAttribute();
        this.writeTaskFieldAliases(list);
        this.writeResourceFieldAliases(list);
    }

    private void writeTaskFieldAliases(List<Project.ExtendedAttributes.ExtendedAttribute> list) {
        Map<TaskField, String> fieldAliasMap = this.m_projectFile.getTaskFieldAliasMap();
        for (int loop = 0; loop < ExtendedAttributeTaskFields.FIELD_ARRAY.length; ++loop) {
            TaskField key = ExtendedAttributeTaskFields.FIELD_ARRAY[loop];
            Integer fieldID = MPPTaskField.getID(key) | 0xB400000;
            String name = key.getName();
            String alias = fieldAliasMap.get(key);
            Project.ExtendedAttributes.ExtendedAttribute attribute = this.m_factory.createProjectExtendedAttributesExtendedAttribute();
            list.add(attribute);
            attribute.setFieldID(fieldID.toString());
            attribute.setFieldName(name);
            attribute.setAlias(alias);
        }
    }

    private void writeResourceFieldAliases(List<Project.ExtendedAttributes.ExtendedAttribute> list) {
        Map<ResourceField, String> fieldAliasMap = this.m_projectFile.getResourceFieldAliasMap();
        for (int loop = 0; loop < ExtendedAttributeResourceFields.FIELD_ARRAY.length; ++loop) {
            ResourceField key = ExtendedAttributeResourceFields.FIELD_ARRAY[loop];
            Integer fieldID = MPPResourceField.getID(key) | 0xC400000;
            String name = key.getName();
            String alias = fieldAliasMap.get(key);
            Project.ExtendedAttributes.ExtendedAttribute attribute = this.m_factory.createProjectExtendedAttributesExtendedAttribute();
            list.add(attribute);
            attribute.setFieldID(fieldID.toString());
            attribute.setFieldName(name);
            attribute.setAlias(alias);
        }
    }

    private void writeCalendars(Project project) {
        LinkedList<ProjectCalendar> calendarList = new LinkedList<ProjectCalendar>(this.m_projectFile.getBaseCalendars());
        for (Resource resource : this.m_projectFile.getAllResources()) {
            ProjectCalendar cal = resource.getResourceCalendar();
            if (cal == null) continue;
            calendarList.add(cal);
        }
        Project.Calendars calendars = this.m_factory.createProjectCalendars();
        project.setCalendars(calendars);
        List<Project.Calendars.Calendar> calendar = calendars.getCalendar();
        for (ProjectCalendar cal : calendarList) {
            calendar.add(this.writeCalendar(cal));
        }
    }

    private Project.Calendars.Calendar writeCalendar(ProjectCalendar bc) {
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime time;
        ProjectCalendar base;
        Project.Calendars.Calendar calendar = this.m_factory.createProjectCalendarsCalendar();
        calendar.setUID(NumberUtility.getBigInteger(bc.getUniqueID()));
        calendar.setIsBaseCalendar(bc.isBaseCalendar());
        if (!bc.isBaseCalendar() && (base = bc.getBaseCalendar()) != null) {
            calendar.setBaseCalendarUID(NumberUtility.getBigInteger(base.getUniqueID()));
        }
        calendar.setName(bc.getName());
        Project.Calendars.Calendar.WeekDays days = this.m_factory.createProjectCalendarsCalendarWeekDays();
        List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList = days.getWeekDay();
        for (int loop = 1; loop < 8; ++loop) {
            int workingFlag = bc.getWorkingDay(Day.getInstance(loop));
            if (workingFlag == 2) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BigInteger.valueOf(loop));
            day.setDayWorking(workingFlag == 1);
            if (workingFlag != 1) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            day.setWorkingTimes(times);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            ProjectCalendarHours bch = bc.getCalendarHours(Day.getInstance(loop));
            if (bch == null) continue;
            for (DateRange range : bch) {
                if (range == null) continue;
                time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(DatatypeConverter.printTime(range.getStart()));
                time.setToTime(DatatypeConverter.printTime(range.getEnd()));
            }
        }
        ArrayList<ProjectCalendarException> exceptions = new ArrayList<ProjectCalendarException>(bc.getCalendarExceptions());
        Collections.sort(exceptions);
        for (ProjectCalendarException exception : exceptions) {
            boolean working = exception.getWorking();
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BIGINTEGER_ZERO);
            day.setDayWorking(working);
            Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod period = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayTimePeriod();
            day.setTimePeriod(period);
            period.setFromDate(DatatypeConverter.printDate(exception.getFromDate()));
            period.setToDate(DatatypeConverter.printDate(exception.getToDate()));
            if (!working) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            day.setWorkingTimes(times);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            for (DateRange range : exception) {
                time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(DatatypeConverter.printTime(range.getStart()));
                time.setToTime(DatatypeConverter.printTime(range.getEnd()));
            }
        }
        if (!dayList.isEmpty()) {
            calendar.setWeekDays(days);
        }
        return calendar;
    }

    private void writeResources(Project project) {
        Project.Resources resources = this.m_factory.createProjectResources();
        project.setResources(resources);
        List<Project.Resources.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getAllResources()) {
            list.add(this.writeResource(resource));
        }
    }

    private Project.Resources.Resource writeResource(Resource mpx) {
        Project.Resources.Resource xml = this.m_factory.createProjectResourcesResource();
        ProjectCalendar cal = mpx.getResourceCalendar();
        if (cal != null) {
            xml.setCalendarUID(NumberUtility.getBigInteger(cal.getUniqueID()));
        }
        xml.setAccrueAt(mpx.getAccrueAt());
        xml.setActiveDirectoryGUID(mpx.getActiveDirectoryGUID());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setAvailableFrom(DatatypeConverter.printDate(mpx.getAvailableFrom()));
        xml.setAvailableTo(DatatypeConverter.printDate(mpx.getAvailableTo()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBookingType(mpx.getBookingType());
        xml.setIsBudget(mpx.getBudget());
        xml.setCanLevel(mpx.getCanLevel());
        xml.setCode(mpx.getCode());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCostPerUse(DatatypeConverter.printCurrency(mpx.getCostPerUse()));
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setCreationDate(DatatypeConverter.printDate(mpx.getCreationDate()));
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setEmailAddress(mpx.getEmailAddress());
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setGroup(mpx.getGroup());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberUtility.getBigInteger(mpx.getID()));
        xml.setInitials(mpx.getInitials());
        xml.setIsEnterprise(mpx.getEnterprise());
        xml.setIsGeneric(mpx.getGeneric());
        xml.setIsInactive(mpx.getInactive());
        xml.setIsNull(mpx.getNull());
        xml.setMaterialLabel(mpx.getMaterialLabel());
        xml.setMaxUnits(DatatypeConverter.printUnits(mpx.getMaxUnits()));
        xml.setName(mpx.getName());
        xml.setNotes(mpx.getNotes());
        xml.setNTAccount(mpx.getNtAccount());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeRate(DatatypeConverter.printRate(mpx.getOvertimeRate()));
        xml.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(mpx.getOvertimeRateFormat()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPeakUnits(DatatypeConverter.printUnits(mpx.getPeakUnits()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentWorkComplete()));
        xml.setPhonetics(mpx.getPhonetics());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setStandardRate(DatatypeConverter.printRate(mpx.getStandardRate()));
        xml.setStandardRateFormat(DatatypeConverter.printTimeUnit(mpx.getStandardRateFormat()));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setType(mpx.getType());
        xml.setUID(mpx.getUniqueID());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkGroup(mpx.getWorkGroup());
        xml.setWorkVariance(new BigDecimal(DatatypeConverter.printDurationInMinutes(mpx.getWorkVariance()) * 1000.0));
        this.writeResourceExtendedAttributes(xml, mpx);
        this.writeResourceBaselines(xml, mpx);
        return xml;
    }

    private void writeResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        Project.Resources.Resource.Baseline baseline = this.m_factory.createProjectResourcesResourceBaseline();
        xmlResource.getBaseline().add(baseline);
        baseline.setNumber(BigInteger.ZERO);
        baseline.setCost(DatatypeConverter.printCurrency(mpxjResource.getBaselineCost()));
        baseline.setWork(DatatypeConverter.printDuration(this, mpxjResource.getBaselineWork()));
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectResourcesResourceBaseline();
            xmlResource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.valueOf(loop));
            baseline.setCost(DatatypeConverter.printCurrency(mpxjResource.getBaselineCost(loop)));
            baseline.setWork(DatatypeConverter.printDuration(this, mpxjResource.getBaselineWork(loop)));
        }
    }

    private void writeResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < ExtendedAttributeResourceFields.FIELD_ARRAY.length; ++loop) {
            ResourceField mpxFieldID = ExtendedAttributeResourceFields.FIELD_ARRAY[loop];
            Object value = mpx.getCachedValue(mpxFieldID);
            if (value == null) continue;
            Integer xmlFieldID = MPPResourceField.getID(mpxFieldID) | 0xC400000;
            Project.Resources.Resource.ExtendedAttribute attrib = this.m_factory.createProjectResourcesResourceExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private void writeTasks(Project project) {
        Project.Tasks tasks = this.m_factory.createProjectTasks();
        project.setTasks(tasks);
        List<Project.Tasks.Task> list = tasks.getTask();
        for (Task task : this.m_projectFile.getAllTasks()) {
            list.add(this.writeTask(task));
        }
    }

    private Project.Tasks.Task writeTask(Task mpx) {
        Project.Tasks.Task xml = this.m_factory.createProjectTasksTask();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualDuration(DatatypeConverter.printDuration(this, mpx.getActualDuration()));
        xml.setActualFinish(DatatypeConverter.printDate(mpx.getActualFinish()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualStart(DatatypeConverter.printDate(mpx.getActualStart()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setCalendarUID(this.getTaskCalendarID(mpx));
        xml.setConstraintDate(DatatypeConverter.printDate(mpx.getConstraintDate()));
        xml.setConstraintType(DatatypeConverter.printConstraintType(mpx.getConstraintType()));
        xml.setContact(mpx.getContact());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCreateDate(DatatypeConverter.printDate(mpx.getCreateDate()));
        xml.setCritical(mpx.getCritical());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDeadline(DatatypeConverter.printDate(mpx.getDeadline()));
        xml.setDuration(DatatypeConverter.printDuration(this, mpx.getDuration()));
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDurationFormat()));
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDuration()));
        xml.setEarlyFinish(DatatypeConverter.printDate(mpx.getEarlyFinish()));
        xml.setEarlyStart(DatatypeConverter.printDate(mpx.getEarlyStart()));
        xml.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(mpx.getEarnedValueMethod()));
        xml.setEffortDriven(mpx.getEffortDriven());
        xml.setEstimated(mpx.getEstimated());
        xml.setExternalTask(mpx.getExternalTask());
        xml.setExternalTaskProject(mpx.getProject());
        Date finishDate = mpx.getFinish();
        if (finishDate != null) {
            xml.setFinish(DatatypeConverter.printDate(finishDate));
        }
        xml.setFinishVariance(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getFinishVariance()) * 1000L));
        xml.setFixedCost(DatatypeConverter.printCurrency(mpx.getFixedCost()));
        AccrueType fixedCostAccrual = mpx.getFixedCostAccrual();
        if (fixedCostAccrual == null) {
            fixedCostAccrual = AccrueType.PRORATED;
        }
        xml.setFixedCostAccrual(fixedCostAccrual);
        xml.setFreeSlack(BIGINTEGER_ZERO);
        xml.setHideBar(mpx.getHideBar());
        xml.setIsNull(mpx.getNull());
        xml.setIsSubproject(mpx.getSubProject() != null);
        xml.setIsSubprojectReadOnly(mpx.getSubprojectReadOnly());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberUtility.getBigInteger(mpx.getID()));
        xml.setIgnoreResourceCalendar(mpx.getIgnoreResourceCalendar());
        xml.setLateFinish(DatatypeConverter.printDate(mpx.getLateFinish()));
        xml.setLateStart(DatatypeConverter.printDate(mpx.getLateStart()));
        xml.setLevelAssignments(mpx.getLevelAssignments());
        xml.setLevelingCanSplit(mpx.getLevelingCanSplit());
        if (mpx.getLevelingDelay() != null) {
            xml.setLevelingDelay(BigInteger.valueOf((long)mpx.getLevelingDelay().getDuration()));
            xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelayFormat()));
        }
        xml.setMilestone(mpx.getMilestone());
        xml.setName(mpx.getName());
        xml.setNotes(mpx.getNotes());
        xml.setOutlineLevel(NumberUtility.getBigInteger(mpx.getOutlineLevel()));
        xml.setOutlineNumber(mpx.getOutlineNumber());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentComplete(NumberUtility.getBigInteger(mpx.getPercentageComplete()));
        xml.setPercentWorkComplete(NumberUtility.getBigInteger(mpx.getPercentageWorkComplete()));
        xml.setPhysicalPercentComplete(NumberUtility.getBigInteger(mpx.getPhysicalPercentComplete()));
        xml.setPriority(DatatypeConverter.printPriority(mpx.getPriority()));
        xml.setRecurring(mpx.getRecurring());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        if (mpx.getRemainingDuration() == null) {
            Duration duration = mpx.getDuration();
            if (duration != null) {
                double amount = duration.getDuration();
                amount -= amount * NumberUtility.getDouble(mpx.getPercentageComplete()) / 100.0;
                xml.setRemainingDuration(DatatypeConverter.printDuration(this, Duration.getInstance(amount, duration.getUnits())));
            }
        } else {
            xml.setRemainingDuration(DatatypeConverter.printDuration(this, mpx.getRemainingDuration()));
        }
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResume(DatatypeConverter.printDate(mpx.getResume()));
        xml.setResumeValid(mpx.getResumeValid());
        xml.setRollup(mpx.getRollup());
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setStartVariance(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getStartVariance()) * 1000L));
        xml.setStop(DatatypeConverter.printDate(mpx.getStop()));
        xml.setSubprojectName(mpx.getSubprojectName());
        xml.setSummary(mpx.getSummary());
        xml.setTotalSlack(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getTotalSlack()) * 1000L));
        xml.setType(mpx.getType());
        xml.setUID(mpx.getUniqueID());
        xml.setWBS(mpx.getWBS());
        xml.setWBSLevel(mpx.getWBSLevel());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkVariance(new BigDecimal(DatatypeConverter.printDurationInMinutes(mpx.getWorkVariance()) * 1000.0));
        this.writePredecessors(xml, mpx);
        this.writeTaskExtendedAttributes(xml, mpx);
        this.writeTaskBaselines(xml, mpx);
        return xml;
    }

    private void writeTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask) {
        Project.Tasks.Task.Baseline baseline = this.m_factory.createProjectTasksTaskBaseline();
        xmlTask.getBaseline().add(baseline);
        baseline.setNumber(BigInteger.ZERO);
        baseline.setCost(DatatypeConverter.printCurrency(mpxjTask.getBaselineCost()));
        baseline.setDuration(DatatypeConverter.printDuration(this, mpxjTask.getBaselineDuration()));
        baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpxjTask.getBaselineDuration()));
        baseline.setFinish(DatatypeConverter.printDate(mpxjTask.getBaselineFinish()));
        baseline.setStart(DatatypeConverter.printDate(mpxjTask.getBaselineStart()));
        baseline.setWork(DatatypeConverter.printDuration(this, mpxjTask.getBaselineWork()));
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectTasksTaskBaseline();
            xmlTask.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.valueOf(loop));
            baseline.setCost(DatatypeConverter.printCurrency(mpxjTask.getBaselineCost(loop)));
            baseline.setDuration(DatatypeConverter.printDuration(this, mpxjTask.getBaselineDuration(loop)));
            baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpxjTask.getBaselineDuration(loop)));
            baseline.setFinish(DatatypeConverter.printDate(mpxjTask.getBaselineFinish(loop)));
            baseline.setStart(DatatypeConverter.printDate(mpxjTask.getBaselineStart(loop)));
            baseline.setWork(DatatypeConverter.printDuration(this, mpxjTask.getBaselineWork(loop)));
        }
    }

    private void writeTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (int loop = 0; loop < ExtendedAttributeTaskFields.FIELD_ARRAY.length; ++loop) {
            TaskField mpxFieldID = ExtendedAttributeTaskFields.FIELD_ARRAY[loop];
            Object value = mpx.getCachedValue(mpxFieldID);
            if (value == null) continue;
            Integer xmlFieldID = MPPTaskField.getID(mpxFieldID) | 0xB400000;
            Project.Tasks.Task.ExtendedAttribute attrib = this.m_factory.createProjectTasksTaskExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private BigInteger printExtendedAttributeDurationFormat(Object value) {
        BigInteger result = null;
        if (value instanceof Duration) {
            result = DatatypeConverter.printDurationTimeUnits(((Duration)value).getUnits());
        }
        return result;
    }

    private BigInteger getTaskCalendarID(Task mpx) {
        BigInteger result = null;
        ProjectCalendar cal = mpx.getCalendar();
        result = cal != null ? NumberUtility.getBigInteger(cal.getUniqueID()) : BigInteger.valueOf(-1L);
        return result;
    }

    private void writePredecessors(Project.Tasks.Task xml, Task mpx) {
        Integer taskUniqueID;
        TreeSet<Integer> set = new TreeSet<Integer>();
        List<Project.Tasks.Task.PredecessorLink> list = xml.getPredecessorLink();
        List<Relation> predecessors = mpx.getUniqueIDPredecessors();
        if (predecessors != null) {
            for (Relation rel : predecessors) {
                taskUniqueID = rel.getTaskUniqueID();
                set.add(taskUniqueID);
                list.add(this.writePredecessor(taskUniqueID, rel.getType(), rel.getDuration()));
            }
        }
        if ((predecessors = mpx.getPredecessors()) != null) {
            for (Relation rel : predecessors) {
                taskUniqueID = rel.getTaskUniqueID();
                if (set.contains(taskUniqueID)) continue;
                list.add(this.writePredecessor(taskUniqueID, rel.getType(), rel.getDuration()));
            }
        }
    }

    private Project.Tasks.Task.PredecessorLink writePredecessor(Integer taskID, RelationType type, Duration lag) {
        Project.Tasks.Task.PredecessorLink link = this.m_factory.createProjectTasksTaskPredecessorLink();
        link.setPredecessorUID(NumberUtility.getBigInteger(taskID));
        link.setType(BigInteger.valueOf(type.getValue()));
        if (lag != null && lag.getDuration() != 0.0) {
            link.setLinkLag(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(lag) * 10L));
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(lag.getUnits()));
        }
        return link;
    }

    private void writeAssignments(Project project) {
        int uid = 0;
        Project.Assignments assignments = this.m_factory.createProjectAssignments();
        project.setAssignments(assignments);
        List<Project.Assignments.Assignment> list = assignments.getAssignment();
        for (ResourceAssignment assignment : this.m_projectFile.getAllResourceAssignments()) {
            list.add(this.writeAssignment(assignment, uid));
            ++uid;
        }
        for (Task task : this.m_projectFile.getAllTasks()) {
            double percentComplete = NumberUtility.getDouble(task.getPercentageComplete());
            if (percentComplete == 0.0 || !task.getResourceAssignments().isEmpty()) continue;
            ResourceAssignment dummy = this.m_projectFile.newResourceAssignment(task);
            Duration duration = task.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            double durationValue = duration.getDuration();
            TimeUnit durationUnits = duration.getUnits();
            double actualWork = durationValue * percentComplete / 100.0;
            double remainingWork = durationValue - actualWork;
            dummy.setResourceUniqueID(NULL_RESOURCE_ID);
            dummy.setWork(duration);
            dummy.setActualWork(Duration.getInstance(actualWork, durationUnits));
            dummy.setRemainingWork(Duration.getInstance(remainingWork, durationUnits));
            list.add(this.writeAssignment(dummy, uid));
            ++uid;
        }
    }

    private Project.Assignments.Assignment writeAssignment(ResourceAssignment mpx, int uid) {
        Project.Assignments.Assignment xml = this.m_factory.createProjectAssignmentsAssignment();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setDelay(BigInteger.valueOf((long)DatatypeConverter.printDurationInMinutes(mpx.getDelay()) * 1000L));
        xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResourceUID(BigInteger.valueOf(NumberUtility.getInt(mpx.getResourceUniqueID())));
        xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
        xml.setTaskUID(NumberUtility.getBigInteger(mpx.getTask().getUniqueID()));
        xml.setUID(BigInteger.valueOf(uid));
        xml.setUnits(DatatypeConverter.printUnits(mpx.getUnits()));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkContour(mpx.getWorkContour());
        this.writeAssignmentTimephasedData(mpx, xml);
        return xml;
    }

    private void writeAssignmentTimephasedData(ResourceAssignment mpx, Project.Assignments.Assignment xml) {
        if (mpx.getHasTimephasedData()) {
            List<TimephasedDataType> list = xml.getTimephasedData();
            ProjectCalendar calendar = mpx.getCalendar();
            BigInteger assignmentID = xml.getUID();
            List<TimephasedResourceAssignment> complete = mpx.getTimephasedComplete();
            TimephasedResourceAssignment lastComplete = null;
            if (!complete.isEmpty()) {
                lastComplete = complete.get(complete.size() - 1);
            }
            List<TimephasedResourceAssignment> planned = mpx.getTimephasedPlanned();
            TimephasedResourceAssignment firstPlanned = null;
            if (!planned.isEmpty()) {
                firstPlanned = planned.get(0);
            }
            this.writeAssignmentTimephasedData(assignmentID, list, this.splitDays(calendar, mpx.getTimephasedPlanned(), null, lastComplete), 1);
            this.writeAssignmentTimephasedData(assignmentID, list, this.splitDays(calendar, complete, firstPlanned, null), 2);
        }
    }

    private List<TimephasedResourceAssignment> splitDays(ProjectCalendar calendar, List<TimephasedResourceAssignment> list, TimephasedResourceAssignment first, TimephasedResourceAssignment last) {
        LinkedList<TimephasedResourceAssignment> result = new LinkedList<TimephasedResourceAssignment>();
        for (TimephasedResourceAssignment assignment : list) {
            Date startDate = assignment.getStart();
            Date finishDate = assignment.getFinish();
            Date startDay = DateUtility.getDayStartDate(startDate);
            Date finishDay = DateUtility.getDayStartDate(finishDate);
            if (startDay.getTime() == finishDay.getTime()) {
                Date startTime = calendar.getStartTime(startDay);
                Date currentStart = DateUtility.setTime(startDay, startTime);
                if (startDate.getTime() > currentStart.getTime()) {
                    boolean paddingRequired = true;
                    if (last != null) {
                        Date lastFinish = last.getFinish();
                        if (lastFinish.getTime() == startDate.getTime()) {
                            paddingRequired = false;
                        } else {
                            Date lastFinishDay = DateUtility.getDayStartDate(lastFinish);
                            if (startDay.getTime() == lastFinishDay.getTime()) {
                                currentStart = lastFinish;
                            }
                        }
                    }
                    if (paddingRequired) {
                        Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                        TimephasedResourceAssignment padding = new TimephasedResourceAssignment();
                        padding.setStart(currentStart);
                        padding.setFinish(startDate);
                        padding.setTotalWork(zeroHours);
                        padding.setWorkPerDay(zeroHours);
                        result.add(padding);
                    }
                }
                result.add(assignment);
                Date endTime = calendar.getFinishTime(startDay);
                Date currentFinish = DateUtility.setTime(startDay, endTime);
                if (finishDate.getTime() >= currentFinish.getTime()) continue;
                boolean paddingRequired = true;
                if (first != null) {
                    Date firstStart = first.getStart();
                    if (firstStart.getTime() == finishDate.getTime()) {
                        paddingRequired = false;
                    } else {
                        Date firstStartDay = DateUtility.getDayStartDate(firstStart);
                        if (finishDay.getTime() == firstStartDay.getTime()) {
                            currentFinish = firstStart;
                        }
                    }
                }
                if (!paddingRequired) continue;
                Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                TimephasedResourceAssignment padding = new TimephasedResourceAssignment();
                padding.setStart(finishDate);
                padding.setFinish(currentFinish);
                padding.setTotalWork(zeroHours);
                padding.setWorkPerDay(zeroHours);
                result.add(padding);
                continue;
            }
            Date currentStart = startDate;
            Calendar cal = Calendar.getInstance();
            boolean isWorking = calendar.isWorkingDate(currentStart);
            while (currentStart.getTime() < finishDate.getTime()) {
                if (isWorking) {
                    Date endTime = calendar.getFinishTime(currentStart);
                    Date currentFinish = DateUtility.setTime(currentStart, endTime);
                    TimephasedResourceAssignment split = new TimephasedResourceAssignment();
                    split.setStart(currentStart);
                    split.setFinish(currentFinish);
                    split.setTotalWork(assignment.getWorkPerDay());
                    split.setWorkPerDay(assignment.getWorkPerDay());
                    result.add(split);
                }
                cal.setTime(currentStart);
                cal.add(6, 1);
                currentStart = cal.getTime();
                isWorking = calendar.isWorkingDate(currentStart);
                if (!isWorking) continue;
                Date startTime = calendar.getStartTime(currentStart);
                DateUtility.setTime(cal, startTime);
                currentStart = cal.getTime();
            }
        }
        return result;
    }

    private void writeAssignmentTimephasedData(BigInteger assignmentID, List<TimephasedDataType> list, List<TimephasedResourceAssignment> data, int type) {
        for (TimephasedResourceAssignment mpx : data) {
            TimephasedDataType xml = this.m_factory.createTimephasedDataType();
            list.add(xml);
            xml.setStart(DatatypeConverter.printDate(mpx.getStart()));
            xml.setFinish(DatatypeConverter.printDate(mpx.getFinish()));
            xml.setType(BigInteger.valueOf(type));
            xml.setUID(assignmentID);
            xml.setUnit(DatatypeConverter.printDurationTimeUnits(mpx.getTotalWork()));
            xml.setValue(DatatypeConverter.printDuration(this, mpx.getTotalWork()));
        }
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }
}

