/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SplitTaskFactory;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.View;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.mpp.EncryptedDocumentInputStream;
import net.sf.mpxj.mpp.FilterReader9;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader9;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPTimephasedResourceAssignmentNormaliser;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectHeaderReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.PropsBlock;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.TableFactory;
import net.sf.mpxj.mpp.TimephasedResourceAssignmentFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta9;
import net.sf.mpxj.mpp.ViewFactory9;
import net.sf.mpxj.mpp.ViewStateReader9;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MPP9Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private Props9 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private static final int SUBPROJECT_LISTEND = 771;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 49741824;
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 3;
    private static final Integer TASK_ACTUAL_OVERTIME_WORK = 3;
    private static final Integer TASK_REMAINING_OVERTIME_WORK = 4;
    private static final Integer TASK_OVERTIME_COST = 5;
    private static final Integer TASK_ACTUAL_OVERTIME_COST = 6;
    private static final Integer TASK_REMAINING_OVERTIME_COST = 7;
    private static final Integer TASK_SUBPROJECT_TASKS_UNIQUEID_OFFSET = 8;
    private static final Integer TASK_SUBPROJECTUNIQUETASKID = 9;
    private static final Integer TASK_SUBPROJECTTASKID = 79;
    private static final Integer TASK_WBS = 10;
    private static final Integer TASK_NAME = 11;
    private static final Integer TASK_CONTACT = 12;
    private static final Integer TASK_TEXT1 = 14;
    private static final Integer TASK_TEXT2 = 15;
    private static final Integer TASK_TEXT3 = 16;
    private static final Integer TASK_TEXT4 = 17;
    private static final Integer TASK_TEXT5 = 18;
    private static final Integer TASK_TEXT6 = 19;
    private static final Integer TASK_TEXT7 = 20;
    private static final Integer TASK_TEXT8 = 21;
    private static final Integer TASK_TEXT9 = 22;
    private static final Integer TASK_TEXT10 = 23;
    private static final Integer TASK_START1 = 24;
    private static final Integer TASK_FINISH1 = 25;
    private static final Integer TASK_START2 = 26;
    private static final Integer TASK_FINISH2 = 27;
    private static final Integer TASK_START3 = 28;
    private static final Integer TASK_FINISH3 = 29;
    private static final Integer TASK_START4 = 30;
    private static final Integer TASK_FINISH4 = 31;
    private static final Integer TASK_START5 = 32;
    private static final Integer TASK_FINISH5 = 33;
    private static final Integer TASK_START6 = 34;
    private static final Integer TASK_FINISH6 = 35;
    private static final Integer TASK_START7 = 36;
    private static final Integer TASK_FINISH7 = 37;
    private static final Integer TASK_START8 = 38;
    private static final Integer TASK_FINISH8 = 39;
    private static final Integer TASK_START9 = 40;
    private static final Integer TASK_FINISH9 = 41;
    private static final Integer TASK_START10 = 42;
    private static final Integer TASK_FINISH10 = 43;
    private static final Integer TASK_NUMBER1 = 45;
    private static final Integer TASK_NUMBER2 = 46;
    private static final Integer TASK_NUMBER3 = 47;
    private static final Integer TASK_NUMBER4 = 48;
    private static final Integer TASK_NUMBER5 = 49;
    private static final Integer TASK_NUMBER6 = 50;
    private static final Integer TASK_NUMBER7 = 51;
    private static final Integer TASK_NUMBER8 = 52;
    private static final Integer TASK_NUMBER9 = 53;
    private static final Integer TASK_NUMBER10 = 54;
    private static final Integer TASK_DURATION1 = 55;
    private static final Integer TASK_DURATION1_UNITS = 56;
    private static final Integer TASK_DURATION2 = 57;
    private static final Integer TASK_DURATION2_UNITS = 58;
    private static final Integer TASK_DURATION3 = 59;
    private static final Integer TASK_DURATION3_UNITS = 60;
    private static final Integer TASK_DURATION4 = 61;
    private static final Integer TASK_DURATION4_UNITS = 62;
    private static final Integer TASK_DURATION5 = 63;
    private static final Integer TASK_DURATION5_UNITS = 64;
    private static final Integer TASK_DURATION6 = 65;
    private static final Integer TASK_DURATION6_UNITS = 66;
    private static final Integer TASK_DURATION7 = 67;
    private static final Integer TASK_DURATION7_UNITS = 68;
    private static final Integer TASK_DURATION8 = 69;
    private static final Integer TASK_DURATION8_UNITS = 70;
    private static final Integer TASK_DURATION9 = 71;
    private static final Integer TASK_DURATION9_UNITS = 72;
    private static final Integer TASK_DURATION10 = 73;
    private static final Integer TASK_DURATION10_UNITS = 74;
    private static final Integer TASK_RECURRING_DATA = 76;
    private static final Integer TASK_EXTERNAL_TASK_ID = 79;
    private static final Integer TASK_DATE1 = 80;
    private static final Integer TASK_DATE2 = 81;
    private static final Integer TASK_DATE3 = 82;
    private static final Integer TASK_DATE4 = 83;
    private static final Integer TASK_DATE5 = 84;
    private static final Integer TASK_DATE6 = 85;
    private static final Integer TASK_DATE7 = 86;
    private static final Integer TASK_DATE8 = 87;
    private static final Integer TASK_DATE9 = 88;
    private static final Integer TASK_DATE10 = 89;
    private static final Integer TASK_TEXT11 = 90;
    private static final Integer TASK_TEXT12 = 91;
    private static final Integer TASK_TEXT13 = 92;
    private static final Integer TASK_TEXT14 = 93;
    private static final Integer TASK_TEXT15 = 94;
    private static final Integer TASK_TEXT16 = 95;
    private static final Integer TASK_TEXT17 = 96;
    private static final Integer TASK_TEXT18 = 97;
    private static final Integer TASK_TEXT19 = 98;
    private static final Integer TASK_TEXT20 = 99;
    private static final Integer TASK_TEXT21 = 100;
    private static final Integer TASK_TEXT22 = 101;
    private static final Integer TASK_TEXT23 = 102;
    private static final Integer TASK_TEXT24 = 103;
    private static final Integer TASK_TEXT25 = 104;
    private static final Integer TASK_TEXT26 = 105;
    private static final Integer TASK_TEXT27 = 106;
    private static final Integer TASK_TEXT28 = 107;
    private static final Integer TASK_TEXT29 = 108;
    private static final Integer TASK_TEXT30 = 109;
    private static final Integer TASK_NUMBER11 = 110;
    private static final Integer TASK_NUMBER12 = 111;
    private static final Integer TASK_NUMBER13 = 112;
    private static final Integer TASK_NUMBER14 = 113;
    private static final Integer TASK_NUMBER15 = 114;
    private static final Integer TASK_NUMBER16 = 115;
    private static final Integer TASK_NUMBER17 = 116;
    private static final Integer TASK_NUMBER18 = 117;
    private static final Integer TASK_NUMBER19 = 118;
    private static final Integer TASK_NUMBER20 = 119;
    private static final Integer TASK_OUTLINECODE1 = 123;
    private static final Integer TASK_OUTLINECODE2 = 124;
    private static final Integer TASK_OUTLINECODE3 = 125;
    private static final Integer TASK_OUTLINECODE4 = 126;
    private static final Integer TASK_OUTLINECODE5 = 127;
    private static final Integer TASK_OUTLINECODE6 = 128;
    private static final Integer TASK_OUTLINECODE7 = 129;
    private static final Integer TASK_OUTLINECODE8 = 130;
    private static final Integer TASK_OUTLINECODE9 = 131;
    private static final Integer TASK_OUTLINECODE10 = 132;
    private static final Integer TASK_HYPERLINK = 133;
    private static final Integer TASK_COST1 = 134;
    private static final Integer TASK_COST2 = 135;
    private static final Integer TASK_COST3 = 136;
    private static final Integer TASK_COST4 = 137;
    private static final Integer TASK_COST5 = 138;
    private static final Integer TASK_COST6 = 139;
    private static final Integer TASK_COST7 = 140;
    private static final Integer TASK_COST8 = 141;
    private static final Integer TASK_COST9 = 142;
    private static final Integer TASK_COST10 = 143;
    private static final Integer TASK_NOTES = 144;
    private static final Integer TASK_ENTERPRISE_COLUMNS = 163;
    private static final Integer RESOURCE_NAME = 1;
    private static final Integer RESOURCE_INITIALS = 3;
    private static final Integer RESOURCE_GROUP = 4;
    private static final Integer RESOURCE_CODE = 5;
    private static final Integer RESOURCE_EMAIL = 6;
    private static final Integer RESOURCE_MATERIAL_LABEL = 8;
    private static final Integer RESOURCE_NT_ACCOUNT = 9;
    private static final Integer RESOURCE_TEXT1 = 10;
    private static final Integer RESOURCE_TEXT2 = 11;
    private static final Integer RESOURCE_TEXT3 = 12;
    private static final Integer RESOURCE_TEXT4 = 13;
    private static final Integer RESOURCE_TEXT5 = 14;
    private static final Integer RESOURCE_TEXT6 = 15;
    private static final Integer RESOURCE_TEXT7 = 16;
    private static final Integer RESOURCE_TEXT8 = 17;
    private static final Integer RESOURCE_TEXT9 = 18;
    private static final Integer RESOURCE_TEXT10 = 19;
    private static final Integer RESOURCE_TEXT11 = 20;
    private static final Integer RESOURCE_TEXT12 = 21;
    private static final Integer RESOURCE_TEXT13 = 22;
    private static final Integer RESOURCE_TEXT14 = 23;
    private static final Integer RESOURCE_TEXT15 = 24;
    private static final Integer RESOURCE_TEXT16 = 25;
    private static final Integer RESOURCE_TEXT17 = 26;
    private static final Integer RESOURCE_TEXT18 = 27;
    private static final Integer RESOURCE_TEXT19 = 28;
    private static final Integer RESOURCE_TEXT20 = 29;
    private static final Integer RESOURCE_TEXT21 = 30;
    private static final Integer RESOURCE_TEXT22 = 31;
    private static final Integer RESOURCE_TEXT23 = 32;
    private static final Integer RESOURCE_TEXT24 = 33;
    private static final Integer RESOURCE_TEXT25 = 34;
    private static final Integer RESOURCE_TEXT26 = 35;
    private static final Integer RESOURCE_TEXT27 = 36;
    private static final Integer RESOURCE_TEXT28 = 37;
    private static final Integer RESOURCE_TEXT29 = 38;
    private static final Integer RESOURCE_TEXT30 = 39;
    private static final Integer RESOURCE_START1 = 40;
    private static final Integer RESOURCE_START2 = 41;
    private static final Integer RESOURCE_START3 = 42;
    private static final Integer RESOURCE_START4 = 43;
    private static final Integer RESOURCE_START5 = 44;
    private static final Integer RESOURCE_START6 = 45;
    private static final Integer RESOURCE_START7 = 46;
    private static final Integer RESOURCE_START8 = 47;
    private static final Integer RESOURCE_START9 = 48;
    private static final Integer RESOURCE_START10 = 49;
    private static final Integer RESOURCE_FINISH1 = 50;
    private static final Integer RESOURCE_FINISH2 = 51;
    private static final Integer RESOURCE_FINISH3 = 52;
    private static final Integer RESOURCE_FINISH4 = 53;
    private static final Integer RESOURCE_FINISH5 = 54;
    private static final Integer RESOURCE_FINISH6 = 55;
    private static final Integer RESOURCE_FINISH7 = 56;
    private static final Integer RESOURCE_FINISH8 = 57;
    private static final Integer RESOURCE_FINISH9 = 58;
    private static final Integer RESOURCE_FINISH10 = 59;
    private static final Integer RESOURCE_NUMBER1 = 60;
    private static final Integer RESOURCE_NUMBER2 = 61;
    private static final Integer RESOURCE_NUMBER3 = 62;
    private static final Integer RESOURCE_NUMBER4 = 63;
    private static final Integer RESOURCE_NUMBER5 = 64;
    private static final Integer RESOURCE_NUMBER6 = 65;
    private static final Integer RESOURCE_NUMBER7 = 66;
    private static final Integer RESOURCE_NUMBER8 = 67;
    private static final Integer RESOURCE_NUMBER9 = 68;
    private static final Integer RESOURCE_NUMBER10 = 69;
    private static final Integer RESOURCE_NUMBER11 = 70;
    private static final Integer RESOURCE_NUMBER12 = 71;
    private static final Integer RESOURCE_NUMBER13 = 72;
    private static final Integer RESOURCE_NUMBER14 = 73;
    private static final Integer RESOURCE_NUMBER15 = 74;
    private static final Integer RESOURCE_NUMBER16 = 75;
    private static final Integer RESOURCE_NUMBER17 = 76;
    private static final Integer RESOURCE_NUMBER18 = 77;
    private static final Integer RESOURCE_NUMBER19 = 78;
    private static final Integer RESOURCE_NUMBER20 = 79;
    private static final Integer RESOURCE_DURATION1 = 80;
    private static final Integer RESOURCE_DURATION2 = 81;
    private static final Integer RESOURCE_DURATION3 = 82;
    private static final Integer RESOURCE_DURATION4 = 83;
    private static final Integer RESOURCE_DURATION5 = 84;
    private static final Integer RESOURCE_DURATION6 = 85;
    private static final Integer RESOURCE_DURATION7 = 86;
    private static final Integer RESOURCE_DURATION8 = 87;
    private static final Integer RESOURCE_DURATION9 = 88;
    private static final Integer RESOURCE_DURATION10 = 89;
    private static final Integer RESOURCE_DURATION1_UNITS = 90;
    private static final Integer RESOURCE_DURATION2_UNITS = 91;
    private static final Integer RESOURCE_DURATION3_UNITS = 92;
    private static final Integer RESOURCE_DURATION4_UNITS = 93;
    private static final Integer RESOURCE_DURATION5_UNITS = 94;
    private static final Integer RESOURCE_DURATION6_UNITS = 95;
    private static final Integer RESOURCE_DURATION7_UNITS = 96;
    private static final Integer RESOURCE_DURATION8_UNITS = 97;
    private static final Integer RESOURCE_DURATION9_UNITS = 98;
    private static final Integer RESOURCE_DURATION10_UNITS = 99;
    private static final Integer RESOURCE_SUBPROJECTRESOURCEID = 102;
    private static final Integer RESOURCE_DATE1 = 103;
    private static final Integer RESOURCE_DATE2 = 104;
    private static final Integer RESOURCE_DATE3 = 105;
    private static final Integer RESOURCE_DATE4 = 106;
    private static final Integer RESOURCE_DATE5 = 107;
    private static final Integer RESOURCE_DATE6 = 108;
    private static final Integer RESOURCE_DATE7 = 109;
    private static final Integer RESOURCE_DATE8 = 110;
    private static final Integer RESOURCE_DATE9 = 111;
    private static final Integer RESOURCE_DATE10 = 112;
    private static final Integer RESOURCE_OUTLINECODE1 = 113;
    private static final Integer RESOURCE_OUTLINECODE2 = 114;
    private static final Integer RESOURCE_OUTLINECODE3 = 115;
    private static final Integer RESOURCE_OUTLINECODE4 = 116;
    private static final Integer RESOURCE_OUTLINECODE5 = 117;
    private static final Integer RESOURCE_OUTLINECODE6 = 118;
    private static final Integer RESOURCE_OUTLINECODE7 = 119;
    private static final Integer RESOURCE_OUTLINECODE8 = 120;
    private static final Integer RESOURCE_OUTLINECODE9 = 121;
    private static final Integer RESOURCE_OUTLINECODE10 = 122;
    private static final Integer RESOURCE_HYPERLINK = 123;
    private static final Integer RESOURCE_NOTES = 124;
    private static final Integer RESOURCE_COST1 = 125;
    private static final Integer RESOURCE_COST2 = 126;
    private static final Integer RESOURCE_COST3 = 127;
    private static final Integer RESOURCE_COST4 = 128;
    private static final Integer RESOURCE_COST5 = 129;
    private static final Integer RESOURCE_COST6 = 130;
    private static final Integer RESOURCE_COST7 = 131;
    private static final Integer RESOURCE_COST8 = 132;
    private static final Integer RESOURCE_COST9 = 133;
    private static final Integer RESOURCE_COST10 = 134;
    private static final Integer RESOURCE_ENTERPRISE_COLUMNS = 143;
    private static final Integer RESOURCE_BASELINE1_WORK = 144;
    private static final Integer RESOURCE_BASELINE2_WORK = 148;
    private static final Integer RESOURCE_BASELINE3_WORK = 152;
    private static final Integer RESOURCE_BASELINE4_WORK = 156;
    private static final Integer RESOURCE_BASELINE5_WORK = 160;
    private static final Integer RESOURCE_BASELINE6_WORK = 164;
    private static final Integer RESOURCE_BASELINE7_WORK = 168;
    private static final Integer RESOURCE_BASELINE8_WORK = 172;
    private static final Integer RESOURCE_BASELINE9_WORK = 176;
    private static final Integer RESOURCE_BASELINE10_WORK = 180;
    private static final Integer RESOURCE_BASELINE1_COST = 145;
    private static final Integer RESOURCE_BASELINE2_COST = 149;
    private static final Integer RESOURCE_BASELINE3_COST = 153;
    private static final Integer RESOURCE_BASELINE4_COST = 157;
    private static final Integer RESOURCE_BASELINE5_COST = 161;
    private static final Integer RESOURCE_BASELINE6_COST = 165;
    private static final Integer RESOURCE_BASELINE7_COST = 169;
    private static final Integer RESOURCE_BASELINE8_COST = 173;
    private static final Integer RESOURCE_BASELINE9_COST = 177;
    private static final Integer RESOURCE_BASELINE10_COST = 181;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 1;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 2;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = null;
    private static final Integer OUTLINECODE_DATA = 1;
    private static final Integer PLANNED_WORK = 7;
    private static final Integer COMPLETE_WORK = 9;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};
    private static final int MINIMUM_EXPECTED_TASK_SIZE = 240;
    private static final int MINIMUM_EXPECTED_RESOURCE_SIZE = 188;
    private static final Duration DEFAULT_NORMALIZER_WORK_PER_DAY = Duration.getInstance(480, TimeUnit.MINUTES);

    MPP9Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader reader, ProjectFile file, DirectoryEntry root) throws MPXJException, IOException {
        try {
            String readPassword;
            Props9 props9 = new Props9((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("Props9")));
            file.setProjectFilePath(props9.getUnicodeString(Props.PROJECT_FILE_PATH));
            file.setEncoded(props9.getByte(Props.PASSWORD_FLAG) != 0);
            file.setEncryptionCode(props9.getByte(Props.ENCRYPTION_CODE));
            if (!((props9.getByte(Props.PASSWORD_FLAG) & 1) == 0 || (readPassword = MPPUtility.decodePassword(props9.getByteArray(Props.PROTECTION_PASSWORD_HASH), file.getEncryptionCode())) == null || readPassword.length() <= 0 || reader.getReadPassword() != null && reader.getReadPassword().matches(readPassword))) {
                throw new MPXJException("File is password protected. Please enter password.");
            }
            this.m_reader = reader;
            this.m_file = file;
            this.m_root = root;
            this.m_resourceMap = new HashMap();
            this.m_projectDir = (DirectoryEntry)root.getEntry("   19");
            this.m_viewDir = (DirectoryEntry)root.getEntry("   29");
            DirectoryEntry outlineCodeDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
            VarMeta9 outlineCodeVarMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("VarMeta")));
            this.m_outlineCodeVarData = new Var2Data(outlineCodeVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Var2Data")));
            this.m_projectProps = new Props9(this.getEncryptableInputStream(this.m_projectDir, "Props"));
            this.m_fontBases = new HashMap<Integer, FontBase>();
            this.m_taskSubProjects = new HashMap<Integer, SubProject>();
            this.m_file.setMppFileType(9);
            this.m_file.setAutoFilter(props9.getBoolean(Props.AUTO_FILTER));
            this.processPropertyData();
            this.processCalendarData();
            this.processResourceData();
            this.processTaskData();
            this.processConstraintData();
            this.processAssignmentData();
            this.processViewPropertyData();
            this.processTableData();
            this.processViewData();
            this.processFilterData();
            this.processGroupData();
            this.processSavedViewState();
        }
        finally {
            this.m_reader = null;
            this.m_file = null;
            this.m_root = null;
            this.m_resourceMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
            this.m_outlineCodeVarData = null;
            this.m_fontBases = null;
            this.m_taskSubProjects = null;
        }
    }

    private void processPropertyData() throws IOException, MPXJException {
        ProjectHeaderReader projectHeaderReader = new ProjectHeaderReader();
        projectHeaderReader.process(this.m_file, this.m_projectProps, this.m_root);
        this.processTaskFieldNameAliases(this.m_projectProps.getByteArray(Props.TASK_FIELD_NAME_ALIASES));
        this.processResourceFieldNameAliases(this.m_projectProps.getByteArray(Props.RESOURCE_FIELD_NAME_ALIASES));
        this.processTaskFieldCustomValueLists(this.m_file, this.m_projectProps.getByteArray(Props.TASK_FIELD_CUSTOM_VALUE_LISTS));
        this.processSubProjectData();
        GraphicalIndicatorReader reader = new GraphicalIndicatorReader();
        reader.process(this.m_file, this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] subProjData = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (subProjData != null) {
            int index = 0;
            int offset = 0;
            byte[] itemHeader = new byte[20];
            offset += 4;
            int itemCountOffset = MPPUtility.getInt(subProjData, offset += 4);
            offset += 4;
            block16: while (offset < itemCountOffset) {
                ++index;
                int itemHeaderOffset = MPPUtility.getShort(subProjData, offset);
                offset += 4;
                MPPUtility.getByteArray(subProjData, itemHeaderOffset, itemHeader.length, itemHeader, 0);
                byte subProjectType = itemHeader[16];
                switch (subProjectType) {
                    case 0: {
                        offset += 8;
                        continue block16;
                    }
                    case -103: 
                    case 9: 
                    case 13: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        offset += 4;
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -111: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 3: 
                    case 17: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -127: 
                    case 65: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 1: 
                    case 8: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -64: {
                        int uniqueIDOffset = itemHeaderOffset;
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 5: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        this.m_file.setResourceSubProject(sp);
                        continue block16;
                    }
                    case 2: 
                    case 4: {
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index);
                        if (subProjectType != 4) continue block16;
                        this.m_file.setResourceSubProject(sp);
                        continue block16;
                    }
                    case -115: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 8);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 8);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case 10: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block16;
                    }
                    case -128: {
                        offset += 12;
                        continue block16;
                    }
                    case 16: {
                        offset += 8;
                        continue block16;
                    }
                    case 68: {
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        offset += 4;
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index);
                        this.m_file.setResourceSubProject(sp);
                        continue block16;
                    }
                }
                offset += 12;
            }
        }
    }

    private SubProject readSubProject(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int subprojectIndex) {
        try {
            SubProject sp = new SubProject();
            if (uniqueIDOffset != -1) {
                int prev = 0;
                int value = MPPUtility.getInt(data, uniqueIDOffset);
                while (value != 771) {
                    switch (value) {
                        case 0: 
                        case 49741824: 
                        case 94437376: 
                        case 0xABB0000: 
                        case 187957248: {
                            sp.setTaskUniqueID(prev);
                            this.m_taskSubProjects.put(sp.getTaskUniqueID(), sp);
                            prev = 0;
                            break;
                        }
                        default: {
                            if (prev != 0) {
                                sp.addExternalTaskUniqueID(prev);
                                this.m_taskSubProjects.put(prev, sp);
                            }
                            prev = value;
                        }
                    }
                    value = MPPUtility.getInt(data, uniqueIDOffset += 4);
                }
                if (prev != 0) {
                    sp.addExternalTaskUniqueID(prev);
                    this.m_taskSubProjects.put(prev, sp);
                }
                value = 0x800000 + (subprojectIndex - 1) * 0x400000;
                sp.setUniqueIDOffset(value);
            }
            filePathOffset += 18;
            sp.setDosFullPath(MPPUtility.getString(data, filePathOffset += 4));
            filePathOffset += sp.getDosFullPath().length() + 1;
            int size = MPPUtility.getInt(data, filePathOffset += 24);
            filePathOffset += 4;
            if (size == 0) {
                sp.setFullPath(sp.getDosFullPath());
            } else {
                size = MPPUtility.getInt(data, filePathOffset);
                filePathOffset += 4;
                sp.setFullPath(MPPUtility.getUnicodeString(data, filePathOffset += 2, size));
            }
            fileNameOffset += 18;
            sp.setDosFileName(MPPUtility.getString(data, fileNameOffset += 4));
            fileNameOffset += sp.getDosFileName().length() + 1;
            size = MPPUtility.getInt(data, fileNameOffset += 24);
            fileNameOffset += 4;
            if (size == 0) {
                sp.setFileName(sp.getDosFileName());
            } else {
                size = MPPUtility.getInt(data, fileNameOffset);
                fileNameOffset += 4;
                sp.setFileName(MPPUtility.getUnicodeString(data, fileNameOffset += 2, size));
            }
            this.m_file.addSubProject(sp);
            return sp;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props9 props = new Props9(this.getEncryptableInputStream(this.m_viewDir, "Props"));
        byte[] data = props.getByteArray(Props.FONT_BASES);
        if (data != null) {
            this.processBaseFonts(data);
        }
        ProjectHeader header = this.m_file.getProjectHeader();
        header.setShowProjectSummaryTask(props.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] data) {
        int offset = 0;
        int blockCount = MPPUtility.getShort(data, 0);
        offset += 2;
        for (int loop = 0; loop < blockCount; ++loop) {
            int size = MPPUtility.getShort(data, offset += 2);
            String name = MPPUtility.getUnicodeString(data, offset += 2);
            offset += 64;
            if (name.length() == 0) continue;
            FontBase fontBase = new FontBase(loop, name, size);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private void processTaskFieldNameAliases(byte[] data) {
        if (data != null) {
            String alias;
            ArrayList<String> aliases = new ArrayList<String>(300);
            for (int offset = 0; offset < data.length; offset += (alias.length() + 1) * 2) {
                alias = MPPUtility.getUnicodeString(data, offset);
                aliases.add(alias);
            }
            this.m_file.setTaskFieldAlias(TaskField.TEXT1, (String)aliases.get(118));
            this.m_file.setTaskFieldAlias(TaskField.TEXT2, (String)aliases.get(119));
            this.m_file.setTaskFieldAlias(TaskField.TEXT3, (String)aliases.get(120));
            this.m_file.setTaskFieldAlias(TaskField.TEXT4, (String)aliases.get(121));
            this.m_file.setTaskFieldAlias(TaskField.TEXT5, (String)aliases.get(122));
            this.m_file.setTaskFieldAlias(TaskField.TEXT6, (String)aliases.get(123));
            this.m_file.setTaskFieldAlias(TaskField.TEXT7, (String)aliases.get(124));
            this.m_file.setTaskFieldAlias(TaskField.TEXT8, (String)aliases.get(125));
            this.m_file.setTaskFieldAlias(TaskField.TEXT9, (String)aliases.get(126));
            this.m_file.setTaskFieldAlias(TaskField.TEXT10, (String)aliases.get(127));
            this.m_file.setTaskFieldAlias(TaskField.START1, (String)aliases.get(128));
            this.m_file.setTaskFieldAlias(TaskField.FINISH1, (String)aliases.get(129));
            this.m_file.setTaskFieldAlias(TaskField.START2, (String)aliases.get(130));
            this.m_file.setTaskFieldAlias(TaskField.FINISH2, (String)aliases.get(131));
            this.m_file.setTaskFieldAlias(TaskField.START3, (String)aliases.get(132));
            this.m_file.setTaskFieldAlias(TaskField.FINISH3, (String)aliases.get(133));
            this.m_file.setTaskFieldAlias(TaskField.START4, (String)aliases.get(134));
            this.m_file.setTaskFieldAlias(TaskField.FINISH4, (String)aliases.get(135));
            this.m_file.setTaskFieldAlias(TaskField.START5, (String)aliases.get(136));
            this.m_file.setTaskFieldAlias(TaskField.FINISH5, (String)aliases.get(137));
            this.m_file.setTaskFieldAlias(TaskField.START6, (String)aliases.get(138));
            this.m_file.setTaskFieldAlias(TaskField.FINISH6, (String)aliases.get(139));
            this.m_file.setTaskFieldAlias(TaskField.START7, (String)aliases.get(140));
            this.m_file.setTaskFieldAlias(TaskField.FINISH7, (String)aliases.get(141));
            this.m_file.setTaskFieldAlias(TaskField.START8, (String)aliases.get(142));
            this.m_file.setTaskFieldAlias(TaskField.FINISH8, (String)aliases.get(143));
            this.m_file.setTaskFieldAlias(TaskField.START9, (String)aliases.get(144));
            this.m_file.setTaskFieldAlias(TaskField.FINISH9, (String)aliases.get(145));
            this.m_file.setTaskFieldAlias(TaskField.START10, (String)aliases.get(146));
            this.m_file.setTaskFieldAlias(TaskField.FINISH10, (String)aliases.get(147));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER1, (String)aliases.get(149));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER2, (String)aliases.get(150));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER3, (String)aliases.get(151));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER4, (String)aliases.get(152));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER5, (String)aliases.get(153));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER6, (String)aliases.get(154));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER7, (String)aliases.get(155));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER8, (String)aliases.get(156));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER9, (String)aliases.get(157));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER10, (String)aliases.get(158));
            this.m_file.setTaskFieldAlias(TaskField.DURATION1, (String)aliases.get(159));
            this.m_file.setTaskFieldAlias(TaskField.DURATION2, (String)aliases.get(161));
            this.m_file.setTaskFieldAlias(TaskField.DURATION3, (String)aliases.get(163));
            this.m_file.setTaskFieldAlias(TaskField.DURATION4, (String)aliases.get(165));
            this.m_file.setTaskFieldAlias(TaskField.DURATION5, (String)aliases.get(167));
            this.m_file.setTaskFieldAlias(TaskField.DURATION6, (String)aliases.get(169));
            this.m_file.setTaskFieldAlias(TaskField.DURATION7, (String)aliases.get(171));
            this.m_file.setTaskFieldAlias(TaskField.DURATION8, (String)aliases.get(173));
            this.m_file.setTaskFieldAlias(TaskField.DURATION9, (String)aliases.get(175));
            this.m_file.setTaskFieldAlias(TaskField.DURATION10, (String)aliases.get(177));
            this.m_file.setTaskFieldAlias(TaskField.DATE1, (String)aliases.get(184));
            this.m_file.setTaskFieldAlias(TaskField.DATE2, (String)aliases.get(185));
            this.m_file.setTaskFieldAlias(TaskField.DATE3, (String)aliases.get(186));
            this.m_file.setTaskFieldAlias(TaskField.DATE4, (String)aliases.get(187));
            this.m_file.setTaskFieldAlias(TaskField.DATE5, (String)aliases.get(188));
            this.m_file.setTaskFieldAlias(TaskField.DATE6, (String)aliases.get(189));
            this.m_file.setTaskFieldAlias(TaskField.DATE7, (String)aliases.get(190));
            this.m_file.setTaskFieldAlias(TaskField.DATE8, (String)aliases.get(191));
            this.m_file.setTaskFieldAlias(TaskField.DATE9, (String)aliases.get(192));
            this.m_file.setTaskFieldAlias(TaskField.DATE10, (String)aliases.get(193));
            this.m_file.setTaskFieldAlias(TaskField.TEXT11, (String)aliases.get(194));
            this.m_file.setTaskFieldAlias(TaskField.TEXT12, (String)aliases.get(195));
            this.m_file.setTaskFieldAlias(TaskField.TEXT13, (String)aliases.get(196));
            this.m_file.setTaskFieldAlias(TaskField.TEXT14, (String)aliases.get(197));
            this.m_file.setTaskFieldAlias(TaskField.TEXT15, (String)aliases.get(198));
            this.m_file.setTaskFieldAlias(TaskField.TEXT16, (String)aliases.get(199));
            this.m_file.setTaskFieldAlias(TaskField.TEXT17, (String)aliases.get(200));
            this.m_file.setTaskFieldAlias(TaskField.TEXT18, (String)aliases.get(201));
            this.m_file.setTaskFieldAlias(TaskField.TEXT19, (String)aliases.get(202));
            this.m_file.setTaskFieldAlias(TaskField.TEXT20, (String)aliases.get(203));
            this.m_file.setTaskFieldAlias(TaskField.TEXT21, (String)aliases.get(204));
            this.m_file.setTaskFieldAlias(TaskField.TEXT22, (String)aliases.get(205));
            this.m_file.setTaskFieldAlias(TaskField.TEXT23, (String)aliases.get(206));
            this.m_file.setTaskFieldAlias(TaskField.TEXT24, (String)aliases.get(207));
            this.m_file.setTaskFieldAlias(TaskField.TEXT25, (String)aliases.get(208));
            this.m_file.setTaskFieldAlias(TaskField.TEXT26, (String)aliases.get(209));
            this.m_file.setTaskFieldAlias(TaskField.TEXT27, (String)aliases.get(210));
            this.m_file.setTaskFieldAlias(TaskField.TEXT28, (String)aliases.get(211));
            this.m_file.setTaskFieldAlias(TaskField.TEXT29, (String)aliases.get(212));
            this.m_file.setTaskFieldAlias(TaskField.TEXT30, (String)aliases.get(213));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER11, (String)aliases.get(214));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER12, (String)aliases.get(215));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER13, (String)aliases.get(216));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER14, (String)aliases.get(217));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER15, (String)aliases.get(218));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER16, (String)aliases.get(219));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER17, (String)aliases.get(220));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER18, (String)aliases.get(221));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER19, (String)aliases.get(222));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER20, (String)aliases.get(223));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE1, (String)aliases.get(227));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE2, (String)aliases.get(228));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE3, (String)aliases.get(229));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE4, (String)aliases.get(230));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE5, (String)aliases.get(231));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE6, (String)aliases.get(232));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE7, (String)aliases.get(233));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE8, (String)aliases.get(234));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE9, (String)aliases.get(235));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE10, (String)aliases.get(236));
            this.m_file.setTaskFieldAlias(TaskField.FLAG1, (String)aliases.get(237));
            this.m_file.setTaskFieldAlias(TaskField.FLAG2, (String)aliases.get(238));
            this.m_file.setTaskFieldAlias(TaskField.FLAG3, (String)aliases.get(239));
            this.m_file.setTaskFieldAlias(TaskField.FLAG4, (String)aliases.get(240));
            this.m_file.setTaskFieldAlias(TaskField.FLAG5, (String)aliases.get(241));
            this.m_file.setTaskFieldAlias(TaskField.FLAG6, (String)aliases.get(242));
            this.m_file.setTaskFieldAlias(TaskField.FLAG7, (String)aliases.get(243));
            this.m_file.setTaskFieldAlias(TaskField.FLAG8, (String)aliases.get(244));
            this.m_file.setTaskFieldAlias(TaskField.FLAG9, (String)aliases.get(245));
            this.m_file.setTaskFieldAlias(TaskField.FLAG10, (String)aliases.get(246));
            this.m_file.setTaskFieldAlias(TaskField.FLAG11, (String)aliases.get(247));
            this.m_file.setTaskFieldAlias(TaskField.FLAG12, (String)aliases.get(248));
            this.m_file.setTaskFieldAlias(TaskField.FLAG13, (String)aliases.get(249));
            this.m_file.setTaskFieldAlias(TaskField.FLAG14, (String)aliases.get(250));
            this.m_file.setTaskFieldAlias(TaskField.FLAG15, (String)aliases.get(251));
            this.m_file.setTaskFieldAlias(TaskField.FLAG16, (String)aliases.get(252));
            this.m_file.setTaskFieldAlias(TaskField.FLAG17, (String)aliases.get(253));
            this.m_file.setTaskFieldAlias(TaskField.FLAG18, (String)aliases.get(254));
            this.m_file.setTaskFieldAlias(TaskField.FLAG19, (String)aliases.get(255));
            this.m_file.setTaskFieldAlias(TaskField.FLAG20, (String)aliases.get(256));
            this.m_file.setTaskFieldAlias(TaskField.COST1, (String)aliases.get(278));
            this.m_file.setTaskFieldAlias(TaskField.COST2, (String)aliases.get(279));
            this.m_file.setTaskFieldAlias(TaskField.COST3, (String)aliases.get(280));
            this.m_file.setTaskFieldAlias(TaskField.COST4, (String)aliases.get(281));
            this.m_file.setTaskFieldAlias(TaskField.COST5, (String)aliases.get(282));
            this.m_file.setTaskFieldAlias(TaskField.COST6, (String)aliases.get(283));
            this.m_file.setTaskFieldAlias(TaskField.COST7, (String)aliases.get(284));
            this.m_file.setTaskFieldAlias(TaskField.COST8, (String)aliases.get(285));
            this.m_file.setTaskFieldAlias(TaskField.COST9, (String)aliases.get(286));
            this.m_file.setTaskFieldAlias(TaskField.COST10, (String)aliases.get(287));
        }
    }

    private void processTaskFieldCustomValueLists(ProjectFile file, byte[] data) {
        if (data != null) {
            int offset = 0;
            int length = MPPUtility.getInt(data, offset);
            int numberOfValueLists = MPPUtility.getInt(data, offset += 4);
            offset += 4;
            int valueListOffset = 0;
            for (int index = 0; index < numberOfValueLists && offset < length; ++index) {
                TaskField field = MPPTaskField.getInstance(MPPUtility.getShort(data, offset));
                offset += 2;
                valueListOffset = MPPUtility.getInt(data, offset += 2);
                offset += 4;
                if (valueListOffset >= data.length) continue;
                int tempOffset = valueListOffset;
                int dataOffset = MPPUtility.getInt(data, tempOffset += 8) + valueListOffset;
                int endDataOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int endDescriptionOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int valuesLength = endDataOffset - dataOffset;
                byte[] values = new byte[valuesLength];
                MPPUtility.getByteArray(data, dataOffset, valuesLength, values, 0);
                file.setTaskFieldValueList(field, this.getTaskFieldValues(file, field, values));
                int descriptionsLength = endDescriptionOffset - endDataOffset;
                byte[] descriptions = new byte[descriptionsLength];
                MPPUtility.getByteArray(data, endDataOffset, descriptionsLength, descriptions, 0);
                file.setTaskFieldDescriptionList(field, this.getTaskFieldDescriptions(descriptions));
            }
        }
    }

    public List<String> getTaskFieldDescriptions(byte[] data) {
        String description;
        if (data == null || data.length == 0) {
            return null;
        }
        LinkedList<String> descriptions = new LinkedList<String>();
        for (int offset = 0; offset < data.length; offset += description.length() * 2 + 2) {
            description = MPPUtility.getUnicodeString(data, offset);
            descriptions.add(description);
        }
        return descriptions;
    }

    public List<Object> getTaskFieldValues(ProjectFile file, TaskField field, byte[] data) {
        if (field == null || data == null || data.length == 0) {
            return null;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        switch (field.getDataType()) {
            case DATE: {
                int offset;
                while (offset + 4 <= data.length) {
                    Date date = MPPUtility.getTimestamp(data, offset);
                    list.add(date);
                    offset += 4;
                }
                break;
            }
            case CURRENCY: {
                int offset;
                while (offset + 8 <= data.length) {
                    Double number = NumberUtility.getDouble(MPPUtility.getDouble(data, offset) / 100.0);
                    list.add(number);
                    offset += 8;
                }
                break;
            }
            case NUMERIC: {
                int offset;
                while (offset + 8 <= data.length) {
                    Double number = NumberUtility.getDouble(MPPUtility.getDouble(data, offset));
                    list.add(number);
                    offset += 8;
                }
                break;
            }
            case DURATION: {
                int offset;
                while (offset + 6 <= data.length) {
                    Duration duration = MPPUtility.getAdjustedDuration(file, MPPUtility.getInt(data, offset), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, offset + 4)));
                    list.add(duration);
                    offset += 6;
                }
                break;
            }
            case STRING: {
                String s;
                int offset;
                for (offset = 0; offset < data.length; offset += s.length() * 2 + 2) {
                    s = MPPUtility.getUnicodeString(data, offset);
                    list.add(s);
                }
                break;
            }
            case BOOLEAN: {
                int offset;
                while (offset + 2 <= data.length) {
                    boolean b = MPPUtility.getShort(data, offset) == 1;
                    list.add(b);
                    offset += 2;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return list;
    }

    private void processResourceFieldNameAliases(byte[] data) {
        if (data != null) {
            String alias;
            ArrayList<String> aliases = new ArrayList<String>(250);
            for (int offset = 0; offset < data.length; offset += (alias.length() + 1) * 2) {
                alias = MPPUtility.getUnicodeString(data, offset);
                aliases.add(alias);
            }
            this.m_file.setResourceFieldAlias(ResourceField.TEXT1, (String)aliases.get(52));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT2, (String)aliases.get(53));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT3, (String)aliases.get(54));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT4, (String)aliases.get(55));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT5, (String)aliases.get(56));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT6, (String)aliases.get(57));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT7, (String)aliases.get(58));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT8, (String)aliases.get(59));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT9, (String)aliases.get(60));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT10, (String)aliases.get(61));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT11, (String)aliases.get(62));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT12, (String)aliases.get(63));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT13, (String)aliases.get(64));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT14, (String)aliases.get(65));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT15, (String)aliases.get(66));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT16, (String)aliases.get(67));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT17, (String)aliases.get(68));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT18, (String)aliases.get(69));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT19, (String)aliases.get(70));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT20, (String)aliases.get(71));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT21, (String)aliases.get(72));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT22, (String)aliases.get(73));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT23, (String)aliases.get(74));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT24, (String)aliases.get(75));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT25, (String)aliases.get(76));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT26, (String)aliases.get(77));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT27, (String)aliases.get(78));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT28, (String)aliases.get(79));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT29, (String)aliases.get(80));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT30, (String)aliases.get(81));
            this.m_file.setResourceFieldAlias(ResourceField.START1, (String)aliases.get(82));
            this.m_file.setResourceFieldAlias(ResourceField.START2, (String)aliases.get(83));
            this.m_file.setResourceFieldAlias(ResourceField.START3, (String)aliases.get(84));
            this.m_file.setResourceFieldAlias(ResourceField.START4, (String)aliases.get(85));
            this.m_file.setResourceFieldAlias(ResourceField.START5, (String)aliases.get(86));
            this.m_file.setResourceFieldAlias(ResourceField.START6, (String)aliases.get(87));
            this.m_file.setResourceFieldAlias(ResourceField.START7, (String)aliases.get(88));
            this.m_file.setResourceFieldAlias(ResourceField.START8, (String)aliases.get(89));
            this.m_file.setResourceFieldAlias(ResourceField.START9, (String)aliases.get(90));
            this.m_file.setResourceFieldAlias(ResourceField.START10, (String)aliases.get(91));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH1, (String)aliases.get(92));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH2, (String)aliases.get(93));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH3, (String)aliases.get(94));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH4, (String)aliases.get(95));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH5, (String)aliases.get(96));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH6, (String)aliases.get(97));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH7, (String)aliases.get(98));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH8, (String)aliases.get(99));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH9, (String)aliases.get(100));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH10, (String)aliases.get(101));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER1, (String)aliases.get(102));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER2, (String)aliases.get(103));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER3, (String)aliases.get(104));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER4, (String)aliases.get(105));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER5, (String)aliases.get(106));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER6, (String)aliases.get(107));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER7, (String)aliases.get(108));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER8, (String)aliases.get(109));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER9, (String)aliases.get(110));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER10, (String)aliases.get(111));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER11, (String)aliases.get(112));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER12, (String)aliases.get(113));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER13, (String)aliases.get(114));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER14, (String)aliases.get(115));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER15, (String)aliases.get(116));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER16, (String)aliases.get(117));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER17, (String)aliases.get(118));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER18, (String)aliases.get(119));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER19, (String)aliases.get(120));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER20, (String)aliases.get(121));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION1, (String)aliases.get(122));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION2, (String)aliases.get(123));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION3, (String)aliases.get(124));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION4, (String)aliases.get(125));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION5, (String)aliases.get(126));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION6, (String)aliases.get(127));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION7, (String)aliases.get(128));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION8, (String)aliases.get(129));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION9, (String)aliases.get(130));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION10, (String)aliases.get(131));
            this.m_file.setResourceFieldAlias(ResourceField.DATE1, (String)aliases.get(145));
            this.m_file.setResourceFieldAlias(ResourceField.DATE2, (String)aliases.get(146));
            this.m_file.setResourceFieldAlias(ResourceField.DATE3, (String)aliases.get(147));
            this.m_file.setResourceFieldAlias(ResourceField.DATE4, (String)aliases.get(148));
            this.m_file.setResourceFieldAlias(ResourceField.DATE5, (String)aliases.get(149));
            this.m_file.setResourceFieldAlias(ResourceField.DATE6, (String)aliases.get(150));
            this.m_file.setResourceFieldAlias(ResourceField.DATE7, (String)aliases.get(151));
            this.m_file.setResourceFieldAlias(ResourceField.DATE8, (String)aliases.get(152));
            this.m_file.setResourceFieldAlias(ResourceField.DATE9, (String)aliases.get(153));
            this.m_file.setResourceFieldAlias(ResourceField.DATE10, (String)aliases.get(154));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE1, (String)aliases.get(155));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE2, (String)aliases.get(156));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE3, (String)aliases.get(157));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE4, (String)aliases.get(158));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE5, (String)aliases.get(159));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE6, (String)aliases.get(160));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE7, (String)aliases.get(161));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE8, (String)aliases.get(162));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE9, (String)aliases.get(163));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE10, (String)aliases.get(164));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG10, (String)aliases.get(165));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG1, (String)aliases.get(166));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG2, (String)aliases.get(167));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG3, (String)aliases.get(168));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG4, (String)aliases.get(169));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG5, (String)aliases.get(170));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG6, (String)aliases.get(171));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG7, (String)aliases.get(172));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG8, (String)aliases.get(173));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG9, (String)aliases.get(174));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG11, (String)aliases.get(175));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG12, (String)aliases.get(176));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG13, (String)aliases.get(177));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG14, (String)aliases.get(178));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG15, (String)aliases.get(179));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG16, (String)aliases.get(180));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG17, (String)aliases.get(181));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG18, (String)aliases.get(182));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG19, (String)aliases.get(183));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG20, (String)aliases.get(184));
            this.m_file.setResourceFieldAlias(ResourceField.COST1, (String)aliases.get(207));
            this.m_file.setResourceFieldAlias(ResourceField.COST2, (String)aliases.get(208));
            this.m_file.setResourceFieldAlias(ResourceField.COST3, (String)aliases.get(209));
            this.m_file.setResourceFieldAlias(ResourceField.COST4, (String)aliases.get(210));
            this.m_file.setResourceFieldAlias(ResourceField.COST5, (String)aliases.get(211));
            this.m_file.setResourceFieldAlias(ResourceField.COST6, (String)aliases.get(212));
            this.m_file.setResourceFieldAlias(ResourceField.COST7, (String)aliases.get(213));
            this.m_file.setResourceFieldAlias(ResourceField.COST8, (String)aliases.get(214));
            this.m_file.setResourceFieldAlias(ResourceField.COST9, (String)aliases.get(215));
            this.m_file.setResourceFieldAlias(ResourceField.COST10, (String)aliases.get(216));
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FixedMeta taskFixedMeta, FixedData taskFixedData) {
        TreeMap<Integer, Integer> taskMap = new TreeMap<Integer, Integer>();
        int itemCount = taskFixedMeta.getItemCount();
        for (int loop = 3; loop < itemCount; ++loop) {
            Integer key;
            int uniqueID;
            byte[] data = taskFixedData.getByteArrayValue(loop);
            if (data == null) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(loop);
            int metaDataItemSize = MPPUtility.getInt(metaData, 0);
            if (metaDataItemSize == 2 || metaDataItemSize == 6) {
                uniqueID = MPPUtility.getShort(data, 0);
                key = uniqueID;
                if (taskMap.containsKey(key)) continue;
                taskMap.put(key, null);
                continue;
            }
            if (data.length != 8 && data.length < 240 || taskMap.containsKey(key = Integer.valueOf(uniqueID = MPPUtility.getInt(data, 0)))) continue;
            taskMap.put(key, loop);
        }
        return taskMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FixedMeta rscFixedMeta, FixedData rscFixedData) {
        TreeMap<Integer, Integer> resourceMap = new TreeMap<Integer, Integer>();
        int itemCount = rscFixedMeta.getItemCount();
        for (int loop = 0; loop < itemCount; ++loop) {
            byte[] data = rscFixedData.getByteArrayValue(loop);
            if (data == null || data.length < 188) continue;
            Integer uniqueID = MPPUtility.getShort(data, 0);
            resourceMap.put(uniqueID, loop);
        }
        return resourceMap;
    }

    private void processCalendarData() throws IOException {
        DirectoryEntry calDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        VarMeta9 calVarMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("VarMeta")));
        Var2Data calVarData = new Var2Data(calVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("Var2Data")));
        FixedMeta calFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("FixedMeta")), 10);
        FixedData calFixedData = new FixedData(calFixedMeta, this.getEncryptableInputStream(calDir, "FixedData"));
        HashMap<Integer, ProjectCalendar> calendarMap = new HashMap<Integer, ProjectCalendar>();
        int items = calFixedData.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> baseCalendars = new LinkedList<Pair<ProjectCalendar, Integer>>();
        byte[] defaultCalendarData = this.m_projectProps.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        for (int loop = 0; loop < items; ++loop) {
            byte[] fixedData = calFixedData.getByteArrayValue(loop);
            if (fixedData.length < 8) continue;
            int offset = 0;
            while (offset + 12 <= fixedData.length) {
                Integer calendarID = MPPUtility.getInt(fixedData, offset + 0);
                int baseCalendarID = MPPUtility.getInt(fixedData, offset + 4);
                if (calendarID != -1 && calendarID != 0 && baseCalendarID != 0 && !calendarMap.containsKey(calendarID)) {
                    ProjectCalendar cal;
                    byte[] varData = calVarData.getByteArray(calendarID, CALENDAR_DATA);
                    if (baseCalendarID == -1) {
                        if (varData != null || defaultCalendarData != null) {
                            cal = this.m_file.addBaseCalendar();
                            if (varData == null) {
                                varData = defaultCalendarData;
                            }
                        } else {
                            cal = this.m_file.addDefaultBaseCalendar();
                        }
                        cal.setName(calVarData.getUnicodeString(calendarID, CALENDAR_NAME));
                    } else {
                        cal = varData != null ? this.m_file.addResourceCalendar() : this.m_file.getDefaultResourceCalendar();
                        baseCalendars.add(new Pair<ProjectCalendar, Integer>(cal, baseCalendarID));
                        Integer resourceID = MPPUtility.getInt(fixedData, offset + 8);
                        this.m_resourceMap.put(resourceID, cal);
                    }
                    cal.setUniqueID(calendarID);
                    if (varData != null) {
                        this.processCalendarHours(varData, cal, baseCalendarID == -1);
                        this.processCalendarExceptions(varData, cal);
                    }
                    calendarMap.put(calendarID, cal);
                }
                offset += 12;
            }
        }
        this.updateBaseCalendarNames(baseCalendars, calendarMap);
    }

    private void processCalendarHours(byte[] data, ProjectCalendar cal, boolean isBaseCalendar) {
        for (int index = 0; index < 7; ++index) {
            ProjectCalendarHours hours;
            int offset = 4 + 60 * index;
            int defaultFlag = MPPUtility.getShort(data, offset);
            Day day = Day.getInstance(index + 1);
            if (defaultFlag == 1) {
                if (isBaseCalendar) {
                    cal.setWorkingDay(day, DEFAULT_WORKING_WEEK[index]);
                    if (!cal.isWorkingDay(day)) continue;
                    hours = cal.addCalendarHours(Day.getInstance(index + 1));
                    hours.addRange(new DateRange(ProjectCalendar.DEFAULT_START1, ProjectCalendar.DEFAULT_END1));
                    hours.addRange(new DateRange(ProjectCalendar.DEFAULT_START2, ProjectCalendar.DEFAULT_END2));
                    continue;
                }
                cal.setWorkingDay(day, 2);
                continue;
            }
            int periodCount = MPPUtility.getShort(data, offset + 2);
            if (periodCount == 0) {
                cal.setWorkingDay(day, false);
                continue;
            }
            cal.setWorkingDay(day, true);
            hours = cal.addCalendarHours(Day.getInstance(index + 1));
            for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                Date start = MPPUtility.getTime(data, offset + 8 + periodIndex * 2);
                long duration = MPPUtility.getDuration(data, offset + 20 + periodIndex * 4);
                hours.addRange(new DateRange(start, new Date(start.getTime() + duration)));
            }
        }
    }

    private void processCalendarExceptions(byte[] data, ProjectCalendar cal) {
        int exceptionCount = MPPUtility.getShort(data, 0);
        if (exceptionCount != 0) {
            for (int index = 0; index < exceptionCount; ++index) {
                int offset = 424 + index * 64;
                ProjectCalendarException exception = cal.addCalendarException();
                exception.setFromDate(MPPUtility.getDate(data, offset));
                exception.setToDate(MPPUtility.getDate(data, offset + 2));
                int periodCount = MPPUtility.getShort(data, offset + 6);
                if (periodCount == 0) {
                    exception.setWorking(false);
                    continue;
                }
                exception.setWorking(true);
                for (int exceptionPeriodIndex = 0; exceptionPeriodIndex < periodCount; ++exceptionPeriodIndex) {
                    Date start = MPPUtility.getTime(data, offset + 12 + exceptionPeriodIndex * 2);
                    long duration = MPPUtility.getDuration(data, offset + 24 + exceptionPeriodIndex * 4);
                    exception.addRange(new DateRange(start, new Date(start.getTime() + duration)));
                }
            }
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> baseCalendars, HashMap<Integer, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, Integer> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            Integer baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal != null && baseCal.getName() != null) {
                cal.setBaseCalendar(baseCal);
                continue;
            }
            this.m_file.removeCalendar(cal);
        }
    }

    private void processTaskData() throws IOException {
        DirectoryEntry taskDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta9 taskVarMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("VarMeta")));
        Var2Data taskVarData = new Var2Data(taskVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("Var2Data")));
        FixedMeta taskFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixedMeta")), 47);
        FixedData taskFixedData = new FixedData(taskFixedMeta, this.getEncryptableInputStream(taskDir, "FixedData"), 768, 240);
        TreeMap<Integer, Integer> taskMap = this.createTaskMap(taskFixedMeta, taskFixedData);
        Object[] uniqueid = taskMap.keySet().toArray();
        boolean autoWBS = true;
        LinkedList<Task> externalTasks = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        RTFUtility rtf = new RTFUtility();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            ProjectCalendar calendar;
            int calendarID;
            String notes;
            Task task;
            Integer id = (Integer)uniqueid[loop];
            Integer offset = taskMap.get(id);
            if (!taskFixedData.isValidOffset(offset)) continue;
            byte[] data = taskFixedData.getByteArrayValue(offset);
            if (data.length == 8) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(id);
                task.setID(MPPUtility.getInt(data, 4));
                continue;
            }
            if (data.length < 240) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(offset);
            byte[] recurringData = taskVarData.getByteArray(id, TASK_RECURRING_DATA);
            Task temp = this.m_file.getTaskByID(MPPUtility.getInt(data, 4));
            if (temp != null) {
                if (!taskVarMeta.getUniqueIdentifierSet().contains(id)) continue;
                this.m_file.removeTask(temp);
            }
            task = this.m_file.addTask();
            task.setActualCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 216) / 100.0));
            task.setActualDuration(MPPUtility.getDuration(MPPUtility.getInt(data, 66), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 64))));
            task.setActualFinish(MPPUtility.getTimestamp(data, 100));
            task.setActualOvertimeCost(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_ACTUAL_OVERTIME_COST) / 100.0));
            task.setActualOvertimeWork(Duration.getInstance(taskVarData.getDouble(id, TASK_ACTUAL_OVERTIME_WORK) / 60000.0, TimeUnit.HOURS));
            task.setActualStart(MPPUtility.getTimestamp(data, 96));
            task.setActualWork(Duration.getInstance(MPPUtility.getDouble(data, 184) / 60000.0, TimeUnit.HOURS));
            task.setBaselineCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 232) / 100.0));
            task.setBaselineDuration(MPPUtility.getDuration(MPPUtility.getInt(data, 74), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 78))));
            task.setBaselineFinish(MPPUtility.getTimestamp(data, 108));
            task.setBaselineStart(MPPUtility.getTimestamp(data, 104));
            task.setBaselineWork(Duration.getInstance(MPPUtility.getDouble(data, 176) / 60000.0, TimeUnit.HOURS));
            task.setConstraintDate(MPPUtility.getTimestamp(data, 112));
            task.setConstraintType(ConstraintType.getInstance(MPPUtility.getShort(data, 80)));
            task.setContact(taskVarData.getUnicodeString(id, TASK_CONTACT));
            task.setCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 200) / 100.0));
            task.setCost1(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST1) / 100.0));
            task.setCost2(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST2) / 100.0));
            task.setCost3(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST3) / 100.0));
            task.setCost4(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST4) / 100.0));
            task.setCost5(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST5) / 100.0));
            task.setCost6(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST6) / 100.0));
            task.setCost7(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST7) / 100.0));
            task.setCost8(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST8) / 100.0));
            task.setCost9(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST9) / 100.0));
            task.setCost10(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_COST10) / 100.0));
            task.setCreateDate(MPPUtility.getTimestamp(data, 130));
            task.setDate1(taskVarData.getTimestamp(id, TASK_DATE1));
            task.setDate2(taskVarData.getTimestamp(id, TASK_DATE2));
            task.setDate3(taskVarData.getTimestamp(id, TASK_DATE3));
            task.setDate4(taskVarData.getTimestamp(id, TASK_DATE4));
            task.setDate5(taskVarData.getTimestamp(id, TASK_DATE5));
            task.setDate6(taskVarData.getTimestamp(id, TASK_DATE6));
            task.setDate7(taskVarData.getTimestamp(id, TASK_DATE7));
            task.setDate8(taskVarData.getTimestamp(id, TASK_DATE8));
            task.setDate9(taskVarData.getTimestamp(id, TASK_DATE9));
            task.setDate10(taskVarData.getTimestamp(id, TASK_DATE10));
            task.setDeadline(MPPUtility.getTimestamp(data, 164));
            task.setDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 60), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 64))));
            task.setDuration1(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION1), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION1_UNITS))));
            task.setDuration2(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION2), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION2_UNITS))));
            task.setDuration3(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION3), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION3_UNITS))));
            task.setDuration4(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION4), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION4_UNITS))));
            task.setDuration5(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION5), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION5_UNITS))));
            task.setDuration6(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION6), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION6_UNITS))));
            task.setDuration7(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION7), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION7_UNITS))));
            task.setDuration8(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION8), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION8_UNITS))));
            task.setDuration9(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION9), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION9_UNITS))));
            task.setDuration10(MPPUtility.getAdjustedDuration(this.m_file, taskVarData.getInt(id, TASK_DURATION10), MPPUtility.getDurationTimeUnits(taskVarData.getShort(id, TASK_DURATION10_UNITS))));
            task.setEarlyFinish(MPPUtility.getTimestamp(data, 8));
            task.setEarlyStart(MPPUtility.getTimestamp(data, 88));
            task.setEffortDriven((metaData[11] & 0x10) != 0);
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(data, 64)));
            task.setExpanded((metaData[12] & 2) == 0);
            int externalTaskID = taskVarData.getInt(id, TASK_EXTERNAL_TASK_ID);
            if (externalTaskID != 0) {
                task.setExternalTaskID(externalTaskID);
                task.setExternalTask(true);
                externalTasks.add(task);
            }
            task.setFinish(MPPUtility.getTimestamp(data, 8));
            task.setFinish1(taskVarData.getTimestamp(id, TASK_FINISH1));
            task.setFinish2(taskVarData.getTimestamp(id, TASK_FINISH2));
            task.setFinish3(taskVarData.getTimestamp(id, TASK_FINISH3));
            task.setFinish4(taskVarData.getTimestamp(id, TASK_FINISH4));
            task.setFinish5(taskVarData.getTimestamp(id, TASK_FINISH5));
            task.setFinish6(taskVarData.getTimestamp(id, TASK_FINISH6));
            task.setFinish7(taskVarData.getTimestamp(id, TASK_FINISH7));
            task.setFinish8(taskVarData.getTimestamp(id, TASK_FINISH8));
            task.setFinish9(taskVarData.getTimestamp(id, TASK_FINISH9));
            task.setFinish10(taskVarData.getTimestamp(id, TASK_FINISH10));
            task.setFixedCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 208) / 100.0));
            task.setFixedCostAccrual(AccrueType.getInstance(MPPUtility.getShort(data, 128)));
            task.setFlag1((metaData[37] & 0x20) != 0);
            task.setFlag2((metaData[37] & 0x40) != 0);
            task.setFlag3((metaData[37] & 0x80) != 0);
            task.setFlag4((metaData[38] & 1) != 0);
            task.setFlag5((metaData[38] & 2) != 0);
            task.setFlag6((metaData[38] & 4) != 0);
            task.setFlag7((metaData[38] & 8) != 0);
            task.setFlag8((metaData[38] & 0x10) != 0);
            task.setFlag9((metaData[38] & 0x20) != 0);
            task.setFlag10((metaData[38] & 0x40) != 0);
            task.setFlag11((metaData[38] & 0x80) != 0);
            task.setFlag12((metaData[39] & 1) != 0);
            task.setFlag13((metaData[39] & 2) != 0);
            task.setFlag14((metaData[39] & 4) != 0);
            task.setFlag15((metaData[39] & 8) != 0);
            task.setFlag16((metaData[39] & 0x10) != 0);
            task.setFlag17((metaData[39] & 0x20) != 0);
            task.setFlag18((metaData[39] & 0x40) != 0);
            task.setFlag19((metaData[39] & 0x80) != 0);
            task.setFlag20((metaData[40] & 1) != 0);
            task.setFreeSlack(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 24), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 64))));
            task.setHideBar((metaData[10] & 0x80) != 0);
            this.processHyperlinkData(task, taskVarData.getByteArray(id, TASK_HYPERLINK));
            task.setID(MPPUtility.getInt(data, 4));
            task.setIgnoreResourceCalendar((metaData[10] & 2) != 0);
            task.setLateFinish(MPPUtility.getTimestamp(data, 152));
            task.setLateStart(MPPUtility.getTimestamp(data, 12));
            task.setLevelAssignments((metaData[13] & 4) != 0);
            task.setLevelingCanSplit((metaData[13] & 2) != 0);
            task.setLevelingDelay(MPPUtility.getDuration((double)MPPUtility.getInt(data, 82) / 3.0, MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 86))));
            task.setMarked((metaData[9] & 0x40) != 0);
            task.setMilestone((metaData[8] & 0x20) != 0);
            task.setName(taskVarData.getUnicodeString(id, TASK_NAME));
            task.setNumber1(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER1)));
            task.setNumber2(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER2)));
            task.setNumber3(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER3)));
            task.setNumber4(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER4)));
            task.setNumber5(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER5)));
            task.setNumber6(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER6)));
            task.setNumber7(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER7)));
            task.setNumber8(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER8)));
            task.setNumber9(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER9)));
            task.setNumber10(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER10)));
            task.setNumber11(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER11)));
            task.setNumber12(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER12)));
            task.setNumber13(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER13)));
            task.setNumber14(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER14)));
            task.setNumber15(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER15)));
            task.setNumber16(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER16)));
            task.setNumber17(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER17)));
            task.setNumber18(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER18)));
            task.setNumber19(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER19)));
            task.setNumber20(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_NUMBER20)));
            task.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE1), OUTLINECODE_DATA));
            task.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE2), OUTLINECODE_DATA));
            task.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE3), OUTLINECODE_DATA));
            task.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE4), OUTLINECODE_DATA));
            task.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE5), OUTLINECODE_DATA));
            task.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE6), OUTLINECODE_DATA));
            task.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE7), OUTLINECODE_DATA));
            task.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE8), OUTLINECODE_DATA));
            task.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE9), OUTLINECODE_DATA));
            task.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString(taskVarData.getInt(id, TASK_OUTLINECODE10), OUTLINECODE_DATA));
            task.setOutlineLevel(MPPUtility.getShort(data, 40));
            task.setOvertimeCost(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_OVERTIME_COST) / 100.0));
            task.setPercentageComplete(NumberUtility.getDouble(MPPUtility.getShort(data, 122)));
            task.setPercentageWorkComplete(NumberUtility.getDouble(MPPUtility.getShort(data, 124)));
            task.setPreleveledFinish(MPPUtility.getTimestamp(data, 140));
            task.setPreleveledStart(MPPUtility.getTimestamp(data, 136));
            task.setPriority(Priority.getInstance(MPPUtility.getShort(data, 120)));
            task.setRecurring(recurringData != null);
            task.setRemainingCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 224) / 100.0));
            task.setRemainingDuration(MPPUtility.getDuration(MPPUtility.getInt(data, 70), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 64))));
            task.setRemainingOvertimeCost(NumberUtility.getDouble(taskVarData.getDouble(id, TASK_REMAINING_OVERTIME_COST) / 100.0));
            task.setRemainingOvertimeWork(Duration.getInstance(taskVarData.getDouble(id, TASK_REMAINING_OVERTIME_WORK) / 60000.0, TimeUnit.HOURS));
            task.setRemainingWork(Duration.getInstance(MPPUtility.getDouble(data, 192) / 60000.0, TimeUnit.HOURS));
            task.setResume(MPPUtility.getTimestamp(data, 20));
            task.setRollup((metaData[10] & 8) != 0);
            task.setStart(MPPUtility.getTimestamp(data, 88));
            task.setStartSlack(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 28), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 64))));
            task.setStart1(taskVarData.getTimestamp(id, TASK_START1));
            task.setStart2(taskVarData.getTimestamp(id, TASK_START2));
            task.setStart3(taskVarData.getTimestamp(id, TASK_START3));
            task.setStart4(taskVarData.getTimestamp(id, TASK_START4));
            task.setStart5(taskVarData.getTimestamp(id, TASK_START5));
            task.setStart6(taskVarData.getTimestamp(id, TASK_START6));
            task.setStart7(taskVarData.getTimestamp(id, TASK_START7));
            task.setStart8(taskVarData.getTimestamp(id, TASK_START8));
            task.setStart9(taskVarData.getTimestamp(id, TASK_START9));
            task.setStart10(taskVarData.getTimestamp(id, TASK_START10));
            task.setStop(MPPUtility.getTimestamp(data, 16));
            task.setSubprojectTasksUniqueIDOffset(taskVarData.getInt(id, TASK_SUBPROJECT_TASKS_UNIQUEID_OFFSET));
            task.setSubprojectTaskUniqueID(taskVarData.getInt(id, TASK_SUBPROJECTUNIQUETASKID));
            task.setSubprojectTaskID(taskVarData.getInt(id, TASK_SUBPROJECTTASKID));
            task.setSummaryProgress(MPPUtility.getTimestamp(data, 156));
            task.setText1(taskVarData.getUnicodeString(id, TASK_TEXT1));
            task.setText2(taskVarData.getUnicodeString(id, TASK_TEXT2));
            task.setText3(taskVarData.getUnicodeString(id, TASK_TEXT3));
            task.setText4(taskVarData.getUnicodeString(id, TASK_TEXT4));
            task.setText5(taskVarData.getUnicodeString(id, TASK_TEXT5));
            task.setText6(taskVarData.getUnicodeString(id, TASK_TEXT6));
            task.setText7(taskVarData.getUnicodeString(id, TASK_TEXT7));
            task.setText8(taskVarData.getUnicodeString(id, TASK_TEXT8));
            task.setText9(taskVarData.getUnicodeString(id, TASK_TEXT9));
            task.setText10(taskVarData.getUnicodeString(id, TASK_TEXT10));
            task.setText11(taskVarData.getUnicodeString(id, TASK_TEXT11));
            task.setText12(taskVarData.getUnicodeString(id, TASK_TEXT12));
            task.setText13(taskVarData.getUnicodeString(id, TASK_TEXT13));
            task.setText14(taskVarData.getUnicodeString(id, TASK_TEXT14));
            task.setText15(taskVarData.getUnicodeString(id, TASK_TEXT15));
            task.setText16(taskVarData.getUnicodeString(id, TASK_TEXT16));
            task.setText17(taskVarData.getUnicodeString(id, TASK_TEXT17));
            task.setText18(taskVarData.getUnicodeString(id, TASK_TEXT18));
            task.setText19(taskVarData.getUnicodeString(id, TASK_TEXT19));
            task.setText20(taskVarData.getUnicodeString(id, TASK_TEXT20));
            task.setText21(taskVarData.getUnicodeString(id, TASK_TEXT21));
            task.setText22(taskVarData.getUnicodeString(id, TASK_TEXT22));
            task.setText23(taskVarData.getUnicodeString(id, TASK_TEXT23));
            task.setText24(taskVarData.getUnicodeString(id, TASK_TEXT24));
            task.setText25(taskVarData.getUnicodeString(id, TASK_TEXT25));
            task.setText26(taskVarData.getUnicodeString(id, TASK_TEXT26));
            task.setText27(taskVarData.getUnicodeString(id, TASK_TEXT27));
            task.setText28(taskVarData.getUnicodeString(id, TASK_TEXT28));
            task.setText29(taskVarData.getUnicodeString(id, TASK_TEXT29));
            task.setText30(taskVarData.getUnicodeString(id, TASK_TEXT30));
            task.setType(TaskType.getInstance(MPPUtility.getShort(data, 126)));
            task.setUniqueID(id);
            task.setWBS(taskVarData.getUnicodeString(id, TASK_WBS));
            task.setWork(Duration.getInstance(MPPUtility.getDouble(data, 168) / 60000.0, TimeUnit.HOURS));
            task.setFinishSlack(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 32), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 64))));
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (task.getStart().getTime() < task.getLateStart().getTime()) {
                        task.setStart(task.getLateStart());
                    }
                    if (task.getFinish().getTime() >= task.getLateFinish().getTime()) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (task.getFinish().getTime() >= task.getStart().getTime()) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (recurringData != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file);
                }
                recurringTaskReader.processRecurringTask(task, recurringData);
            }
            if ((notes = taskVarData.getString(id, TASK_NOTES)) != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = rtf.strip(notes);
                }
                task.setNotes(notes);
            }
            if ((calendarID = MPPUtility.getInt(data, 160)) != -1 && (calendar = this.m_file.getBaseCalendarByUniqueID(calendarID)) != null) {
                task.setCalendar(calendar);
            }
            SubProject sp = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject(sp);
            if (sp != null) {
                task.setExternalTask(sp.isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(sp.getFullPath());
                }
            }
            if (task.getWBS() != null) {
                autoWBS = false;
            }
            if ((metaData[9] & 0x80) == 0) {
                task.setSplits(new LinkedList<DateRange>());
            }
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(id);
                task.setID(MPPUtility.getInt(data, 4));
                continue;
            }
            this.processTaskEnterpriseColumns(task, taskVarData);
            this.m_file.fireTaskReadEvent(task);
        }
        this.m_file.setAutoWBS(autoWBS);
        if (!externalTasks.isEmpty()) {
            this.processExternalTasks(externalTasks);
        }
    }

    private void processTaskEnterpriseColumns(Task task, Var2Data taskVarData) {
        byte[] data = taskVarData.getByteArray(task.getUniqueID(), TASK_ENTERPRISE_COLUMNS);
        if (data != null) {
            PropsBlock props = new PropsBlock(data);
            for (Integer key : props.keySet()) {
                int keyValue = key - 0xB400000;
                TaskField field = MPPTaskField.getInstance(keyValue);
                if (field == null) continue;
                Object value = null;
                block0 : switch (field.getDataType()) {
                    case CURRENCY: {
                        value = props.getDouble(key) / 100.0;
                        break;
                    }
                    case DATE: {
                        value = props.getTimestamp(key);
                        break;
                    }
                    case DURATION: {
                        double durationValueInHours;
                        byte[] durationData = props.getByteArray(key);
                        switch (field.getValue()) {
                            case 246: 
                            case 251: 
                            case 256: 
                            case 261: 
                            case 266: 
                            case 271: 
                            case 276: 
                            case 281: 
                            case 286: 
                            case 291: {
                                durationValueInHours = MPPUtility.getDouble(durationData) / 60000.0;
                                value = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                                break block0;
                            }
                        }
                        durationValueInHours = (double)MPPUtility.getInt(durationData, 0) / 600.0;
                        TimeUnit durationUnits = MPPUtility.getDurationTimeUnits(MPPUtility.getInt(durationData, 4));
                        Duration duration = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        value = duration.convertUnits(durationUnits, this.m_file.getProjectHeader());
                        break;
                    }
                    case BOOLEAN: {
                        field = null;
                        int bits = props.getInt(key);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (bits & 2) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (bits & 4) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (bits & 8) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (bits & 0x10) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (bits & 0x20) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (bits & 0x40) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (bits & 0x80) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (bits & 0x100) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (bits & 0x200) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (bits & 0x400) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (bits & 0x800) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (bits & 0x1000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (bits & 0x2000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (bits & 0x4000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (bits & 0x8000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (bits & 0x10000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (bits & 0x20000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (bits & 0x40000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (bits & 0x80000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (bits & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        value = props.getDouble(key);
                        break;
                    }
                    case STRING: {
                        value = props.getUnicodeString(key);
                        break;
                    }
                }
                task.set((FieldType)field, value);
            }
        }
    }

    private void processResourceEnterpriseColumns(Resource resource, Var2Data resourceVarData) {
        byte[] data = resourceVarData.getByteArray(resource.getUniqueID(), RESOURCE_ENTERPRISE_COLUMNS);
        if (data != null) {
            PropsBlock props = new PropsBlock(data);
            resource.setCreationDate(props.getTimestamp(Props.RESOURCE_CREATION_DATE));
            for (Integer key : props.keySet()) {
                int keyValue = key - 0xC400000;
                ResourceField field = MPPResourceField.getInstance(keyValue);
                if (field == null) continue;
                Object value = null;
                switch (field.getDataType()) {
                    case CURRENCY: {
                        value = props.getDouble(key) / 100.0;
                        break;
                    }
                    case DATE: {
                        value = props.getTimestamp(key);
                        break;
                    }
                    case DURATION: {
                        byte[] durationData = props.getByteArray(key);
                        double durationValueInHours = (double)MPPUtility.getInt(durationData, 0) / 600.0;
                        TimeUnit durationUnits = MPPUtility.getDurationTimeUnits(MPPUtility.getInt(durationData, 4));
                        Duration duration = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        value = duration.convertUnits(durationUnits, this.m_file.getProjectHeader());
                        break;
                    }
                    case BOOLEAN: {
                        field = null;
                        int bits = props.getInt(key);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (bits & 2) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (bits & 4) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (bits & 8) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (bits & 0x10) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (bits & 0x20) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (bits & 0x40) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (bits & 0x80) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (bits & 0x100) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (bits & 0x200) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (bits & 0x400) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (bits & 0x800) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (bits & 0x1000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (bits & 0x2000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (bits & 0x4000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (bits & 0x8000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (bits & 0x10000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (bits & 0x20000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (bits & 0x40000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (bits & 0x80000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (bits & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        value = props.getDouble(key);
                        break;
                    }
                    case STRING: {
                        value = props.getUnicodeString(key);
                        break;
                    }
                }
                resource.set((FieldType)field, value);
            }
        }
    }

    private void processExternalTasks(List<Task> externalTasks) {
        Collections.sort(externalTasks);
        SubProject currentSubProject = null;
        for (Task currentTask : externalTasks) {
            SubProject sp = currentTask.getSubProject();
            if (sp == null) {
                currentTask.setSubProject(currentSubProject);
            } else {
                currentSubProject = sp;
            }
            if (currentSubProject == null) continue;
            currentTask.setProject(currentSubProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            task.setHyperlink(hyperlink);
            task.setHyperlinkAddress(address);
            task.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            resource.setHyperlink(hyperlink);
            resource.setHyperlinkAddress(address);
            resource.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processConstraintData() throws IOException {
        DirectoryEntry consDir;
        try {
            consDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException ex) {
            consDir = null;
        }
        if (consDir != null) {
            FixedMeta consFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)consDir.getEntry("FixedMeta")), 10);
            FixedData consFixedData = new FixedData(consFixedMeta, 20, this.getEncryptableInputStream(consDir, "FixedData"));
            int count = consFixedMeta.getItemCount();
            int lastConstraintID = -1;
            for (int loop = 0; loop < count; ++loop) {
                int taskID2;
                byte[] data;
                int constraintID;
                int index;
                byte[] metaData = consFixedMeta.getByteArrayValue(loop);
                if (MPPUtility.getShort(metaData, 0) != 0 || (index = consFixedData.getIndexFromOffset(MPPUtility.getInt(metaData, 4))) == -1 || (constraintID = MPPUtility.getInt(data = consFixedData.getByteArrayValue(index), 0)) <= lastConstraintID) continue;
                lastConstraintID = constraintID;
                int taskID1 = MPPUtility.getInt(data, 4);
                if (taskID1 == (taskID2 = MPPUtility.getInt(data, 8))) continue;
                Task task1 = this.m_file.getTaskByUniqueID(taskID1);
                Task task2 = this.m_file.getTaskByUniqueID(taskID2);
                if (task1 == null || task2 == null) continue;
                Relation rel = task2.addPredecessor(task1);
                rel.setType(RelationType.getInstance(MPPUtility.getShort(data, 12)));
                TimeUnit durationUnits = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 14));
                rel.setDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 16), durationUnits));
            }
        }
    }

    private void processResourceData() throws IOException {
        DirectoryEntry rscDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta9 rscVarMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("VarMeta")));
        Var2Data rscVarData = new Var2Data(rscVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("Var2Data")));
        FixedMeta rscFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("FixedMeta")), 37);
        FixedData rscFixedData = new FixedData(rscFixedMeta, this.getEncryptableInputStream(rscDir, "FixedData"));
        TreeMap<Integer, Integer> resourceMap = this.createResourceMap(rscFixedMeta, rscFixedData);
        Integer[] uniqueid = rscVarMeta.getUniqueIdentifierArray();
        RTFUtility rtf = new RTFUtility();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            Integer id = uniqueid[loop];
            Integer offset = resourceMap.get(id);
            if (offset == null) continue;
            byte[] data = rscFixedData.getByteArrayValue(offset);
            Resource resource = this.m_file.addResource();
            resource.setAccrueAt(AccrueType.getInstance(MPPUtility.getShort(data, 12)));
            resource.setActualCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 132) / 100.0));
            resource.setActualOvertimeCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 172) / 100.0));
            resource.setActualOvertimeWork(Duration.getInstance(MPPUtility.getDouble(data, 108) / 60000.0, TimeUnit.HOURS));
            resource.setActualWork(Duration.getInstance(MPPUtility.getDouble(data, 60) / 60000.0, TimeUnit.HOURS));
            resource.setAvailableFrom(MPPUtility.getTimestamp(data, 20));
            resource.setAvailableTo(MPPUtility.getTimestamp(data, 24));
            resource.setBaselineCost(1, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE1_COST) / 100.0));
            resource.setBaselineCost(2, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE2_COST) / 100.0));
            resource.setBaselineCost(3, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE3_COST) / 100.0));
            resource.setBaselineCost(4, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE4_COST) / 100.0));
            resource.setBaselineCost(5, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE5_COST) / 100.0));
            resource.setBaselineCost(6, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE6_COST) / 100.0));
            resource.setBaselineCost(7, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE7_COST) / 100.0));
            resource.setBaselineCost(8, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE8_COST) / 100.0));
            resource.setBaselineCost(9, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE9_COST) / 100.0));
            resource.setBaselineCost(10, NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_BASELINE10_COST) / 100.0));
            resource.setBaselineWork(1, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE1_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(2, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE2_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(3, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE3_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(4, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE4_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(5, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE5_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(6, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE6_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(7, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE7_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(8, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE8_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(9, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE9_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineWork(10, Duration.getInstance(rscVarData.getDouble(id, RESOURCE_BASELINE10_WORK) / 60000.0, TimeUnit.HOURS));
            resource.setBaselineCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 148) / 100.0));
            resource.setBaselineWork(Duration.getInstance(MPPUtility.getDouble(data, 68) / 60000.0, TimeUnit.HOURS));
            resource.setCode(rscVarData.getUnicodeString(id, RESOURCE_CODE));
            resource.setCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 140) / 100.0));
            resource.setCost1(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST1) / 100.0));
            resource.setCost2(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST2) / 100.0));
            resource.setCost3(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST3) / 100.0));
            resource.setCost4(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST4) / 100.0));
            resource.setCost5(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST5) / 100.0));
            resource.setCost6(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST6) / 100.0));
            resource.setCost7(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST7) / 100.0));
            resource.setCost8(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST8) / 100.0));
            resource.setCost9(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST9) / 100.0));
            resource.setCost10(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_COST10) / 100.0));
            resource.setCostPerUse(NumberUtility.getDouble(MPPUtility.getDouble(data, 84) / 100.0));
            resource.setDate1(rscVarData.getTimestamp(id, RESOURCE_DATE1));
            resource.setDate2(rscVarData.getTimestamp(id, RESOURCE_DATE2));
            resource.setDate3(rscVarData.getTimestamp(id, RESOURCE_DATE3));
            resource.setDate4(rscVarData.getTimestamp(id, RESOURCE_DATE4));
            resource.setDate5(rscVarData.getTimestamp(id, RESOURCE_DATE5));
            resource.setDate6(rscVarData.getTimestamp(id, RESOURCE_DATE6));
            resource.setDate7(rscVarData.getTimestamp(id, RESOURCE_DATE7));
            resource.setDate8(rscVarData.getTimestamp(id, RESOURCE_DATE8));
            resource.setDate9(rscVarData.getTimestamp(id, RESOURCE_DATE9));
            resource.setDate10(rscVarData.getTimestamp(id, RESOURCE_DATE10));
            resource.setDuration1(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION1), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION1_UNITS))));
            resource.setDuration2(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION2), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION2_UNITS))));
            resource.setDuration3(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION3), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION3_UNITS))));
            resource.setDuration4(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION4), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION4_UNITS))));
            resource.setDuration5(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION5), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION5_UNITS))));
            resource.setDuration6(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION6), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION6_UNITS))));
            resource.setDuration7(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION7), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION7_UNITS))));
            resource.setDuration8(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION8), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION8_UNITS))));
            resource.setDuration9(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION9), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION9_UNITS))));
            resource.setDuration10(MPPUtility.getDuration(rscVarData.getInt(id, RESOURCE_DURATION10), MPPUtility.getDurationTimeUnits(rscVarData.getShort(id, RESOURCE_DURATION10_UNITS))));
            resource.setEmailAddress(rscVarData.getUnicodeString(id, RESOURCE_EMAIL));
            resource.setFinish1(rscVarData.getTimestamp(id, RESOURCE_FINISH1));
            resource.setFinish2(rscVarData.getTimestamp(id, RESOURCE_FINISH2));
            resource.setFinish3(rscVarData.getTimestamp(id, RESOURCE_FINISH3));
            resource.setFinish4(rscVarData.getTimestamp(id, RESOURCE_FINISH4));
            resource.setFinish5(rscVarData.getTimestamp(id, RESOURCE_FINISH5));
            resource.setFinish6(rscVarData.getTimestamp(id, RESOURCE_FINISH6));
            resource.setFinish7(rscVarData.getTimestamp(id, RESOURCE_FINISH7));
            resource.setFinish8(rscVarData.getTimestamp(id, RESOURCE_FINISH8));
            resource.setFinish9(rscVarData.getTimestamp(id, RESOURCE_FINISH9));
            resource.setFinish10(rscVarData.getTimestamp(id, RESOURCE_FINISH10));
            resource.setGroup(rscVarData.getUnicodeString(id, RESOURCE_GROUP));
            this.processHyperlinkData(resource, rscVarData.getByteArray(id, RESOURCE_HYPERLINK));
            resource.setID(MPPUtility.getInt(data, 4));
            resource.setInitials(rscVarData.getUnicodeString(id, RESOURCE_INITIALS));
            resource.setMaterialLabel(rscVarData.getUnicodeString(id, RESOURCE_MATERIAL_LABEL));
            resource.setMaxUnits(NumberUtility.getDouble(MPPUtility.getDouble(data, 44) / 100.0));
            resource.setName(rscVarData.getUnicodeString(id, RESOURCE_NAME));
            resource.setNtAccount(rscVarData.getUnicodeString(id, RESOURCE_NT_ACCOUNT));
            resource.setNumber1(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER1)));
            resource.setNumber2(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER2)));
            resource.setNumber3(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER3)));
            resource.setNumber4(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER4)));
            resource.setNumber5(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER5)));
            resource.setNumber6(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER6)));
            resource.setNumber7(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER7)));
            resource.setNumber8(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER8)));
            resource.setNumber9(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER9)));
            resource.setNumber10(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER10)));
            resource.setNumber11(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER11)));
            resource.setNumber12(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER12)));
            resource.setNumber13(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER13)));
            resource.setNumber14(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER14)));
            resource.setNumber15(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER15)));
            resource.setNumber16(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER16)));
            resource.setNumber17(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER17)));
            resource.setNumber18(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER18)));
            resource.setNumber19(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER19)));
            resource.setNumber20(NumberUtility.getDouble(rscVarData.getDouble(id, RESOURCE_NUMBER20)));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE1), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE2), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE3), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE4), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE5), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE6), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE7), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE8), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE9), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString(rscVarData.getInt(id, RESOURCE_OUTLINECODE10), OUTLINECODE_DATA));
            resource.setOvertimeCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 164) / 100.0));
            resource.setOvertimeRate(new Rate(MPPUtility.getDouble(data, 36), TimeUnit.HOURS));
            resource.setOvertimeWork(Duration.getInstance(MPPUtility.getDouble(data, 76) / 60000.0, TimeUnit.HOURS));
            resource.setPeakUnits(NumberUtility.getDouble(MPPUtility.getDouble(data, 124) / 100.0));
            resource.setRegularWork(Duration.getInstance(MPPUtility.getDouble(data, 100) / 60000.0, TimeUnit.HOURS));
            resource.setRemainingCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 156) / 100.0));
            resource.setRemainingOvertimeCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 180) / 100.0));
            resource.setRemainingWork(Duration.getInstance(MPPUtility.getDouble(data, 92) / 60000.0, TimeUnit.HOURS));
            resource.setStandardRate(new Rate(MPPUtility.getDouble(data, 28), TimeUnit.HOURS));
            resource.setStart1(rscVarData.getTimestamp(id, RESOURCE_START1));
            resource.setStart2(rscVarData.getTimestamp(id, RESOURCE_START2));
            resource.setStart3(rscVarData.getTimestamp(id, RESOURCE_START3));
            resource.setStart4(rscVarData.getTimestamp(id, RESOURCE_START4));
            resource.setStart5(rscVarData.getTimestamp(id, RESOURCE_START5));
            resource.setStart6(rscVarData.getTimestamp(id, RESOURCE_START6));
            resource.setStart7(rscVarData.getTimestamp(id, RESOURCE_START7));
            resource.setStart8(rscVarData.getTimestamp(id, RESOURCE_START8));
            resource.setStart9(rscVarData.getTimestamp(id, RESOURCE_START9));
            resource.setStart10(rscVarData.getTimestamp(id, RESOURCE_START10));
            resource.setSubprojectResourceUniqueID(rscVarData.getInt(id, RESOURCE_SUBPROJECTRESOURCEID));
            resource.setText1(rscVarData.getUnicodeString(id, RESOURCE_TEXT1));
            resource.setText2(rscVarData.getUnicodeString(id, RESOURCE_TEXT2));
            resource.setText3(rscVarData.getUnicodeString(id, RESOURCE_TEXT3));
            resource.setText4(rscVarData.getUnicodeString(id, RESOURCE_TEXT4));
            resource.setText5(rscVarData.getUnicodeString(id, RESOURCE_TEXT5));
            resource.setText6(rscVarData.getUnicodeString(id, RESOURCE_TEXT6));
            resource.setText7(rscVarData.getUnicodeString(id, RESOURCE_TEXT7));
            resource.setText8(rscVarData.getUnicodeString(id, RESOURCE_TEXT8));
            resource.setText9(rscVarData.getUnicodeString(id, RESOURCE_TEXT9));
            resource.setText10(rscVarData.getUnicodeString(id, RESOURCE_TEXT10));
            resource.setText11(rscVarData.getUnicodeString(id, RESOURCE_TEXT11));
            resource.setText12(rscVarData.getUnicodeString(id, RESOURCE_TEXT12));
            resource.setText13(rscVarData.getUnicodeString(id, RESOURCE_TEXT13));
            resource.setText14(rscVarData.getUnicodeString(id, RESOURCE_TEXT14));
            resource.setText15(rscVarData.getUnicodeString(id, RESOURCE_TEXT15));
            resource.setText16(rscVarData.getUnicodeString(id, RESOURCE_TEXT16));
            resource.setText17(rscVarData.getUnicodeString(id, RESOURCE_TEXT17));
            resource.setText18(rscVarData.getUnicodeString(id, RESOURCE_TEXT18));
            resource.setText19(rscVarData.getUnicodeString(id, RESOURCE_TEXT19));
            resource.setText20(rscVarData.getUnicodeString(id, RESOURCE_TEXT20));
            resource.setText21(rscVarData.getUnicodeString(id, RESOURCE_TEXT21));
            resource.setText22(rscVarData.getUnicodeString(id, RESOURCE_TEXT22));
            resource.setText23(rscVarData.getUnicodeString(id, RESOURCE_TEXT23));
            resource.setText24(rscVarData.getUnicodeString(id, RESOURCE_TEXT24));
            resource.setText25(rscVarData.getUnicodeString(id, RESOURCE_TEXT25));
            resource.setText26(rscVarData.getUnicodeString(id, RESOURCE_TEXT26));
            resource.setText27(rscVarData.getUnicodeString(id, RESOURCE_TEXT27));
            resource.setText28(rscVarData.getUnicodeString(id, RESOURCE_TEXT28));
            resource.setText29(rscVarData.getUnicodeString(id, RESOURCE_TEXT29));
            resource.setText30(rscVarData.getUnicodeString(id, RESOURCE_TEXT30));
            resource.setType(MPPUtility.getShort(data, 14) == 0 ? ResourceType.WORK : ResourceType.MATERIAL);
            resource.setUniqueID(id);
            resource.setWork(Duration.getInstance(MPPUtility.getDouble(data, 52) / 60000.0, TimeUnit.HOURS));
            byte[] metaData = rscFixedMeta.getByteArrayValue(offset);
            resource.setFlag1((metaData[28] & 0x40) != 0);
            resource.setFlag2((metaData[28] & 0x80) != 0);
            resource.setFlag3((metaData[29] & 1) != 0);
            resource.setFlag4((metaData[29] & 2) != 0);
            resource.setFlag5((metaData[29] & 4) != 0);
            resource.setFlag6((metaData[29] & 8) != 0);
            resource.setFlag7((metaData[29] & 0x10) != 0);
            resource.setFlag8((metaData[29] & 0x20) != 0);
            resource.setFlag9((metaData[29] & 0x40) != 0);
            resource.setFlag10((metaData[28] & 0x20) != 0);
            resource.setFlag11((metaData[29] & 0x20) != 0);
            resource.setFlag12((metaData[30] & 1) != 0);
            resource.setFlag13((metaData[30] & 2) != 0);
            resource.setFlag14((metaData[30] & 4) != 0);
            resource.setFlag15((metaData[30] & 8) != 0);
            resource.setFlag16((metaData[30] & 0x10) != 0);
            resource.setFlag17((metaData[30] & 0x20) != 0);
            resource.setFlag18((metaData[30] & 0x40) != 0);
            resource.setFlag19((metaData[30] & 0x80) != 0);
            resource.setFlag20((metaData[31] & 1) != 0);
            String notes = rscVarData.getString(id, RESOURCE_NOTES);
            if (notes != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = rtf.strip(notes);
                }
                resource.setNotes(notes);
            }
            resource.setResourceCalendar(this.m_resourceMap.get(id));
            this.processResourceEnterpriseColumns(resource, rscVarData);
            this.m_file.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        DirectoryEntry assnDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta9 assnVarMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("VarMeta")));
        Var2Data assnVarData = new Var2Data(assnVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("Var2Data")));
        FixedMeta assnFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixedMeta")), 34);
        FixedData assnFixedData = new FixedData(142, this.getEncryptableInputStream(assnDir, "FixedData"));
        Set<Integer> set = assnVarMeta.getUniqueIdentifierSet();
        int count = assnFixedMeta.getItemCount();
        TimephasedResourceAssignmentFactory timephasedFactory = new TimephasedResourceAssignmentFactory();
        SplitTaskFactory splitFactory = new SplitTaskFactory();
        MPPTimephasedResourceAssignmentNormaliser normaliser = new MPPTimephasedResourceAssignmentNormaliser();
        for (int loop = 0; loop < count; ++loop) {
            Integer taskID;
            Task task;
            int id;
            Integer varDataId;
            int offset;
            byte[] data;
            byte[] meta = assnFixedMeta.getByteArrayValue(loop);
            if (meta[0] != 0 || (data = assnFixedData.getByteArrayValue(assnFixedData.getIndexFromOffset(offset = MPPUtility.getInt(meta, 4)))) == null || !set.contains(varDataId = Integer.valueOf(id = MPPUtility.getInt(data, 0))) || (task = this.m_file.getTaskByUniqueID(taskID = Integer.valueOf(MPPUtility.getInt(data, 4)))) == null) continue;
            Integer resourceID = MPPUtility.getInt(data, 8);
            Resource resource = this.m_file.getResourceByUniqueID(resourceID);
            ProjectCalendar calendar = null;
            if (resource != null) {
                calendar = resource.getResourceCalendar();
            }
            if (calendar == null) {
                task.getCalendar();
            }
            if (calendar == null) {
                calendar = this.m_file.getCalendar();
            }
            Date assignmentStart = MPPUtility.getTimestamp(data, 12);
            double assignmentUnits = MPPUtility.getDouble(data, 54) / 100.0;
            byte[] completeWork = assnVarData.getByteArray(assnVarMeta.getOffset(varDataId, COMPLETE_WORK));
            byte[] plannedWork = assnVarData.getByteArray(assnVarMeta.getOffset(varDataId, PLANNED_WORK));
            List<TimephasedResourceAssignment> timephasedComplete = timephasedFactory.getCompleteWork(calendar, assignmentStart, completeWork);
            List<TimephasedResourceAssignment> timephasedPlanned = timephasedFactory.getPlannedWork(calendar, assignmentStart, assignmentUnits, plannedWork, timephasedComplete);
            if (task.getSplits() != null && task.getSplits().isEmpty()) {
                splitFactory.processSplitData(task, timephasedComplete, timephasedPlanned);
            }
            if (resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setTimephasedNormaliser(normaliser);
            assignment.setActualCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 110) / 100.0));
            assignment.setActualWork(MPPUtility.getDuration(MPPUtility.getDouble(data, 70) / 100.0, TimeUnit.HOURS));
            assignment.setCost(NumberUtility.getDouble(MPPUtility.getDouble(data, 102) / 100.0));
            assignment.setDelay(MPPUtility.getDuration(MPPUtility.getShort(data, 24), TimeUnit.HOURS));
            assignment.setFinish(MPPUtility.getTimestamp(data, 16));
            assignment.setRemainingWork(MPPUtility.getDuration(MPPUtility.getDouble(data, 86) / 100.0, TimeUnit.HOURS));
            assignment.setStart(assignmentStart);
            assignment.setUnits(assignmentUnits);
            assignment.setWork(MPPUtility.getDuration(MPPUtility.getDouble(data, 62) / 100.0, TimeUnit.HOURS));
            if (timephasedPlanned.isEmpty() && timephasedComplete.isEmpty()) {
                Duration workPerDay = DEFAULT_NORMALIZER_WORK_PER_DAY;
                int units = NumberUtility.getInt(assignment.getUnits());
                if (units != 100) {
                    workPerDay = Duration.getInstance(workPerDay.getDuration() * (double)units / 100.0, workPerDay.getUnits());
                }
                TimephasedResourceAssignment tra = new TimephasedResourceAssignment();
                tra.setStart(assignmentStart);
                tra.setWorkPerDay(workPerDay);
                tra.setModified(false);
                tra.setFinish(assignment.getFinish());
                tra.setTotalWork(assignment.getWork().convertUnits(TimeUnit.MINUTES, this.m_file.getProjectHeader()));
                timephasedPlanned.add(tra);
            }
            assignment.setTimephasedPlanned(timephasedPlanned, true);
            assignment.setTimephasedComplete(timephasedComplete, true);
            if (plannedWork == null) continue;
            if (timephasedFactory.getWorkModified(timephasedPlanned)) {
                assignment.setWorkContour(WorkContour.CONTOURED);
                continue;
            }
            assignment.setWorkContour(WorkContour.getInstance(MPPUtility.getShort(plannedWork, 28)));
        }
    }

    private boolean getDurationEstimated(int type) {
        return (type & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta9 viewVarMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data viewVarData = new Var2Data(viewVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(122, this.getEncryptableInputStream(dir, "FixedData"));
        int items = fixedMeta.getItemCount();
        ViewFactory9 factory = new ViewFactory9();
        int lastOffset = -1;
        for (int loop = 0; loop < items; ++loop) {
            byte[] fm = fixedMeta.getByteArrayValue(loop);
            int offset = MPPUtility.getShort(fm, 4);
            if (offset <= lastOffset) continue;
            byte[] fd = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(offset));
            if (fd != null) {
                View view = factory.createView(this.m_file, fm, fd, viewVarData, this.m_fontBases);
                this.m_file.addView(view);
            }
            lastOffset = offset;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(dir, "FixedData"));
        VarMeta9 varMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        TableFactory factory = new TableFactory(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int items = fixedData.getItemCount();
        for (int loop = 0; loop < items; ++loop) {
            byte[] data = fixedData.getByteArrayValue(loop);
            Table table = factory.createTable(this.m_file, data, varMeta, varData);
            this.m_file.addTable(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(dir, "FixedData"), true);
        VarMeta9 varMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FilterReader9 reader = new FilterReader9();
        reader.process(this.m_file, fixedData, varData);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(dir, "FixedData"));
        VarMeta9 varMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        GroupReader9 reader = new GroupReader9();
        reader.process(this.m_file, fixedData, varData, this.m_fontBases);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta9 varMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, (InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        InputStream is = this.getEncryptableInputStream(dir, "FixedData");
        byte[] fixedData = new byte[is.available()];
        is.read(fixedData);
        ViewStateReader9 reader = new ViewStateReader9();
        reader.process(this.m_file, varData, fixedData);
    }

    private InputStream getEncryptableInputStream(DirectoryEntry directory, String name) throws IOException {
        DocumentEntry entry = (DocumentEntry)directory.getEntry(name);
        Object stream = this.m_file.getEncoded() ? new EncryptedDocumentInputStream(entry, this.m_file.getEncryptionCode()) : new DocumentInputStream(entry);
        return stream;
    }
}

