/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.FieldType;
import net.sf.mpxj.Filter;
import net.sf.mpxj.FilterCriteria;
import net.sf.mpxj.FilterCriteriaLogicType;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;

public abstract class FilterReader {
    protected abstract Integer getVarDataType();

    public void process(ProjectFile file, FixedData fixedData, Var2Data varData) {
        boolean lastLogicalAnd = true;
        int filterCount = fixedData.getItemCount();
        for (int filterLoop = 0; filterLoop < filterCount; ++filterLoop) {
            byte[] filterFixedData = fixedData.getByteArrayValue(filterLoop);
            if (filterFixedData == null || filterFixedData.length < 4) continue;
            Filter filter = new Filter();
            filter.setID(MPPUtility.getInt(filterFixedData, 0));
            filter.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(filterFixedData, 4)));
            byte[] filterVarData = varData.getByteArray(filter.getID(), this.getVarDataType());
            if (filterVarData == null) continue;
            int varDataOffset = MPPUtility.getInt(filterVarData, 16);
            filter.setShowRelatedSummaryRows(MPPUtility.getByte(filterVarData, 4) != 0);
            int offset = 180;
            block11: while (offset + 240 <= varDataOffset) {
                String prompt;
                Object value;
                FilterCriteria criteria = new FilterCriteria(file);
                filter.addCriteria(criteria);
                int operatorValue = MPPUtility.getInt(filterVarData, offset);
                criteria.setOperator(TestOperator.getInstance(operatorValue - 999));
                int fieldType = MPPUtility.getShort(filterVarData, offset + 120);
                int entityType = MPPUtility.getByte(filterVarData, offset + 123);
                FieldType type = null;
                switch (entityType) {
                    case 11: {
                        type = MPPTaskField.getInstance(fieldType);
                        break;
                    }
                    case 12: {
                        type = MPPResourceField.getInstance(fieldType);
                    }
                }
                criteria.setField(type);
                if (MPPUtility.getByte(filterVarData, offset + 224) == 0) {
                    value = this.getValue(file, type, filterVarData, offset, varDataOffset);
                    criteria.setValue(0, value);
                } else {
                    prompt = this.getPrompt(filterVarData, offset, varDataOffset);
                    criteria.setPromptText(0, prompt);
                }
                if (criteria.getOperator() == TestOperator.IS_WITHIN || criteria.getOperator() == TestOperator.IS_NOT_WITHIN) {
                    if (MPPUtility.getByte(filterVarData, offset + 224 + 80) == 0) {
                        value = this.getValue(file, type, filterVarData, offset + 80, varDataOffset);
                        criteria.setValue(1, value);
                    } else {
                        prompt = this.getPrompt(filterVarData, offset + 80, varDataOffset);
                        criteria.setPromptText(1, prompt);
                    }
                    offset += 320;
                } else {
                    offset += 240;
                }
                if (offset + 80 > varDataOffset) {
                    criteria.setCriteriaLogic(FilterCriteriaLogicType.IN_BLOCK_AND);
                    continue;
                }
                int logicalOperator = MPPUtility.getShort(filterVarData, offset);
                switch (logicalOperator) {
                    case 25: {
                        criteria.setCriteriaLogic(FilterCriteriaLogicType.IN_BLOCK_AND);
                        lastLogicalAnd = true;
                        offset += 80;
                        continue block11;
                    }
                    case 27: {
                        criteria.setCriteriaLogic(FilterCriteriaLogicType.BETWEEN_BLOCK_AND);
                        lastLogicalAnd = true;
                        offset += 80;
                        continue block11;
                    }
                    case 26: {
                        criteria.setCriteriaLogic(FilterCriteriaLogicType.IN_BLOCK_OR);
                        lastLogicalAnd = false;
                        offset += 80;
                        continue block11;
                    }
                    case 28: {
                        criteria.setCriteriaLogic(FilterCriteriaLogicType.BETWEEN_BLOCK_OR);
                        lastLogicalAnd = false;
                        offset += 80;
                        continue block11;
                    }
                }
                if (lastLogicalAnd) {
                    criteria.setCriteriaLogic(FilterCriteriaLogicType.IN_BLOCK_AND);
                    continue;
                }
                criteria.setCriteriaLogic(FilterCriteriaLogicType.IN_BLOCK_OR);
            }
            file.addFilter(filter);
        }
    }

    private Object getValue(ProjectFile file, FieldType type, byte[] filterVarData, int offset, int varDataOffset) {
        boolean valueFlag;
        Object value = null;
        boolean bl = valueFlag = MPPUtility.getInt(filterVarData, offset + 160) == 1;
        if (!valueFlag) {
            int field = MPPUtility.getShort(filterVarData, offset + 200);
            value = type instanceof TaskField ? MPPTaskField.getInstance(field) : MPPResourceField.getInstance(field);
        } else {
            switch (type.getDataType()) {
                case DURATION: {
                    value = MPPUtility.getAdjustedDuration(file, MPPUtility.getInt(filterVarData, offset + 192), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(filterVarData, offset + 192)));
                    break;
                }
                case NUMERIC: {
                    value = MPPUtility.getDouble(filterVarData, offset + 192);
                    break;
                }
                case PERCENTAGE: {
                    value = (double)MPPUtility.getInt(filterVarData, offset + 192);
                    break;
                }
                case CURRENCY: {
                    value = MPPUtility.getDouble(filterVarData, offset + 192) / 100.0;
                    break;
                }
                case STRING: {
                    int textOffset = MPPUtility.getShort(filterVarData, offset + 228);
                    value = MPPUtility.getUnicodeString(filterVarData, varDataOffset + textOffset);
                    break;
                }
                case BOOLEAN: {
                    int intValue = MPPUtility.getShort(filterVarData, offset + 192);
                    value = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case DATE: {
                    value = MPPUtility.getTimestamp(filterVarData, offset + 192);
                    break;
                }
            }
        }
        return value;
    }

    private String getPrompt(byte[] filterVarData, int offset, int varDataOffset) {
        int textOffset = MPPUtility.getShort(filterVarData, offset + 232);
        String value = MPPUtility.getUnicodeString(filterVarData, varDataOffset + textOffset);
        return value;
    }
}

