/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;

public class SplitTaskTest
extends MPXJTestCase {
    private DateFormat m_df = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public void testSplits1() throws Exception {
        List<DateRange> taskSplits;
        int taskID;
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/splits9a.mpp");
        Task task = mpp.getTaskByUniqueID(1);
        SplitTaskTest.assertNull(task.getSplits());
        for (taskID = 2; taskID <= 6; ++taskID) {
            task = mpp.getTaskByUniqueID(taskID);
            taskSplits = task.getSplits();
            SplitTaskTest.assertEquals((int)3, (int)taskSplits.size());
            this.testSplit(taskSplits.get(0), "06/01/2006 08:00", "11/01/2006 17:00");
            this.testSplit(taskSplits.get(2), "13/01/2006 08:00", "20/01/2006 17:00");
        }
        for (taskID = 7; taskID <= 13; ++taskID) {
            task = mpp.getTaskByUniqueID(taskID);
            taskSplits = task.getSplits();
            SplitTaskTest.assertEquals((int)5, (int)taskSplits.size());
            this.testSplit(taskSplits.get(0), "06/01/2006 08:00", "09/01/2006 17:00");
            this.testSplit(taskSplits.get(2), "16/01/2006 08:00", "20/01/2006 17:00");
            this.testSplit(taskSplits.get(4), "25/01/2006 08:00", "27/01/2006 17:00");
        }
    }

    public void testSplits2() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/splits9b.mpp");
        Task task = mpp.getTaskByUniqueID(1);
        List<DateRange> taskSplits = task.getSplits();
        SplitTaskTest.assertEquals((int)5, (int)taskSplits.size());
        this.testSplit(taskSplits.get(0), "26/08/2005 08:00", "29/08/2005 17:00");
        this.testSplit(taskSplits.get(1), "30/08/2005 08:00", "01/09/2005 17:00");
        this.testSplit(taskSplits.get(2), "02/09/2005 08:00", "06/09/2005 17:00");
        this.testSplit(taskSplits.get(3), "07/09/2005 08:00", "09/09/2005 17:00");
        this.testSplit(taskSplits.get(4), "12/09/2005 08:00", "16/09/2005 17:00");
        task = mpp.getTaskByUniqueID(3);
        SplitTaskTest.assertNull(task.getSplits());
        task = mpp.getTaskByUniqueID(4);
        taskSplits = task.getSplits();
        SplitTaskTest.assertEquals((int)3, (int)taskSplits.size());
        this.testSplit(taskSplits.get(0), "29/08/2005 08:00", "31/08/2005 17:00");
        this.testSplit(taskSplits.get(1), "01/09/2005 08:00", "02/09/2005 17:00");
        this.testSplit(taskSplits.get(2), "05/09/2005 08:00", "13/09/2005 17:00");
        task = mpp.getTaskByUniqueID(5);
        taskSplits = task.getSplits();
        SplitTaskTest.assertEquals((int)3, (int)taskSplits.size());
        this.testSplit(taskSplits.get(0), "26/08/2005 08:00", "07/09/2005 17:00");
        this.testSplit(taskSplits.get(1), "08/09/2005 08:00", "09/09/2005 17:00");
        this.testSplit(taskSplits.get(2), "12/09/2005 08:00", "26/09/2005 17:00");
    }

    private void testSplit(DateRange range, String start, String end) {
        SplitTaskTest.assertEquals((String)start, (String)this.m_df.format(range.getStart()));
        SplitTaskTest.assertEquals((String)end, (String)this.m_df.format(range.getEnd()));
    }
}

