/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;

public class ProjectCalendarTest
extends MPXJTestCase {
    public void testGetWork() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        ProjectFile project = new ProjectFile();
        ProjectCalendar projectCalendar = project.addDefaultBaseCalendar();
        Date startDate = df.parse("14/03/2006 08:00");
        Date endDate = df.parse("15/03/2006 08:00");
        Duration variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("13/03/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)-1.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("14/03/2006 08:00");
        endDate = df.parse("15/03/2006 09:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.13, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("15/03/2006 09:30");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.19, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("15/03/2006 12:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.5, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("15/03/2006 13:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.5, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("15/03/2006 14:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.63, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("15/03/2006 16:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.88, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("15/03/2006 17:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)2.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("16/03/2006 07:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)2.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("16/03/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)2.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("18/03/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)4.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("19/03/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)4.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("20/03/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)4.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("18/03/2006 08:00");
        endDate = df.parse("19/03/2006 17:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("18/03/2006 08:00");
        endDate = df.parse("20/03/2006 17:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("17/03/2006 08:00");
        endDate = df.parse("20/03/2006 17:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)2.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("17/03/2006 08:00");
        endDate = df.parse("18/03/2006 17:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("10/07/2006 08:00");
        endDate = df.parse("11/07/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("13/03/2006 08:00");
        endDate = df.parse("11/07/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)86.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("14/03/2006 08:00");
        endDate = df.parse("14/03/2006 08:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 09:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.13, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 10:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.25, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 11:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.38, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 12:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.5, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 13:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.5, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 16:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.88, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 17:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.0, (double)variance.getDuration(), (double)0.01);
        endDate = df.parse("14/03/2006 18:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)1.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("12/03/2006 08:00");
        endDate = df.parse("12/03/2006 17:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.0, (double)variance.getDuration(), (double)0.01);
        startDate = df.parse("13/03/2006 08:00");
        endDate = df.parse("24/03/2006 16:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)9.88, (double)variance.getDuration(), (double)0.01);
        ProjectCalendarException exception = projectCalendar.addCalendarException();
        exception.setFromDate(df.parse("14/03/2006 00:00"));
        exception.setToDate(df.parse("14/03/2006 23:59"));
        exception.setWorking(false);
        startDate = df.parse("13/03/2006 08:00");
        endDate = df.parse("24/03/2006 16:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)8.88, (double)variance.getDuration(), (double)0.01);
        exception = projectCalendar.addCalendarException();
        exception.setFromDate(df.parse("18/03/2006 00:00"));
        exception.setToDate(df.parse("18/03/2006 23:59"));
        exception.setWorking(true);
        exception.addRange(new DateRange(df.parse("18/03/2006 08:00"), df.parse("18/03/2006 12:00")));
        startDate = df.parse("18/03/2006 08:00");
        endDate = df.parse("18/03/2006 16:00");
        variance = projectCalendar.getWork(startDate, endDate, TimeUnit.DAYS);
        ProjectCalendarTest.assertEquals((double)0.5, (double)variance.getDuration(), (double)0.01);
    }

    public void testVarianceCalculations9() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile file = reader.read(this.m_basedir + "/DurationTest9.mpp");
        Task task = file.getTaskByID(1);
        Duration duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-59.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.MINUTES, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)-1.09, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getFinishVariance();
        ProjectCalendarTest.assertEquals((double)-1.97, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(2);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.98, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)0.94, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getFinishVariance();
        ProjectCalendarTest.assertEquals((double)0.13, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(3);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-4.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)0.88, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getFinishVariance();
        ProjectCalendarTest.assertEquals((double)-1.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(4);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.8, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.WEEKS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)0.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(5);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-1.45, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.MONTHS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)0.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(6);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-59.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.MINUTES, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)-5.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(7);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.98, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)-5.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(8);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-4.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)-5.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(9);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.8, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.WEEKS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)-6.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(10);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-1.5, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.MONTHS, (Object)duration.getUnits());
        task = file.getTaskByID(11);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-59.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.ELAPSED_MINUTES, (Object)duration.getUnits());
        task = file.getTaskByID(12);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.98, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.ELAPSED_HOURS, (Object)duration.getUnits());
        task = file.getTaskByID(13);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-0.67, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.ELAPSED_DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(14);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.95, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.ELAPSED_WEEKS, (Object)duration.getUnits());
        task = file.getTaskByID(15);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.44, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.ELAPSED_MONTHS, (Object)duration.getUnits());
    }

    public void testVarianceCalculations8() throws Exception {
        MPPReader reader = new MPPReader();
        ProjectFile file = reader.read(this.m_basedir + "/DurationTest8.mpp");
        Task task = file.getTaskByID(1);
        Duration duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-59.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.MINUTES, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)-1.09, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getFinishVariance();
        ProjectCalendarTest.assertEquals((double)-1.97, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(2);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.98, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.HOURS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)0.94, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getFinishVariance();
        ProjectCalendarTest.assertEquals((double)0.13, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(3);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)-4.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)0.88, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        duration = task.getFinishVariance();
        ProjectCalendarTest.assertEquals((double)-1.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
        task = file.getTaskByID(4);
        duration = task.getDurationVariance();
        ProjectCalendarTest.assertEquals((double)0.8, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.WEEKS, (Object)duration.getUnits());
        duration = task.getStartVariance();
        ProjectCalendarTest.assertEquals((double)0.0, (double)duration.getDuration(), (double)0.01);
        ProjectCalendarTest.assertEquals((Object)TimeUnit.DAYS, (Object)duration.getUnits());
    }

    public void testGetDate() throws Exception {
        ProjectFile file = new ProjectFile();
        ProjectCalendar cal = file.addDefaultBaseCalendar();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        Date startDate = df.parse("09/10/2003 08:00");
        Duration duration = Duration.getInstance(8, TimeUnit.HOURS);
        Date endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"10/10/2003 08:00", (String)df.format(endDate));
        duration = Duration.getInstance(16, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"10/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"13/10/2003 08:00", (String)df.format(endDate));
        duration = Duration.getInstance(24, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"13/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"14/10/2003 08:00", (String)df.format(endDate));
        duration = Duration.getInstance(9, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"10/10/2003 09:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"10/10/2003 09:00", (String)df.format(endDate));
        duration = Duration.getInstance(1, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 09:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 09:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 09:00");
        duration = Duration.getInstance(1, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 10:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 10:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 11:30");
        duration = Duration.getInstance(1, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 13:30", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 13:30", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 13:00");
        duration = Duration.getInstance(1, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 14:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 14:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 14:00");
        duration = Duration.getInstance(1, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 15:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 15:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 08:00");
        duration = Duration.getInstance(4, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 12:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 13:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 13:00");
        duration = Duration.getInstance(4, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"10/10/2003 08:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 09:00");
        duration = Duration.getInstance(3, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 12:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 13:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 14:00");
        duration = Duration.getInstance(3, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"09/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"10/10/2003 08:00", (String)df.format(endDate));
        startDate = df.parse("09/10/2003 8:00");
        duration = Duration.getInstance(24, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"13/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"14/10/2003 08:00", (String)df.format(endDate));
        ProjectCalendarException ex = cal.addCalendarException();
        ex.setFromDate(df.parse("10/10/2003 00:00"));
        ex.setToDate(df.parse("10/10/2003 23:59"));
        ex.setWorking(false);
        startDate = df.parse("09/10/2003 8:00");
        duration = Duration.getInstance(24, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"14/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"15/10/2003 08:00", (String)df.format(endDate));
        ex = cal.addCalendarException();
        ex.setFromDate(df.parse("11/10/2003 00:00"));
        ex.setToDate(df.parse("11/10/2003 23:59"));
        ex.setWorking(true);
        ex.addRange(new DateRange(df.parse("11/10/2003 09:00"), df.parse("11/10/2003 13:00")));
        startDate = df.parse("09/10/2003 8:00");
        duration = Duration.getInstance(24, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"14/10/2003 12:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"14/10/2003 13:00", (String)df.format(endDate));
        startDate = df.parse("12/10/2003 8:00");
        duration = Duration.getInstance(8, TimeUnit.HOURS);
        endDate = cal.getDate(startDate, duration, false);
        ProjectCalendarTest.assertEquals((String)"13/10/2003 17:00", (String)df.format(endDate));
        endDate = cal.getDate(startDate, duration, true);
        ProjectCalendarTest.assertEquals((String)"14/10/2003 08:00", (String)df.format(endDate));
    }

    public void testStartTime() throws Exception {
        ProjectFile file = new ProjectFile();
        ProjectCalendar cal = file.addDefaultBaseCalendar();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        ProjectCalendarTest.assertEquals((String)"01/01/0001 08:00", (String)df.format(cal.getStartTime(df.parse("09/10/2003 00:00"))));
        ProjectCalendarTest.assertNull((Object)cal.getStartTime(df.parse("11/10/2003 00:00")));
    }
}

