/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;

public class MppSubprojectTest
extends MPXJTestCase {
    public void testMpp9Subproject() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9subproject.mpp");
        this.testSubprojects(mpp, true);
    }

    public void testMpp12Subproject() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12subproject.mpp");
        this.testSubprojects(mpp, true);
    }

    public void testMpd9Subproject() throws Exception {
        block2: {
            try {
                ProjectFile mpp = new MPDDatabaseReader().read(this.m_basedir + "/mpp9subproject.mpd");
                this.testSubprojects(mpp, false);
            }
            catch (Exception ex) {
                if (this.m_ikvm) break block2;
                throw ex;
            }
        }
    }

    private void testSubprojects(ProjectFile mpp, boolean isMPP) throws Exception {
        Task taskNormal = mpp.getTaskByUniqueID(1);
        Task taskSubprojectA = mpp.getTaskByUniqueID(2);
        Task taskSubprojectB = mpp.getTaskByUniqueID(3);
        MppSubprojectTest.assertEquals((String)"Normal Task", (String)taskNormal.getName());
        MppSubprojectTest.assertEquals((String)"SubprojectA-9", (String)taskSubprojectA.getName());
        MppSubprojectTest.assertEquals((String)"SubprojectB-9", (String)taskSubprojectB.getName());
        SubProject subprojectA = taskSubprojectA.getSubProject();
        MppSubprojectTest.assertNotNull((Object)subprojectA);
        String expectedFilenameA = "\\SubprojectA-9.mpp";
        MppSubprojectTest.assertTrue(("\\SubprojectA-9.mpp".indexOf(subprojectA.getFileName()) != -1 ? 1 : 0) != 0);
        MppSubprojectTest.assertTrue((subprojectA.getFullPath().indexOf("\\SubprojectA-9.mpp") != -1 ? 1 : 0) != 0);
        MppSubprojectTest.assertEquals((Object)2, (Object)subprojectA.getTaskUniqueID());
        MppSubprojectTest.assertEquals((boolean)false, (boolean)taskSubprojectA.getSubprojectReadOnly());
        if (isMPP) {
            MppSubprojectTest.assertEquals((Object)0x800000, (Object)subprojectA.getUniqueIDOffset());
            MppSubprojectTest.assertEquals((Object)0x800000, (Object)taskSubprojectA.getSubprojectTasksUniqueIDOffset());
            MppSubprojectTest.assertEquals((Object)0, (Object)taskSubprojectA.getSubprojectTaskUniqueID());
        }
    }
}

