/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Group;
import net.sf.mpxj.GroupClause;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.MPPReader;

public class MppGroupTest
extends MPXJTestCase {
    public void testMpp9Groups() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9group.mpp");
        this.testGroups(mpp);
    }

    public void testMpp12Groups() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12group.mpp");
        this.testGroups(mpp);
    }

    private void testGroups(ProjectFile mpp) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        Group group = mpp.getGroupByName("Group 1");
        MppGroupTest.assertNotNull((Object)group);
        MppGroupTest.assertEquals((String)"Group 1", (String)group.getName());
        MppGroupTest.assertFalse((boolean)group.getShowSummaryTasks());
        List<GroupClause> clauses = group.getGroupClauses();
        MppGroupTest.assertNotNull(clauses);
        GroupClause clause = clauses.get(0);
        MppGroupTest.assertEquals((Object)TaskField.DURATION1, (Object)clause.getField());
        MppGroupTest.assertTrue((boolean)clause.getAscending());
        FontStyle font = clause.getFont();
        MppGroupTest.assertEquals((String)"Arial", (String)font.getFontBase().getName());
        MppGroupTest.assertEquals((int)8, (int)font.getFontBase().getSize());
        MppGroupTest.assertTrue((boolean)font.getBold());
        MppGroupTest.assertFalse((boolean)font.getItalic());
        MppGroupTest.assertFalse((boolean)font.getUnderline());
        MppGroupTest.assertEquals((Object)ColorType.YELLOW, (Object)clause.getCellBackgroundColor());
        MppGroupTest.assertEquals((int)1, (int)clause.getGroupOn());
        MppGroupTest.assertEquals((int)1, (int)((Double)clause.getStartAt()).intValue());
        MppGroupTest.assertEquals((int)2, (int)((Double)clause.getGroupInterval()).intValue());
        clause = clauses.get(1);
        MppGroupTest.assertEquals((Object)TaskField.NUMBER1, (Object)clause.getField());
        MppGroupTest.assertFalse((boolean)clause.getAscending());
        font = clause.getFont();
        MppGroupTest.assertEquals((String)"Arial", (String)font.getFontBase().getName());
        MppGroupTest.assertEquals((int)8, (int)font.getFontBase().getSize());
        MppGroupTest.assertTrue((boolean)font.getBold());
        MppGroupTest.assertFalse((boolean)font.getItalic());
        MppGroupTest.assertFalse((boolean)font.getUnderline());
        MppGroupTest.assertEquals((Object)ColorType.SILVER, (Object)clause.getCellBackgroundColor());
        MppGroupTest.assertEquals((int)1, (int)clause.getGroupOn());
        MppGroupTest.assertEquals((int)3, (int)((Double)clause.getStartAt()).intValue());
        MppGroupTest.assertEquals((int)4, (int)((Double)clause.getGroupInterval()).intValue());
        clause = clauses.get(2);
        MppGroupTest.assertEquals((Object)TaskField.COST1, (Object)clause.getField());
        MppGroupTest.assertTrue((boolean)clause.getAscending());
        font = clause.getFont();
        MppGroupTest.assertEquals((String)"Arial", (String)font.getFontBase().getName());
        MppGroupTest.assertEquals((int)8, (int)font.getFontBase().getSize());
        MppGroupTest.assertTrue((boolean)font.getBold());
        MppGroupTest.assertFalse((boolean)font.getItalic());
        MppGroupTest.assertFalse((boolean)font.getUnderline());
        MppGroupTest.assertEquals((Object)ColorType.YELLOW, (Object)clause.getCellBackgroundColor());
        MppGroupTest.assertEquals((int)1, (int)clause.getGroupOn());
        MppGroupTest.assertEquals((int)5, (int)((Double)clause.getStartAt()).intValue());
        MppGroupTest.assertEquals((int)6, (int)((Double)clause.getGroupInterval()).intValue());
        clause = clauses.get(3);
        MppGroupTest.assertEquals((Object)TaskField.PERCENT_COMPLETE, (Object)clause.getField());
        MppGroupTest.assertFalse((boolean)clause.getAscending());
        font = clause.getFont();
        MppGroupTest.assertEquals((String)"Arial", (String)font.getFontBase().getName());
        MppGroupTest.assertEquals((int)8, (int)font.getFontBase().getSize());
        MppGroupTest.assertTrue((boolean)font.getBold());
        MppGroupTest.assertFalse((boolean)font.getItalic());
        MppGroupTest.assertFalse((boolean)font.getUnderline());
        MppGroupTest.assertEquals((Object)ColorType.SILVER, (Object)clause.getCellBackgroundColor());
        MppGroupTest.assertEquals((int)1, (int)clause.getGroupOn());
        MppGroupTest.assertEquals((int)7, (int)((Integer)clause.getStartAt()));
        MppGroupTest.assertEquals((int)8, (int)((Integer)clause.getGroupInterval()));
        clause = clauses.get(4);
        MppGroupTest.assertEquals((Object)TaskField.FLAG1, (Object)clause.getField());
        MppGroupTest.assertTrue((boolean)clause.getAscending());
        font = clause.getFont();
        MppGroupTest.assertEquals((String)"Arial", (String)font.getFontBase().getName());
        MppGroupTest.assertEquals((int)8, (int)font.getFontBase().getSize());
        MppGroupTest.assertTrue((boolean)font.getBold());
        MppGroupTest.assertFalse((boolean)font.getItalic());
        MppGroupTest.assertFalse((boolean)font.getUnderline());
        MppGroupTest.assertEquals((Object)ColorType.YELLOW, (Object)clause.getCellBackgroundColor());
        clause = clauses.get(5);
        MppGroupTest.assertEquals((Object)TaskField.DATE1, (Object)clause.getField());
        MppGroupTest.assertFalse((boolean)clause.getAscending());
        font = clause.getFont();
        MppGroupTest.assertEquals((String)"Arial", (String)font.getFontBase().getName());
        MppGroupTest.assertEquals((int)8, (int)font.getFontBase().getSize());
        MppGroupTest.assertTrue((boolean)font.getBold());
        MppGroupTest.assertFalse((boolean)font.getItalic());
        MppGroupTest.assertFalse((boolean)font.getUnderline());
        MppGroupTest.assertEquals((Object)ColorType.SILVER, (Object)clause.getCellBackgroundColor());
        MppGroupTest.assertEquals((int)1, (int)clause.getGroupOn());
        MppGroupTest.assertEquals((String)"07/02/2006 00:00", (String)df.format((Date)clause.getStartAt()));
        MppGroupTest.assertEquals((int)10, (int)((Integer)clause.getGroupInterval()));
    }
}

