/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;

public class MppCalendarTest
extends MPXJTestCase {
    public void testMpp9Calendar() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9calendar.mpp");
        this.testCalendars(mpp);
    }

    public void testMpp12Calendar() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12calendar.mpp");
        this.testCalendars(mpp);
    }

    public void testMpd9Calendar() throws Exception {
        block2: {
            try {
                ProjectFile mpp = new MPDDatabaseReader().read(this.m_basedir + "/mpp9calendar.mpd");
                this.testCalendars(mpp);
            }
            catch (Exception ex) {
                if (this.m_ikvm) break block2;
                throw ex;
            }
        }
    }

    public void testMpp9CalendarExceptions() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9exceptions.mpp");
        this.testExceptions(mpp);
    }

    public void testMpp12CalendarExceptions() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12exceptions.mpp");
        this.testExceptions(mpp);
    }

    private void testCalendars(ProjectFile mpp) {
        SimpleDateFormat tf = new SimpleDateFormat("HH:mm");
        List<ProjectCalendar> baseCalendars = mpp.getBaseCalendars();
        MppCalendarTest.assertEquals((int)5, (int)baseCalendars.size());
        ProjectCalendar cal = mpp.getBaseCalendarByUniqueID(1);
        MppCalendarTest.assertNotNull((Object)cal);
        MppCalendarTest.assertEquals((String)"Standard", (String)cal.getName());
        MppCalendarTest.assertNull((Object)cal.getBaseCalendar());
        MppCalendarTest.assertTrue((boolean)cal.isBaseCalendar());
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.MONDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.TUESDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.WEDNESDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.THURSDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.FRIDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getWorkingDay(Day.SATURDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getWorkingDay(Day.SUNDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getCalendarExceptions().size());
        ProjectCalendarHours hours = cal.getCalendarHours(Day.MONDAY);
        MppCalendarTest.assertEquals((int)2, (int)hours.getRangeCount());
        DateRange range = hours.getRange(0);
        MppCalendarTest.assertEquals((String)"08:00", (String)tf.format(range.getStart()));
        MppCalendarTest.assertEquals((String)"12:00", (String)tf.format(range.getEnd()));
        range = cal.getCalendarHours(Day.MONDAY).getRange(1);
        MppCalendarTest.assertEquals((String)"13:00", (String)tf.format(range.getStart()));
        MppCalendarTest.assertEquals((String)"17:00", (String)tf.format(range.getEnd()));
        List<ProjectCalendar> resourceCalendars = mpp.getResourceCalendars();
        MppCalendarTest.assertEquals((int)2, (int)resourceCalendars.size());
    }

    private void testExceptions(ProjectFile mpp) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        SimpleDateFormat tf = new SimpleDateFormat("HH:mm");
        List<ProjectCalendar> baseCalendars = mpp.getBaseCalendars();
        MppCalendarTest.assertEquals((int)1, (int)baseCalendars.size());
        ProjectCalendar cal = mpp.getBaseCalendarByUniqueID(1);
        MppCalendarTest.assertNotNull((Object)cal);
        MppCalendarTest.assertEquals((String)"Standard", (String)cal.getName());
        MppCalendarTest.assertNull((Object)cal.getBaseCalendar());
        MppCalendarTest.assertTrue((boolean)cal.isBaseCalendar());
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.MONDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getWorkingDay(Day.TUESDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.WEDNESDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.THURSDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.FRIDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.SATURDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getWorkingDay(Day.SUNDAY));
        List<ProjectCalendarException> exceptions = cal.getCalendarExceptions();
        MppCalendarTest.assertEquals((int)3, (int)exceptions.size());
        ProjectCalendarException exception = exceptions.get(0);
        MppCalendarTest.assertFalse((boolean)exception.getWorking());
        MppCalendarTest.assertEquals((String)"05/03/2008 00:00", (String)df.format(exception.getFromDate()));
        MppCalendarTest.assertEquals((String)"05/03/2008 23:59", (String)df.format(exception.getToDate()));
        MppCalendarTest.assertNull((Object)exception.getRange(0).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(0).getEnd());
        MppCalendarTest.assertNull((Object)exception.getRange(1).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(1).getEnd());
        MppCalendarTest.assertNull((Object)exception.getRange(2).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(2).getEnd());
        MppCalendarTest.assertNull((Object)exception.getRange(3).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(3).getEnd());
        MppCalendarTest.assertNull((Object)exception.getRange(4).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(4).getEnd());
        exception = exceptions.get(1);
        MppCalendarTest.assertTrue((boolean)exception.getWorking());
        MppCalendarTest.assertEquals((String)"09/03/2008 00:00", (String)df.format(exception.getFromDate()));
        MppCalendarTest.assertEquals((String)"09/03/2008 23:59", (String)df.format(exception.getToDate()));
        MppCalendarTest.assertEquals((String)"08:00", (String)tf.format(exception.getRange(0).getStart()));
        MppCalendarTest.assertEquals((String)"12:00", (String)tf.format(exception.getRange(0).getEnd()));
        MppCalendarTest.assertEquals((String)"13:00", (String)tf.format(exception.getRange(1).getStart()));
        MppCalendarTest.assertEquals((String)"17:00", (String)tf.format(exception.getRange(1).getEnd()));
        MppCalendarTest.assertNull((Object)exception.getRange(2).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(2).getEnd());
        MppCalendarTest.assertNull((Object)exception.getRange(3).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(3).getEnd());
        MppCalendarTest.assertNull((Object)exception.getRange(4).getStart());
        MppCalendarTest.assertNull((Object)exception.getRange(4).getEnd());
        exception = exceptions.get(2);
        MppCalendarTest.assertTrue((boolean)exception.getWorking());
        MppCalendarTest.assertEquals((String)"16/03/2008 00:00", (String)df.format(exception.getFromDate()));
        MppCalendarTest.assertEquals((String)"16/03/2008 23:59", (String)df.format(exception.getToDate()));
        MppCalendarTest.assertEquals((String)"08:00", (String)tf.format(exception.getRange(0).getStart()));
        MppCalendarTest.assertEquals((String)"09:00", (String)tf.format(exception.getRange(0).getEnd()));
        MppCalendarTest.assertEquals((String)"11:00", (String)tf.format(exception.getRange(1).getStart()));
        MppCalendarTest.assertEquals((String)"12:00", (String)tf.format(exception.getRange(1).getEnd()));
        MppCalendarTest.assertEquals((String)"14:00", (String)tf.format(exception.getRange(2).getStart()));
        MppCalendarTest.assertEquals((String)"15:00", (String)tf.format(exception.getRange(2).getEnd()));
        MppCalendarTest.assertEquals((String)"16:00", (String)tf.format(exception.getRange(3).getStart()));
        MppCalendarTest.assertEquals((String)"17:00", (String)tf.format(exception.getRange(3).getEnd()));
        MppCalendarTest.assertEquals((String)"18:00", (String)tf.format(exception.getRange(4).getStart()));
        MppCalendarTest.assertEquals((String)"19:00", (String)tf.format(exception.getRange(4).getEnd()));
    }
}

