/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class MppBaselineTest
extends MPXJTestCase {
    public void testMpp9EnterpriseFields() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9baselines.mpp");
        this.testBaselineFields(mpp);
    }

    public void testMspdiBaselineFields() throws Exception {
        ProjectFile mpp = new MSPDIReader().read(this.m_basedir + "/baselines.xml");
        this.testBaselineFields(mpp);
    }

    public void testMpp12BaselineFields() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12baselines.mpp");
        this.testBaselineFields(mpp);
    }

    private void testBaselineFields(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Task task = mpp.getTaskByID(1);
        MppBaselineTest.assertEquals((int)1, (int)task.getBaselineCost(1).intValue());
        MppBaselineTest.assertEquals((int)2, (int)task.getBaselineCost(2).intValue());
        MppBaselineTest.assertEquals((int)3, (int)task.getBaselineCost(3).intValue());
        MppBaselineTest.assertEquals((int)4, (int)task.getBaselineCost(4).intValue());
        MppBaselineTest.assertEquals((int)5, (int)task.getBaselineCost(5).intValue());
        MppBaselineTest.assertEquals((int)6, (int)task.getBaselineCost(6).intValue());
        MppBaselineTest.assertEquals((int)7, (int)task.getBaselineCost(7).intValue());
        MppBaselineTest.assertEquals((int)8, (int)task.getBaselineCost(8).intValue());
        MppBaselineTest.assertEquals((int)9, (int)task.getBaselineCost(9).intValue());
        MppBaselineTest.assertEquals((int)10, (int)task.getBaselineCost(10).intValue());
        MppBaselineTest.assertEquals((int)1, (int)((int)task.getBaselineDuration(1).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(1).getUnits());
        MppBaselineTest.assertEquals((int)2, (int)((int)task.getBaselineDuration(2).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(2).getUnits());
        MppBaselineTest.assertEquals((int)3, (int)((int)task.getBaselineDuration(3).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(3).getUnits());
        MppBaselineTest.assertEquals((int)4, (int)((int)task.getBaselineDuration(4).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(4).getUnits());
        MppBaselineTest.assertEquals((int)5, (int)((int)task.getBaselineDuration(5).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(5).getUnits());
        MppBaselineTest.assertEquals((int)6, (int)((int)task.getBaselineDuration(6).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(6).getUnits());
        MppBaselineTest.assertEquals((int)7, (int)((int)task.getBaselineDuration(7).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(7).getUnits());
        MppBaselineTest.assertEquals((int)8, (int)((int)task.getBaselineDuration(8).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(8).getUnits());
        MppBaselineTest.assertEquals((int)9, (int)((int)task.getBaselineDuration(9).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(9).getUnits());
        MppBaselineTest.assertEquals((int)10, (int)((int)task.getBaselineDuration(10).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getBaselineDuration(10).getUnits());
        MppBaselineTest.assertEquals((String)"01/01/2000", (String)df.format(task.getBaselineFinish(1)));
        MppBaselineTest.assertEquals((String)"02/01/2000", (String)df.format(task.getBaselineFinish(2)));
        MppBaselineTest.assertEquals((String)"03/01/2000", (String)df.format(task.getBaselineFinish(3)));
        MppBaselineTest.assertEquals((String)"04/01/2000", (String)df.format(task.getBaselineFinish(4)));
        MppBaselineTest.assertEquals((String)"05/01/2000", (String)df.format(task.getBaselineFinish(5)));
        MppBaselineTest.assertEquals((String)"06/01/2000", (String)df.format(task.getBaselineFinish(6)));
        MppBaselineTest.assertEquals((String)"07/01/2000", (String)df.format(task.getBaselineFinish(7)));
        MppBaselineTest.assertEquals((String)"08/01/2000", (String)df.format(task.getBaselineFinish(8)));
        MppBaselineTest.assertEquals((String)"09/01/2000", (String)df.format(task.getBaselineFinish(9)));
        MppBaselineTest.assertEquals((String)"10/01/2000", (String)df.format(task.getBaselineFinish(10)));
        MppBaselineTest.assertEquals((String)"01/01/2001", (String)df.format(task.getBaselineStart(1)));
        MppBaselineTest.assertEquals((String)"02/01/2001", (String)df.format(task.getBaselineStart(2)));
        MppBaselineTest.assertEquals((String)"03/01/2001", (String)df.format(task.getBaselineStart(3)));
        MppBaselineTest.assertEquals((String)"04/01/2001", (String)df.format(task.getBaselineStart(4)));
        MppBaselineTest.assertEquals((String)"05/01/2001", (String)df.format(task.getBaselineStart(5)));
        MppBaselineTest.assertEquals((String)"06/01/2001", (String)df.format(task.getBaselineStart(6)));
        MppBaselineTest.assertEquals((String)"07/01/2001", (String)df.format(task.getBaselineStart(7)));
        MppBaselineTest.assertEquals((String)"08/01/2001", (String)df.format(task.getBaselineStart(8)));
        MppBaselineTest.assertEquals((String)"09/01/2001", (String)df.format(task.getBaselineStart(9)));
        MppBaselineTest.assertEquals((String)"10/01/2001", (String)df.format(task.getBaselineStart(10)));
        MppBaselineTest.assertEquals((int)1, (int)((int)task.getBaselineWork(1).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(1).getUnits());
        MppBaselineTest.assertEquals((int)2, (int)((int)task.getBaselineWork(2).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(2).getUnits());
        MppBaselineTest.assertEquals((int)3, (int)((int)task.getBaselineWork(3).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(3).getUnits());
        MppBaselineTest.assertEquals((int)4, (int)((int)task.getBaselineWork(4).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(4).getUnits());
        MppBaselineTest.assertEquals((int)5, (int)((int)task.getBaselineWork(5).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(5).getUnits());
        MppBaselineTest.assertEquals((int)6, (int)((int)task.getBaselineWork(6).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(6).getUnits());
        MppBaselineTest.assertEquals((int)7, (int)((int)task.getBaselineWork(7).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(7).getUnits());
        MppBaselineTest.assertEquals((int)8, (int)((int)task.getBaselineWork(8).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(8).getUnits());
        MppBaselineTest.assertEquals((int)9, (int)((int)task.getBaselineWork(9).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(9).getUnits());
        MppBaselineTest.assertEquals((int)10, (int)((int)task.getBaselineWork(10).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)task.getBaselineWork(10).getUnits());
        Resource resource = mpp.getResourceByID(1);
        MppBaselineTest.assertEquals((int)1, (int)((int)resource.getBaselineWork(1).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(1).getUnits());
        MppBaselineTest.assertEquals((int)2, (int)((int)resource.getBaselineWork(2).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(2).getUnits());
        MppBaselineTest.assertEquals((int)3, (int)((int)resource.getBaselineWork(3).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(3).getUnits());
        MppBaselineTest.assertEquals((int)4, (int)((int)resource.getBaselineWork(4).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(4).getUnits());
        MppBaselineTest.assertEquals((int)5, (int)((int)resource.getBaselineWork(5).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(5).getUnits());
        MppBaselineTest.assertEquals((int)6, (int)((int)resource.getBaselineWork(6).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(6).getUnits());
        MppBaselineTest.assertEquals((int)7, (int)((int)resource.getBaselineWork(7).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(7).getUnits());
        MppBaselineTest.assertEquals((int)8, (int)((int)resource.getBaselineWork(8).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(8).getUnits());
        MppBaselineTest.assertEquals((int)9, (int)((int)resource.getBaselineWork(9).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(9).getUnits());
        MppBaselineTest.assertEquals((int)10, (int)((int)resource.getBaselineWork(10).getDuration()));
        MppBaselineTest.assertEquals((Object)TimeUnit.HOURS, (Object)resource.getBaselineWork(10).getUnits());
        MppBaselineTest.assertEquals((int)1, (int)resource.getBaselineCost(1).intValue());
        MppBaselineTest.assertEquals((int)2, (int)resource.getBaselineCost(2).intValue());
        MppBaselineTest.assertEquals((int)3, (int)resource.getBaselineCost(3).intValue());
        MppBaselineTest.assertEquals((int)4, (int)resource.getBaselineCost(4).intValue());
        MppBaselineTest.assertEquals((int)5, (int)resource.getBaselineCost(5).intValue());
        MppBaselineTest.assertEquals((int)6, (int)resource.getBaselineCost(6).intValue());
        MppBaselineTest.assertEquals((int)7, (int)resource.getBaselineCost(7).intValue());
        MppBaselineTest.assertEquals((int)8, (int)resource.getBaselineCost(8).intValue());
        MppBaselineTest.assertEquals((int)9, (int)resource.getBaselineCost(9).intValue());
        MppBaselineTest.assertEquals((int)10, (int)resource.getBaselineCost(10).intValue());
    }
}

