/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.io.File;
import java.util.List;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GraphicalIndicator;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpp.MPPReader;

public class GraphicalIndicatorTest
extends MPXJTestCase {
    private static final int NONE = 0;
    private static final int GREEN_BALL = 1;
    private static final int AMBER_BALL = 2;
    private static final int RED_BALL = 3;
    private static final int BLACK_BALL = 4;
    private static final int WHITE_BALL = 5;
    private static final int[] COST1_RESULTS = new int[]{4, 1, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] COST2_RESULTS = new int[]{5, 2, 3, 3, 3, 0, 0, 4, 5, 5, 5, 5, 5, 5};
    private static final int[] COST3_RESULTS = new int[]{3, 3, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 3, 3};
    private static final int[] COST4_RESULTS = new int[]{1, 2, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
    private static final int[] DATE1_RESULTS = new int[]{3, 3, 1, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] DATE2_RESULTS = new int[]{1, 1, 1, 2, 0, 0, 3, 3, 3, 1, 1, 1, 1, 1};
    private static final int[] DATE3_RESULTS = new int[]{2, 2, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 2, 2};
    private static final int[] DATE4_RESULTS = new int[]{1, 3, 1, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 1};
    private static final int[] DATE5_RESULTS = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] DURATION1_RESULTS = new int[]{2, 1, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] DURATION2_RESULTS = new int[]{5, 2, 3, 3, 3, 0, 0, 4, 5, 5, 5, 5, 5, 5};
    private static final int[] DURATION3_RESULTS = new int[]{3, 3, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 3, 3};
    private static final int[] DURATION4_RESULTS = new int[]{1, 2, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
    private static final int[] FLAG_RESULTS = new int[]{3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] NUMBER1_RESULTS = new int[]{2, 1, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] NUMBER2_RESULTS = new int[]{5, 2, 3, 3, 3, 0, 0, 4, 5, 5, 5, 5, 5, 5};
    private static final int[] NUMBER3_RESULTS = new int[]{3, 3, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 3, 3};
    private static final int[] NUMBER4_RESULTS = new int[]{1, 2, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
    private static final int[] TEXT1_RESULTS = new int[]{2, 1, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] TEXT2_RESULTS = new int[]{5, 2, 3, 3, 3, 0, 0, 4, 5, 5, 5, 5, 5, 5};
    private static final int[] TEXT3_RESULTS = new int[]{3, 3, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 3, 3};
    private static final int[] TEXT4_RESULTS = new int[]{1, 2, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
    private static final int[] TEXT5_RESULTS = new int[]{3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] TEXT6_RESULTS = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] TEXT7_RESULTS = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

    public void testGraphicalIndicators() throws Exception {
        File in = new File(this.m_basedir + "/GraphicalIndicatorTest.mpp");
        ProjectFile project = new MPPReader().read(in);
        List<Task> taskList = project.getAllTasks();
        FieldContainer[] tasks = taskList.toArray(new Task[taskList.size()]);
        this.testIndicator(project, TaskField.COST1, tasks, COST1_RESULTS);
        this.testIndicator(project, TaskField.COST2, tasks, COST2_RESULTS);
        this.testIndicator(project, TaskField.COST3, tasks, COST3_RESULTS);
        this.testIndicator(project, TaskField.COST4, tasks, COST4_RESULTS);
        this.testIndicator(project, TaskField.DATE1, tasks, DATE1_RESULTS);
        this.testIndicator(project, TaskField.DATE2, tasks, DATE2_RESULTS);
        this.testIndicator(project, TaskField.DATE3, tasks, DATE3_RESULTS);
        this.testIndicator(project, TaskField.DATE4, tasks, DATE4_RESULTS);
        this.testIndicator(project, TaskField.DATE5, tasks, DATE5_RESULTS);
        this.testIndicator(project, TaskField.DURATION1, tasks, DURATION1_RESULTS);
        this.testIndicator(project, TaskField.DURATION2, tasks, DURATION2_RESULTS);
        this.testIndicator(project, TaskField.DURATION3, tasks, DURATION3_RESULTS);
        this.testIndicator(project, TaskField.DURATION4, tasks, DURATION4_RESULTS);
        this.testIndicator(project, TaskField.FLAG1, tasks, FLAG_RESULTS);
        this.testIndicator(project, TaskField.FLAG2, tasks, FLAG_RESULTS);
        this.testIndicator(project, TaskField.FLAG3, tasks, FLAG_RESULTS);
        this.testIndicator(project, TaskField.NUMBER1, tasks, NUMBER1_RESULTS);
        this.testIndicator(project, TaskField.NUMBER2, tasks, NUMBER2_RESULTS);
        this.testIndicator(project, TaskField.NUMBER3, tasks, NUMBER3_RESULTS);
        this.testIndicator(project, TaskField.NUMBER4, tasks, NUMBER4_RESULTS);
        this.testIndicator(project, TaskField.TEXT1, tasks, TEXT1_RESULTS);
        this.testIndicator(project, TaskField.TEXT2, tasks, TEXT2_RESULTS);
        this.testIndicator(project, TaskField.TEXT3, tasks, TEXT3_RESULTS);
        this.testIndicator(project, TaskField.TEXT4, tasks, TEXT4_RESULTS);
        this.testIndicator(project, TaskField.TEXT5, tasks, TEXT5_RESULTS);
        this.testIndicator(project, TaskField.TEXT6, tasks, TEXT6_RESULTS);
        this.testIndicator(project, TaskField.TEXT7, tasks, TEXT7_RESULTS);
    }

    private void testIndicator(ProjectFile project, FieldType fieldType, FieldContainer[] rows, int[] expectedResults) {
        GraphicalIndicator indicator = project.getGraphicalIndicator(fieldType);
        for (int loop = 0; loop < expectedResults.length; ++loop) {
            int value = indicator.evaluate(rows[loop]);
            GraphicalIndicatorTest.assertEquals((String)("Testing " + fieldType + " row " + loop), (int)expectedResults[loop], (int)value);
        }
    }
}

