/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class DurationTest
extends MPXJTestCase {
    public void testMpp9() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp9duration.mpp");
        this.testDurations(mpp);
    }

    public void testMpp12() throws Exception {
        ProjectFile mpp = new MPPReader().read(this.m_basedir + "/mpp12duration.mpp");
        this.testDurations(mpp);
    }

    public void testMspdi() throws Exception {
        ProjectFile mpp = new MSPDIReader().read(this.m_basedir + "/mspdiduration.xml");
        this.testDurations(mpp);
    }

    public void testMpd() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(this.m_basedir + "/mpdduration.mpd");
        this.testDurations(mpp);
    }

    private void testDurations(ProjectFile mpp) {
        Task task = mpp.getTaskByID(1);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.MINUTES), (Object)task.getDuration());
        task = mpp.getTaskByID(2);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.HOURS), (Object)task.getDuration());
        task = mpp.getTaskByID(3);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.DAYS), (Object)task.getDuration());
        task = mpp.getTaskByID(4);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.WEEKS), (Object)task.getDuration());
        task = mpp.getTaskByID(5);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.MONTHS), (Object)task.getDuration());
        task = mpp.getTaskByID(6);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.ELAPSED_MINUTES), (Object)task.getDuration());
        task = mpp.getTaskByID(7);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.ELAPSED_HOURS), (Object)task.getDuration());
        task = mpp.getTaskByID(8);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.ELAPSED_DAYS), (Object)task.getDuration());
        task = mpp.getTaskByID(9);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.ELAPSED_WEEKS), (Object)task.getDuration());
        task = mpp.getTaskByID(10);
        DurationTest.assertEquals((Object)Duration.getInstance(1, TimeUnit.ELAPSED_MONTHS), (Object)task.getDuration());
    }
}

