/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ViewType implements MpxjEnum
{
    UNKNOWN(0, "UNKNOWN"),
    GANTT_CHART(1, "GANTT_CHART"),
    NETWORK_DIAGRAM(2, "NETWORK_DIAGRAM"),
    RELATIONSHIP_DIAGRAM(3, "RELATIONSHIP_DIAGRAM"),
    TASK_FORM(4, "TASK_FORM"),
    TASK_SHEET(5, "TASK_SHEET"),
    RESOURCE_FORM(6, "RESOURCE_FORM"),
    RESOURCE_SHEET(7, "RESOURCE_SHEET"),
    RESOURCE_GRAPH(8, "RESOURCE_GRAPH"),
    TASK_DETAILS_FORM(10, "TASK_DETAILS_FORM"),
    TASK_NAME_FORM(11, "TASK_NAME_FORM"),
    RESOURCE_NAME_FORM(12, "RESOURCE_NAME_FORM"),
    CALENDAR(13, "CALENDAR"),
    TASK_USAGE(14, "TASK_USAGE"),
    RESOURCE_USAGE(15, "RESOURCE_USAGE");

    private static final ViewType[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private ViewType(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static ViewType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = UNKNOWN.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static ViewType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return ViewType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.m_name;
    }

    static {
        TYPE_VALUES = new ViewType[16];
        Iterator i$ = EnumSet.range(UNKNOWN, RESOURCE_USAGE).iterator();
        while (i$.hasNext()) {
            ViewType e;
            ViewType.TYPE_VALUES[e.getValue()] = e = (ViewType)i$.next();
        }
    }
}

