/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.utility.DateUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectCalendarException
extends ProjectCalendarDateRanges
implements Comparable<ProjectCalendarException> {
    private Date m_fromDate;
    private Date m_toDate;
    private boolean m_working;

    public Date getFromDate() {
        return this.m_fromDate;
    }

    public void setFromDate(Date from) {
        this.m_fromDate = DateUtility.getDayStartDate(from);
    }

    public Date getToDate() {
        return this.m_toDate;
    }

    public void setToDate(Date to) {
        this.m_toDate = DateUtility.getDayEndDate(to);
    }

    public boolean getWorking() {
        return this.m_working;
    }

    public void setWorking(boolean flag) {
        this.m_working = flag;
    }

    public boolean contains(Date date) {
        boolean result = false;
        if (date != null) {
            result = DateUtility.compare(this.getFromDate(), this.getToDate(), date) == 0;
        }
        return result;
    }

    @Override
    public int compareTo(ProjectCalendarException o) {
        long fromTime2;
        long fromTime1 = this.m_fromDate.getTime();
        return fromTime1 < (fromTime2 = o.m_fromDate.getTime()) ? -1 : (fromTime1 == fromTime2 ? 0 : 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ProjectCalendarException");
        sb.append(" working=" + this.m_working);
        sb.append(" fromDate=" + this.m_fromDate);
        sb.append(" toDate=" + this.m_toDate);
        for (DateRange range : this) {
            sb.append(range.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

