/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DateOrder implements MpxjEnum
{
    MDY(0),
    DMY(1),
    YMD(2);

    private static final DateOrder[] TYPE_VALUES;
    private int m_value;

    private DateOrder(int type) {
        this.m_value = type;
    }

    public static DateOrder getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = MDY.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static DateOrder getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return DateOrder.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String toString() {
        return Integer.toString(this.m_value);
    }

    static {
        TYPE_VALUES = new DateOrder[3];
        Iterator i$ = EnumSet.range(MDY, YMD).iterator();
        while (i$.hasNext()) {
            DateOrder e;
            DateOrder.TYPE_VALUES[e.getValue()] = e = (DateOrder)i$.next();
        }
    }
}

