/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Iterator;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType implements MpxjEnum
{
    STRING(1),
    DATE(2),
    CURRENCY(3),
    BOOLEAN(4),
    NUMERIC(5),
    DURATION(6),
    UNITS(7),
    PERCENTAGE(8),
    ACCRUE(9),
    CONSTRAINT(10),
    RATE(11),
    PRIORITY(12),
    RELATION_LIST(13),
    TASK_TYPE(14),
    RESOURCE_TYPE(15);

    private static final DataType[] TYPE_VALUES;
    private int m_value;

    private DataType(int type) {
        this.m_value = type;
    }

    public static DataType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = STRING.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static DataType getInstance(Number type) {
        int value = type == null ? -1 : NumberUtility.getInt(type);
        return DataType.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = new DataType[16];
        Iterator i$ = EnumSet.range(STRING, RESOURCE_TYPE).iterator();
        while (i$.hasNext()) {
            DataType e;
            DataType.TYPE_VALUES[e.getValue()] = e = (DataType)i$.next();
        }
    }
}

