/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CodePage {
    ANSI("ANSI", "Cp1252"),
    MAC("MAC", "MacRoman"),
    LATIN("850", "Cp850"),
    US("437", "Cp437"),
    ZH("ZH", "GB2312");

    private String m_value;
    private String m_charset;
    private static final Map<String, CodePage> NAME_MAP;

    private CodePage(String value, String charset) {
        this.m_value = value;
        this.m_charset = charset;
    }

    public static CodePage getInstance(String value) {
        CodePage result = NAME_MAP.get(value);
        if (result == null) {
            result = ANSI;
        }
        return result;
    }

    public Charset getCharset() {
        return Charset.forName(this.m_charset);
    }

    public String toString() {
        return this.m_value;
    }

    static {
        NAME_MAP = new HashMap<String, CodePage>();
        for (CodePage e : EnumSet.range(ANSI, ZH)) {
            NAME_MAP.put(e.m_value, e);
        }
    }
}

