/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.combobox;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumComboBoxModel<E extends Enum<E>>
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 2176566393195371004L;
    private final Map<String, E> valueMap = new HashMap<String, E>();
    private final Class<E> enumClass;
    private final List<E> quickList = new ArrayList();
    private E selected = null;

    public EnumComboBoxModel(Class<E> en) {
        this.enumClass = en;
        EnumSet<Enum> ens = EnumSet.allOf(en);
        for (Enum element : ens) {
            String s = element.toString();
            if (this.valueMap.containsKey(s)) {
                throw new IllegalArgumentException("multiple constants map to one string value");
            }
            this.valueMap.put(s, element);
            this.quickList.add(element);
        }
        this.selected = (Enum)this.quickList.get(0);
    }

    @Override
    public int getSize() {
        return this.quickList.size();
    }

    @Override
    public E getElementAt(int index) {
        return (E)((Enum)this.quickList.get(index));
    }

    @Override
    public void setSelectedItem(Object anItem) {
        Enum input = null;
        input = this.enumClass.isInstance(anItem) ? (Enum)anItem : (Enum)this.valueMap.get(anItem);
        if (input != null || anItem == null) {
            this.selected = input;
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public E getSelectedItem() {
        return this.selected;
    }
}

