/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.planner;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.planner.schema.Allocation;
import net.sf.mpxj.planner.schema.Allocations;
import net.sf.mpxj.planner.schema.Calendar;
import net.sf.mpxj.planner.schema.Calendars;
import net.sf.mpxj.planner.schema.Constraint;
import net.sf.mpxj.planner.schema.DayType;
import net.sf.mpxj.planner.schema.DayTypes;
import net.sf.mpxj.planner.schema.Days;
import net.sf.mpxj.planner.schema.DefaultWeek;
import net.sf.mpxj.planner.schema.Interval;
import net.sf.mpxj.planner.schema.ObjectFactory;
import net.sf.mpxj.planner.schema.OverriddenDayType;
import net.sf.mpxj.planner.schema.OverriddenDayTypes;
import net.sf.mpxj.planner.schema.Predecessor;
import net.sf.mpxj.planner.schema.Predecessors;
import net.sf.mpxj.planner.schema.Project;
import net.sf.mpxj.planner.schema.Resources;
import net.sf.mpxj.planner.schema.Tasks;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.Sequence;
import net.sf.mpxj.writer.AbstractProjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlannerWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private Project m_plannerProject;
    private NumberFormat m_twoDigitFormat = new DecimalFormat("00");
    private NumberFormat m_fourDigitFormat = new DecimalFormat("0000");
    private static Map<RelationType, String> RELATIONSHIP_TYPES = new HashMap<RelationType, String>();

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            JAXBContext context = JAXBContext.newInstance((String)"net.sf.mpxj.planner.schema");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
            this.m_factory = new ObjectFactory();
            this.m_plannerProject = this.m_factory.createProject();
            this.writeProjectHeader();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            marshaller.marshal((Object)this.m_plannerProject, stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_plannerProject = null;
        }
    }

    private void writeProjectHeader() {
        ProjectHeader mpxjHeader = this.m_projectFile.getProjectHeader();
        this.m_plannerProject.setCompany(mpxjHeader.getCompany());
        this.m_plannerProject.setManager(mpxjHeader.getManager());
        this.m_plannerProject.setName(this.getString(mpxjHeader.getName()));
        this.m_plannerProject.setProjectStart(this.getDateTime(mpxjHeader.getStartDate()));
        this.m_plannerProject.setMrprojectVersion("2");
    }

    private void writeCalendars() throws JAXBException {
        Calendars calendars = this.m_factory.createCalendars();
        this.m_plannerProject.setCalendars(calendars);
        this.writeDayTypes(calendars);
        List<Calendar> calendar = calendars.getCalendar();
        for (ProjectCalendar mpxjCalendar : this.m_projectFile.getBaseCalendars()) {
            Calendar plannerCalendar = this.m_factory.createCalendar();
            calendar.add(plannerCalendar);
            this.writeCalendar(mpxjCalendar, plannerCalendar);
        }
    }

    private void writeDayTypes(Calendars calendars) {
        DayTypes dayTypes = this.m_factory.createDayTypes();
        calendars.setDayTypes(dayTypes);
        List<DayType> typeList = dayTypes.getDayType();
        DayType dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("0");
        dayType.setName("Working");
        dayType.setDescription("A default working day");
        dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("1");
        dayType.setName("Nonworking");
        dayType.setDescription("A default non working day");
        dayType = this.m_factory.createDayType();
        typeList.add(dayType);
        dayType.setId("2");
        dayType.setName("Use base");
        dayType.setDescription("Use day from base calendar");
    }

    private void writeCalendar(ProjectCalendar mpxjCalendar, Calendar plannerCalendar) throws JAXBException {
        plannerCalendar.setId(this.getIntegerString(mpxjCalendar.getUniqueID()));
        plannerCalendar.setName(this.getString(mpxjCalendar.getName()));
        DefaultWeek dw = this.m_factory.createDefaultWeek();
        plannerCalendar.setDefaultWeek(dw);
        dw.setMon(this.getWorkingDayString(mpxjCalendar, Day.MONDAY));
        dw.setTue(this.getWorkingDayString(mpxjCalendar, Day.TUESDAY));
        dw.setWed(this.getWorkingDayString(mpxjCalendar, Day.WEDNESDAY));
        dw.setThu(this.getWorkingDayString(mpxjCalendar, Day.THURSDAY));
        dw.setFri(this.getWorkingDayString(mpxjCalendar, Day.FRIDAY));
        dw.setSat(this.getWorkingDayString(mpxjCalendar, Day.SATURDAY));
        dw.setSun(this.getWorkingDayString(mpxjCalendar, Day.SUNDAY));
        OverriddenDayTypes odt = this.m_factory.createOverriddenDayTypes();
        plannerCalendar.setOverriddenDayTypes(odt);
        List<OverriddenDayType> typeList = odt.getOverriddenDayType();
        Sequence uniqueID = new Sequence(0);
        for (int dayLoop = 1; dayLoop < 8; ++dayLoop) {
            Day day = Day.getInstance(dayLoop);
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            this.processWorkingHours(mpxjCalendar, uniqueID, day, typeList);
            break;
        }
        Days plannerDays = this.m_factory.createDays();
        plannerCalendar.setDays(plannerDays);
        List<net.sf.mpxj.planner.schema.Day> dayList = plannerDays.getDay();
        this.processExceptionDays(mpxjCalendar, dayList);
        List<Calendar> calendarList = plannerCalendar.getCalendar();
        for (ProjectCalendar mpxjDerivedCalendar : mpxjCalendar.getDerivedCalendars()) {
            Calendar plannerDerivedCalendar = this.m_factory.createCalendar();
            calendarList.add(plannerDerivedCalendar);
            this.writeCalendar(mpxjDerivedCalendar, plannerDerivedCalendar);
        }
    }

    private void processWorkingHours(ProjectCalendar mpxjCalendar, Sequence uniqueID, Day day, List<OverriddenDayType> typeList) {
        ProjectCalendarHours mpxjHours;
        if (this.isWorkingDay(mpxjCalendar, day) && (mpxjHours = mpxjCalendar.getCalendarHours(day)) != null) {
            OverriddenDayType odt = this.m_factory.createOverriddenDayType();
            typeList.add(odt);
            odt.setId(this.getIntegerString(uniqueID.next()));
            List<Interval> intervalList = odt.getInterval();
            for (DateRange mpxjRange : mpxjHours) {
                Date rangeStart = mpxjRange.getStart();
                Date rangeEnd = mpxjRange.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Interval interval = this.m_factory.createInterval();
                intervalList.add(interval);
                interval.setStart(this.getTimeString(rangeStart));
                interval.setEnd(this.getTimeString(rangeEnd));
            }
        }
    }

    private void processExceptionDays(ProjectCalendar mpxjCalendar, List<net.sf.mpxj.planner.schema.Day> dayList) {
        for (ProjectCalendarException mpxjCalendarException : mpxjCalendar.getCalendarExceptions()) {
            Date rangeStartDay = mpxjCalendarException.getFromDate();
            Date rangeEndDay = mpxjCalendarException.getToDate();
            if (DateUtility.getDayStartDate(rangeStartDay).getTime() == DateUtility.getDayEndDate(rangeEndDay).getTime()) {
                net.sf.mpxj.planner.schema.Day day = this.m_factory.createDay();
                dayList.add(day);
                day.setType("day-type");
                day.setDate(this.getDateString(mpxjCalendarException.getFromDate()));
                day.setId(mpxjCalendarException.getWorking() ? "0" : "1");
                continue;
            }
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(rangeStartDay);
            while (cal.getTime().getTime() < rangeEndDay.getTime()) {
                net.sf.mpxj.planner.schema.Day day = this.m_factory.createDay();
                dayList.add(day);
                day.setType("day-type");
                day.setDate(this.getDateString(cal.getTime()));
                day.setId(mpxjCalendarException.getWorking() ? "0" : "1");
                cal.add(6, 1);
            }
        }
    }

    private void writeResources() {
        Resources resources = this.m_factory.createResources();
        this.m_plannerProject.setResources(resources);
        List<net.sf.mpxj.planner.schema.Resource> resourceList = resources.getResource();
        for (Resource mpxjResource : this.m_projectFile.getAllResources()) {
            net.sf.mpxj.planner.schema.Resource plannerResource = this.m_factory.createResource();
            resourceList.add(plannerResource);
            this.writeResource(mpxjResource, plannerResource);
        }
    }

    private void writeResource(Resource mpxjResource, net.sf.mpxj.planner.schema.Resource plannerResource) {
        ProjectCalendar resourceCalendar = mpxjResource.getResourceCalendar();
        if (resourceCalendar != null) {
            plannerResource.setCalendar(this.getIntegerString(resourceCalendar.getUniqueID()));
        }
        plannerResource.setEmail(mpxjResource.getEmailAddress());
        plannerResource.setId(this.getIntegerString(mpxjResource.getUniqueID()));
        plannerResource.setName(this.getString(mpxjResource.getName()));
        plannerResource.setNote(mpxjResource.getNotes());
        plannerResource.setShortName(mpxjResource.getInitials());
        plannerResource.setType(mpxjResource.getType() == ResourceType.MATERIAL ? "2" : "1");
        plannerResource.setUnits("0");
    }

    private void writeTasks() throws JAXBException {
        Tasks tasks = this.m_factory.createTasks();
        this.m_plannerProject.setTasks(tasks);
        List<net.sf.mpxj.planner.schema.Task> taskList = tasks.getTask();
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task, taskList);
        }
    }

    private void writeTask(Task mpxjTask, List<net.sf.mpxj.planner.schema.Task> taskList) throws JAXBException {
        net.sf.mpxj.planner.schema.Task plannerTask = this.m_factory.createTask();
        taskList.add(plannerTask);
        plannerTask.setEnd(this.getDateTimeString(mpxjTask.getFinish()));
        plannerTask.setId(this.getIntegerString(mpxjTask.getUniqueID()));
        plannerTask.setName(this.getString(mpxjTask.getName()));
        plannerTask.setNote(mpxjTask.getNotes());
        plannerTask.setPercentComplete(this.getIntegerString(mpxjTask.getPercentageWorkComplete()));
        plannerTask.setPriority(this.getIntegerString(mpxjTask.getPriority().getValue() * 10));
        plannerTask.setScheduling(this.getScheduling(mpxjTask.getType()));
        plannerTask.setStart(this.getDateTimeString(DateUtility.getDayStartDate(mpxjTask.getStart())));
        if (mpxjTask.getMilestone()) {
            plannerTask.setType("milestone");
        } else {
            plannerTask.setType("normal");
        }
        plannerTask.setWork(this.getDurationString(mpxjTask.getWork()));
        plannerTask.setWorkStart(this.getDateTimeString(mpxjTask.getStart()));
        ConstraintType mpxjConstraintType = mpxjTask.getConstraintType();
        if (mpxjConstraintType != ConstraintType.AS_SOON_AS_POSSIBLE) {
            Constraint plannerConstraint = this.m_factory.createConstraint();
            plannerTask.setConstraint(plannerConstraint);
            if (mpxjConstraintType == ConstraintType.START_NO_EARLIER_THAN) {
                plannerConstraint.setType("start-no-earlier-than");
            } else if (mpxjConstraintType == ConstraintType.MUST_START_ON) {
                plannerConstraint.setType("must-start-on");
            }
            plannerConstraint.setTime(this.getDateTimeString(mpxjTask.getConstraintDate()));
        }
        this.writePredecessors(mpxjTask, plannerTask);
        List<net.sf.mpxj.planner.schema.Task> childTaskList = plannerTask.getTask();
        for (Task task : mpxjTask.getChildTasks()) {
            this.writeTask(task, childTaskList);
        }
    }

    private void writePredecessors(Task mpxjTask, net.sf.mpxj.planner.schema.Task plannerTask) {
        Predecessor plannerPredecessor;
        Integer taskUniqueID;
        TreeSet<Integer> set = new TreeSet<Integer>();
        Predecessors plannerPredecessors = this.m_factory.createPredecessors();
        plannerTask.setPredecessors(plannerPredecessors);
        List<Predecessor> predecessorList = plannerPredecessors.getPredecessor();
        int id = 0;
        List<Relation> predecessors = mpxjTask.getUniqueIDPredecessors();
        if (predecessors != null) {
            for (Relation rel : predecessors) {
                taskUniqueID = rel.getTaskUniqueID();
                set.add(taskUniqueID);
                plannerPredecessor = this.m_factory.createPredecessor();
                plannerPredecessor.setId(this.getIntegerString(++id));
                plannerPredecessor.setPredecessorId(this.getIntegerString(taskUniqueID));
                plannerPredecessor.setLag(this.getDurationString(rel.getDuration()));
                plannerPredecessor.setType(RELATIONSHIP_TYPES.get(rel.getType()));
                predecessorList.add(plannerPredecessor);
            }
        }
        if ((predecessors = mpxjTask.getPredecessors()) != null) {
            for (Relation rel : predecessors) {
                taskUniqueID = rel.getTaskUniqueID();
                if (set.contains(taskUniqueID)) continue;
                plannerPredecessor = this.m_factory.createPredecessor();
                plannerPredecessor.setId(this.getIntegerString(++id));
                plannerPredecessor.setPredecessorId(this.getIntegerString(taskUniqueID));
                plannerPredecessor.setLag(this.getDurationString(rel.getDuration()));
                plannerPredecessor.setType(RELATIONSHIP_TYPES.get(rel.getType()));
                predecessorList.add(plannerPredecessor);
            }
        }
    }

    private void writeAssignments() {
        Allocations allocations = this.m_factory.createAllocations();
        this.m_plannerProject.setAllocations(allocations);
        List<Allocation> allocationList = allocations.getAllocation();
        for (ResourceAssignment mpxjAssignment : this.m_projectFile.getAllResourceAssignments()) {
            Allocation plannerAllocation = this.m_factory.createAllocation();
            allocationList.add(plannerAllocation);
            plannerAllocation.setTaskId(this.getIntegerString(mpxjAssignment.getTask().getUniqueID()));
            plannerAllocation.setResourceId(this.getIntegerString(mpxjAssignment.getResourceUniqueID()));
            plannerAllocation.setUnits(this.getIntegerString(mpxjAssignment.getUnits()));
        }
    }

    private String getDateTime(Date value) {
        StringBuffer result = new StringBuffer(16);
        if (value != null) {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            cal.setTime(value);
            result.append(this.m_fourDigitFormat.format(cal.get(1)));
            result.append(this.m_twoDigitFormat.format(cal.get(2) + 1));
            result.append(this.m_twoDigitFormat.format(cal.get(5)));
            result.append("T");
            result.append(this.m_twoDigitFormat.format(cal.get(11)));
            result.append(this.m_twoDigitFormat.format(cal.get(12)));
            result.append(this.m_twoDigitFormat.format(cal.get(13)));
            result.append("Z");
        }
        return result.toString();
    }

    private String getIntegerString(Number value) {
        return value == null ? null : Integer.toString(value.intValue());
    }

    private String getIntegerString(int value) {
        return Integer.toString(value);
    }

    private boolean isWorkingDay(ProjectCalendar mpxjCalendar, Day day) {
        boolean result = false;
        switch (mpxjCalendar.getWorkingDay(day)) {
            case 1: {
                result = true;
                break;
            }
            case 0: {
                result = false;
                break;
            }
            case 2: {
                result = this.isWorkingDay(mpxjCalendar.getBaseCalendar(), day);
            }
        }
        return result;
    }

    private String getWorkingDayString(ProjectCalendar mpxjCalendar, Day day) {
        String result = null;
        switch (mpxjCalendar.getWorkingDay(day)) {
            case 1: {
                result = "0";
                break;
            }
            case 0: {
                result = "1";
                break;
            }
            case 2: {
                result = "2";
            }
        }
        return result;
    }

    private String getTimeString(Date value) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(value);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        StringBuffer sb = new StringBuffer(4);
        sb.append(this.m_twoDigitFormat.format(hours));
        sb.append(this.m_twoDigitFormat.format(minutes));
        return sb.toString();
    }

    private String getDateString(Date value) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(value);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        StringBuffer sb = new StringBuffer(8);
        sb.append(this.m_fourDigitFormat.format(year));
        sb.append(this.m_twoDigitFormat.format(month));
        sb.append(this.m_twoDigitFormat.format(day));
        return sb.toString();
    }

    private String getDateTimeString(Date value) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(value);
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.m_fourDigitFormat.format(cal.get(1)));
        sb.append(this.m_twoDigitFormat.format(cal.get(2) + 1));
        sb.append(this.m_twoDigitFormat.format(cal.get(5)));
        sb.append('T');
        sb.append(this.m_twoDigitFormat.format(cal.get(11)));
        sb.append(this.m_twoDigitFormat.format(cal.get(12)));
        sb.append(this.m_twoDigitFormat.format(cal.get(13)));
        sb.append('Z');
        return sb.toString();
    }

    private String getDurationString(Duration value) {
        String result = null;
        if (value != null) {
            double seconds = 0.0;
            switch (value.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    seconds = value.getDuration() * 60.0;
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    seconds = value.getDuration() * 28800.0;
                    break;
                }
                case DAYS: {
                    double minutesPerDay = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    seconds = value.getDuration() * (minutesPerDay * 60.0);
                    break;
                }
                case ELAPSED_DAYS: {
                    seconds = value.getDuration() * 86400.0;
                    break;
                }
                case WEEKS: {
                    double minutesPerWeek = this.m_projectFile.getProjectHeader().getMinutesPerWeek().doubleValue();
                    seconds = value.getDuration() * (minutesPerWeek * 60.0);
                    break;
                }
                case ELAPSED_WEEKS: {
                    seconds = value.getDuration() * 604800.0;
                    break;
                }
                case MONTHS: {
                    double minutesPerDay = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double daysPerMonth = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    seconds = value.getDuration() * (daysPerMonth * minutesPerDay * 60.0);
                    break;
                }
                case ELAPSED_MONTHS: {
                    seconds = value.getDuration() * 2592000.0;
                    break;
                }
                case YEARS: {
                    double minutesPerDay = this.m_projectFile.getProjectHeader().getMinutesPerDay().doubleValue();
                    double daysPerMonth = this.m_projectFile.getProjectHeader().getDaysPerMonth().doubleValue();
                    seconds = value.getDuration() * (12.0 * daysPerMonth * minutesPerDay * 60.0);
                    break;
                }
                case ELAPSED_YEARS: {
                    seconds = value.getDuration() * 3.1536E7;
                    break;
                }
            }
            result = Long.toString((long)seconds);
        }
        return result;
    }

    private String getScheduling(TaskType value) {
        String result = "fixed-work";
        if (value != null && value == TaskType.FIXED_DURATION) {
            result = "fixed-duration";
        }
        return result;
    }

    private String getString(String value) {
        return value == null ? "" : value;
    }

    static {
        RELATIONSHIP_TYPES.put(RelationType.FINISH_FINISH, "FF");
        RELATIONSHIP_TYPES.put(RelationType.FINISH_START, "FS");
        RELATIONSHIP_TYPES.put(RelationType.START_FINISH, "SF");
        RELATIONSHIP_TYPES.put(RelationType.START_START, "SS");
    }
}

