/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.AbstractTimephasedResourceAssignmentNormaliser;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSPDITimephasedResourceAssignmentNormaliser
extends AbstractTimephasedResourceAssignmentNormaliser {
    @Override
    public void normalise(ProjectCalendar calendar, LinkedList<TimephasedResourceAssignment> list) {
        this.splitDays(calendar, list);
        this.mergeSameDay(calendar, list);
        this.mergeSameWork(list);
        this.validateSameDay(calendar, list);
        this.convertToHours(list);
    }

    private void splitDays(ProjectCalendar calendar, LinkedList<TimephasedResourceAssignment> list) {
        LinkedList<TimephasedResourceAssignment> result = new LinkedList<TimephasedResourceAssignment>();
        Calendar cal = Calendar.getInstance();
        block0: for (TimephasedResourceAssignment assignment : list) {
            while (assignment != null) {
                Date startDay = DateUtility.getDayStartDate(assignment.getStart());
                Date finishDay = DateUtility.getDayStartDate(assignment.getFinish());
                if (assignment.getFinish().getTime() == finishDay.getTime()) {
                    cal.setTime(finishDay);
                    cal.add(6, -1);
                    finishDay = cal.getTime();
                }
                if (startDay.getTime() == finishDay.getTime()) {
                    result.add(assignment);
                    continue block0;
                }
                TimephasedResourceAssignment[] split = this.splitFirstDay(calendar, assignment);
                if (split[0] != null) {
                    result.add(split[0]);
                }
                assignment = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedResourceAssignment[] splitFirstDay(ProjectCalendar calendar, TimephasedResourceAssignment assignment) {
        TimephasedResourceAssignment[] result = new TimephasedResourceAssignment[2];
        Date assignmentStart = assignment.getStart();
        Date assignmentFinish = assignment.getFinish();
        Duration calendarWork = calendar.getWork(assignmentStart, assignmentFinish, TimeUnit.MINUTES);
        Duration assignmentWork = assignment.getTotalWork();
        if (calendarWork.getDuration() != 0.0) {
            TimephasedResourceAssignment split;
            Duration splitWork;
            double splitMinutes;
            Date splitFinish;
            Date splitStart;
            if (calendar.isWorkingDate(assignmentStart)) {
                splitStart = assignmentStart;
                Date splitFinishTime = calendar.getFinishTime(splitStart);
                splitFinish = DateUtility.setTime(splitStart, splitFinishTime);
                splitMinutes = calendar.getWork(splitStart, splitFinish, TimeUnit.MINUTES).getDuration();
                splitMinutes *= assignmentWork.getDuration();
                splitMinutes /= calendarWork.getDuration();
                splitMinutes = NumberUtility.truncate(splitMinutes, 2.0);
                splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                TimephasedResourceAssignment split2 = new TimephasedResourceAssignment();
                split2.setStart(splitStart);
                split2.setFinish(splitFinish);
                split2.setTotalWork(splitWork);
                result[0] = split2;
            } else {
                splitFinish = assignmentStart;
                splitMinutes = 0.0;
            }
            splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = assignmentFinish;
            if (splitStart.getTime() > splitFinish.getTime()) {
                split = null;
            } else {
                splitMinutes = assignmentWork.getDuration() - splitMinutes;
                splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedResourceAssignment();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalWork(splitWork);
            }
            result[1] = split;
        }
        return result;
    }

    private void mergeSameDay(ProjectCalendar calendar, LinkedList<TimephasedResourceAssignment> list) {
        LinkedList<TimephasedResourceAssignment> result = new LinkedList<TimephasedResourceAssignment>();
        TimephasedResourceAssignment previousAssignment = null;
        for (TimephasedResourceAssignment assignment : list) {
            if (previousAssignment == null) {
                assignment.setWorkPerDay(assignment.getTotalWork());
                result.add(assignment);
            } else {
                Date previousAssignmentStart = previousAssignment.getStart();
                Date previousAssignmentStartDay = DateUtility.getDayStartDate(previousAssignmentStart);
                Date assignmentStart = assignment.getStart();
                Date assignmentStartDay = DateUtility.getDayStartDate(assignmentStart);
                if (previousAssignmentStartDay.getTime() == assignmentStartDay.getTime()) {
                    Duration previousAssignmentWork = previousAssignment.getTotalWork();
                    Duration assignmentWork = assignment.getTotalWork();
                    if (previousAssignmentWork.getDuration() != 0.0 && assignmentWork.getDuration() == 0.0) continue;
                    result.removeLast();
                    if (previousAssignmentWork.getDuration() != 0.0 && assignmentWork.getDuration() != 0.0) {
                        double work = previousAssignment.getTotalWork().getDuration();
                        Duration totalWork = Duration.getInstance(work += assignment.getTotalWork().getDuration(), TimeUnit.MINUTES);
                        TimephasedResourceAssignment merged = new TimephasedResourceAssignment();
                        merged.setStart(previousAssignment.getStart());
                        merged.setFinish(assignment.getFinish());
                        merged.setTotalWork(totalWork);
                        assignment = merged;
                    } else if (assignmentWork.getDuration() == 0.0) {
                        assignment = previousAssignment;
                    }
                }
                assignment.setWorkPerDay(assignment.getTotalWork());
                result.add(assignment);
            }
            Duration calendarWork = calendar.getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.MINUTES);
            Duration assignmentWork = assignment.getTotalWork();
            if (calendarWork.getDuration() == 0.0 && assignmentWork.getDuration() == 0.0) {
                result.removeLast();
                continue;
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }

    private void validateSameDay(ProjectCalendar calendar, LinkedList<TimephasedResourceAssignment> list) {
        for (TimephasedResourceAssignment assignment : list) {
            Date assignmentStart = assignment.getStart();
            Date calendarStartTime = calendar.getStartTime(assignmentStart);
            Date assignmentStartTime = DateUtility.getCanonicalTime(assignmentStart);
            Date assignmentFinish = assignment.getFinish();
            Date calendarFinishTime = calendar.getFinishTime(assignmentFinish);
            Date assignmentFinishTime = DateUtility.getCanonicalTime(assignmentFinish);
            double totalWork = assignment.getTotalWork().getDuration();
            if (assignmentStartTime != null && calendarStartTime != null && (totalWork == 0.0 && assignmentStartTime.getTime() != calendarStartTime.getTime() || assignmentStartTime.getTime() < calendarStartTime.getTime())) {
                assignmentStart = DateUtility.setTime(assignmentStart, calendarStartTime);
                assignment.setStart(assignmentStart);
            }
            if (assignmentFinishTime == null || calendarFinishTime == null || (totalWork != 0.0 || assignmentFinishTime.getTime() == calendarFinishTime.getTime()) && assignmentFinishTime.getTime() <= calendarFinishTime.getTime()) continue;
            assignmentFinish = DateUtility.setTime(assignmentFinish, calendarFinishTime);
            assignment.setFinish(assignmentFinish);
        }
    }
}

