/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.SplitTaskFactory;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedResourceAssignment;
import net.sf.mpxj.TimephasedResourceAssignmentNormaliser;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDITimephasedResourceAssignmentNormaliser;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MSPDIReader
extends AbstractProjectReader {
    private boolean m_compatibleInput = true;
    private ProjectFile m_projectFile;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SAXSource doc = new SAXSource(xmlReader, new InputSource(stream));
            JAXBContext context = JAXBContext.newInstance((String)"net.sf.mpxj.mspdi.schema");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (this.m_compatibleInput) {
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        return true;
                    }
                });
            }
            Project project = (Project)unmarshaller.unmarshal((Source)doc);
            HashMap<BigInteger, ProjectCalendar> calendarMap = new HashMap<BigInteger, ProjectCalendar>();
            this.readProjectHeader(project);
            this.readProjectExtendedAttributes(project);
            this.readCalendars(project, calendarMap);
            this.readResources(project, calendarMap);
            this.readTasks(project);
            this.readAssignments(project);
            this.m_projectFile.updateUniqueCounters();
            ProjectCalendar defaultCalendar = calendarMap.get(project.getCalendarUID());
            if (defaultCalendar != null) {
                this.m_projectFile.getProjectHeader().setCalendarName(defaultCalendar.getName());
            }
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void readProjectHeader(Project project) {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        header.setActualsInSync(BooleanUtility.getBoolean(project.isActualsInSync()));
        header.setAdminProject(BooleanUtility.getBoolean(project.isAdminProject()));
        header.setAuthor(project.getAuthor());
        header.setAutoAddNewResourcesAndTasks(BooleanUtility.getBoolean(project.isAutoAddNewResourcesAndTasks()));
        header.setAutolink(BooleanUtility.getBoolean(project.isAutolink()));
        header.setBaselineForEarnedValue(NumberUtility.getInteger(project.getBaselineForEarnedValue()));
        header.setCategory(project.getCategory());
        header.setCompany(project.getCompany());
        header.setCreationDate(DatatypeConverter.parseDate(project.getCreationDate()));
        header.setCriticalSlackLimit(NumberUtility.getInteger(project.getCriticalSlackLimit()));
        header.setCurrencyDigits(NumberUtility.getInteger(project.getCurrencyDigits()));
        header.setCurrencyCode(project.getCurrencyCode());
        header.setCurrencySymbol(project.getCurrencySymbol());
        header.setCurrentDate(DatatypeConverter.parseDate(project.getCurrentDate()));
        header.setDaysPerMonth(NumberUtility.getInteger(project.getDaysPerMonth()));
        header.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        header.setDefaultEndTime(DatatypeConverter.parseTime(project.getDefaultFinishTime()));
        header.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        header.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate()));
        header.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate()));
        header.setDefaultStartTime(DatatypeConverter.parseTime(project.getDefaultStartTime()));
        header.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        header.setDefaultTaskType(project.getDefaultTaskType());
        header.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        header.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        header.setEditableActualCosts(BooleanUtility.getBoolean(project.isEditableActualCosts()));
        header.setExtendedCreationDate(DatatypeConverter.parseDate(project.getExtendedCreationDate()));
        header.setFinishDate(DatatypeConverter.parseDate(project.getFinishDate()));
        header.setFiscalYearStart(BooleanUtility.getBoolean(project.isFiscalYearStart()));
        header.setFiscalYearStartMonth(NumberUtility.getInteger(project.getFYStartDate()));
        header.setHonorConstraints(BooleanUtility.getBoolean(project.isHonorConstraints()));
        header.setInsertedProjectsLikeSummary(BooleanUtility.getBoolean(project.isInsertedProjectsLikeSummary()));
        header.setLastSaved(DatatypeConverter.parseDate(project.getLastSaved()));
        header.setManager(project.getManager());
        header.setMicrosoftProjectServerURL(BooleanUtility.getBoolean(project.isMicrosoftProjectServerURL()));
        header.setMinutesPerDay(NumberUtility.getInteger(project.getMinutesPerDay()));
        header.setMinutesPerWeek(NumberUtility.getInteger(project.getMinutesPerWeek()));
        header.setMoveCompletedEndsBack(BooleanUtility.getBoolean(project.isMoveCompletedEndsBack()));
        header.setMoveCompletedEndsForward(BooleanUtility.getBoolean(project.isMoveCompletedEndsForward()));
        header.setMoveRemainingStartsBack(BooleanUtility.getBoolean(project.isMoveRemainingStartsBack()));
        header.setMoveRemainingStartsForward(BooleanUtility.getBoolean(project.isMoveRemainingStartsForward()));
        header.setMultipleCriticalPaths(BooleanUtility.getBoolean(project.isMultipleCriticalPaths()));
        header.setName(project.getName());
        header.setNewTasksEffortDriven(BooleanUtility.getBoolean(project.isNewTasksEffortDriven()));
        header.setNewTasksEstimated(BooleanUtility.getBoolean(project.isNewTasksEstimated()));
        header.setNewTaskStartIsProjectStart(NumberUtility.getInt(project.getNewTaskStartDate()) == 0);
        header.setProjectExternallyEdited(BooleanUtility.getBoolean(project.isProjectExternallyEdited()));
        header.setProjectTitle(project.getTitle());
        header.setRemoveFileProperties(BooleanUtility.getBoolean(project.isRemoveFileProperties()));
        header.setRevision(NumberUtility.getInteger(project.getRevision()));
        header.setScheduleFrom(BooleanUtility.getBoolean(project.isScheduleFromStart()) ? ScheduleFrom.START : ScheduleFrom.FINISH);
        header.setSubject(project.getSubject());
        header.setSplitInProgressTasks(BooleanUtility.getBoolean(project.isSplitsInProgressTasks()));
        header.setSpreadActualCost(BooleanUtility.getBoolean(project.isSpreadActualCost()));
        header.setSpreadPercentComplete(BooleanUtility.getBoolean(project.isSpreadPercentComplete()));
        header.setStartDate(DatatypeConverter.parseDate(project.getStartDate()));
        header.setStatusDate(DatatypeConverter.parseDate(project.getStatusDate()));
        header.setSymbolPosition(project.getCurrencySymbolPosition());
        header.setUniqueID(project.getUID());
        header.setUpdatingTaskStatusUpdatesResourceStatus(BooleanUtility.getBoolean(project.isTaskUpdatesResource()));
        header.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
    }

    private void readCalendars(Project project, HashMap<BigInteger, ProjectCalendar> map) {
        Project.Calendars calendars = project.getCalendars();
        if (calendars != null) {
            LinkedList<Pair<ProjectCalendar, BigInteger>> baseCalendars = new LinkedList<Pair<ProjectCalendar, BigInteger>>();
            for (Project.Calendars.Calendar cal : calendars.getCalendar()) {
                this.readCalendar(cal, map, baseCalendars);
            }
            MSPDIReader.updateBaseCalendarNames(baseCalendars, map);
        }
    }

    private static void updateBaseCalendarNames(List<Pair<ProjectCalendar, BigInteger>> baseCalendars, HashMap<BigInteger, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, BigInteger> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            BigInteger baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setBaseCalendar(baseCal);
        }
    }

    private void readCalendar(Project.Calendars.Calendar calendar, HashMap<BigInteger, ProjectCalendar> map, LinkedList<Pair<ProjectCalendar, BigInteger>> baseCalendars) {
        Project.Calendars.Calendar.WeekDays days;
        ProjectCalendar bc = BooleanUtility.getBoolean(calendar.isIsBaseCalendar()) ? this.m_projectFile.addBaseCalendar() : this.m_projectFile.addResourceCalendar();
        bc.setUniqueID(NumberUtility.getInteger(calendar.getUID()));
        bc.setName(calendar.getName());
        BigInteger baseCalendarID = calendar.getBaseCalendarUID();
        if (baseCalendarID != null) {
            baseCalendars.add(new Pair<ProjectCalendar, BigInteger>(bc, baseCalendarID));
        }
        if ((days = calendar.getWeekDays()) != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay weekDay : days.getWeekDay()) {
                this.readDay(bc, weekDay);
            }
        } else {
            bc.setWorkingDay(Day.SUNDAY, 2);
            bc.setWorkingDay(Day.MONDAY, 2);
            bc.setWorkingDay(Day.TUESDAY, 2);
            bc.setWorkingDay(Day.WEDNESDAY, 2);
            bc.setWorkingDay(Day.THURSDAY, 2);
            bc.setWorkingDay(Day.FRIDAY, 2);
            bc.setWorkingDay(Day.SATURDAY, 2);
        }
        map.put(calendar.getUID(), bc);
    }

    private void readDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day) {
        BigInteger dayType = day.getDayType();
        if (dayType != null) {
            if (dayType.intValue() == 0) {
                this.readExceptionDay(calendar, day);
            } else {
                this.readNormalDay(calendar, day);
            }
        }
    }

    private void readNormalDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        int dayNumber = weekDay.getDayType().intValue();
        Day day = Day.getInstance(dayNumber);
        calendar.setWorkingDay(day, BooleanUtility.getBoolean(weekDay.isDayWorking()));
        ProjectCalendarHours hours = calendar.addCalendarHours(day);
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = weekDay.getWorkingTimes();
        if (times != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : times.getWorkingTime()) {
                Date startTime = DatatypeConverter.parseTime(period.getFromTime());
                Date endTime = DatatypeConverter.parseTime(period.getToTime());
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endTime);
                    cal.add(6, 1);
                    endTime = cal.getTime();
                }
                hours.addRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day) {
        ProjectCalendarException exception = calendar.addCalendarException();
        Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod timePeriod = day.getTimePeriod();
        exception.setFromDate(DatatypeConverter.parseDate(timePeriod.getFromDate()));
        exception.setToDate(DatatypeConverter.parseDate(timePeriod.getToDate()));
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = day.getWorkingTimes();
        if (times != null) {
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> time = times.getWorkingTime();
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : time) {
                Date startTime = DatatypeConverter.parseTime(period.getFromTime());
                Date endTime = DatatypeConverter.parseTime(period.getToTime());
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endTime);
                    cal.add(6, 1);
                    endTime = cal.getTime();
                }
                exception.addRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void readProjectExtendedAttributes(Project project) {
        Project.ExtendedAttributes attributes = project.getExtendedAttributes();
        if (attributes != null) {
            for (Project.ExtendedAttributes.ExtendedAttribute ea : attributes.getExtendedAttribute()) {
                this.readFieldAlias(ea);
            }
        }
    }

    private void readFieldAlias(Project.ExtendedAttributes.ExtendedAttribute attribute) {
        String alias = attribute.getAlias();
        if (alias != null && alias.length() != 0) {
            int id = Integer.parseInt(attribute.getFieldID());
            int base = id & 0xFFFF0000;
            int index = id & 0xFFFF;
            switch (base) {
                case 0xB400000: {
                    TaskField taskField = MPPTaskField.getInstance(index);
                    if (taskField == null) break;
                    this.m_projectFile.setTaskFieldAlias(taskField, attribute.getAlias());
                    break;
                }
                case 0xC400000: {
                    ResourceField resourceField = MPPResourceField.getInstance(index);
                    if (resourceField == null) break;
                    this.m_projectFile.setResourceFieldAlias(resourceField, attribute.getAlias());
                    break;
                }
            }
        }
    }

    private void readResources(Project project, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Project.Resources resources = project.getResources();
        if (resources != null) {
            for (Project.Resources.Resource resource : resources.getResource()) {
                this.readResource(resource, calendarMap);
            }
        }
    }

    private void readResource(Project.Resources.Resource xml, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Resource mpx = this.m_projectFile.addResource();
        mpx.setAccrueAt(xml.getAccrueAt());
        mpx.setActveDirectoryGUID(xml.getActiveDirectoryGUID());
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWorkProtected()));
        mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWork()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setAvailableFrom(DatatypeConverter.parseDate(xml.getAvailableFrom()));
        mpx.setAvailableTo(DatatypeConverter.parseDate(xml.getAvailableTo()));
        mpx.setBCWS(DatatypeConverter.parseCurrency(xml.getBCWS()));
        mpx.setBCWP(DatatypeConverter.parseCurrency(xml.getBCWP()));
        mpx.setBookingType(xml.getBookingType());
        mpx.setBudget(BooleanUtility.getBoolean(xml.isIsBudget()));
        mpx.setCanLevel(BooleanUtility.getBoolean(xml.isCanLevel()));
        mpx.setCode(xml.getCode());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCostPerUse(DatatypeConverter.parseCurrency(xml.getCostPerUse()));
        mpx.setCostVariance(DatatypeConverter.parseCurrency(xml.getCostVariance()));
        mpx.setCreationDate(DatatypeConverter.parseDate(xml.getCreationDate()));
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setEmailAddress(xml.getEmailAddress());
        mpx.setGroup(xml.getGroup());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberUtility.getInteger(xml.getID()));
        mpx.setInitials(xml.getInitials());
        mpx.setIsEnterprise(BooleanUtility.getBoolean(xml.isIsEnterprise()));
        mpx.setIsGeneric(BooleanUtility.getBoolean(xml.isIsGeneric()));
        mpx.setIsInactive(BooleanUtility.getBoolean(xml.isIsInactive()));
        mpx.setIsNull(BooleanUtility.getBoolean(xml.isIsNull()));
        mpx.setMaterialLabel(xml.getMaterialLabel());
        mpx.setMaxUnits(DatatypeConverter.parseUnits(xml.getMaxUnits()));
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && xml.getNotes().length() != 0) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNtAccount(xml.getNTAccount());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeRate(DatatypeConverter.parseRate(xml.getOvertimeRate()));
        mpx.setOvertimeRateFormat(DatatypeConverter.parseTimeUnit(xml.getOvertimeRateFormat()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getOvertimeWork()));
        mpx.setPeakUnits(DatatypeConverter.parseUnits(xml.getPeakUnits()));
        mpx.setPercentWorkComplete(xml.getPercentWorkComplete());
        mpx.setPhonetics(xml.getPhonetics());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingWork()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingOvertimeWork()));
        mpx.setStandardRate(DatatypeConverter.parseRate(xml.getStandardRate()));
        mpx.setStandardRateFormat(DatatypeConverter.parseTimeUnit(xml.getStandardRateFormat()));
        mpx.setSV(DatatypeConverter.parseCurrency(xml.getSV()));
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberUtility.getInteger(xml.getUID()));
        mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getWork()));
        mpx.setWorkGroup(xml.getWorkGroup());
        mpx.setWorkVariance(DatatypeConverter.parseDurationInMinutes(xml.getWorkVariance()));
        this.readResourceExtendedAttributes(xml, mpx);
        this.readResourceBaselines(xml, mpx);
        mpx.setResourceCalendar(calendarMap.get(xml.getCalendarUID()));
        mpx.setOverAllocated(BooleanUtility.getBoolean(xml.isOverAllocated()));
        this.m_projectFile.fireResourceReadEvent(mpx);
    }

    private void readResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        for (Project.Resources.Resource.Baseline baseline : xmlResource.getBaseline()) {
            int number = NumberUtility.getInt(baseline.getNumber());
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjResource.setBaselineCost(cost);
                mpxjResource.setBaselineWork(work);
                continue;
            }
            mpxjResource.setBaselineCost(number, cost);
            mpxjResource.setBaselineWork(number, work);
        }
    }

    private void readResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        for (Project.Resources.Resource.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            ResourceField mpxFieldID = MPPResourceField.getInstance(xmlFieldID);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID);
        }
    }

    private void readTasks(Project project) {
        Project.Tasks tasks = project.getTasks();
        if (tasks != null) {
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readTask(task);
            }
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
        }
        this.m_projectFile.updateStructure();
    }

    private void readTask(Project.Tasks.Task xml) {
        Task mpx = this.m_projectFile.addTask();
        mpx.setNull(BooleanUtility.getBoolean(xml.isIsNull()));
        mpx.setID(NumberUtility.getInteger(xml.getID()));
        mpx.setUniqueID(NumberUtility.getInteger(xml.getUID()));
        if (!mpx.getNull()) {
            mpx.setDurationFormat(DatatypeConverter.parseDurationTimeUnits(xml.getDurationFormat()));
            mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
            mpx.setActualDuration(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualDuration()));
            mpx.setActualFinish(DatatypeConverter.parseDate(xml.getActualFinish()));
            mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
            mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualOvertimeWork()));
            mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualOvertimeWorkProtected()));
            mpx.setActualStart(DatatypeConverter.parseDate(xml.getActualStart()));
            mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualWork()));
            mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getActualWorkProtected()));
            mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
            mpx.setCalendar(this.getTaskCalendar(xml));
            mpx.setConstraintDate(DatatypeConverter.parseDate(xml.getConstraintDate()));
            mpx.setConstraintType(DatatypeConverter.parseConstraintType(xml.getConstraintType()));
            mpx.setContact(xml.getContact());
            mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
            mpx.setCreateDate(DatatypeConverter.parseDate(xml.getCreateDate()));
            mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
            mpx.setDeadline(DatatypeConverter.parseDate(xml.getDeadline()));
            mpx.setDuration(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getDuration()));
            mpx.setEarlyFinish(DatatypeConverter.parseDate(xml.getEarlyFinish()));
            mpx.setEarlyStart(DatatypeConverter.parseDate(xml.getEarlyStart()));
            mpx.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(xml.getEarnedValueMethod()));
            mpx.setEffortDriven(BooleanUtility.getBoolean(xml.isEffortDriven()));
            mpx.setEstimated(BooleanUtility.getBoolean(xml.isEstimated()));
            mpx.setExternalTask(BooleanUtility.getBoolean(xml.isExternalTask()));
            mpx.setProject(xml.getExternalTaskProject());
            mpx.setFinish(DatatypeConverter.parseDate(xml.getFinish()));
            mpx.setFinishVariance(DatatypeConverter.parseDurationInMinutes(xml.getFinishVariance()));
            mpx.setFixedCost(DatatypeConverter.parseCurrency(xml.getFixedCost()));
            mpx.setFixedCostAccrual(xml.getFixedCostAccrual());
            mpx.setFreeSlack(DatatypeConverter.parseDurationInMinutes(xml.getFreeSlack()));
            mpx.setHideBar(BooleanUtility.getBoolean(xml.isHideBar()));
            mpx.setHyperlink(xml.getHyperlink());
            mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
            mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
            mpx.setIgnoreResourceCalendar(BooleanUtility.getBoolean(xml.isIgnoreResourceCalendar()));
            mpx.setLateFinish(DatatypeConverter.parseDate(xml.getLateFinish()));
            mpx.setLateStart(DatatypeConverter.parseDate(xml.getLateStart()));
            mpx.setLevelAssignments(BooleanUtility.getBoolean(xml.isLevelAssignments()));
            mpx.setLevelingCanSplit(BooleanUtility.getBoolean(xml.isLevelingCanSplit()));
            mpx.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(xml.getLevelingDelayFormat()));
            if (xml.getLevelingDelay() != null && mpx.getLevelingDelayFormat() != null) {
                mpx.setLevelingDelay(Duration.getInstance(xml.getLevelingDelay().doubleValue(), mpx.getLevelingDelayFormat()));
            }
            mpx.setMilestone(BooleanUtility.getBoolean(xml.isMilestone()));
            mpx.setName(xml.getName());
            if (xml.getNotes() != null && xml.getNotes().length() != 0) {
                mpx.setNotes(xml.getNotes());
            }
            mpx.setOutlineLevel(NumberUtility.getInteger(xml.getOutlineLevel()));
            mpx.setOutlineNumber(xml.getOutlineNumber());
            mpx.setOverAllocated(BooleanUtility.getBoolean(xml.isOverAllocated()));
            mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
            mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getOvertimeWork()));
            mpx.setPercentageComplete(xml.getPercentComplete());
            mpx.setPercentageWorkComplete(xml.getPercentWorkComplete());
            mpx.setPhysicalPercentComplete(NumberUtility.getInteger(xml.getPhysicalPercentComplete()));
            mpx.setPreleveledFinish(DatatypeConverter.parseDate(xml.getPreLeveledFinish()));
            mpx.setPreleveledStart(DatatypeConverter.parseDate(xml.getPreLeveledStart()));
            mpx.setPriority(DatatypeConverter.parsePriority(xml.getPriority()));
            mpx.setRecurring(BooleanUtility.getBoolean(xml.isRecurring()));
            mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRegularWork()));
            mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
            mpx.setRemainingDuration(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRemainingDuration()));
            mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
            mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRemainingOvertimeWork()));
            mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getRemainingWork()));
            mpx.setResume(DatatypeConverter.parseDate(xml.getResume()));
            mpx.setResumeValid(BooleanUtility.getBoolean(xml.isResumeValid()));
            mpx.setRollup(BooleanUtility.getBoolean(xml.isRollup()));
            mpx.setStart(DatatypeConverter.parseDate(xml.getStart()));
            mpx.setStartVariance(DatatypeConverter.parseDurationInMinutes(xml.getStartVariance()));
            mpx.setStop(DatatypeConverter.parseDate(xml.getStop()));
            mpx.setSubProject(BooleanUtility.getBoolean(xml.isIsSubproject()) ? new SubProject() : null);
            mpx.setSubprojectName(xml.getSubprojectName());
            mpx.setSubprojectReadOnly(BooleanUtility.getBoolean(xml.isIsSubprojectReadOnly()));
            mpx.setSummary(BooleanUtility.getBoolean(xml.isSummary()));
            mpx.setType(xml.getType());
            mpx.setWBS(xml.getWBS());
            mpx.setWBSLevel(xml.getWBSLevel());
            mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, mpx.getDurationFormat(), xml.getWork()));
            mpx.setWorkVariance(Duration.getInstance(NumberUtility.getDouble(xml.getWorkVariance()) / 1000.0, TimeUnit.MINUTES));
            mpx.setTotalSlack(DatatypeConverter.parseDurationInMinutes(xml.getTotalSlack()));
            mpx.setCritical(BooleanUtility.getBoolean(xml.isCritical()));
            this.readTaskExtendedAttributes(xml, mpx);
            this.readTaskBaselines(xml, mpx);
        }
        this.m_projectFile.fireTaskReadEvent(mpx);
    }

    private void readTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask) {
        for (Project.Tasks.Task.Baseline baseline : xmlTask.getBaseline()) {
            int number = NumberUtility.getInt(baseline.getNumber());
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, mpxjTask.getDurationFormat(), baseline.getDuration());
            Date finish = DatatypeConverter.parseDate(baseline.getFinish());
            Date start = DatatypeConverter.parseDate(baseline.getStart());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjTask.setBaselineCost(cost);
                mpxjTask.setBaselineDuration(duration);
                mpxjTask.setBaselineFinish(finish);
                mpxjTask.setBaselineStart(start);
                mpxjTask.setBaselineWork(work);
                continue;
            }
            mpxjTask.setBaselineCost(number, cost);
            mpxjTask.setBaselineDuration(number, duration);
            mpxjTask.setBaselineFinish(number, finish);
            mpxjTask.setBaselineStart(number, start);
            mpxjTask.setBaselineWork(number, work);
        }
    }

    private void readTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        for (Project.Tasks.Task.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            TaskField mpxFieldID = MPPTaskField.getInstance(xmlFieldID);
            if (mpxFieldID == null) continue;
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID);
        }
    }

    private ProjectCalendar getTaskCalendar(Project.Tasks.Task task) {
        ProjectCalendar calendar = null;
        BigInteger calendarID = task.getCalendarUID();
        if (calendarID != null) {
            calendar = this.m_projectFile.getBaseCalendarByUniqueID(calendarID.intValue());
        }
        return calendar;
    }

    private void readPredecessors(Project.Tasks.Task task) {
        Task currTask;
        Integer uid = task.getUID();
        if (uid != null && (currTask = this.m_projectFile.getTaskByUniqueID(uid)) != null) {
            for (Project.Tasks.Task.PredecessorLink link : task.getPredecessorLink()) {
                this.readPredecessor(currTask, link);
            }
        }
    }

    private void readPredecessor(Task currTask, Project.Tasks.Task.PredecessorLink link) {
        Task prevTask;
        BigInteger uid = link.getPredecessorUID();
        if (uid != null && (prevTask = this.m_projectFile.getTaskByUniqueID(uid.intValue())) != null) {
            RelationType type = link.getType() != null ? RelationType.getInstance(link.getType().intValue()) : RelationType.FINISH_START;
            int lag = link.getLinkLag() != null ? link.getLinkLag().intValue() / 600 : 0;
            Relation rel = currTask.addPredecessor(prevTask);
            rel.setType(type);
            rel.setDuration(Duration.getInstance(lag, TimeUnit.HOURS));
        }
    }

    private void readAssignments(Project project) {
        Project.Assignments assignments = project.getAssignments();
        if (assignments != null) {
            SplitTaskFactory splitFactory = new SplitTaskFactory();
            MSPDITimephasedResourceAssignmentNormaliser normaliser = new MSPDITimephasedResourceAssignmentNormaliser();
            for (Project.Assignments.Assignment assignment : assignments.getAssignment()) {
                this.readAssignment(assignment, splitFactory, normaliser);
            }
        }
    }

    private void readAssignment(Project.Assignments.Assignment assignment, SplitTaskFactory splitFactory, TimephasedResourceAssignmentNormaliser normaliser) {
        BigInteger taskUID = assignment.getTaskUID();
        BigInteger resourceUID = assignment.getResourceUID();
        if (taskUID != null && resourceUID != null) {
            Task task = this.m_projectFile.getTaskByUniqueID(taskUID.intValue());
            Resource resource = this.m_projectFile.getResourceByUniqueID(resourceUID.intValue());
            ProjectCalendar calendar = null;
            if (resource != null) {
                calendar = resource.getResourceCalendar();
            }
            if (calendar == null) {
                task.getCalendar();
            }
            if (calendar == null) {
                calendar = this.m_projectFile.getCalendar();
            }
            LinkedList<TimephasedResourceAssignment> timephasedComplete = this.readTimephasedAssignment(calendar, assignment, 2);
            LinkedList<TimephasedResourceAssignment> timephasedPlanned = this.readTimephasedAssignment(calendar, assignment, 1);
            boolean raw = true;
            if (this.isSplit(calendar, timephasedComplete) || this.isSplit(calendar, timephasedPlanned)) {
                task.setSplits(new LinkedList<DateRange>());
                normaliser.normalise(calendar, timephasedComplete);
                normaliser.normalise(calendar, timephasedPlanned);
                splitFactory.processSplitData(task, timephasedComplete, timephasedPlanned);
                raw = false;
            }
            if (task != null && resource != null) {
                ResourceAssignment mpx = task.addResourceAssignment(resource);
                mpx.setTimephasedNormaliser(normaliser);
                mpx.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
                mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualWork()));
                mpx.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
                mpx.setDelay(DatatypeConverter.parseDurationInMinutes(assignment.getDelay()));
                mpx.setFinish(DatatypeConverter.parseDate(assignment.getFinish()));
                mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getOvertimeWork()));
                mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingWork()));
                mpx.setStart(DatatypeConverter.parseDate(assignment.getStart()));
                mpx.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
                mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getWork()));
                mpx.setWorkContour(assignment.getWorkContour());
                mpx.setTimephasedComplete(timephasedComplete, raw);
                mpx.setTimephasedPlanned(timephasedPlanned, raw);
            }
        }
    }

    private boolean isSplit(ProjectCalendar calendar, List<TimephasedResourceAssignment> list) {
        boolean result = false;
        for (TimephasedResourceAssignment assignment : list) {
            Duration calendarWork;
            if (assignment.getTotalWork().getDuration() != 0.0 || (calendarWork = calendar.getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.MINUTES)).getDuration() == 0.0) continue;
            result = true;
            break;
        }
        return result;
    }

    private LinkedList<TimephasedResourceAssignment> readTimephasedAssignment(ProjectCalendar calendar, Project.Assignments.Assignment assignment, int type) {
        LinkedList<TimephasedResourceAssignment> result = new LinkedList<TimephasedResourceAssignment>();
        for (TimephasedDataType item : assignment.getTimephasedData()) {
            if (NumberUtility.getInt(item.getType()) != type) continue;
            Date startDate = DatatypeConverter.parseDate(item.getStart());
            Date finishDate = DatatypeConverter.parseDate(item.getFinish());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.MINUTES, item.getValue());
            work = work == null ? Duration.getInstance(0, TimeUnit.MINUTES) : Duration.getInstance(NumberUtility.truncate(work.getDuration(), 2.0), TimeUnit.MINUTES);
            TimephasedResourceAssignment tra = new TimephasedResourceAssignment();
            tra.setStart(startDate);
            tra.setFinish(finishDate);
            tra.setTotalWork(work);
            result.add(tra);
        }
        return result;
    }

    public void setMicrosoftProjectCompatibleInput(boolean flag) {
        this.m_compatibleInput = flag;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }
}

